/*
 * Decompiled with CFR 0.152.
 */
package dev.paseto.jpaseto.io.gson;

import com.google.gson.Gson;
import dev.paseto.jpaseto.io.DeserializationException;
import dev.paseto.jpaseto.io.Deserializer;
import dev.paseto.jpaseto.io.gson.GsonSerializer;
import dev.paseto.jpaseto.lang.Assert;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class GsonDeserializer<T>
implements Deserializer<T> {
    private final Class<T> returnType;
    private final Gson gson;

    public GsonDeserializer() {
        this(GsonSerializer.DEFAULT_GSON);
    }

    public GsonDeserializer(Gson gson) {
        this(gson, Object.class);
    }

    private GsonDeserializer(Gson gson, Class<T> returnType) {
        Assert.notNull((Object)gson, (String)"gson cannot be null.");
        Assert.notNull(returnType, (String)"Return type cannot be null.");
        this.gson = gson;
        this.returnType = returnType;
    }

    public T deserialize(byte[] bytes) throws DeserializationException {
        try {
            return this.readValue(bytes);
        }
        catch (IOException e) {
            String msg = "Unable to deserialize bytes into a " + this.returnType.getName() + " instance: " + e.getMessage();
            throw new DeserializationException(msg, (Throwable)e);
        }
    }

    protected T readValue(byte[] bytes) throws IOException {
        return (T)this.gson.fromJson(new String(bytes, StandardCharsets.UTF_8), this.returnType);
    }
}

