/*
 * Decompiled with CFR 0.152.
 */
package dev.paseto.jpaseto.io.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.paseto.jpaseto.io.SerializationException;
import dev.paseto.jpaseto.io.Serializer;
import dev.paseto.jpaseto.lang.Assert;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class GsonSerializer<T>
implements Serializer<T> {
    static final Gson DEFAULT_GSON = new GsonBuilder().disableHtmlEscaping().create();
    private Gson gson;

    public GsonSerializer() {
        this(DEFAULT_GSON);
    }

    public GsonSerializer(Gson gson) {
        Assert.notNull((Object)gson, (String)"gson cannot be null.");
        this.gson = gson;
    }

    public byte[] serialize(T t) throws SerializationException {
        Assert.notNull(t, (String)"Object to serialize cannot be null.");
        try {
            return this.writeValueAsBytes(t);
        }
        catch (Exception e) {
            String msg = "Unable to serialize object: " + e.getMessage();
            throw new SerializationException(msg, (Throwable)e);
        }
    }

    protected byte[] writeValueAsBytes(T t) {
        Object o = t instanceof byte[] ? Base64.getEncoder().encodeToString((byte[])t) : (t instanceof char[] ? new String((char[])t) : t);
        return this.gson.toJson(o).getBytes(StandardCharsets.UTF_8);
    }
}

