/*
 * Decompiled with CFR 0.152.
 */
package dev.paseto.jpaseto.impl;

import com.google.auto.service.AutoService;
import dev.paseto.jpaseto.PasetoV1LocalBuilder;
import dev.paseto.jpaseto.impl.AbstractPasetoBuilder;
import dev.paseto.jpaseto.impl.CryptoProviders;
import dev.paseto.jpaseto.impl.crypto.V1LocalCryptoProvider;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.SecretKey;

@AutoService(value={PasetoV1LocalBuilder.class})
public class DefaultPasetoV1LocalBuilder
extends AbstractPasetoBuilder<PasetoV1LocalBuilder>
implements PasetoV1LocalBuilder {
    private static final String HEADER = "v1.local.";
    private SecretKey sharedSecret = null;
    private final V1LocalCryptoProvider cryptoProvider;

    public DefaultPasetoV1LocalBuilder() {
        this(CryptoProviders.v1LocalCryptoProvider());
    }

    DefaultPasetoV1LocalBuilder(V1LocalCryptoProvider cryptoProvider) {
        this.cryptoProvider = cryptoProvider;
    }

    public PasetoV1LocalBuilder setSharedSecret(SecretKey sharedSecret) {
        this.sharedSecret = sharedSecret;
        return this;
    }

    public String compact() {
        byte[] payload = this.payloadAsBytes();
        byte[] footer = this.footerAsBytes();
        byte[] randomBytes = new byte[32];
        try {
            SecureRandom.getInstanceStrong().nextBytes(randomBytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityException("JVM does not provide a strong secure random number generator", e);
        }
        byte[] nonce = this.cryptoProvider.nonce(payload, randomBytes);
        byte[] cipherText = this.cryptoProvider.encrypt(payload, footer, nonce, this.sharedSecret);
        String base64d = this.noPadBase64(new byte[][]{cipherText});
        return HEADER + base64d + this.footerToString(footer);
    }
}

