/*
 * Decompiled with CFR 0.152.
 */
package dev.paseto.jpaseto.impl.crypto;

import dev.paseto.jpaseto.InvalidMacException;
import dev.paseto.jpaseto.impl.crypto.Hmacs;
import dev.paseto.jpaseto.impl.crypto.PreAuthEncoder;
import dev.paseto.jpaseto.impl.crypto.V1LocalCryptoProvider;
import dev.paseto.jpaseto.impl.lang.Bytes;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.crypto.SecretKey;

public abstract class BaseV1LocalCryptoProvider
implements V1LocalCryptoProvider {
    private static final byte[] HEADER_BYTES = "v1.local.".getBytes(StandardCharsets.UTF_8);

    @Override
    public byte[] encrypt(byte[] payload, byte[] footer, byte[] nonce, SecretKey sharedSecret) {
        byte[] salt = Arrays.copyOf(nonce, 16);
        byte[] rightNonce = Arrays.copyOfRange(nonce, 16, nonce.length);
        byte[] encryptionKey = this.encryptionKey(sharedSecret, salt);
        byte[] authenticationKey = this.authenticationKey(sharedSecret, salt);
        byte[] cipherText = V1LocalCryptoProvider.doCipher(1, encryptionKey, rightNonce, payload);
        byte[] preAuth = PreAuthEncoder.encode(HEADER_BYTES, nonce, cipherText, footer);
        byte[] calculatedMac = Hmacs.hmacSha384(authenticationKey, preAuth);
        return Bytes.concat(nonce, cipherText, calculatedMac);
    }

    @Override
    public byte[] decrypt(byte[] encryptedBytes, byte[] footer, byte[] nonce, SecretKey sharedSecret) {
        byte[] salt = Arrays.copyOf(nonce, 16);
        byte[] rightNonce = Arrays.copyOfRange(nonce, 16, nonce.length);
        byte[] cipherText = Arrays.copyOfRange(encryptedBytes, 32, encryptedBytes.length - 48);
        byte[] mac = Arrays.copyOfRange(encryptedBytes, encryptedBytes.length - 48, encryptedBytes.length);
        byte[] encryptionKey = this.encryptionKey(sharedSecret, salt);
        byte[] authenticationKey = this.authenticationKey(sharedSecret, salt);
        byte[] preAuth = PreAuthEncoder.encode(HEADER_BYTES, nonce, cipherText, footer);
        byte[] calculatedMac = Hmacs.hmacSha384(authenticationKey, preAuth);
        if (!MessageDigest.isEqual(calculatedMac, mac)) {
            throw new InvalidMacException("Failed to validate mac in token");
        }
        return V1LocalCryptoProvider.doCipher(2, encryptionKey, rightNonce, cipherText);
    }

    private byte[] encryptionKey(SecretKey sharedSecret, byte[] salt) {
        return this.hkdfSha384(sharedSecret, salt, "paseto-encryption-key");
    }

    private byte[] authenticationKey(SecretKey sharedSecret, byte[] salt) {
        return this.hkdfSha384(sharedSecret, salt, "paseto-auth-key-for-aead");
    }

    private byte[] hkdfSha384(SecretKey sharedSecret, byte[] salt, String info) {
        return this.hkdfSha384(sharedSecret, salt, info.getBytes(StandardCharsets.UTF_8));
    }

    protected abstract byte[] hkdfSha384(SecretKey var1, byte[] var2, byte[] var3);
}

