/*
 * Decompiled with CFR 0.152.
 */
package dev.pellet.logging;

import dev.pellet.logging.InstantDateTimeSerializer;
import dev.pellet.logging.PelletLogElement;
import dev.pellet.logging.PelletLogElements;
import dev.pellet.logging.PelletLogLevel;
import dev.pellet.logging.PelletLogging;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.MDC;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0002J.\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u00062\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u0016J8\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u0016J\"\u0010\u0012\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u000eH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ldev/pellet/logging/PelletStructuredLogger;", "Ldev/pellet/logging/PelletLogging;", "name", "", "levelProvider", "Lkotlin/Function0;", "Ldev/pellet/logging/PelletLogLevel;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "isLevelEnabled", "", "level", "log", "", "elementsBuilder", "Ldev/pellet/logging/PelletLogElements;", "messageBuilder", "throwable", "", "logStructured", "message", "elements", "Companion", "pellet-logging"})
public final class PelletStructuredLogger
implements PelletLogging {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final Function0<PelletLogLevel> levelProvider;
    @NotNull
    private static final String levelKey = "level";
    @NotNull
    private static final String nameKey = "name";
    @NotNull
    private static final String messageKey = "message";
    @NotNull
    private static final String throwableKey = "throwable";
    @NotNull
    private static final String threadKey = "thread";
    @NotNull
    private static final String timestampKey = "timestamp";
    @NotNull
    private static final Json.Default encoder = Json.Default;

    public PelletStructuredLogger(@NotNull String name, @NotNull Function0<? extends PelletLogLevel> levelProvider) {
        Intrinsics.checkNotNullParameter((Object)name, (String)nameKey);
        Intrinsics.checkNotNullParameter(levelProvider, (String)"levelProvider");
        this.name = name;
        this.levelProvider = levelProvider;
    }

    @Override
    public void log(@NotNull PelletLogLevel level, @Nullable Function0<PelletLogElements> elementsBuilder, @NotNull Function0<String> messageBuilder) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)levelKey);
        Intrinsics.checkNotNullParameter(messageBuilder, (String)"messageBuilder");
        if (!this.isLevelEnabled(level)) {
            return;
        }
        String message = (String)messageBuilder.invoke();
        Function0<PelletLogElements> function0 = elementsBuilder;
        PelletLogElements elements = function0 != null ? (PelletLogElements)function0.invoke() : null;
        this.logStructured(level, message, elements);
    }

    @Override
    public void log(@NotNull PelletLogLevel level, @Nullable Throwable throwable, @Nullable Function0<PelletLogElements> elementsBuilder, @NotNull Function0<String> messageBuilder) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)levelKey);
        Intrinsics.checkNotNullParameter(messageBuilder, (String)"messageBuilder");
        if (!this.isLevelEnabled(level)) {
            return;
        }
        Function0<PelletLogElements> function0 = elementsBuilder;
        PelletLogElements elements = function0 != null ? (PelletLogElements)function0.invoke() : null;
        PelletLogElements pelletLogElements = elements;
        if (pelletLogElements == null) {
            pelletLogElements = new PelletLogElements(null, 1, null);
        }
        PelletLogElements computedElements = pelletLogElements.add(throwableKey, throwable);
        String message = (String)messageBuilder.invoke();
        this.logStructured(level, message, computedElements);
    }

    private final void logStructured(PelletLogLevel level, String message, PelletLogElements elements) {
        JsonPrimitive jsonPrimitive;
        Map.Entry it;
        Map map;
        Object k;
        Map.Entry it$iv$iv;
        boolean bl;
        Map map2;
        boolean $i$f$associateByTo;
        Iterable $this$associateByTo$iv$iv$iv;
        Map $this$mapValuesTo$iv$iv;
        boolean $i$f$mapValuesTo;
        Map destination$iv$iv;
        Map $this$mapValues$iv;
        boolean $i$f$mapValues;
        JsonElement timestamp = encoder.encodeToJsonElement((SerializationStrategy)InstantDateTimeSerializer.INSTANCE, (Object)Instant.now());
        Pair[] pairArray = new Pair[5];
        String string = level.toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        pairArray[0] = TuplesKt.to((Object)levelKey, (Object)JsonElementKt.JsonPrimitive((String)string));
        pairArray[1] = TuplesKt.to((Object)timestampKey, (Object)JsonElementKt.getJsonPrimitive((JsonElement)timestamp));
        pairArray[2] = TuplesKt.to((Object)messageKey, (Object)JsonElementKt.JsonPrimitive((String)message));
        pairArray[3] = TuplesKt.to((Object)nameKey, (Object)JsonElementKt.JsonPrimitive((String)this.name));
        pairArray[4] = TuplesKt.to((Object)threadKey, (Object)JsonElementKt.JsonPrimitive((String)Thread.currentThread().getName()));
        Map map3 = MapsKt.mutableMapOf((Pair[])pairArray);
        Map mdcElements = MDC.getMDCAdapter().getCopyOfContextMap();
        if (mdcElements != null) {
            Map map4 = MapsKt.minus((Map)mdcElements, (Iterable)map3.keySet());
            $i$f$mapValues = false;
            Map map5 = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            $i$f$mapValuesTo = false;
            $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                map2 = destination$iv$iv;
                bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                map = map2;
                boolean bl2 = false;
                jsonPrimitive = JsonElementKt.JsonPrimitive((String)((String)it.getValue()));
                map.put(k, jsonPrimitive);
            }
            Map jsonMdcElements = destination$iv$iv;
            map3.putAll(jsonMdcElements);
        }
        if (elements != null) {
            $this$mapValues$iv = MapsKt.minus(elements.all(), (Iterable)map3.keySet());
            $i$f$mapValues = false;
            $this$mapValuesTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            $i$f$mapValuesTo = false;
            $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                JsonPrimitive jsonPrimitive2;
                it$iv$iv = (Map.Entry)element$iv$iv$iv;
                map2 = destination$iv$iv;
                bl = false;
                it = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                map = map2;
                boolean bl3 = false;
                PelletLogElement container = (PelletLogElement)it.getValue();
                PelletLogElement pelletLogElement = container;
                if (pelletLogElement instanceof PelletLogElement.NullValue) {
                    jsonPrimitive2 = (JsonPrimitive)JsonNull.INSTANCE;
                } else if (pelletLogElement instanceof PelletLogElement.StringValue) {
                    jsonPrimitive2 = JsonElementKt.JsonPrimitive((String)((PelletLogElement.StringValue)container).getValue());
                } else if (pelletLogElement instanceof PelletLogElement.NumberValue) {
                    jsonPrimitive2 = JsonElementKt.JsonPrimitive((Number)((PelletLogElement.NumberValue)container).getValue());
                } else if (pelletLogElement instanceof PelletLogElement.BooleanValue) {
                    jsonPrimitive2 = JsonElementKt.JsonPrimitive((Boolean)((PelletLogElement.BooleanValue)container).getValue());
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                jsonPrimitive = jsonPrimitive2;
                map.put(k, jsonPrimitive);
            }
            Map jsonLogElements = destination$iv$iv;
            map3.putAll(jsonLogElements);
        }
        JsonObject json = new JsonObject(map3);
        StringFormat $this$encodeToString$iv = (StringFormat)encoder;
        boolean $i$f$encodeToString = false;
        SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(JsonObject.class));
        boolean $i$f$cast = false;
        String encoded = $this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, (Object)json);
        System.out.println((Object)encoded);
    }

    private final boolean isLevelEnabled(PelletLogLevel level) {
        PelletLogLevel currentLevel = (PelletLogLevel)((Object)this.levelProvider.invoke());
        return level.getValue() >= currentLevel.getValue();
    }

    @Override
    public void error(@Nullable Function0<PelletLogElements> elementsBuilder, @NotNull Function0<String> messageBuilder) {
        PelletLogging.DefaultImpls.error(this, elementsBuilder, messageBuilder);
    }

    @Override
    public void error(@Nullable Throwable throwable, @Nullable Function0<PelletLogElements> elementsBuilder, @NotNull Function0<String> messageBuilder) {
        PelletLogging.DefaultImpls.error(this, throwable, elementsBuilder, messageBuilder);
    }

    @Override
    public void warn(@Nullable Function0<PelletLogElements> elementsBuilder, @NotNull Function0<String> messageBuilder) {
        PelletLogging.DefaultImpls.warn(this, elementsBuilder, messageBuilder);
    }

    @Override
    public void warn(@Nullable Throwable throwable, @Nullable Function0<PelletLogElements> elementsBuilder, @NotNull Function0<String> messageBuilder) {
        PelletLogging.DefaultImpls.warn(this, throwable, elementsBuilder, messageBuilder);
    }

    @Override
    public void info(@Nullable Function0<PelletLogElements> elementsBuilder, @NotNull Function0<String> messageBuilder) {
        PelletLogging.DefaultImpls.info(this, elementsBuilder, messageBuilder);
    }

    @Override
    public void info(@Nullable Throwable throwable, @Nullable Function0<PelletLogElements> elementsBuilder, @NotNull Function0<String> messageBuilder) {
        PelletLogging.DefaultImpls.info(this, throwable, elementsBuilder, messageBuilder);
    }

    @Override
    public void debug(@Nullable Function0<PelletLogElements> elementsBuilder, @NotNull Function0<String> messageBuilder) {
        PelletLogging.DefaultImpls.debug(this, elementsBuilder, messageBuilder);
    }

    @Override
    public void debug(@Nullable Throwable throwable, @Nullable Function0<PelletLogElements> elementsBuilder, @NotNull Function0<String> messageBuilder) {
        PelletLogging.DefaultImpls.debug(this, throwable, elementsBuilder, messageBuilder);
    }

    @Override
    public void trace(@Nullable Function0<PelletLogElements> elementsBuilder, @NotNull Function0<String> messageBuilder) {
        PelletLogging.DefaultImpls.trace(this, elementsBuilder, messageBuilder);
    }

    @Override
    public void trace(@Nullable Throwable throwable, @Nullable Function0<PelletLogElements> elementsBuilder, @NotNull Function0<String> messageBuilder) {
        PelletLogging.DefaultImpls.trace(this, throwable, elementsBuilder, messageBuilder);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ldev/pellet/logging/PelletStructuredLogger$Companion;", "", "()V", "encoder", "Lkotlinx/serialization/json/Json$Default;", "levelKey", "", "messageKey", "nameKey", "threadKey", "throwableKey", "timestampKey", "pellet-logging"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

