/*
 * Decompiled with CFR 0.152.
 */
package dev.petuska.npm.publish.task;

import dev.petuska.npm.publish.task.NpmExecTask;
import dev.petuska.npm.publish.util.GeneralKt;
import groovy.json.JsonSlurper;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@CacheableTask
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0003J\u0010\u0010\b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Ldev/petuska/npm/publish/task/NpmPackTask;", "Ldev/petuska/npm/publish/task/NpmExecTask;", "()V", "dry", "Lorg/gradle/api/provider/Property;", "", "getDry", "()Lorg/gradle/api/provider/Property;", "outputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "packageDir", "Lorg/gradle/api/file/DirectoryProperty;", "getPackageDir", "()Lorg/gradle/api/file/DirectoryProperty;", "doAction", "", "path", "", "npm-publish-gradle-plugin"})
public abstract class NpmPackTask
extends NpmExecTask {
    public NpmPackTask() {
        this.setGroup("build");
        this.setDescription("Packs NPM package");
        this.getDry().convention((Object)false);
        this.getOutputFile().convention(this.getPackageDir().map(NpmPackTask::_init_$lambda-1).flatMap(arg_0 -> NpmPackTask._init_$lambda-4(this, arg_0)));
    }

    @InputDirectory
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public abstract DirectoryProperty getPackageDir();

    @Input
    @Option(option="dry", description="Execute in dry-run mode")
    @NotNull
    public abstract Property<Boolean> getDry();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputFile();

    @Option(option="outputFile", description="Path to the output file")
    public final void outputFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.getOutputFile().set(new File(path));
    }

    @TaskAction
    private final void doAction() {
        File pDir = ((Directory)GeneralKt.getFinal((Property)this.getPackageDir())).getAsFile();
        File oDir = ((RegularFile)GeneralKt.getFinal((Property)this.getOutputFile())).getAsFile();
        boolean d = GeneralKt.getFinal(this.getDry());
        this.debug((Function0<String>)((Function0)new Function0<String>(pDir, oDir, d){
            final /* synthetic */ File $pDir;
            final /* synthetic */ File $oDir;
            final /* synthetic */ boolean $d;
            {
                this.$pDir = $pDir;
                this.$oDir = $oDir;
                this.$d = $d;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Packing package at " + this.$pDir.getPath() + " to " + this.$oDir.getParentFile().getPath() + " " + (this.$d ? "with" : "without") + " --dry-run flag";
            }
        }));
        File tmpDir = this.getTemporaryDir();
        Object[] objectArray = new Object[]{"pack", pDir, d ? "--dry-run" : null};
        this.npmExec(CollectionsKt.listOf((Object[])objectArray), (Action<ExecSpec>)((Action)arg_0 -> NpmPackTask.doAction$lambda-5(tmpDir, arg_0)));
        Object object = tmpDir.listFiles();
        if (object == null || (object = (File)ArraysKt.firstOrNull((Object[])object)) == null) {
            throw new IllegalStateException("Internal error. Temporary packed file not found.".toString());
        }
        Object outFile = object;
        Intrinsics.checkNotNullExpressionValue((Object)oDir, (String)"oDir");
        FilesKt.copyTo$default((File)outFile, (File)oDir, (boolean)true, (int)0, (int)4, null);
        if (!d) {
            this.info((Function0<String>)((Function0)new Function0<String>(pDir, oDir){
                final /* synthetic */ File $pDir;
                final /* synthetic */ File $oDir;
                {
                    this.$pDir = $pDir;
                    this.$oDir = $oDir;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Packed package at " + this.$pDir.getPath() + " to " + this.$oDir.getPath();
                }
            }));
        }
    }

    private static final Map _init_$lambda-1(Directory dir) {
        Object object;
        File file;
        File p0 = file = dir.file("package.json").getAsFile();
        boolean bl = false;
        File file2 = p0.exists() ? file : null;
        if (file2 != null) {
            File it = file2;
            boolean bl2 = false;
            object = new JsonSlurper().parse(it);
        } else {
            object = null;
        }
        return (Map)GeneralKt.unsafeCast(object);
    }

    private static final Provider _init_$lambda-4(NpmPackTask this$0, Map it) {
        Provider provider;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object v = it.get("name");
        String name = v != null && (v = v.toString()) != null && (v = StringsKt.replace$default(v, (String)"@", (String)"", (boolean)false, (int)4, null)) != null ? StringsKt.replace$default(v, (String)"/", (String)"-", (boolean)false, (int)4, null) : null;
        Object v2 = it.get("version");
        String version = v2 != null ? v2.toString() : null;
        String string = name;
        if (string != null) {
            String it2 = string;
            boolean bl = false;
            Object fileName = null;
            fileName = name;
            String string2 = version;
            if (string2 != null) {
                String it3 = string2;
                boolean bl2 = false;
                fileName = fileName + "-" + version;
            }
            provider = this$0.getProject().getLayout().getBuildDirectory().file("packages/" + fileName + ".tgz");
        } else {
            provider = null;
        }
        return (Provider)GeneralKt.unsafeCast(provider);
    }

    private static final void doAction$lambda-5(File $tmpDir, ExecSpec it) {
        it.workingDir((Object)$tmpDir);
    }
}

