/*
 * Decompiled with CFR 0.152.
 */
package dev.petuska.npm.publish.task;

import dev.petuska.npm.publish.extension.domain.NpmRegistry;
import dev.petuska.npm.publish.task.NpmExecTask;
import dev.petuska.npm.publish.util.GeneralKt;
import java.io.File;
import java.net.URI;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;
import org.gradle.api.tasks.options.Option;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@UntrackedTask(because="Must always run")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0003J\u0014\u0010\f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u0012R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007\u00a8\u0006\u0013"}, d2={"Ldev/petuska/npm/publish/task/NpmPublishTask;", "Ldev/petuska/npm/publish/task/NpmExecTask;", "()V", "dry", "Lorg/gradle/api/provider/Property;", "", "getDry", "()Lorg/gradle/api/provider/Property;", "packageDir", "Lorg/gradle/api/file/DirectoryProperty;", "getPackageDir", "()Lorg/gradle/api/file/DirectoryProperty;", "registry", "Ldev/petuska/npm/publish/extension/domain/NpmRegistry;", "getRegistry", "doAction", "", "action", "Lorg/gradle/api/Action;", "npm-publish-gradle-plugin"})
public abstract class NpmPublishTask
extends NpmExecTask {
    public NpmPublishTask() {
        this.setGroup("publishing");
        this.setDescription("Publishes NPM package to NPM registry");
        this.getDry().convention(this.getRegistry().flatMap(arg_0 -> NpmPublishTask._init_$lambda-0((KProperty1)1.INSTANCE, arg_0)));
        this.getRegistry().convention(this.getProject().provider(() -> NpmPublishTask._init_$lambda-1(this)));
    }

    @Nested
    @NotNull
    public abstract Property<NpmRegistry> getRegistry();

    @InputDirectory
    @NotNull
    public abstract DirectoryProperty getPackageDir();

    @Input
    @Option(option="dry", description="Execute in dry-run mode")
    @NotNull
    public abstract Property<Boolean> getDry();

    public final void registry(@NotNull Action<NpmRegistry> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        GeneralKt.configure(this.getRegistry(), action2);
    }

    @TaskAction
    private final void doAction() {
        File pDir = ((Directory)GeneralKt.getFinal((Property)this.getPackageDir())).getAsFile();
        NpmRegistry reg = GeneralKt.getFinal(this.getRegistry());
        URI uri = GeneralKt.getFinal(reg.getUri());
        String string = uri.getAuthority();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri.authority");
        String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
        String string3 = uri.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"uri.path");
        String repo = string2 + ((Object)StringsKt.trim((CharSequence)string3)).toString() + "/";
        boolean d = GeneralKt.getFinal(this.getDry());
        this.debug((Function0<String>)((Function0)new Function0<String>(pDir, reg, d){
            final /* synthetic */ File $pDir;
            final /* synthetic */ NpmRegistry $reg;
            final /* synthetic */ boolean $d;
            {
                this.$pDir = $pDir;
                this.$reg = $reg;
                this.$d = $d;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Publishing package at " + this.$pDir.getPath() + " to " + this.$reg.getName() + " registry " + (this.$d ? "with" : "without") + " --dry-run flag";
            }
        }));
        Object[] objectArray = new Object[9];
        objectArray[0] = "publish";
        objectArray[1] = pDir;
        objectArray[2] = "--access";
        objectArray[3] = String.valueOf((Object)GeneralKt.getFinal(reg.getAccess()));
        objectArray[4] = "--registry";
        String string4 = uri.getScheme();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"uri.scheme");
        objectArray[5] = ((Object)StringsKt.trim((CharSequence)string4)).toString() + "://" + repo;
        objectArray[6] = GeneralKt.finalise(reg.getAuthToken()).isPresent() ? "--//" + repo + ":_authToken=" + reg.getAuthToken().get() : null;
        objectArray[7] = GeneralKt.finalise(reg.getOtp()).isPresent() ? "--otp " + reg.getOtp().get() : null;
        objectArray[8] = d ? "--dry-run" : null;
        this.npmExec(CollectionsKt.listOf((Object[])objectArray), (Action<ExecSpec>)((Action)arg_0 -> NpmPublishTask.doAction$lambda-2(this, arg_0)));
        if (!d) {
            this.info((Function0<String>)((Function0)new Function0<String>(pDir, reg){
                final /* synthetic */ File $pDir;
                final /* synthetic */ NpmRegistry $reg;
                {
                    this.$pDir = $pDir;
                    this.$reg = $reg;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Published package at " + this.$pDir.getPath() + " to " + this.$reg.getName() + " registry";
                }
            }));
        }
    }

    private static final Provider _init_$lambda-0(KProperty1 $tmp0, NpmRegistry p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Provider)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final NpmRegistry _init_$lambda-1(NpmPublishTask this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object[] objectArray = new Object[]{this$0.getName()};
        return (NpmRegistry)this$0.getProject().getObjects().newInstance(NpmRegistry.class, objectArray);
    }

    private static final void doAction$lambda-2(NpmPublishTask this$0, ExecSpec it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        it.workingDir(GeneralKt.getFinal((Property)this$0.getPackageDir()));
    }
}

