/*
 * Decompiled with CFR 0.152.
 */
package dev.petuska.npm.publish.task;

import dev.petuska.npm.publish.extension.domain.NpmRegistry;
import dev.petuska.npm.publish.task.NpmExecTask;
import dev.petuska.npm.publish.util.GeneralKt;
import java.io.File;
import java.net.URI;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;
import org.gradle.api.tasks.options.Option;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;

@UntrackedTask(because="Must always run")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0003J\u0014\u0010\f\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u0015R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0007\u00a8\u0006\u0016"}, d2={"Ldev/petuska/npm/publish/task/NpmPublishTask;", "Ldev/petuska/npm/publish/task/NpmExecTask;", "()V", "dry", "Lorg/gradle/api/provider/Property;", "", "getDry", "()Lorg/gradle/api/provider/Property;", "packageDir", "Lorg/gradle/api/file/DirectoryProperty;", "getPackageDir", "()Lorg/gradle/api/file/DirectoryProperty;", "registry", "Ldev/petuska/npm/publish/extension/domain/NpmRegistry;", "getRegistry", "tag", "", "getTag", "doAction", "", "action", "Lorg/gradle/api/Action;", "npm-publish-gradle-plugin"})
public abstract class NpmPublishTask
extends NpmExecTask {
    public NpmPublishTask() {
        this.setGroup("publishing");
        this.setDescription("Publishes NPM package to NPM registry");
        this.getDry().convention(this.getRegistry().flatMap(arg_0 -> NpmPublishTask._init_$lambda$0((Function1)1.INSTANCE, arg_0)));
        this.getRegistry().convention(this.getProject().provider(() -> NpmPublishTask._init_$lambda$1(this)));
    }

    @Nested
    @NotNull
    public abstract Property<NpmRegistry> getRegistry();

    @InputDirectory
    @NotNull
    public abstract DirectoryProperty getPackageDir();

    @Input
    @Option(option="dry", description="Execute in dry-run mode")
    @NotNull
    public abstract Property<Boolean> getDry();

    @Input
    @Optional
    @Option(option="tag", description="Optional tag to label the published package version")
    @NotNull
    public abstract Property<String> getTag();

    public final void registry(@NotNull Action<NpmRegistry> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        GeneralKt.configure(this.getRegistry(), action2);
    }

    @TaskAction
    private final void doAction() {
        List list;
        File pDir = (File)this.getPackageDir().getAsFile().get();
        NpmRegistry reg = (NpmRegistry)this.getRegistry().get();
        URI uri = (URI)reg.getUri().get();
        String string = uri.getAuthority();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAuthority(...)");
        String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
        String string3 = uri.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
        String repo = string2 + ((Object)StringsKt.trim((CharSequence)string3)).toString() + "/";
        Boolean d = (Boolean)this.getDry().get();
        this.info((Function0<String>)((Function0)new Function0<String>(pDir, reg, d){
            final /* synthetic */ File $pDir;
            final /* synthetic */ NpmRegistry $reg;
            final /* synthetic */ Boolean $d;
            {
                this.$pDir = $pDir;
                this.$reg = $reg;
                this.$d = $d;
                super(0);
            }

            @NotNull
            public final String invoke() {
                String string = this.$reg.getName();
                Boolean bl = this.$d;
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"$d");
                return "Publishing package at " + this.$pDir + " to " + string + " registry " + (bl != false ? "with" : "without") + " --dry-run flag";
            }
        }));
        List $this$doAction_u24lambda_u242 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$doAction_u24lambda_u242.add("publish");
        $this$doAction_u24lambda_u242.add(String.valueOf(pDir));
        $this$doAction_u24lambda_u242.add("--access=" + reg.getAccess().get());
        String string4 = uri.getScheme();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getScheme(...)");
        $this$doAction_u24lambda_u242.add("--registry=" + ((Object)StringsKt.trim((CharSequence)string4)).toString() + "://" + repo);
        if (reg.getOtp().isPresent()) {
            $this$doAction_u24lambda_u242.add("--otp=" + reg.getOtp().get());
        }
        if (reg.getAuthToken().isPresent()) {
            $this$doAction_u24lambda_u242.add("--//" + repo + ":_authToken=" + reg.getAuthToken().get());
        }
        Intrinsics.checkNotNull((Object)d);
        if (d.booleanValue()) {
            $this$doAction_u24lambda_u242.add("--dry-run");
        }
        if (this.getTag().isPresent()) {
            $this$doAction_u24lambda_u242.add("--tag=" + this.getTag().get());
        }
        List args = CollectionsKt.build((List)list);
        this.npmExec(args, (Action<ExecSpec>)((Action)arg_0 -> NpmPublishTask.doAction$lambda$3(this, arg_0))).rethrowFailure();
        if (!d.booleanValue()) {
            this.info((Function0<String>)((Function0)new Function0<String>(pDir, reg){
                final /* synthetic */ File $pDir;
                final /* synthetic */ NpmRegistry $reg;
                {
                    this.$pDir = $pDir;
                    this.$reg = $reg;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Published package at " + this.$pDir + " to " + this.$reg.getName() + " registry";
                }
            }));
        }
    }

    private static final Provider _init_$lambda$0(Function1 $tmp0, Object in) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Provider)$tmp0.invoke(in);
    }

    private static final NpmRegistry _init_$lambda$1(NpmPublishTask this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object[] objectArray = new Object[]{this$0.getName()};
        return (NpmRegistry)this$0.getProject().getObjects().newInstance(NpmRegistry.class, objectArray);
    }

    private static final void doAction$lambda$3(NpmPublishTask this$0, ExecSpec it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        it.workingDir(this$0.getPackageDir().get());
    }
}

