/*
 * Decompiled with CFR 0.152.
 */
package dev.petuska.npm.publish.task;

import dev.petuska.npm.publish.task.NpmExecTask;
import dev.petuska.npm.publish.util.GeneralKt;
import groovy.json.JsonSlurper;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.provider.ValueSource;
import org.gradle.api.provider.ValueSourceParameters;
import org.gradle.api.provider.ValueSourceSpec;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CacheableTask
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0015\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\r\u0010\u001c\u001a\u00020\u0019H\u0001\u00a2\u0006\u0002\b\u001dR\u0014\u0010\u0004\u001a\u00020\u00058aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001f"}, d2={"Ldev/petuska/npm/publish/task/NpmPackTask;", "Ldev/petuska/npm/publish/task/NpmExecTask;", "<init>", "()V", "layout", "Lorg/gradle/api/file/ProjectLayout;", "getLayout$npm_publish_gradle_plugin", "()Lorg/gradle/api/file/ProjectLayout;", "providers", "Lorg/gradle/api/provider/ProviderFactory;", "getProviders$npm_publish_gradle_plugin", "()Lorg/gradle/api/provider/ProviderFactory;", "packageDir", "Lorg/gradle/api/file/DirectoryProperty;", "getPackageDir", "()Lorg/gradle/api/file/DirectoryProperty;", "dry", "Lorg/gradle/api/provider/Property;", "", "getDry", "()Lorg/gradle/api/provider/Property;", "outputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "", "path", "", "doAction", "doAction$npm_publish_gradle_plugin", "PackageJsonParserValueSource", "npm-publish-gradle-plugin"})
public abstract class NpmPackTask
extends NpmExecTask {
    public NpmPackTask() {
        this.setGroup("build");
        this.setDescription("Packs NPM package");
        this.getDry().convention((Object)false);
        this.getOutputFile().convention(this.getLayout$npm_publish_gradle_plugin().getBuildDirectory().zip(this.getProviders$npm_publish_gradle_plugin().of(PackageJsonParserValueSource.class, arg_0 -> NpmPackTask._init_$lambda$1(arg_0 -> NpmPackTask._init_$lambda$0(this, arg_0), arg_0)), (arg_0, arg_1) -> NpmPackTask._init_$lambda$3(NpmPackTask::_init_$lambda$2, arg_0, arg_1)));
    }

    @Inject
    @NotNull
    public abstract ProjectLayout getLayout$npm_publish_gradle_plugin();

    @Inject
    @NotNull
    public abstract ProviderFactory getProviders$npm_publish_gradle_plugin();

    @InputDirectory
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public abstract DirectoryProperty getPackageDir();

    @Input
    @Option(option="dry", description="Execute in dry-run mode")
    @NotNull
    public abstract Property<Boolean> getDry();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputFile();

    @Option(option="outputFile", description="Path to the output file")
    public final void outputFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.getOutputFile().set(new File(path));
    }

    @TaskAction
    public final void doAction$npm_publish_gradle_plugin() {
        List list;
        File pDir = (File)this.getPackageDir().getAsFile().get();
        File oDir = (File)this.getOutputFile().getAsFile().get();
        Boolean d = (Boolean)this.getDry().get();
        this.debug((Function0<String>)((Function0)() -> NpmPackTask.doAction$lambda$4(pDir, oDir, d)));
        File tmpDir = this.getTemporaryDir();
        List $this$doAction_u24lambda_u245 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$doAction_u24lambda_u245.add("pack");
        $this$doAction_u24lambda_u245.add(String.valueOf(pDir));
        if (d.booleanValue()) {
            $this$doAction_u24lambda_u245.add("--dry-run");
        }
        List args = CollectionsKt.build((List)list);
        this.npmExec(args, (Action<ExecSpec>)((Action)arg_0 -> NpmPackTask.doAction$lambda$6(tmpDir, arg_0))).rethrowFailure();
        if (!d.booleanValue()) {
            Object object = tmpDir.listFiles();
            if (object == null || (object = (File)ArraysKt.firstOrNull((Object[])object)) == null) {
                throw new IllegalStateException("[npm-publish] Internal error. Temporary packed file not found.".toString());
            }
            Object outFile = object;
            Intrinsics.checkNotNull((Object)oDir);
            FilesKt.copyTo$default((File)outFile, (File)oDir, (boolean)true, (int)0, (int)4, null);
            this.info((Function0<String>)((Function0)() -> NpmPackTask.doAction$lambda$7(pDir, oDir)));
        }
    }

    private static final Unit _init_$lambda$0(NpmPackTask this$0, ValueSourceSpec it) {
        ((PackageJsonParserValueSource.Params)it.getParameters()).setPackageDir(this$0.getPackageDir());
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final RegularFile _init_$lambda$2(Directory buildDir, String fileName) {
        return buildDir.file("packages/" + fileName);
    }

    private static final RegularFile _init_$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        return (RegularFile)$tmp0.invoke(p0, p1);
    }

    private static final String doAction$lambda$4(File $pDir, File $oDir, Boolean $d) {
        return "Packing package at " + $pDir.getPath() + " to " + $oDir.getParentFile().getPath() + " " + ($d != false ? "with" : "without") + " --dry-run flag";
    }

    private static final void doAction$lambda$6(File $tmpDir, ExecSpec it) {
        it.workingDir((Object)$tmpDir);
    }

    private static final String doAction$lambda$7(File $pDir, File $oDir) {
        return "Packed package at " + $pDir.getPath() + " to " + $oDir.getPath();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\b \u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0007B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\b"}, d2={"Ldev/petuska/npm/publish/task/NpmPackTask$PackageJsonParserValueSource;", "Lorg/gradle/api/provider/ValueSource;", "", "Ldev/petuska/npm/publish/task/NpmPackTask$PackageJsonParserValueSource$Params;", "<init>", "()V", "obtain", "Params", "npm-publish-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nNpmPackTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NpmPackTask.kt\ndev/petuska/npm/publish/task/NpmPackTask$PackageJsonParserValueSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n1#2:123\n*E\n"})
    public static abstract class PackageJsonParserValueSource
    implements ValueSource<String, Params> {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public String obtain() {
            Object object = ((Directory)((Params)this.getParameters()).getPackageDir().get()).file("package.json").getAsFile();
            File p0 = object;
            boolean bl = false;
            if (!p0.exists()) return null;
            File file = object;
            File file2 = file;
            if (file2 == null) return null;
            Object it = file2;
            boolean bl2 = false;
            object = (Map)GeneralKt.unsafeCast(new JsonSlurper().parse((File)it));
            if (object == null) return null;
            it = object;
            boolean bl3 = false;
            Object v = it.get("name");
            String name = v != null && (v = v.toString()) != null && (v = StringsKt.replace$default(v, (String)"@", (String)"", (boolean)false, (int)4, null)) != null ? StringsKt.replace$default(v, (String)"/", (String)"-", (boolean)false, (int)4, null) : null;
            Object v2 = it.get("version");
            String version = v2 != null ? v2.toString() : null;
            String string = name;
            if (string == null) return null;
            String it2 = string;
            boolean bl4 = false;
            Object fileName = null;
            fileName = name;
            String string2 = version;
            if (string2 != null) {
                String it3 = string2;
                boolean bl5 = false;
                fileName = fileName + "-" + version;
            }
            String string3 = fileName + ".tgz";
            return string3;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b`\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\u00020\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ldev/petuska/npm/publish/task/NpmPackTask$PackageJsonParserValueSource$Params;", "Lorg/gradle/api/provider/ValueSourceParameters;", "packageDir", "Lorg/gradle/api/file/DirectoryProperty;", "getPackageDir", "()Lorg/gradle/api/file/DirectoryProperty;", "setPackageDir", "(Lorg/gradle/api/file/DirectoryProperty;)V", "npm-publish-gradle-plugin"})
        public static interface Params
        extends ValueSourceParameters {
            @NotNull
            public DirectoryProperty getPackageDir();

            public void setPackageDir(@NotNull DirectoryProperty var1);
        }
    }
}

