/*
 * Decompiled with CFR 0.152.
 */
package dev.petuska.npm.publish.task;

import dev.petuska.npm.publish.extension.domain.NpmRegistry;
import dev.petuska.npm.publish.task.NpmExecTask;
import dev.petuska.npm.publish.util.GeneralKt;
import java.io.File;
import java.net.URI;
import java.util.Base64;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.SyncSpec;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;
import org.gradle.api.tasks.options.Option;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;

@UntrackedTask(because="Must always run")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\b\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u0019J\r\u0010\u001c\u001a\u00020\u0017H\u0001\u00a2\u0006\u0002\b\u001dR\u0014\u0010\u0004\u001a\u00020\u00058aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\fR\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\fR\u0014\u0010\u001a\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0010\u00a8\u0006\u001e"}, d2={"Ldev/petuska/npm/publish/task/NpmPublishTask;", "Ldev/petuska/npm/publish/task/NpmExecTask;", "<init>", "()V", "fs", "Lorg/gradle/api/file/FileSystemOperations;", "getFs$npm_publish_gradle_plugin", "()Lorg/gradle/api/file/FileSystemOperations;", "registry", "Lorg/gradle/api/provider/Property;", "Ldev/petuska/npm/publish/extension/domain/NpmRegistry;", "getRegistry", "()Lorg/gradle/api/provider/Property;", "packageDir", "Lorg/gradle/api/file/DirectoryProperty;", "getPackageDir", "()Lorg/gradle/api/file/DirectoryProperty;", "dry", "", "getDry", "tag", "", "getTag", "", "action", "Lorg/gradle/api/Action;", "workingDir", "getWorkingDir", "doAction", "doAction$npm_publish_gradle_plugin", "npm-publish-gradle-plugin"})
public abstract class NpmPublishTask
extends NpmExecTask {
    public NpmPublishTask() {
        this.setGroup("publishing");
        this.setDescription("Publishes NPM package to NPM registry");
        this.getDry().convention(this.getRegistry().flatMap(arg_0 -> NpmPublishTask._init_$lambda$0((Function1)1.INSTANCE, arg_0)));
        this.getWorkingDir().convention(this.getProject().getLayout().getBuildDirectory().dir(this.getRegistry().zip((Provider)this.getPackageDir(), (arg_0, arg_1) -> NpmPublishTask._init_$lambda$2(NpmPublishTask::_init_$lambda$1, arg_0, arg_1))));
        this.getRegistry().convention(this.getProject().provider(() -> NpmPublishTask._init_$lambda$3(this)));
    }

    @Inject
    @NotNull
    public abstract FileSystemOperations getFs$npm_publish_gradle_plugin();

    @Nested
    @NotNull
    public abstract Property<NpmRegistry> getRegistry();

    @InputDirectory
    @NotNull
    public abstract DirectoryProperty getPackageDir();

    @Input
    @Option(option="dry", description="Execute in dry-run mode")
    @NotNull
    public abstract Property<Boolean> getDry();

    @Input
    @Optional
    @Option(option="tag", description="Optional tag to label the published package version")
    @NotNull
    public abstract Property<String> getTag();

    public final void registry(@NotNull Action<NpmRegistry> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        GeneralKt.configure(this.getRegistry(), action);
    }

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getWorkingDir();

    @TaskAction
    public final void doAction$npm_publish_gradle_plugin() {
        List list;
        NpmRegistry reg = (NpmRegistry)this.getRegistry().get();
        URI uri = (URI)reg.getUri().get();
        String string = uri.getAuthority();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAuthority(...)");
        String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
        String string3 = uri.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
        String repo = string2 + ((Object)StringsKt.trim((CharSequence)string3)).toString() + "/";
        File workingDir = ((Directory)this.getWorkingDir().get()).getAsFile();
        Boolean d = (Boolean)this.getDry().get();
        this.info((Function0<String>)((Function0)() -> NpmPublishTask.doAction$lambda$4(workingDir, reg, d)));
        List $this$doAction_u24lambda_u245 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$doAction_u24lambda_u245.add("publish");
        $this$doAction_u24lambda_u245.add(String.valueOf(workingDir));
        $this$doAction_u24lambda_u245.add("--access=" + reg.getAccess().get());
        String string4 = uri.getScheme();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getScheme(...)");
        $this$doAction_u24lambda_u245.add("--registry=" + ((Object)StringsKt.trim((CharSequence)string4)).toString() + "://" + repo);
        if (reg.getOtp().isPresent()) {
            $this$doAction_u24lambda_u245.add("--otp=" + reg.getOtp().get());
        }
        if (reg.getAuthToken().isPresent()) {
            $this$doAction_u24lambda_u245.add("--//" + repo + ":_authToken=" + reg.getAuthToken().get());
        }
        if (reg.getAuth().isPresent()) {
            $this$doAction_u24lambda_u245.add("--//" + repo + ":_auth=" + reg.getAuth().get());
        }
        if (reg.getUsername().isPresent()) {
            $this$doAction_u24lambda_u245.add("--//" + repo + ":username=" + reg.getUsername().get());
        }
        if (reg.getPassword().isPresent()) {
            String password = (String)reg.getPassword().get();
            Base64.Encoder encoder = Base64.getEncoder();
            Intrinsics.checkNotNull((Object)password);
            byte[] byArray = password.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            String encoded = encoder.encodeToString(byArray);
            $this$doAction_u24lambda_u245.add("--//" + repo + ":_password=" + encoded);
        }
        if (d.booleanValue()) {
            $this$doAction_u24lambda_u245.add("--dry-run");
        }
        if (this.getTag().isPresent()) {
            $this$doAction_u24lambda_u245.add("--tag=" + this.getTag().get());
        }
        List args = CollectionsKt.build((List)list);
        this.getFs$npm_publish_gradle_plugin().sync(arg_0 -> NpmPublishTask.doAction$lambda$7(arg_0 -> NpmPublishTask.doAction$lambda$6(this, reg, workingDir, arg_0), arg_0));
        this.npmExec(args, (Action<ExecSpec>)((Action)arg_0 -> NpmPublishTask.doAction$lambda$8(workingDir, arg_0))).rethrowFailure();
        if (!d.booleanValue()) {
            this.info((Function0<String>)((Function0)() -> NpmPublishTask.doAction$lambda$9(workingDir, reg)));
        }
    }

    private static final Provider _init_$lambda$0(Function1 $tmp0, Object in) {
        return (Provider)$tmp0.invoke(in);
    }

    private static final String _init_$lambda$1(NpmRegistry reg, Directory pDir) {
        return "registries/" + reg.getName() + "/" + pDir.getAsFile().getName();
    }

    private static final String _init_$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        return (String)$tmp0.invoke(p0, p1);
    }

    private static final NpmRegistry _init_$lambda$3(NpmPublishTask this$0) {
        Object[] objectArray = new Object[]{this$0.getName()};
        return (NpmRegistry)this$0.getProject().getObjects().newInstance(NpmRegistry.class, objectArray);
    }

    private static final String doAction$lambda$4(File $workingDir, NpmRegistry $reg, Boolean $d) {
        return "Publishing package at " + $workingDir + " to " + $reg.getName() + " registry " + ($d != false ? "with" : "without") + " --dry-run flag";
    }

    private static final Unit doAction$lambda$6(NpmPublishTask this$0, NpmRegistry $reg, File $workingDir, SyncSpec it) {
        Object[] objectArray = new Object[]{this$0.getPackageDir()};
        it.from(objectArray);
        if ($reg.getNpmrc().isPresent()) {
            objectArray = new Object[]{$reg.getNpmrc()};
            it.from(objectArray);
        }
        it.into((Object)$workingDir);
        return Unit.INSTANCE;
    }

    private static final void doAction$lambda$7(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void doAction$lambda$8(File $workingDir, ExecSpec it) {
        it.workingDir((Object)$workingDir);
    }

    private static final String doAction$lambda$9(File $workingDir, NpmRegistry $reg) {
        return "Published package at " + $workingDir + " to " + $reg.getName() + " registry";
    }
}

