/*
 * Decompiled with CFR 0.152.
 */
package dev.pretsa.scm.version;

import dev.pretsa.scm.version.Configuration;
import dev.pretsa.scm.version.SemanticVersion;
import dev.pretsa.scm.version.VersionQualifier;
import dev.pretsa.scm.version.VersionType;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationBuilder.class);
    private static final String VERSION_TYPE = "version type";
    private static final String NEXT_VERSION_COMPONENT = "next version component";
    private static final String VERSION_QUALIFIER = "version qualifier";

    private ConfigurationBuilder() {
    }

    public static Configuration build(Path topDirectory, Map<String, String> properties) {
        logger.atDebug().addArgument((Object)topDirectory).log("Working directory is {}");
        VersionType versionType = ConfigurationBuilder.getVersionType(properties.keySet());
        SemanticVersion.Component nextVersionComponent = ConfigurationBuilder.getNextVersionComponent(versionType, properties.keySet());
        VersionQualifier versionQualifier = ConfigurationBuilder.getVersionQualifier(properties.keySet());
        return new Configuration(topDirectory, versionType, nextVersionComponent, versionQualifier);
    }

    private static VersionType getVersionType(Set<String> keys) {
        boolean containsNext = ConfigurationBuilder.containsNext(keys);
        boolean containsCurrent = ConfigurationBuilder.containsCurrent(keys);
        if (containsNext && containsCurrent) {
            throw new IllegalArgumentException("Multiple version types present, only one is allowed [NEXT, CURRENT].");
        }
        if (containsNext) {
            ConfigurationBuilder.logUserDefinedProperty(VERSION_TYPE, VersionType.NEXT.name());
            return VersionType.NEXT;
        }
        if (containsCurrent) {
            ConfigurationBuilder.logUserDefinedProperty(VERSION_TYPE, VersionType.CURRENT.name());
            return VersionType.CURRENT;
        }
        ConfigurationBuilder.logDefaultProperty(VERSION_TYPE, VersionType.NEXT.name());
        return VersionType.NEXT;
    }

    private static boolean containsCurrent(Set<String> keys) {
        return keys.contains("scm.current");
    }

    private static boolean containsNext(Set<String> keys) {
        return keys.contains("scm.next") || keys.contains("scm.next.major.release") || keys.contains("scm.next.minor.release") || keys.contains("scm.next.patch.release") || keys.contains("scm.next.major.snapshot") || keys.contains("scm.next.minor.snapshot") || keys.contains("scm.next.patch.snapshot");
    }

    private static SemanticVersion.Component getNextVersionComponent(VersionType versionType, Set<String> keys) {
        boolean containsMajor = ConfigurationBuilder.containsMajor(keys);
        boolean containsMinor = ConfigurationBuilder.containsMinor(keys);
        boolean containsPatch = ConfigurationBuilder.containsPatch(keys);
        if (containsMajor && containsMinor || (containsMajor || containsMinor) && containsPatch) {
            throw new IllegalArgumentException("Multiple NEXT version components present, only one is allowed [MAJOR, MINOR, PATCH].");
        }
        if (versionType == VersionType.CURRENT && (containsMajor || containsMinor || containsPatch)) {
            throw new IllegalArgumentException("Version NEXT component present, but version type is CURRENT.");
        }
        if (containsMajor) {
            ConfigurationBuilder.logUserDefinedProperty(NEXT_VERSION_COMPONENT, SemanticVersion.Component.MAJOR.name());
            return SemanticVersion.Component.MAJOR;
        }
        if (ConfigurationBuilder.containsMinor(keys)) {
            ConfigurationBuilder.logUserDefinedProperty(NEXT_VERSION_COMPONENT, SemanticVersion.Component.MINOR.name());
            return SemanticVersion.Component.MINOR;
        }
        if (ConfigurationBuilder.containsPatch(keys)) {
            ConfigurationBuilder.logUserDefinedProperty(NEXT_VERSION_COMPONENT, SemanticVersion.Component.PATCH.name());
            return SemanticVersion.Component.PATCH;
        }
        ConfigurationBuilder.logDefaultProperty(NEXT_VERSION_COMPONENT, SemanticVersion.Component.PATCH.name());
        return SemanticVersion.Component.PATCH;
    }

    private static boolean containsMajor(Set<String> keys) {
        return keys.contains("scm.major") || keys.contains("scm.next.major.release") || keys.contains("scm.next.major.snapshot");
    }

    private static boolean containsMinor(Set<String> keys) {
        return keys.contains("scm.minor") || keys.contains("scm.next.minor.release") || keys.contains("scm.next.minor.snapshot");
    }

    private static boolean containsPatch(Set<String> keys) {
        return keys.contains("scm.patch") || keys.contains("scm.next.patch.release") || keys.contains("scm.next.patch.snapshot");
    }

    private static VersionQualifier getVersionQualifier(Set<String> keys) {
        boolean containsRelease = ConfigurationBuilder.containsRelease(keys);
        boolean containsSnapshot = ConfigurationBuilder.containsSnapshot(keys);
        if (containsRelease && containsSnapshot) {
            throw new IllegalArgumentException("Multiple version qualifiers present, only one is allowed [RELEASE, SNAPSHOT].");
        }
        if (containsRelease) {
            ConfigurationBuilder.logUserDefinedProperty(VERSION_QUALIFIER, VersionQualifier.RELEASE.name());
            return VersionQualifier.RELEASE;
        }
        if (ConfigurationBuilder.containsSnapshot(keys)) {
            ConfigurationBuilder.logUserDefinedProperty(VERSION_QUALIFIER, VersionQualifier.SNAPSHOT.name());
            return VersionQualifier.SNAPSHOT;
        }
        ConfigurationBuilder.logDefaultProperty(VERSION_QUALIFIER, VersionQualifier.SNAPSHOT.name());
        return VersionQualifier.SNAPSHOT;
    }

    private static boolean containsRelease(Set<String> keys) {
        return keys.contains("scm.release") || keys.contains("scm.next.major.release") || keys.contains("scm.next.minor.release") || keys.contains("scm.next.patch.release");
    }

    private static boolean containsSnapshot(Set<String> keys) {
        return keys.contains("scm.snapshot") || keys.contains("scm.next.major.snapshot") || keys.contains("scm.next.minor.snapshot") || keys.contains("scm.next.patch.snapshot");
    }

    private static void logUserDefinedProperty(String key, String value) {
        logger.atDebug().addArgument((Object)key).addArgument((Object)value).log("Found user defined property for {}, value set to {}");
    }

    private static void logDefaultProperty(String key, String value) {
        logger.atDebug().addArgument((Object)key).addArgument((Object)value).log("No user defined property for {}, value set to {}");
    }
}

