/*
 * Decompiled with CFR 0.152.
 */
package dev.pretsa.scm.version;

import dev.pretsa.scm.version.Configuration;
import dev.pretsa.scm.version.ScmVersionProvider;
import dev.pretsa.scm.version.SemanticVersion;
import dev.pretsa.scm.version.VersionType;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class VersionProvider {
    private static final Logger logger = LoggerFactory.getLogger(VersionProvider.class);
    private final ScmVersionProvider scm;

    @Inject
    public VersionProvider(ScmVersionProvider scmVersionProvider) {
        this.scm = scmVersionProvider;
    }

    public String getVersion(Configuration configuration) {
        String currentVersionTag = this.scm.getLatestVersion(configuration.topDirectory());
        SemanticVersion currentVersion = SemanticVersion.parse(currentVersionTag);
        SemanticVersion finalVersion = switch (configuration.versionType()) {
            default -> throw new IncompatibleClassChangeError();
            case VersionType.CURRENT -> currentVersion;
            case VersionType.NEXT -> currentVersion.next(configuration.nextVersionComponent());
        };
        String finalVersionString = finalVersion.formatted(configuration.versionQualifier().suffix());
        logger.atInfo().addArgument((Object)"scm.version").addArgument((Object)finalVersionString).addArgument((Object)configuration.describe()).log("{} property computed to [{}] as the [{}]");
        return finalVersionString;
    }
}

