/*
 * Decompiled with CFR 0.152.
 */
package dev.pretsa.scm.version;

public record Version(int major, int minor, int patch) {
    public static Version parse(String version) {
        String[] splitRevision = version.split("\\.");
        if (splitRevision.length != 3) {
            throw new IllegalArgumentException("Not a valid version");
        }
        int major = Integer.parseInt(splitRevision[0]);
        int minor = Integer.parseInt(splitRevision[1]);
        int patch = Integer.parseInt(splitRevision[2]);
        return new Version(major, minor, patch);
    }

    public Version next(Component component) {
        return switch (component) {
            default -> throw new IncompatibleClassChangeError();
            case Component.MAJOR -> new Version(this.major + 1, 0, 0);
            case Component.MINOR -> new Version(this.major, this.minor + 1, 0);
            case Component.PATCH -> new Version(this.major, this.minor, this.patch + 1);
        };
    }

    public String formatted() {
        return "%s.%s.%s".formatted(this.major, this.minor, this.patch);
    }

    public String formatted(String suffix) {
        return "%s%s".formatted(this.formatted(), suffix);
    }

    public static enum Component {
        MAJOR,
        MINOR,
        PATCH;

    }
}

