/*
 * Decompiled with CFR 0.152.
 */
package dev.pretsa.scm.version;

import dev.pretsa.scm.version.Configuration;
import dev.pretsa.scm.version.ScmTagProvider;
import dev.pretsa.scm.version.Version;
import dev.pretsa.scm.version.VersionType;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class VersionProvider {
    private static final Logger logger = LoggerFactory.getLogger(VersionProvider.class);
    private final ScmTagProvider scm;

    @Inject
    public VersionProvider(ScmTagProvider scmTagProvider) {
        this.scm = scmTagProvider;
    }

    public String getVersion(Configuration configuration) {
        String currentVersionTag = this.scm.getLatestTag(configuration.directory());
        Version currentVersion = Version.parse(currentVersionTag);
        Version finalVersion = switch (configuration.versionType()) {
            default -> throw new IncompatibleClassChangeError();
            case VersionType.CURRENT -> currentVersion;
            case VersionType.NEXT -> currentVersion.next(configuration.nextVersionComponent());
        };
        String finalVersionString = finalVersion.formatted(configuration.versionQualifier().suffix());
        logger.atInfo().addArgument((Object)"scm.version").addArgument((Object)finalVersionString).addArgument((Object)configuration.describe()).log("{} property computed to [{}] as the [{}]");
        return finalVersionString;
    }
}

