/*
 * Decompiled with CFR 0.152.
 */
package dev.pretsa.scm.version.git;

import dev.pretsa.scm.version.ScmTagProvider;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class GitScmTagProvider
implements ScmTagProvider {
    private static final Logger logger = LoggerFactory.getLogger(GitScmTagProvider.class);
    private static final String TAG_WITH_SEMANTIC_VERSION_GLOB = "*[0-9]*.[0-9]*.[0-9]*";
    private static final Pattern TAG_WITH_SEMANTIC_VERSION_PATTERN = Pattern.compile("(.+-)?(v)?(.+)");
    private static final String DEFAULT_TAG = "0.0.0";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getLatestTag(Path directory) {
        FileRepositoryBuilder repositoryBuilder = (FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().readEnvironment()).findGitDir(directory.toFile());
        try (Repository repository = repositoryBuilder.build();
             Git git = Git.wrap((Repository)repository);){
            String tag = git.describe().setAbbrev(0).setTags(true).setMatch(new String[]{TAG_WITH_SEMANTIC_VERSION_GLOB}).call();
            if (tag == null) {
                throw new IllegalArgumentException("No git tag matching supported glob [%s]".formatted(TAG_WITH_SEMANTIC_VERSION_GLOB));
            }
            Matcher semanticVersionMatcher = TAG_WITH_SEMANTIC_VERSION_PATTERN.matcher(tag);
            if (semanticVersionMatcher.find()) {
                String string = semanticVersionMatcher.group(3);
                return string;
            }
            throw new IllegalArgumentException("Git tag [%s] does not match supported pattern [%s]".formatted(tag, TAG_WITH_SEMANTIC_VERSION_PATTERN.pattern()));
        }
        catch (Exception e) {
            logger.atWarn().addArgument((Object)directory).addArgument((Object)e.getMessage()).log("Error loading tag at {}: {}");
            logger.atInfo().addArgument((Object)DEFAULT_TAG).log("Using default tag [{}]");
            return DEFAULT_TAG;
        }
    }
}

