/*
 * Decompiled with CFR 0.152.
 */
package dev.pretsa.scm.version.maven;

import dev.pretsa.scm.version.Configuration;
import dev.pretsa.scm.version.ConfigurationBuilder;
import dev.pretsa.scm.version.VersionProvider;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.ProtoSession;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.spi.PropertyContributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public class VersionPropertyContributor
implements PropertyContributor {
    private static final Logger logger = LoggerFactory.getLogger(VersionPropertyContributor.class);
    private final VersionProvider versionProvider;

    @Inject
    public VersionPropertyContributor(VersionProvider versionProvider) {
        this.versionProvider = versionProvider;
    }

    public Map<String, String> contribute(ProtoSession protoSession) {
        try {
            logger.atInfo().log("scm-version-maven-extension loaded");
            if (protoSession.getUserProperties().containsKey("scm.version")) {
                logger.atInfo().addArgument((Object)"scm.version").addArgument(protoSession.getUserProperties().get("scm.version")).log("Found user defined property [{}], value set to [{}]. Nothing will be done! and other scm.* properties will be ignored");
                return protoSession.getUserProperties();
            }
            Configuration configuration = ConfigurationBuilder.build(protoSession.getTopDirectory(), protoSession.getUserProperties());
            String version = this.versionProvider.getVersion(configuration);
            HashMap<String, String> result = new HashMap<String, String>(protoSession.getUserProperties());
            result.put("scm.version", version);
            return result;
        }
        catch (Exception e) {
            logger.atError().addArgument((Object)"scm.version").addArgument((Object)e.getMessage()).log("Error computing {} property, {}");
            return protoSession.getUserProperties();
        }
    }
}

