/*
 * Decompiled with CFR 0.152.
 */
package dev.profunktor.redis4cats;

import cats.Functor;
import cats.MonadError;
import cats.UnorderedFoldable$;
import cats.effect.kernel.GenTemporal;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.syntax.package;
import dev.profunktor.redis4cats.BaseRedis;
import dev.profunktor.redis4cats.Redis;
import dev.profunktor.redis4cats.Redis$;
import dev.profunktor.redis4cats.Redis$Pool$Settings$;
import dev.profunktor.redis4cats.RedisCluster;
import dev.profunktor.redis4cats.RedisCommands;
import dev.profunktor.redis4cats.config;
import dev.profunktor.redis4cats.connection.RedisClient;
import dev.profunktor.redis4cats.connection.RedisClusterClient;
import dev.profunktor.redis4cats.connection.RedisMasterReplica;
import dev.profunktor.redis4cats.connection.RedisStatefulConnection;
import dev.profunktor.redis4cats.connection.RedisURI;
import dev.profunktor.redis4cats.connection.RedisURI$;
import dev.profunktor.redis4cats.data;
import dev.profunktor.redis4cats.effect.FutureLift;
import dev.profunktor.redis4cats.effect.Log;
import dev.profunktor.redis4cats.effect.MkRedis;
import dev.profunktor.redis4cats.effect.MkRedis$;
import dev.profunktor.redis4cats.tx.TxRunner;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.ReadFrom;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.codec.RedisCodec;
import java.io.Serializable;
import org.typelevel.keypool.KeyPool;
import scala.Function$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public class Redis<F, K, V>
extends BaseRedis<F, K, V> {
    public static <F, K, V> Tuple2<Object, Function1<Redis<F, K, V>, Object>> acquireAndRelease(RedisClient redisClient, RedisCodec redisCodec, TxRunner<F> txRunner, FutureLift<F> futureLift, Log<F> log, MonadError<F, Throwable> monadError) {
        return Redis$.MODULE$.acquireAndRelease(redisClient, redisCodec, txRunner, futureLift, log, monadError);
    }

    public static <F, K, V> Tuple2<Object, Function1<RedisCluster<F, K, V>, Object>> acquireAndReleaseCluster(RedisClusterClient redisClusterClient, RedisCodec redisCodec, Option<ReadFrom> option, TxRunner<F> txRunner, FutureLift<F> futureLift, Log<F> log, MonadError<F, Throwable> monadError) {
        return Redis$.MODULE$.acquireAndReleaseCluster(redisClusterClient, redisCodec, option, txRunner, futureLift, log, monadError);
    }

    public static <F, K, V> Tuple2<Object, Function1<BaseRedis<F, K, V>, Object>> acquireAndReleaseClusterByNode(RedisClusterClient redisClusterClient, RedisCodec redisCodec, Option<ReadFrom> option, String string, TxRunner<F> txRunner, FutureLift<F> futureLift, Log<F> log, MonadError<F, Throwable> monadError) {
        return Redis$.MODULE$.acquireAndReleaseClusterByNode(redisClusterClient, redisCodec, option, string, txRunner, futureLift, log, monadError);
    }

    public static <F> RedisPartiallyApplied<F> apply(MkRedis<F> mkRedis, MonadError<F, Throwable> monadError) {
        return Redis$.MODULE$.apply(mkRedis, monadError);
    }

    public Redis(RedisStatefulConnection<F, K, V> connection, TxRunner<F> tx, FutureLift<F> evidence$1, MonadError<F, Throwable> evidence$2, Log<F> evidence$3) {
        super(connection, tx, false, evidence$1, evidence$2, evidence$3);
    }

    public static class RedisPartiallyApplied<F> {
        private final MkRedis<F> evidence$1;
        private final MonadError<F, Throwable> evidence$2;
        private final FutureLift fl;
        private final Log log;

        public RedisPartiallyApplied(MkRedis<F> evidence$1, MonadError<F, Throwable> evidence$2) {
            this.evidence$1 = evidence$1;
            this.evidence$2 = evidence$2;
            this.fl = MkRedis$.MODULE$.apply(evidence$1).futureLift();
            this.log = MkRedis$.MODULE$.apply(evidence$1).log();
        }

        public FutureLift<F> fl() {
            return this.fl;
        }

        public Log<F> log() {
            return this.log;
        }

        public <K, V> Resource<F, RedisCommands<F, K, V>> simple(String uri, RedisCodec codec) {
            return MkRedis$.MODULE$.apply(this.evidence$1).clientFrom(() -> this.simple$$anonfun$1(uri)).flatMap((Function1 & Serializable)_$7 -> this.fromClient((RedisClient)_$7, codec));
        }

        public <K, V> Resource<F, RedisCommands<F, K, V>> withOptions(String uri, ClientOptions opts, RedisCodec codec) {
            return MkRedis$.MODULE$.apply(this.evidence$1).clientWithOptions(() -> this.withOptions$$anonfun$1(uri), opts).flatMap((Function1 & Serializable)_$8 -> this.fromClient((RedisClient)_$8, codec));
        }

        public <K, V> Resource<F, RedisCommands<F, K, V>> custom(String uri, ClientOptions opts, config.Redis4CatsConfig config2, RedisCodec codec) {
            return Resource$.MODULE$.eval(RedisURI$.MODULE$.make(() -> this.custom$$anonfun$1(uri), this.evidence$2)).flatMap((Function1 & Serializable)_$9 -> MkRedis$.MODULE$.apply(this.evidence$1).clientCustom(() -> this.custom$$anonfun$2$$anonfun$1(_$9), opts, config2)).flatMap((Function1 & Serializable)_$10 -> this.fromClient((RedisClient)_$10, codec));
        }

        public Resource<F, RedisCommands<F, String, String>> utf8(String uri) {
            return this.simple(uri, data.RedisCodec$.MODULE$.Utf8());
        }

        public <K, V> Resource<F, RedisCommands<F, K, V>> fromClient(RedisClient client, RedisCodec codec) {
            return MkRedis$.MODULE$.apply(this.evidence$1).txRunner().flatMap((Function1 & Serializable)tx -> {
                Tuple2 tuple2 = Redis$.MODULE$.acquireAndRelease(client, codec, tx, this.fl(), this.log(), this.evidence$2);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Object acquire = tuple2._1();
                Function1 release = (Function1)tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply(acquire, (Object)release);
                Object acquire2 = tuple22._1();
                Function1 release2 = (Function1)tuple22._2();
                return (Resource)package.all$.MODULE$.toFunctorOps((Object)Resource$.MODULE$.make(acquire2, release2, this.evidence$2), (Functor)Resource$.MODULE$.catsEffectMonadErrorForResource(this.evidence$2)).widen();
            });
        }

        public <K, V> Resource<F, KeyPool<F, BoxedUnit, RedisCommands<F, K, V>>> pooled(RedisClient client, RedisCodec codec, GenTemporal<F, Throwable> T) {
            return Resource$.MODULE$.eval(Redis$Pool$Settings$.MODULE$.default(this.evidence$1, T)).flatMap((Function1 & Serializable)poolSettings -> this.customPooled(client, codec, (Pool.Settings)poolSettings, T));
        }

        public <K, V> Resource<F, KeyPool<F, BoxedUnit, RedisCommands<F, K, V>>> customPooled(RedisClient client, RedisCodec codec, Pool.Settings poolSettings, GenTemporal<F, Throwable> T) {
            Resource cmdsResource = this.fromClient(client, codec);
            return KeyPool.Builder$.MODULE$.apply((Function1 & Serializable)_$11 -> cmdsResource, T).withMaxPerKey((Function1 & Serializable)y -> BoxesRunTime.unboxToInt((Object)Function$.MODULE$.const((Object)BoxesRunTime.boxToInteger((int)poolSettings.maxTotal()), y))).withMaxTotal(poolSettings.maxTotal()).withMaxIdle(poolSettings.maxIdle()).withIdleTimeAllowedInPool((Duration)poolSettings.idleTimeAllowedInPool()).build();
        }

        public <K, V> Resource<F, RedisCommands<F, K, V>> cluster(RedisCodec codec, Seq<String> uris, Option<ReadFrom> readFrom) {
            return Resource$.MODULE$.eval(package.all$.MODULE$.toTraverseOps((Object)uris.toList(), UnorderedFoldable$.MODULE$.catsTraverseForList()).traverse((Function1 & Serializable)_$12 -> RedisURI$.MODULE$.make(() -> this.cluster$$anonfun$1$$anonfun$1(_$12), this.evidence$2), this.evidence$2)).flatMap((Function1 & Serializable)redisUris -> MkRedis$.MODULE$.apply(this.evidence$1).clusterClient((Seq)redisUris).flatMap((Function1 & Serializable)client -> this.fromClusterClient((RedisClusterClient)client, codec, readFrom).map((Function1 & Serializable)redis -> redis)));
        }

        public <K, V> Option<ReadFrom> cluster$default$3(RedisCodec codec, Seq<String> uris) {
            return None$.MODULE$;
        }

        public Resource<F, RedisCommands<F, String, String>> clusterUtf8(Seq<String> uris, Option<ReadFrom> readFrom) {
            return this.cluster(data.RedisCodec$.MODULE$.Utf8(), uris, readFrom);
        }

        public Option<ReadFrom> clusterUtf8$default$2(Seq<String> uris) {
            return None$.MODULE$;
        }

        public <K, V> Resource<F, RedisCommands<F, K, V>> fromClusterClient(RedisClusterClient clusterClient, RedisCodec codec, Option<ReadFrom> readFrom) {
            return MkRedis$.MODULE$.apply(this.evidence$1).txRunner().flatMap((Function1 & Serializable)tx -> {
                Tuple2 tuple2 = Redis$.MODULE$.acquireAndReleaseCluster(clusterClient, codec, readFrom, tx, this.fl(), this.log(), this.evidence$2);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Object acquire = tuple2._1();
                Function1 release = (Function1)tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply(acquire, (Object)release);
                Object acquire2 = tuple22._1();
                Function1 release2 = (Function1)tuple22._2();
                return (Resource)package.all$.MODULE$.toFunctorOps((Object)Resource$.MODULE$.make(acquire2, release2, this.evidence$2), (Functor)Resource$.MODULE$.catsEffectMonadErrorForResource(this.evidence$2)).widen();
            });
        }

        public <K, V> Option<ReadFrom> fromClusterClient$default$3(RedisClusterClient clusterClient, RedisCodec codec) {
            return None$.MODULE$;
        }

        public <K, V> Resource<F, RedisCommands<F, K, V>> fromClusterClientByNode(RedisClusterClient clusterClient, RedisCodec codec, String nodeId, Option<ReadFrom> readFrom) {
            return MkRedis$.MODULE$.apply(this.evidence$1).txRunner().flatMap((Function1 & Serializable)tx -> {
                Tuple2 tuple2 = Redis$.MODULE$.acquireAndReleaseClusterByNode(clusterClient, codec, readFrom, nodeId, tx, this.fl(), this.log(), this.evidence$2);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Object acquire = tuple2._1();
                Function1 release = (Function1)tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply(acquire, (Object)release);
                Object acquire2 = tuple22._1();
                Function1 release2 = (Function1)tuple22._2();
                return (Resource)package.all$.MODULE$.toFunctorOps((Object)Resource$.MODULE$.make(acquire2, release2, this.evidence$2), (Functor)Resource$.MODULE$.catsEffectMonadErrorForResource(this.evidence$2)).widen();
            });
        }

        public <K, V> Option<ReadFrom> fromClusterClientByNode$default$4(RedisClusterClient clusterClient, RedisCodec codec, String nodeId) {
            return None$.MODULE$;
        }

        public <K, V> Resource<F, RedisCommands<F, K, V>> masterReplica(RedisMasterReplica<K, V> conn) {
            return MkRedis$.MODULE$.apply(this.evidence$1).txRunner().map((Function1 & Serializable)tx -> new Redis(new RedisStatefulConnection((StatefulRedisConnection)conn.underlying(), this.evidence$2, this.fl()), tx, this.fl(), this.evidence$2, this.log()));
        }

        private final String simple$$anonfun$1(String uri$1) {
            return uri$1;
        }

        private final String withOptions$$anonfun$1(String uri$2) {
            return uri$2;
        }

        private final String custom$$anonfun$1(String uri$3) {
            return uri$3;
        }

        private final RedisURI custom$$anonfun$2$$anonfun$1(RedisURI _$9$1) {
            return _$9$1;
        }

        private final String cluster$$anonfun$1$$anonfun$1(String _$12$1) {
            return _$12$1;
        }
    }
}

