/*
 * Decompiled with CFR 0.152.
 */
package dev.profunktor.redis4cats;

import cats.Applicative$;
import cats.ApplicativeError;
import cats.Functor;
import cats.MonadError;
import cats.data.NonEmptyList;
import cats.effect.kernel.Async;
import cats.syntax.ApplicativeErrorIdOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import dev.profunktor.redis4cats.JavaConversions$;
import dev.profunktor.redis4cats.RedisCommands;
import dev.profunktor.redis4cats.RedisConversionOps;
import dev.profunktor.redis4cats.algebra.BitCommandOperation;
import dev.profunktor.redis4cats.algebra.BitCommandOperation$Get$;
import dev.profunktor.redis4cats.algebra.BitCommandOperation$IncrSignedBy$;
import dev.profunktor.redis4cats.algebra.BitCommandOperation$IncrUnsignedBy$;
import dev.profunktor.redis4cats.algebra.BitCommandOperation$Overflow$;
import dev.profunktor.redis4cats.algebra.BitCommandOperation$Overflows$;
import dev.profunktor.redis4cats.algebra.BitCommandOperation$SetSigned$;
import dev.profunktor.redis4cats.algebra.BitCommandOperation$SetUnsigned$;
import dev.profunktor.redis4cats.connection.RedisConnection;
import dev.profunktor.redis4cats.data;
import dev.profunktor.redis4cats.effect.FutureLift;
import dev.profunktor.redis4cats.effect.FutureLift$;
import dev.profunktor.redis4cats.effect.Log;
import dev.profunktor.redis4cats.effects;
import dev.profunktor.redis4cats.effects$FlushMode$Async$;
import dev.profunktor.redis4cats.effects$FlushMode$Sync$;
import dev.profunktor.redis4cats.effects$FunctionRestoreMode$Append$;
import dev.profunktor.redis4cats.effects$FunctionRestoreMode$Flush$;
import dev.profunktor.redis4cats.effects$FunctionRestoreMode$Replace$;
import dev.profunktor.redis4cats.effects$GeoCoordinate$;
import dev.profunktor.redis4cats.effects$GetExArg$Ex$;
import dev.profunktor.redis4cats.effects$GetExArg$ExAt$;
import dev.profunktor.redis4cats.effects$GetExArg$Persist$;
import dev.profunktor.redis4cats.effects$GetExArg$Px$;
import dev.profunktor.redis4cats.effects$GetExArg$PxAt$;
import dev.profunktor.redis4cats.effects$HGetExArgs$Ex$;
import dev.profunktor.redis4cats.effects$HGetExArgs$ExAt$;
import dev.profunktor.redis4cats.effects$HGetExArgs$Persist$;
import dev.profunktor.redis4cats.effects$HGetExArgs$Px$;
import dev.profunktor.redis4cats.effects$HGetExArgs$PxAt$;
import dev.profunktor.redis4cats.effects$MessageId$;
import dev.profunktor.redis4cats.effects$RedisType$;
import dev.profunktor.redis4cats.effects$SetArg$Existence$Nx$;
import dev.profunktor.redis4cats.effects$SetArg$Existence$Xx$;
import dev.profunktor.redis4cats.effects$SetArg$Ttl$Ex$;
import dev.profunktor.redis4cats.effects$SetArg$Ttl$Keep$;
import dev.profunktor.redis4cats.effects$SetArg$Ttl$Px$;
import dev.profunktor.redis4cats.effects$XReadOffsets$All$;
import dev.profunktor.redis4cats.effects$XReadOffsets$Custom$;
import dev.profunktor.redis4cats.effects$XReadOffsets$Latest$;
import dev.profunktor.redis4cats.effects$XTrimArgs$Precision$Approximate$;
import dev.profunktor.redis4cats.effects$XTrimArgs$Precision$Exact$;
import dev.profunktor.redis4cats.effects$XTrimArgs$Strategy$MAXLEN$;
import dev.profunktor.redis4cats.effects$XTrimArgs$Strategy$MINID$;
import dev.profunktor.redis4cats.tx.TxRunner;
import dev.profunktor.redis4cats.tx.TxStore;
import dev.profunktor.redis4cats.tx.package;
import io.lettuce.core.BitFieldArgs;
import io.lettuce.core.FlushMode;
import io.lettuce.core.FunctionRestoreMode;
import io.lettuce.core.GeoArgs;
import io.lettuce.core.GeoWithin;
import io.lettuce.core.GetExArgs;
import io.lettuce.core.HGetExArgs;
import io.lettuce.core.KeyValue;
import io.lettuce.core.Limit;
import io.lettuce.core.Range;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanCursor;
import io.lettuce.core.ScoredValue;
import io.lettuce.core.SetArgs;
import io.lettuce.core.TransactionResult;
import io.lettuce.core.XAddArgs;
import io.lettuce.core.XReadArgs;
import io.lettuce.core.ZAddArgs;
import io.lettuce.core.ZAggregateArgs;
import io.lettuce.core.ZStoreArgs;
import io.lettuce.core.api.async.RedisAsyncCommands;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import java.io.Serializable;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class BaseRedis<F, K, V>
implements RedisCommands<F, K, V>,
RedisConversionOps {
    private final RedisConnection conn;
    private final TxRunner tx;
    private final boolean cluster;
    private final FutureLift<F> evidence$1;
    private final MonadError<F, Throwable> evidence$2;
    private final Log<F> evidence$3;
    private final Object ping;
    private final Object flushAll;
    private final Object flushDb;

    public BaseRedis(RedisConnection<F, K, V> conn, TxRunner<F> tx, boolean cluster, FutureLift<F> evidence$1, MonadError<F, Throwable> evidence$2, Log<F> evidence$3) {
        this.conn = conn;
        this.tx = tx;
        this.cluster = cluster;
        this.evidence$1 = evidence$1;
        this.evidence$2 = evidence$2;
        this.evidence$3 = evidence$3;
        this.ping = package.all$.MODULE$.toFlatMapOps(this.async(), evidence$2).flatMap((Function1 & Serializable)_$288 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.$init$$$anonfun$1$$anonfun$1(_$288), (ApplicativeError)evidence$2, evidence$1, evidence$3).futureLift());
        this.flushAll = package.all$.MODULE$.toFlatMapOps(this.async(), evidence$2).flatMap((Function1 & Serializable)_$304 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.$init$$$anonfun$2$$anonfun$1(_$304), (ApplicativeError)evidence$2, evidence$1, evidence$3).futureLift(), (Functor)evidence$2).void());
        this.flushDb = package.all$.MODULE$.toFlatMapOps(this.async(), evidence$2).flatMap((Function1 & Serializable)_$306 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.$init$$$anonfun$3$$anonfun$1(_$306), (ApplicativeError)evidence$2, evidence$1, evidence$3).futureLift(), (Functor)evidence$2).void());
    }

    public RedisConnection<F, K, V> conn() {
        return this.conn;
    }

    public TxRunner<F> tx() {
        return this.tx;
    }

    public boolean cluster() {
        return this.cluster;
    }

    public <G> RedisCommands<G, K, V> liftK(Async<G> evidence$1, Log<G> evidence$2) {
        return new BaseRedis<G, K, V>(this.conn().liftK(evidence$1), this.tx().liftK(evidence$1), this.cluster(), FutureLift$.MODULE$.forAsync(evidence$1), evidence$1, evidence$2);
    }

    public F async() {
        if (this.cluster()) {
            return (F)this.conn().clusterAsync();
        }
        return (F)package.all$.MODULE$.toFunctorOps(this.conn().async(), this.evidence$2).widen();
    }

    public F sync() {
        if (this.cluster()) {
            return (F)this.conn().clusterSync();
        }
        return (F)package.all$.MODULE$.toFunctorOps(this.conn().sync(), this.evidence$2).widen();
    }

    @Override
    public F copy(K source, K destination) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$16 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.copy$$anonfun$1$$anonfun$1(_$16, source, destination), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Boolean2boolean(BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(x)))));
    }

    @Override
    public F copy(K source, K destination, effects.CopyArgs copyArgs) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$17 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> this.copy$$anonfun$2$$anonfun$1(_$17, source, destination, copyArgs), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Boolean2boolean(BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(x)))));
    }

    @Override
    public F del(K k, Seq<K> keys) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$18 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.del$$anonfun$1$$anonfun$1(_$18, keys, k), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x)))));
    }

    @Override
    public F dump(K key) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$19 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.dump$$anonfun$1$$anonfun$1(_$19, key), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$20 -> Option$.MODULE$.apply(_$20)));
    }

    @Override
    public F exists(K key, Seq<K> keys) {
        Seq all = (Seq)keys.$plus$colon(key);
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$21 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.exists$$anonfun$1$$anonfun$1(_$21, all), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$22 -> BoxesRunTime.equals((Object)_$22, (Object)BoxesRunTime.boxToLong((long)all.size()))));
    }

    @Override
    public F expire(K key, FiniteDuration expiresIn) {
        return (F)package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)c -> {
            block8: {
                block3: {
                    TimeUnit timeUnit;
                    TimeUnit timeUnit2;
                    block7: {
                        TimeUnit timeUnit3;
                        block6: {
                            TimeUnit timeUnit4;
                            TimeUnit timeUnit5;
                            block5: {
                                block4: {
                                    TimeUnit timeUnit6;
                                    TimeUnit timeUnit7;
                                    block2: {
                                        timeUnit3 = expiresIn.unit();
                                        timeUnit7 = TimeUnit.MILLISECONDS;
                                        timeUnit6 = timeUnit3;
                                        if (timeUnit7 != null) break block2;
                                        if (timeUnit6 == null) break block3;
                                        break block4;
                                    }
                                    if (((Object)((Object)timeUnit7)).equals((Object)timeUnit6)) break block3;
                                }
                                timeUnit5 = TimeUnit.MICROSECONDS;
                                timeUnit4 = timeUnit3;
                                if (timeUnit5 != null) break block5;
                                if (timeUnit4 == null) break block3;
                                break block6;
                            }
                            if (((Object)((Object)timeUnit5)).equals((Object)timeUnit4)) break block3;
                        }
                        timeUnit2 = TimeUnit.NANOSECONDS;
                        timeUnit = timeUnit3;
                        if (timeUnit2 != null) break block7;
                        if (timeUnit == null) break block3;
                        break block8;
                    }
                    if (!((Object)((Object)timeUnit2)).equals((Object)timeUnit)) break block8;
                }
                return FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.expire$$anonfun$1$$anonfun$1(c, key, expiresIn), this.evidence$2, this.evidence$1, this.evidence$3).futureLift();
            }
            return FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.expire$$anonfun$1$$anonfun$2(c, key, expiresIn), this.evidence$2, this.evidence$1, this.evidence$3).futureLift();
        }), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Boolean2boolean(BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(x))));
    }

    @Override
    public F expire(K key, FiniteDuration expiresIn, effects.ExpireExistenceArg expireExistenceArg) {
        return (F)package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)c -> {
            block8: {
                block3: {
                    TimeUnit timeUnit;
                    TimeUnit timeUnit2;
                    block7: {
                        TimeUnit timeUnit3;
                        block6: {
                            TimeUnit timeUnit4;
                            TimeUnit timeUnit5;
                            block5: {
                                block4: {
                                    TimeUnit timeUnit6;
                                    TimeUnit timeUnit7;
                                    block2: {
                                        timeUnit3 = expiresIn.unit();
                                        timeUnit7 = TimeUnit.MILLISECONDS;
                                        timeUnit6 = timeUnit3;
                                        if (timeUnit7 != null) break block2;
                                        if (timeUnit6 == null) break block3;
                                        break block4;
                                    }
                                    if (((Object)((Object)timeUnit7)).equals((Object)timeUnit6)) break block3;
                                }
                                timeUnit5 = TimeUnit.MICROSECONDS;
                                timeUnit4 = timeUnit3;
                                if (timeUnit5 != null) break block5;
                                if (timeUnit4 == null) break block3;
                                break block6;
                            }
                            if (((Object)((Object)timeUnit5)).equals((Object)timeUnit4)) break block3;
                        }
                        timeUnit2 = TimeUnit.NANOSECONDS;
                        timeUnit = timeUnit3;
                        if (timeUnit2 != null) break block7;
                        if (timeUnit == null) break block3;
                        break block8;
                    }
                    if (!((Object)((Object)timeUnit2)).equals((Object)timeUnit)) break block8;
                }
                return FutureLift$.MODULE$.FutureLiftOps(() -> this.expire$$anonfun$3$$anonfun$1(c, key, expiresIn, expireExistenceArg), this.evidence$2, this.evidence$1, this.evidence$3).futureLift();
            }
            return FutureLift$.MODULE$.FutureLiftOps(() -> this.expire$$anonfun$3$$anonfun$2(c, key, expiresIn, expireExistenceArg), this.evidence$2, this.evidence$1, this.evidence$3).futureLift();
        }), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Boolean2boolean(BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(x))));
    }

    @Override
    public F expireAt(K key, Instant at) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$23 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.expireAt$$anonfun$1$$anonfun$1(_$23, key, at), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Boolean2boolean(BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(x)))));
    }

    @Override
    public F expireAt(K key, Instant at, effects.ExpireExistenceArg expireExistenceArg) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$24 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> this.expireAt$$anonfun$2$$anonfun$1(_$24, key, at, expireExistenceArg), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Boolean2boolean(BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(x)))));
    }

    @Override
    public F objectIdletime(K key) {
        return (F)package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$25 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.objectIdletime$$anonfun$1$$anonfun$1(_$25, key), this.evidence$2, this.evidence$1, this.evidence$3).futureLift()), this.evidence$2).map((Function1 & Serializable)x$1 -> {
            Long l = x$1;
            if (l == null) {
                return package.all$.MODULE$.none();
            }
            Long d = l;
            FiniteDuration finiteDuration = (FiniteDuration)package.all$.MODULE$.catsSyntaxOptionId((Object)FiniteDuration$.MODULE$.apply(Predef$.MODULE$.Long2long(d), TimeUnit.SECONDS));
            return OptionIdOps$.MODULE$.some$extension((Object)finiteDuration);
        });
    }

    private Option<FiniteDuration> toFiniteDuration(TimeUnit units, Long duration) {
        Long l = duration;
        Long d = l;
        if (Predef$.MODULE$.Long2long(d) < 0L) {
            return package.all$.MODULE$.none();
        }
        Long d2 = l;
        FiniteDuration finiteDuration = (FiniteDuration)package.all$.MODULE$.catsSyntaxOptionId((Object)FiniteDuration$.MODULE$.apply(Predef$.MODULE$.Long2long(d2), units));
        return OptionIdOps$.MODULE$.some$extension((Object)finiteDuration);
    }

    private Option<Instant> toEpoch(Long duration) {
        Long l = duration;
        Long d = l;
        if (Predef$.MODULE$.Long2long(d) < 0L) {
            return package.all$.MODULE$.none();
        }
        Long d2 = l;
        Instant instant = (Instant)package.all$.MODULE$.catsSyntaxOptionId((Object)Instant.ofEpochMilli(Predef$.MODULE$.Long2long(d2)));
        return OptionIdOps$.MODULE$.some$extension((Object)instant);
    }

    @Override
    public F persist(K key) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$26 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.persist$$anonfun$1$$anonfun$1(_$26, key), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Boolean2boolean(BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(x)))));
    }

    @Override
    public F pttl(K key) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$27 -> {
            TimeUnit timeUnit = TimeUnit.MILLISECONDS;
            return package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.pttl$$anonfun$1$$anonfun$1(_$27, key), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)duration -> this.toFiniteDuration(timeUnit, (Long)duration));
        });
    }

    @Override
    public F randomKey() {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$28 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.randomKey$$anonfun$1$$anonfun$1(_$28), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$29 -> Option$.MODULE$.apply(_$29)));
    }

    @Override
    public F restore(K key, byte[] value) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$30 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.restore$$anonfun$1$$anonfun$1(_$30, key, value), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).void());
    }

    @Override
    public F restore(K key, byte[] value, effects.RestoreArgs restoreArgs) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$31 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> this.restore$$anonfun$2$$anonfun$1(_$31, key, value, restoreArgs), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).void());
    }

    @Override
    public F scan() {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$32 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.scan$$anonfun$1$$anonfun$1(_$32), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)underlying -> data.KeyScanCursor$.MODULE$.apply(underlying)));
    }

    @Override
    public F scan(long cursor) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$33 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.scan$$anonfun$2$$anonfun$1(_$33, cursor), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)underlying -> data.KeyScanCursor$.MODULE$.apply(underlying)));
    }

    @Override
    public F scan(data.KeyScanCursor<K> previous) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$34 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.scan$$anonfun$3$$anonfun$1(_$34, previous), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)underlying -> data.KeyScanCursor$.MODULE$.apply(underlying)));
    }

    @Override
    public F scan(effects.ScanArgs scanArgs) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$35 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.scan$$anonfun$4$$anonfun$1(_$35, scanArgs), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)underlying -> data.KeyScanCursor$.MODULE$.apply(underlying)));
    }

    @Override
    public F scan(long cursor, effects.ScanArgs scanArgs) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$36 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.scan$$anonfun$5$$anonfun$1(_$36, cursor, scanArgs), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)underlying -> data.KeyScanCursor$.MODULE$.apply(underlying)));
    }

    @Override
    public F scan(data.KeyScanCursor<K> previous, effects.ScanArgs scanArgs) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$37 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.scan$$anonfun$6$$anonfun$1(_$37, previous, scanArgs), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)underlying -> data.KeyScanCursor$.MODULE$.apply(underlying)));
    }

    @Override
    public F scan(effects.KeyScanArgs keyScanArgs) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$38 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.scan$$anonfun$7$$anonfun$1(_$38, keyScanArgs), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)underlying -> data.KeyScanCursor$.MODULE$.apply(underlying)));
    }

    @Override
    public F scan(data.KeyScanCursor<K> cursor, effects.KeyScanArgs keyScanArgs) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$39 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.scan$$anonfun$8$$anonfun$1(_$39, cursor, keyScanArgs), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)underlying -> data.KeyScanCursor$.MODULE$.apply(underlying)));
    }

    @Override
    public F ttl(K key) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$40 -> {
            TimeUnit timeUnit = TimeUnit.SECONDS;
            return package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.ttl$$anonfun$1$$anonfun$1(_$40, key), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)duration -> this.toFiniteDuration(timeUnit, (Long)duration));
        });
    }

    @Override
    public F typeOf(K key) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$41 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.typeOf$$anonfun$1$$anonfun$1(_$41, key), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)s -> effects$RedisType$.MODULE$.fromString((String)s)));
    }

    @Override
    public F unlink(Seq<K> key) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$42 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.unlink$$anonfun$1$$anonfun$1(_$42, key), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x)))));
    }

    public F showThread(String op) {
        return (F)FutureLift$.MODULE$.apply(this.evidence$1).delay((Function0 & Serializable)() -> {
            BaseRedis.showThread$$anonfun$1(op);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public F multi() {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)x$1 -> {
            RedisClusterAsyncCommands redisClusterAsyncCommands = x$1;
            if (redisClusterAsyncCommands instanceof RedisAsyncCommands) {
                RedisAsyncCommands c = (RedisAsyncCommands)redisClusterAsyncCommands;
                return package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.multi$$anonfun$1$$anonfun$1(c), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).void();
            }
            return package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(this.conn().async(), this.evidence$2).flatMap((Function1 & Serializable)_$43 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.multi$$anonfun$1$$anonfun$2$$anonfun$1(_$43), this.evidence$2, this.evidence$1, this.evidence$3).futureLift()), this.evidence$2).void();
        });
    }

    @Override
    public F exec() {
        return (F)package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)x$1 -> {
            RedisClusterAsyncCommands redisClusterAsyncCommands = x$1;
            if (redisClusterAsyncCommands instanceof RedisAsyncCommands) {
                RedisAsyncCommands c = (RedisAsyncCommands)redisClusterAsyncCommands;
                return FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.exec$$anonfun$1$$anonfun$1(c), this.evidence$2, this.evidence$1, this.evidence$3).futureLift();
            }
            return package.all$.MODULE$.toFlatMapOps(this.conn().async(), this.evidence$2).flatMap((Function1 & Serializable)_$44 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.exec$$anonfun$1$$anonfun$2$$anonfun$1(_$44), this.evidence$2, this.evidence$1, this.evidence$3).futureLift());
        }), this.evidence$2).flatMap((Function1 & Serializable)x$1 -> {
            TransactionResult transactionResult = x$1;
            TransactionResult res = transactionResult;
            if (res.wasDiscarded() || res.isEmpty()) {
                package.TransactionDiscarded$ transactionDiscarded$ = (package.TransactionDiscarded$)package.all$.MODULE$.catsSyntaxApplicativeErrorId((Object)package.TransactionDiscarded$.MODULE$);
                return ApplicativeErrorIdOps$.MODULE$.raiseError$extension((Object)transactionDiscarded$, this.evidence$2);
            }
            return Applicative$.MODULE$.apply(this.evidence$2).unit();
        });
    }

    @Override
    public F discard() {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)x$1 -> {
            RedisClusterAsyncCommands redisClusterAsyncCommands = x$1;
            if (redisClusterAsyncCommands instanceof RedisAsyncCommands) {
                RedisAsyncCommands c = (RedisAsyncCommands)redisClusterAsyncCommands;
                return package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.discard$$anonfun$1$$anonfun$1(c), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).void();
            }
            return package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(this.conn().async(), this.evidence$2).flatMap((Function1 & Serializable)_$45 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.discard$$anonfun$1$$anonfun$2$$anonfun$1(_$45), this.evidence$2, this.evidence$1, this.evidence$3).futureLift()), this.evidence$2).void();
        });
    }

    @Override
    public F watch(Seq<K> keys) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)x$1 -> {
            RedisClusterAsyncCommands redisClusterAsyncCommands = x$1;
            if (redisClusterAsyncCommands instanceof RedisAsyncCommands) {
                RedisAsyncCommands c = (RedisAsyncCommands)redisClusterAsyncCommands;
                return package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.watch$$anonfun$1$$anonfun$1(c, keys), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).void();
            }
            return package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(this.conn().async(), this.evidence$2).flatMap((Function1 & Serializable)_$46 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.watch$$anonfun$1$$anonfun$2$$anonfun$1(_$46, keys), this.evidence$2, this.evidence$1, this.evidence$3).futureLift()), this.evidence$2).void();
        });
    }

    @Override
    public F unwatch() {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)x$1 -> {
            RedisClusterAsyncCommands redisClusterAsyncCommands = x$1;
            if (redisClusterAsyncCommands instanceof RedisAsyncCommands) {
                RedisAsyncCommands c = (RedisAsyncCommands)redisClusterAsyncCommands;
                return package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.unwatch$$anonfun$1$$anonfun$1(c), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).void();
            }
            return package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(this.conn().async(), this.evidence$2).flatMap((Function1 & Serializable)_$47 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.unwatch$$anonfun$1$$anonfun$2$$anonfun$1(_$47), this.evidence$2, this.evidence$1, this.evidence$3).futureLift()), this.evidence$2).void();
        });
    }

    @Override
    public <A> F transact(Function1<TxStore<F, String, A>, List<F>> fs) {
        return (F)this.tx().run(this.multi(), this.exec(), this.discard(), fs);
    }

    @Override
    public F transact_(List<F> fs) {
        return (F)package.all$.MODULE$.toFunctorOps(this.transact((Function1 & Serializable)_$48 -> fs), this.evidence$2).void();
    }

    @Override
    public <A> F pipeline(Function1<TxStore<F, String, A>, List<F>> fs) {
        BoxedUnit boxedUnit = (BoxedUnit)package.all$.MODULE$.catsSyntaxApplicativeId((Object)BoxedUnit.UNIT);
        return (F)this.tx().run(this.disableAutoFlush(), FutureLift$.MODULE$.apply(this.evidence$1).guarantee(this.flushCommands(), this.enableAutoFlush()), ApplicativeIdOps$.MODULE$.pure$extension((Object)boxedUnit, this.evidence$2), fs);
    }

    @Override
    public F pipeline_(List<F> fs) {
        return (F)package.all$.MODULE$.toFunctorOps(this.pipeline((Function1 & Serializable)_$49 -> fs), this.evidence$2).void();
    }

    @Override
    public F enableAutoFlush() {
        return (F)this.conn().setAutoFlushCommands(true);
    }

    @Override
    public F disableAutoFlush() {
        return (F)this.conn().setAutoFlushCommands(false);
    }

    @Override
    public F flushCommands() {
        return (F)this.conn().flushCommands();
    }

    @Override
    public <A> F unsafe(Function1<RedisClusterAsyncCommands<K, V>, RedisFuture<A>> f) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$50 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.unsafe$$anonfun$1$$anonfun$1(f, _$50), this.evidence$2, this.evidence$1, this.evidence$3).futureLift());
    }

    @Override
    public <A> F unsafeSync(Function1<RedisClusterAsyncCommands<K, V>, A> f) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)cmd -> FutureLift$.MODULE$.apply(this.evidence$1).delay(() -> BaseRedis.unsafeSync$$anonfun$1$$anonfun$1(f, cmd)));
    }

    @Override
    public F append(K key, V value) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$51 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.append$$anonfun$1$$anonfun$1(_$51, key, value), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).void());
    }

    @Override
    public F getSet(K key, V value) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$52 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.getSet$$anonfun$1$$anonfun$1(_$52, key, value), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Option$.MODULE$.apply(x)));
    }

    @Override
    public F set(K key, V value) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$53 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.set$$anonfun$1$$anonfun$1(_$53, key, value), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).void());
    }

    @Override
    public F set(K key, V value, effects.SetArgs setArgs) {
        SetArgs jSetArgs = new SetArgs();
        setArgs.existence().foreach((Function1 & Serializable)x$1 -> {
            effects.SetArg.Existence existence = x$1;
            if (effects$SetArg$Existence$Nx$.MODULE$.equals(existence)) {
                return jSetArgs.nx();
            }
            if (effects$SetArg$Existence$Xx$.MODULE$.equals(existence)) {
                return jSetArgs.xx();
            }
            throw new MatchError((Object)existence);
        });
        setArgs.ttl().foreach((Function1 & Serializable)x$1 -> {
            effects.SetArg.Ttl ttl = x$1;
            if (ttl instanceof effects.SetArg.Ttl.Px) {
                FiniteDuration finiteDuration;
                effects.SetArg.Ttl.Px px = effects$SetArg$Ttl$Px$.MODULE$.unapply((effects.SetArg.Ttl.Px)ttl);
                FiniteDuration d = finiteDuration = px._1();
                return jSetArgs.px(d.toMillis());
            }
            if (ttl instanceof effects.SetArg.Ttl.Ex) {
                FiniteDuration finiteDuration;
                effects.SetArg.Ttl.Ex ex = effects$SetArg$Ttl$Ex$.MODULE$.unapply((effects.SetArg.Ttl.Ex)ttl);
                FiniteDuration d = finiteDuration = ex._1();
                return jSetArgs.ex(d.toSeconds());
            }
            if (effects$SetArg$Ttl$Keep$.MODULE$.equals(ttl)) {
                return jSetArgs.keepttl();
            }
            throw new MatchError((Object)ttl);
        });
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$54 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.set$$anonfun$4$$anonfun$1(_$54, key, value, jSetArgs), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$55 -> {
            String string = _$55;
            String string2 = "OK";
            return !(string != null ? !string.equals(string2) : string2 != null);
        }));
    }

    @Override
    public F setNx(K key, V value) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$56 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.setNx$$anonfun$1$$anonfun$1(_$56, key, value), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Boolean2boolean(BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(x)))));
    }

    @Override
    public F setEx(K key, V value, FiniteDuration expiresIn) {
        block8: {
            block3: {
                TimeUnit timeUnit;
                TimeUnit timeUnit2;
                block7: {
                    TimeUnit timeUnit3;
                    block6: {
                        TimeUnit timeUnit4;
                        TimeUnit timeUnit5;
                        block5: {
                            block4: {
                                TimeUnit timeUnit6;
                                TimeUnit timeUnit7;
                                block2: {
                                    timeUnit3 = expiresIn.unit();
                                    timeUnit7 = TimeUnit.MILLISECONDS;
                                    timeUnit6 = timeUnit3;
                                    if (timeUnit7 != null) break block2;
                                    if (timeUnit6 == null) break block3;
                                    break block4;
                                }
                                if (((Object)((Object)timeUnit7)).equals((Object)timeUnit6)) break block3;
                            }
                            timeUnit5 = TimeUnit.MICROSECONDS;
                            timeUnit4 = timeUnit3;
                            if (timeUnit5 != null) break block5;
                            if (timeUnit4 == null) break block3;
                            break block6;
                        }
                        if (((Object)((Object)timeUnit5)).equals((Object)timeUnit4)) break block3;
                    }
                    timeUnit2 = TimeUnit.NANOSECONDS;
                    timeUnit = timeUnit3;
                    if (timeUnit2 != null) break block7;
                    if (timeUnit == null) break block3;
                    break block8;
                }
                if (!((Object)((Object)timeUnit2)).equals((Object)timeUnit)) break block8;
            }
            return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$57 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.setEx$$anonfun$1$$anonfun$1(_$57, key, expiresIn, value), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).void());
        }
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$58 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.setEx$$anonfun$2$$anonfun$1(_$58, key, expiresIn, value), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).void());
    }

    @Override
    public F setRange(K key, V value, long offset) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$59 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.setRange$$anonfun$1$$anonfun$1(_$59, key, offset, value), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).void());
    }

    @Override
    public F decr(K key) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$60 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.decr$$anonfun$1$$anonfun$1(_$60, key), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x)))));
    }

    @Override
    public F decrBy(K key, long amount) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$61 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.decrBy$$anonfun$1$$anonfun$1(_$61, key, amount), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x)))));
    }

    @Override
    public F incr(K key) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$62 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.incr$$anonfun$1$$anonfun$1(_$62, key), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x)))));
    }

    @Override
    public F incrBy(K key, long amount) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$63 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.incrBy$$anonfun$1$$anonfun$1(_$63, key, amount), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x)))));
    }

    @Override
    public F incrByFloat(K key, double amount) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$64 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.incrByFloat$$anonfun$1$$anonfun$1(_$64, key, amount), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Double2double(BoxesRunTime.boxToDouble((double)Predef$.MODULE$.Double2double(x)))));
    }

    @Override
    public F get(K key) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$65 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.get$$anonfun$1$$anonfun$1(_$65, key), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Option$.MODULE$.apply(x)));
    }

    @Override
    public F getEx(K key, effects.GetExArg getExArg) {
        GetExArgs getExArgs;
        GetExArgs jgetExArgs = new GetExArgs();
        effects.GetExArg getExArg2 = getExArg;
        if (getExArg2 instanceof effects.GetExArg.Ex) {
            FiniteDuration finiteDuration;
            effects.GetExArg.Ex ex = effects$GetExArg$Ex$.MODULE$.unapply((effects.GetExArg.Ex)getExArg2);
            FiniteDuration d = finiteDuration = ex._1();
            getExArgs = jgetExArgs.ex(d.toSeconds());
        } else if (getExArg2 instanceof effects.GetExArg.Px) {
            FiniteDuration finiteDuration;
            effects.GetExArg.Px px = effects$GetExArg$Px$.MODULE$.unapply((effects.GetExArg.Px)getExArg2);
            FiniteDuration d = finiteDuration = px._1();
            getExArgs = jgetExArgs.ex(d.toMillis());
        } else if (getExArg2 instanceof effects.GetExArg.ExAt) {
            Instant instant;
            effects.GetExArg.ExAt exAt = effects$GetExArg$ExAt$.MODULE$.unapply((effects.GetExArg.ExAt)getExArg2);
            Instant at = instant = exAt._1();
            getExArgs = jgetExArgs.exAt(at);
        } else if (getExArg2 instanceof effects.GetExArg.PxAt) {
            Instant instant;
            effects.GetExArg.PxAt pxAt = effects$GetExArg$PxAt$.MODULE$.unapply((effects.GetExArg.PxAt)getExArg2);
            Instant at = instant = pxAt._1();
            getExArgs = jgetExArgs.pxAt(at);
        } else if (effects$GetExArg$Persist$.MODULE$.equals(getExArg2)) {
            getExArgs = jgetExArgs.persist();
        } else {
            throw new MatchError((Object)getExArg2);
        }
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$66 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.getEx$$anonfun$1$$anonfun$1(_$66, key, jgetExArgs), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Option$.MODULE$.apply(x)));
    }

    @Override
    public F getRange(K key, long start, long end) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$67 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.getRange$$anonfun$1$$anonfun$1(_$67, key, start, end), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Option$.MODULE$.apply(x)));
    }

    @Override
    public F strLen(K key) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$68 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.strLen$$anonfun$1$$anonfun$1(_$68, key), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> BoxesRunTime.unboxToLong((Object)x)));
    }

    @Override
    public F mGet(Set<K> keys) {
        return (F)package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$69 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.mGet$$anonfun$1$$anonfun$1(_$69, keys), this.evidence$2, this.evidence$1, this.evidence$3).futureLift()), this.evidence$2).map((Function1 & Serializable)_$70 -> JavaConversions$.MODULE$.ListHasAsScala(_$70).asScala().toList().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(KeyValue x) {
                KeyValue keyValue = x;
                KeyValue kv = keyValue;
                return kv.hasValue();
            }

            public final Object applyOrElse(KeyValue x, Function1 function1) {
                KeyValue keyValue = x;
                KeyValue kv = keyValue;
                if (kv.hasValue()) {
                    Object object = Predef$.MODULE$.ArrowAssoc(kv.getKey());
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, kv.getValue());
                }
                return function1.apply((Object)x);
            }
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    @Override
    public F mSet(scala.collection.immutable.Map<K, V> keyValues) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$71 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.mSet$$anonfun$1$$anonfun$1(_$71, keyValues), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).void());
    }

    @Override
    public F mSetNx(scala.collection.immutable.Map<K, V> keyValues) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$72 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.mSetNx$$anonfun$1$$anonfun$1(_$72, keyValues), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Boolean2boolean(BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(x)))));
    }

    @Override
    public F hDel(K key, K field, Seq<K> fields) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$73 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.hDel$$anonfun$1$$anonfun$1(_$73, key, fields, field), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x)))));
    }

    @Override
    public F hGetDel(K key, K field, Seq<K> fields) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$74 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.hGetDel$$anonfun$1$$anonfun$1(_$74, key, fields, field), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$75 -> JavaConversions$.MODULE$.ListHasAsScala(_$75).asScala().toList().map((Function1 & Serializable)kv -> Option$.MODULE$.apply(kv.getValue()))));
    }

    @Override
    public F hExists(K key, K field) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$76 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.hExists$$anonfun$1$$anonfun$1(_$76, key, field), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Boolean2boolean(BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(x)))));
    }

    @Override
    public F hGet(K key, K field) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$77 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.hGet$$anonfun$1$$anonfun$1(_$77, key, field), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Option$.MODULE$.apply(x)));
    }

    @Override
    public F hGetEx(K key, effects.HGetExArgs getExArg, K field, Seq<K> fields) {
        HGetExArgs hGetExArgs;
        HGetExArgs jgetExArgs = new HGetExArgs();
        effects.HGetExArgs hGetExArgs2 = getExArg;
        if (hGetExArgs2 instanceof effects.HGetExArgs.Ex) {
            FiniteDuration finiteDuration;
            effects.HGetExArgs.Ex ex = effects$HGetExArgs$Ex$.MODULE$.unapply((effects.HGetExArgs.Ex)hGetExArgs2);
            FiniteDuration d = finiteDuration = ex._1();
            hGetExArgs = jgetExArgs.ex(java.time.Duration.ofMillis(d.toMillis()));
        } else if (hGetExArgs2 instanceof effects.HGetExArgs.Px) {
            FiniteDuration finiteDuration;
            effects.HGetExArgs.Px px = effects$HGetExArgs$Px$.MODULE$.unapply((effects.HGetExArgs.Px)hGetExArgs2);
            FiniteDuration d = finiteDuration = px._1();
            hGetExArgs = jgetExArgs.px(java.time.Duration.ofMillis(d.toMillis()));
        } else if (hGetExArgs2 instanceof effects.HGetExArgs.ExAt) {
            Instant instant;
            effects.HGetExArgs.ExAt exAt = effects$HGetExArgs$ExAt$.MODULE$.unapply((effects.HGetExArgs.ExAt)hGetExArgs2);
            Instant at = instant = exAt._1();
            hGetExArgs = jgetExArgs.exAt(at);
        } else if (hGetExArgs2 instanceof effects.HGetExArgs.PxAt) {
            Instant instant;
            effects.HGetExArgs.PxAt pxAt = effects$HGetExArgs$PxAt$.MODULE$.unapply((effects.HGetExArgs.PxAt)hGetExArgs2);
            Instant at = instant = pxAt._1();
            hGetExArgs = jgetExArgs.pxAt(at);
        } else if (effects$HGetExArgs$Persist$.MODULE$.equals(hGetExArgs2)) {
            hGetExArgs = jgetExArgs.persist();
        } else {
            throw new MatchError((Object)hGetExArgs2);
        }
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$78 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.hGetEx$$anonfun$1$$anonfun$1(_$78, key, jgetExArgs, fields, field), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$79 -> JavaConversions$.MODULE$.ListHasAsScala(_$79).asScala().toList().map((Function1 & Serializable)kv -> Option$.MODULE$.apply(kv.getValue()))));
    }

    @Override
    public F hGetAll(K key) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$80 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.hGetAll$$anonfun$1$$anonfun$1(_$80, key), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$81 -> JavaConversions$.MODULE$.MapHasAsScala(_$81).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())));
    }

    @Override
    public F hmGet(K key, K field, Seq<K> fields) {
        return (F)package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$82 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.hmGet$$anonfun$1$$anonfun$1(_$82, key, fields, field), this.evidence$2, this.evidence$1, this.evidence$3).futureLift()), this.evidence$2).map((Function1 & Serializable)_$83 -> JavaConversions$.MODULE$.ListHasAsScala(_$83).asScala().toList().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(KeyValue x) {
                KeyValue keyValue = x;
                KeyValue kv = keyValue;
                return kv.hasValue();
            }

            public final Object applyOrElse(KeyValue x, Function1 function1) {
                KeyValue keyValue = x;
                KeyValue kv = keyValue;
                if (kv.hasValue()) {
                    Object object = Predef$.MODULE$.ArrowAssoc(kv.getKey());
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, kv.getValue());
                }
                return function1.apply((Object)x);
            }
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    @Override
    public F hKeys(K key) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$84 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.hKeys$$anonfun$1$$anonfun$1(_$84, key), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$85 -> JavaConversions$.MODULE$.ListHasAsScala(_$85).asScala().toList()));
    }

    @Override
    public F hVals(K key) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$86 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.hVals$$anonfun$1$$anonfun$1(_$86, key), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$87 -> JavaConversions$.MODULE$.ListHasAsScala(_$87).asScala().toList()));
    }

    @Override
    public F hStrLen(K key, K field) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$88 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.hStrLen$$anonfun$1$$anonfun$1(_$88, key, field), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> BoxesRunTime.unboxToLong((Object)x)));
    }

    @Override
    public F hLen(K key) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$89 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.hLen$$anonfun$1$$anonfun$1(_$89, key), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> BoxesRunTime.unboxToLong((Object)x)));
    }

    @Override
    public F hScan(K key) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$90 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.hScan$$anonfun$1$$anonfun$1(_$90, key), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$91 -> data.MapScanCursor$.MODULE$.apply(_$91)));
    }

    @Override
    public F hScan(K key, data.MapScanCursor<K, V> cursor) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$92 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.hScan$$anonfun$2$$anonfun$1(_$92, key, cursor), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$93 -> data.MapScanCursor$.MODULE$.apply(_$93)));
    }

    @Override
    public F hScan(K key, effects.ScanArgs scanArgs) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$94 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.hScan$$anonfun$3$$anonfun$1(_$94, key, scanArgs), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$95 -> data.MapScanCursor$.MODULE$.apply(_$95)));
    }

    @Override
    public F hScan(K key, data.MapScanCursor<K, V> cursor, effects.ScanArgs scanArgs) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$96 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.hScan$$anonfun$4$$anonfun$1(_$96, key, cursor, scanArgs), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$97 -> data.MapScanCursor$.MODULE$.apply(_$97)));
    }

    @Override
    public F hScanNoValues(K key) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$98 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.hScanNoValues$$anonfun$1$$anonfun$1(_$98, key), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$99 -> data.KeyScanCursor$.MODULE$.apply(_$99)));
    }

    @Override
    public F hScanNoValues(K key, data.KeyScanCursor<K> cursor) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$100 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.hScanNoValues$$anonfun$2$$anonfun$1(_$100, key, cursor), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$101 -> data.KeyScanCursor$.MODULE$.apply(_$101)));
    }

    @Override
    public F hScanNoValues(K key, effects.ScanArgs scanArgs) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$102 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.hScanNoValues$$anonfun$3$$anonfun$1(_$102, key, scanArgs), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$103 -> data.KeyScanCursor$.MODULE$.apply(_$103)));
    }

    @Override
    public F hScanNoValues(K key, data.KeyScanCursor<K> cursor, effects.ScanArgs scanArgs) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$104 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.hScanNoValues$$anonfun$4$$anonfun$1(_$104, key, cursor, scanArgs), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$105 -> data.KeyScanCursor$.MODULE$.apply(_$105)));
    }

    @Override
    public F hSet(K key, K field, V value) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$106 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.hSet$$anonfun$1$$anonfun$1(_$106, key, field, value), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Boolean2boolean(BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(x)))));
    }

    @Override
    public F hSet(K key, scala.collection.immutable.Map<K, V> fieldValues) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$107 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.hSet$$anonfun$2$$anonfun$1(_$107, key, fieldValues), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x)))));
    }

    @Override
    public F hExpire(K key, FiniteDuration expiresIn, Seq<K> fields) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)c -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.hExpire$$anonfun$1$$anonfun$1(expiresIn, c, key, fields), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$108 -> ((IterableOnceOps)JavaConversions$.MODULE$.ListHasAsScala(_$108).asScala().map((Function1 & Serializable)x -> BoxesRunTime.unboxToLong((Object)x))).toList()));
    }

    @Override
    public F hExpire(K key, FiniteDuration expire, effects.ExpireExistenceArg args, Seq<K> fields) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)c -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> this.hExpire$$anonfun$2$$anonfun$1(expire, c, key, args, fields), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$109 -> ((IterableOnceOps)JavaConversions$.MODULE$.ListHasAsScala(_$109).asScala().map((Function1 & Serializable)x -> BoxesRunTime.unboxToLong((Object)x))).toList()));
    }

    @Override
    public F hExpireAt(K key, Instant expireAt, Seq<K> fields) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$110 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.hExpireAt$$anonfun$1$$anonfun$1(_$110, key, expireAt, fields), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$111 -> ((IterableOnceOps)JavaConversions$.MODULE$.ListHasAsScala(_$111).asScala().map((Function1 & Serializable)x -> BoxesRunTime.unboxToLong((Object)x))).toList()));
    }

    @Override
    public F hExpireAt(K key, Instant expireAt, effects.ExpireExistenceArg args, Seq<K> fields) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$112 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> this.hExpireAt$$anonfun$2$$anonfun$1(_$112, key, expireAt, args, fields), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$113 -> ((IterableOnceOps)JavaConversions$.MODULE$.ListHasAsScala(_$113).asScala().map((Function1 & Serializable)x -> BoxesRunTime.unboxToLong((Object)x))).toList()));
    }

    @Override
    public F hExpireTime(K key, Seq<K> fields) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$114 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.hExpireTime$$anonfun$1$$anonfun$1(_$114, key, fields), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$115 -> ((IterableOnceOps)JavaConversions$.MODULE$.ListHasAsScala(_$115).asScala().map((Function1 & Serializable)duration -> this.toEpoch((Long)duration))).toList()));
    }

    @Override
    public F hpExpireTime(K key, Seq<K> fields) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$116 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.hpExpireTime$$anonfun$1$$anonfun$1(_$116, key, fields), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$117 -> ((IterableOnceOps)JavaConversions$.MODULE$.ListHasAsScala(_$117).asScala().map((Function1 & Serializable)duration -> this.toEpoch((Long)duration))).toList()));
    }

    @Override
    public F hPersist(K key, Seq<K> fields) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$118 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.hPersist$$anonfun$1$$anonfun$1(_$118, key, fields), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$119 -> ((IterableOnceOps)JavaConversions$.MODULE$.ListHasAsScala(_$119).asScala().map((Function1 & Serializable)l -> BoxesRunTime.equals((Object)l, (Object)BoxesRunTime.boxToInteger((int)1)))).toList()));
    }

    @Override
    public F hpttl(K key, Seq<K> fields) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$120 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.hpttl$$anonfun$1$$anonfun$1(_$120, key, fields), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$121 -> {
            TimeUnit timeUnit = TimeUnit.MILLISECONDS;
            return ((IterableOnceOps)JavaConversions$.MODULE$.ListHasAsScala(_$121).asScala().map((Function1 & Serializable)duration -> this.toFiniteDuration(timeUnit, (Long)duration))).toList();
        }));
    }

    @Override
    public F httl(K key, Seq<K> fields) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$122 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.httl$$anonfun$1$$anonfun$1(_$122, key, fields), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$123 -> {
            TimeUnit timeUnit = TimeUnit.SECONDS;
            return ((IterableOnceOps)JavaConversions$.MODULE$.ListHasAsScala(_$123).asScala().map((Function1 & Serializable)duration -> this.toFiniteDuration(timeUnit, (Long)duration))).toList();
        }));
    }

    @Override
    public F hSetNx(K key, K field, V value) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$124 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.hSetNx$$anonfun$1$$anonfun$1(_$124, key, field, value), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Boolean2boolean(BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(x)))));
    }

    @Override
    public F hmSet(K key, scala.collection.immutable.Map<K, V> fieldValues) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$125 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.hmSet$$anonfun$1$$anonfun$1(_$125, key, fieldValues), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).void());
    }

    @Override
    public F hIncrBy(K key, K field, long amount) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$126 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.hIncrBy$$anonfun$1$$anonfun$1(_$126, key, field, amount), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x)))));
    }

    @Override
    public F hIncrByFloat(K key, K field, double amount) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$127 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.hIncrByFloat$$anonfun$1$$anonfun$1(_$127, key, field, amount), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Double2double(BoxesRunTime.boxToDouble((double)Predef$.MODULE$.Double2double(x)))));
    }

    @Override
    public F sIsMember(K key, V value) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$128 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.sIsMember$$anonfun$1$$anonfun$1(_$128, key, value), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Boolean2boolean(BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(x)))));
    }

    @Override
    public F sMisMember(K key, Seq<V> values) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$129 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.sMisMember$$anonfun$1$$anonfun$1(_$129, key, values), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$130 -> ((IterableOnceOps)JavaConversions$.MODULE$.ListHasAsScala(_$130).asScala().map((Function1 & Serializable)_$131 -> BoxesRunTime.unboxToBoolean((Object)_$131))).toList()));
    }

    @Override
    public F sAdd(K key, Seq<V> values) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$132 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.sAdd$$anonfun$1$$anonfun$1(_$132, key, values), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x)))));
    }

    @Override
    public F sDiffStore(K destination, Seq<K> keys) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$133 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.sDiffStore$$anonfun$1$$anonfun$1(_$133, destination, keys), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x)))));
    }

    @Override
    public F sInterStore(K destination, Seq<K> keys) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$134 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.sInterStore$$anonfun$1$$anonfun$1(_$134, destination, keys), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x)))));
    }

    @Override
    public F sMove(K source, K destination, V value) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$135 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.sMove$$anonfun$1$$anonfun$1(_$135, source, destination, value), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Boolean2boolean(BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(x)))));
    }

    @Override
    public F sPop(K key) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$136 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.sPop$$anonfun$1$$anonfun$1(_$136, key), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Option$.MODULE$.apply(x)));
    }

    @Override
    public F sPop(K key, long count) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$137 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.sPop$$anonfun$2$$anonfun$1(_$137, key, count), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$138 -> JavaConversions$.MODULE$.SetHasAsScala(_$138).asScala().toSet()));
    }

    @Override
    public F sRem(K key, Seq<V> values) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$139 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.sRem$$anonfun$1$$anonfun$1(_$139, key, values), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x)))));
    }

    @Override
    public F sCard(K key) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$140 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.sCard$$anonfun$1$$anonfun$1(_$140, key), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x)))));
    }

    @Override
    public F sDiff(Seq<K> keys) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$141 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.sDiff$$anonfun$1$$anonfun$1(_$141, keys), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$142 -> JavaConversions$.MODULE$.SetHasAsScala(_$142).asScala().toSet()));
    }

    @Override
    public F sInter(Seq<K> keys) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$143 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.sInter$$anonfun$1$$anonfun$1(_$143, keys), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$144 -> JavaConversions$.MODULE$.SetHasAsScala(_$144).asScala().toSet()));
    }

    @Override
    public F sMembers(K key) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$145 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.sMembers$$anonfun$1$$anonfun$1(_$145, key), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$146 -> JavaConversions$.MODULE$.SetHasAsScala(_$146).asScala().toSet()));
    }

    @Override
    public F sRandMember(K key) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$147 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.sRandMember$$anonfun$1$$anonfun$1(_$147, key), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Option$.MODULE$.apply(x)));
    }

    @Override
    public F sRandMember(K key, long count) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$148 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.sRandMember$$anonfun$2$$anonfun$1(_$148, key, count), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$149 -> JavaConversions$.MODULE$.ListHasAsScala(_$149).asScala().toList()));
    }

    @Override
    public F sUnion(Seq<K> keys) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$150 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.sUnion$$anonfun$1$$anonfun$1(_$150, keys), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$151 -> JavaConversions$.MODULE$.SetHasAsScala(_$151).asScala().toSet()));
    }

    @Override
    public F sUnionStore(K destination, Seq<K> keys) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$152 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.sUnionStore$$anonfun$1$$anonfun$1(_$152, destination, keys), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).void());
    }

    @Override
    public F lIndex(K key, long index) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$153 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.lIndex$$anonfun$1$$anonfun$1(_$153, key, index), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Option$.MODULE$.apply(x)));
    }

    @Override
    public F lLen(K key) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$154 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.lLen$$anonfun$1$$anonfun$1(_$154, key), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> BoxesRunTime.unboxToLong((Object)x)));
    }

    @Override
    public F lRange(K key, long start, long stop) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$155 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.lRange$$anonfun$1$$anonfun$1(_$155, key, start, stop), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$156 -> JavaConversions$.MODULE$.ListHasAsScala(_$156).asScala().toList()));
    }

    @Override
    public F blPop(Duration timeout, NonEmptyList<K> keys) {
        return (F)package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$157 -> FutureLift$.MODULE$.FutureLiftOps(() -> this.blPop$$anonfun$1$$anonfun$1(_$157, timeout, keys), this.evidence$2, this.evidence$1, this.evidence$3).futureLift()), this.evidence$2).map((Function1 & Serializable)_$158 -> Option$.MODULE$.apply(_$158).map((Function1 & Serializable)kv -> {
            Object object = Predef$.MODULE$.ArrowAssoc(kv.getKey());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, kv.getValue());
        }));
    }

    @Override
    public F brPop(Duration timeout, NonEmptyList<K> keys) {
        return (F)package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$159 -> FutureLift$.MODULE$.FutureLiftOps(() -> this.brPop$$anonfun$1$$anonfun$1(_$159, timeout, keys), this.evidence$2, this.evidence$1, this.evidence$3).futureLift()), this.evidence$2).map((Function1 & Serializable)_$160 -> Option$.MODULE$.apply(_$160).map((Function1 & Serializable)kv -> {
            Object object = Predef$.MODULE$.ArrowAssoc(kv.getKey());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, kv.getValue());
        }));
    }

    @Override
    public F brPopLPush(Duration timeout, K source, K destination) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$161 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> this.brPopLPush$$anonfun$1$$anonfun$1(_$161, timeout, source, destination), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Option$.MODULE$.apply(x)));
    }

    @Override
    public F lPop(K key) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$162 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.lPop$$anonfun$1$$anonfun$1(_$162, key), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Option$.MODULE$.apply(x)));
    }

    @Override
    public F lPush(K key, Seq<V> values) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$163 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.lPush$$anonfun$1$$anonfun$1(_$163, key, values), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x)))));
    }

    @Override
    public F lPushX(K key, Seq<V> values) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$164 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.lPushX$$anonfun$1$$anonfun$1(_$164, key, values), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x)))));
    }

    @Override
    public F rPop(K key) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$165 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.rPop$$anonfun$1$$anonfun$1(_$165, key), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Option$.MODULE$.apply(x)));
    }

    @Override
    public F rPopLPush(K source, K destination) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$166 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.rPopLPush$$anonfun$1$$anonfun$1(_$166, source, destination), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Option$.MODULE$.apply(x)));
    }

    @Override
    public F rPush(K key, Seq<V> values) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$167 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.rPush$$anonfun$1$$anonfun$1(_$167, key, values), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x)))));
    }

    @Override
    public F rPushX(K key, Seq<V> values) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$168 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.rPushX$$anonfun$1$$anonfun$1(_$168, key, values), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x)))));
    }

    @Override
    public F lInsertAfter(K key, V pivot, V value) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$169 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.lInsertAfter$$anonfun$1$$anonfun$1(_$169, key, pivot, value), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x)))));
    }

    @Override
    public F lInsertBefore(K key, V pivot, V value) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$170 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.lInsertBefore$$anonfun$1$$anonfun$1(_$170, key, pivot, value), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x)))));
    }

    @Override
    public F lRem(K key, long count, V value) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$171 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.lRem$$anonfun$1$$anonfun$1(_$171, key, count, value), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x)))));
    }

    @Override
    public F lSet(K key, long index, V value) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$172 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.lSet$$anonfun$1$$anonfun$1(_$172, key, index, value), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).void());
    }

    @Override
    public F lTrim(K key, long start, long stop) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$173 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.lTrim$$anonfun$1$$anonfun$1(_$173, key, start, stop), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).void());
    }

    @Override
    public F bitCount(K key) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$174 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.bitCount$$anonfun$1$$anonfun$1(_$174, key), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x)))));
    }

    @Override
    public F bitCount(K key, long start, long end) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$175 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.bitCount$$anonfun$2$$anonfun$1(_$175, key, start, end), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x)))));
    }

    @Override
    public F bitField(K key, Seq<BitCommandOperation> operations) {
        return (F)package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$176 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.bitField$$anonfun$1$$anonfun$1(_$176, key, operations), this.evidence$2, this.evidence$1, this.evidence$3).futureLift()), this.evidence$2).map((Function1 & Serializable)_$177 -> JavaConversions$.MODULE$.ListHasAsScala(_$177).asScala().toList().map((Function1 & Serializable)_$178 -> Predef$.MODULE$.Long2long(_$178)));
    }

    @Override
    public F bitPos(K key, boolean state) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$179 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.bitPos$$anonfun$1$$anonfun$1(_$179, key, state), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x)))));
    }

    @Override
    public F bitPos(K key, boolean state, long start) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$180 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.bitPos$$anonfun$2$$anonfun$1(_$180, key, state, start), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x)))));
    }

    @Override
    public F bitPos(K key, boolean state, long start, long end) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$181 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.bitPos$$anonfun$3$$anonfun$1(_$181, key, state, start, end), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x)))));
    }

    @Override
    public F bitOpAnd(K destination, K source, Seq<K> sources) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$182 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.bitOpAnd$$anonfun$1$$anonfun$1(_$182, destination, sources, source), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).void());
    }

    @Override
    public F bitOpNot(K destination, K source) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$183 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.bitOpNot$$anonfun$1$$anonfun$1(_$183, destination, source), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).void());
    }

    @Override
    public F bitOpOr(K destination, K source, Seq<K> sources) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$184 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.bitOpOr$$anonfun$1$$anonfun$1(_$184, destination, sources, source), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).void());
    }

    @Override
    public F bitOpXor(K destination, K source, Seq<K> sources) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$185 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.bitOpXor$$anonfun$1$$anonfun$1(_$185, destination, sources, source), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).void());
    }

    @Override
    public F getBit(K key, long offset) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$186 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.getBit$$anonfun$1$$anonfun$1(_$186, key, offset), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Option$.MODULE$.apply(x)));
    }

    @Override
    public F setBit(K key, long offset, int value) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$187 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.setBit$$anonfun$1$$anonfun$1(_$187, key, offset, value), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x)))));
    }

    @Override
    public F geoDist(K key, V from, V to, GeoArgs.Unit unit) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$188 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.geoDist$$anonfun$1$$anonfun$1(_$188, key, from, to, unit), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Double2double(BoxesRunTime.boxToDouble((double)Predef$.MODULE$.Double2double(x)))));
    }

    @Override
    public F geoHash(K key, V value, Seq<V> values) {
        return (F)package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$189 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.geoHash$$anonfun$1$$anonfun$1(_$189, key, values, value), this.evidence$2, this.evidence$1, this.evidence$3).futureLift()), this.evidence$2).map((Function1 & Serializable)_$190 -> JavaConversions$.MODULE$.ListHasAsScala(_$190).asScala().toList().map((Function1 & Serializable)x -> Option$.MODULE$.apply(x.getValue())));
    }

    @Override
    public F geoPos(K key, V value, Seq<V> values) {
        return (F)package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$191 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.geoPos$$anonfun$1$$anonfun$1(_$191, key, values, value), this.evidence$2, this.evidence$1, this.evidence$3).futureLift()), this.evidence$2).map((Function1 & Serializable)_$192 -> JavaConversions$.MODULE$.ListHasAsScala(_$192).asScala().toList().map((Function1 & Serializable)c -> effects$GeoCoordinate$.MODULE$.apply(c.getX().doubleValue(), c.getY().doubleValue())));
    }

    @Override
    public F geoRadius(K key, effects.GeoRadius geoRadius, GeoArgs.Unit unit) {
        return (F)package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$193 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.geoRadius$$anonfun$1$$anonfun$1(_$193, key, geoRadius, unit), this.evidence$2, this.evidence$1, this.evidence$3).futureLift()), this.evidence$2).map((Function1 & Serializable)_$194 -> JavaConversions$.MODULE$.SetHasAsScala(_$194).asScala().toSet());
    }

    @Override
    public F geoRadius(K key, effects.GeoRadius geoRadius, GeoArgs.Unit unit, GeoArgs args) {
        return (F)package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$195 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.geoRadius$$anonfun$3$$anonfun$1(_$195, key, geoRadius, unit, args), this.evidence$2, this.evidence$1, this.evidence$3).futureLift()), this.evidence$2).map((Function1 & Serializable)_$196 -> JavaConversions$.MODULE$.ListHasAsScala(_$196).asScala().toList().map((Function1 & Serializable)_$197 -> this.GeoRadiusResultOps((GeoWithin)_$197).asGeoRadiusResult()));
    }

    @Override
    public F geoRadiusByMember(K key, V value, double dist, GeoArgs.Unit unit) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$198 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.geoRadiusByMember$$anonfun$1$$anonfun$1(_$198, key, value, dist, unit), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$199 -> JavaConversions$.MODULE$.SetHasAsScala(_$199).asScala().toSet()));
    }

    @Override
    public F geoRadiusByMember(K key, V value, double dist, GeoArgs.Unit unit, GeoArgs args) {
        return (F)package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$200 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.geoRadiusByMember$$anonfun$2$$anonfun$1(_$200, key, value, dist, unit, args), this.evidence$2, this.evidence$1, this.evidence$3).futureLift()), this.evidence$2).map((Function1 & Serializable)_$201 -> JavaConversions$.MODULE$.ListHasAsScala(_$201).asScala().toList().map((Function1 & Serializable)_$202 -> this.GeoRadiusResultOps((GeoWithin)_$202).asGeoRadiusResult()));
    }

    @Override
    public F geoAdd(K key, Seq<effects.GeoLocation<V>> geoValues) {
        Seq triplets = (Seq)geoValues.flatMap((Function1 & Serializable)g -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)g.lon()), BoxesRunTime.boxToDouble((double)g.lat()), g.value()})));
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$203 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.geoAdd$$anonfun$1$$anonfun$1(_$203, key, triplets), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).void());
    }

    @Override
    public F geoRadius(K key, effects.GeoRadius geoRadius, GeoArgs.Unit unit, effects.GeoRadiusKeyStorage<K> storage) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.conn().async(), this.evidence$2).flatMap((Function1 & Serializable)_$204 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> this.geoRadius$$anonfun$5$$anonfun$1(_$204, key, geoRadius, unit, storage), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).void());
    }

    @Override
    public F geoRadius(K key, effects.GeoRadius geoRadius, GeoArgs.Unit unit, effects.GeoRadiusDistStorage<K> storage) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.conn().async(), this.evidence$2).flatMap((Function1 & Serializable)_$205 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> this.geoRadius$$anonfun$6$$anonfun$1(_$205, key, geoRadius, unit, storage), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).void());
    }

    @Override
    public F geoRadiusByMember(K key, V value, double dist, GeoArgs.Unit unit, effects.GeoRadiusKeyStorage<K> storage) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$206 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> this.geoRadiusByMember$$anonfun$4$$anonfun$1(_$206, key, value, dist, unit, storage), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).void());
    }

    @Override
    public F geoRadiusByMember(K key, V value, double dist, GeoArgs.Unit unit, effects.GeoRadiusDistStorage<K> storage) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$207 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> this.geoRadiusByMember$$anonfun$5$$anonfun$1(_$207, key, value, dist, unit, storage), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).void());
    }

    @Override
    public F zAdd(K key, Option<ZAddArgs> args, Seq<effects.ScoreWithValue<V>> values) {
        Object object;
        Option<ZAddArgs> option = args;
        if (option instanceof Some) {
            ZAddArgs x2 = (ZAddArgs)((Some)option).value();
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$208 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.$anonfun$2$$anonfun$1(_$208, key, x2, values), this.evidence$2, this.evidence$1, this.evidence$3).futureLift());
        } else if (None$.MODULE$.equals(option)) {
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$209 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.$anonfun$3$$anonfun$1(_$209, key, values), this.evidence$2, this.evidence$1, this.evidence$3).futureLift());
        } else {
            throw new MatchError(option);
        }
        Object res = object;
        return (F)package.all$.MODULE$.toFunctorOps(res, this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x))));
    }

    @Override
    public F zAddIncr(K key, Option<ZAddArgs> args, effects.ScoreWithValue<V> member) {
        Object object;
        Option<ZAddArgs> option = args;
        if (option instanceof Some) {
            ZAddArgs x2 = (ZAddArgs)((Some)option).value();
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$210 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.$anonfun$4$$anonfun$1(_$210, key, x2, member), this.evidence$2, this.evidence$1, this.evidence$3).futureLift());
        } else if (None$.MODULE$.equals(option)) {
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$211 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.$anonfun$5$$anonfun$1(_$211, key, member), this.evidence$2, this.evidence$1, this.evidence$3).futureLift());
        } else {
            throw new MatchError(option);
        }
        Object res = object;
        return (F)package.all$.MODULE$.toFunctorOps(res, this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Double2double(BoxesRunTime.boxToDouble((double)Predef$.MODULE$.Double2double(x))));
    }

    @Override
    public F zIncrBy(K key, V member, double amount) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$212 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.zIncrBy$$anonfun$1$$anonfun$1(_$212, key, amount, member), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Double2double(BoxesRunTime.boxToDouble((double)Predef$.MODULE$.Double2double(x)))));
    }

    @Override
    public F zInterStore(K destination, Option<ZStoreArgs> args, Seq<K> keys) {
        Object object;
        Option<ZStoreArgs> option = args;
        if (option instanceof Some) {
            ZStoreArgs x2 = (ZStoreArgs)((Some)option).value();
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$213 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.$anonfun$6$$anonfun$1(_$213, destination, x2, keys), this.evidence$2, this.evidence$1, this.evidence$3).futureLift());
        } else if (None$.MODULE$.equals(option)) {
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$214 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.$anonfun$7$$anonfun$1(_$214, destination, keys), this.evidence$2, this.evidence$1, this.evidence$3).futureLift());
        } else {
            throw new MatchError(option);
        }
        Object res = object;
        return (F)package.all$.MODULE$.toFunctorOps(res, this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x))));
    }

    @Override
    public F zRem(K key, V value, Seq<V> values) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$215 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.zRem$$anonfun$1$$anonfun$1(_$215, key, values, value), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x)))));
    }

    @Override
    public F zRemRangeByLex(K key, effects.ZRange<V> range) {
        return (F)package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$216 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.zRemRangeByLex$$anonfun$1$$anonfun$1(_$216, key, range), this.evidence$2, this.evidence$1, this.evidence$3).futureLift()), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x))));
    }

    @Override
    public F zRemRangeByRank(K key, long start, long stop) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$217 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.zRemRangeByRank$$anonfun$1$$anonfun$1(_$217, key, start, stop), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x)))));
    }

    @Override
    public <T> F zRemRangeByScore(K key, effects.ZRange<T> range, Numeric<T> evidence$1) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$218 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> this.zRemRangeByScore$$anonfun$1$$anonfun$1(_$218, key, range, evidence$1), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x)))));
    }

    @Override
    public F zUnionStore(K destination, Option<ZStoreArgs> args, Seq<K> keys) {
        Object object;
        Option<ZStoreArgs> option = args;
        if (option instanceof Some) {
            ZStoreArgs x2 = (ZStoreArgs)((Some)option).value();
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$219 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.$anonfun$8$$anonfun$1(_$219, destination, x2, keys), this.evidence$2, this.evidence$1, this.evidence$3).futureLift());
        } else if (None$.MODULE$.equals(option)) {
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$220 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.$anonfun$9$$anonfun$1(_$220, destination, keys), this.evidence$2, this.evidence$1, this.evidence$3).futureLift());
        } else {
            throw new MatchError(option);
        }
        Object res = object;
        return (F)package.all$.MODULE$.toFunctorOps(res, this.evidence$2).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x))));
    }

    @Override
    public F zCard(K key) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$221 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.zCard$$anonfun$1$$anonfun$1(_$221, key), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> BoxesRunTime.unboxToLong((Object)x)));
    }

    @Override
    public <T> F zCount(K key, effects.ZRange<T> range, Numeric<T> evidence$1) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$222 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> this.zCount$$anonfun$1$$anonfun$1(_$222, key, range, evidence$1), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> BoxesRunTime.unboxToLong((Object)x)));
    }

    @Override
    public F zMScore(K key, Seq<V> values) {
        return (F)package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$223 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.zMScore$$anonfun$1$$anonfun$1(_$223, key, values), this.evidence$2, this.evidence$1, this.evidence$3).futureLift()), this.evidence$2).map((Function1 & Serializable)_$224 -> JavaConversions$.MODULE$.ListHasAsScala(_$224).asScala().toList().map((Function1 & Serializable)x -> Option$.MODULE$.apply(x)));
    }

    @Override
    public F zLexCount(K key, effects.ZRange<V> range) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$225 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.zLexCount$$anonfun$1$$anonfun$1(_$225, key, range), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> BoxesRunTime.unboxToLong((Object)x)));
    }

    @Override
    public F zRange(K key, long start, long stop) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$226 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.zRange$$anonfun$1$$anonfun$1(_$226, key, start, stop), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$227 -> JavaConversions$.MODULE$.ListHasAsScala(_$227).asScala().toList()));
    }

    @Override
    public F zRangeByLex(K key, effects.ZRange<V> range, Option<effects.RangeLimit> limit) {
        Object object;
        Option<effects.RangeLimit> option = limit;
        if (option instanceof Some) {
            effects.RangeLimit x = (effects.RangeLimit)((Some)option).value();
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$228 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.$anonfun$10$$anonfun$1(_$228, key, range, x), this.evidence$2, this.evidence$1, this.evidence$3).futureLift());
        } else if (None$.MODULE$.equals(option)) {
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$229 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.$anonfun$11$$anonfun$1(_$229, key, range), this.evidence$2, this.evidence$1, this.evidence$3).futureLift());
        } else {
            throw new MatchError(option);
        }
        Object res = object;
        return (F)package.all$.MODULE$.toFunctorOps(res, this.evidence$2).map((Function1 & Serializable)_$230 -> JavaConversions$.MODULE$.ListHasAsScala(_$230).asScala().toList());
    }

    @Override
    public <T> F zRangeByScore(K key, effects.ZRange<T> range, Option<effects.RangeLimit> limit, Numeric<T> evidence$1) {
        Object object;
        Option<effects.RangeLimit> option = limit;
        if (option instanceof Some) {
            effects.RangeLimit x = (effects.RangeLimit)((Some)option).value();
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$231 -> FutureLift$.MODULE$.FutureLiftOps(() -> this.$anonfun$12$$anonfun$1(_$231, key, range, evidence$1, x), this.evidence$2, this.evidence$1, this.evidence$3).futureLift());
        } else if (None$.MODULE$.equals(option)) {
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$232 -> FutureLift$.MODULE$.FutureLiftOps(() -> this.$anonfun$13$$anonfun$1(_$232, key, range, evidence$1), this.evidence$2, this.evidence$1, this.evidence$3).futureLift());
        } else {
            throw new MatchError(option);
        }
        Object res = object;
        return (F)package.all$.MODULE$.toFunctorOps(res, this.evidence$2).map((Function1 & Serializable)_$233 -> JavaConversions$.MODULE$.ListHasAsScala(_$233).asScala().toList());
    }

    @Override
    public <T> F zRangeByScoreWithScores(K key, effects.ZRange<T> range, Option<effects.RangeLimit> limit, Numeric<T> evidence$1) {
        Object object;
        Option<effects.RangeLimit> option = limit;
        if (option instanceof Some) {
            effects.RangeLimit x = (effects.RangeLimit)((Some)option).value();
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$234 -> FutureLift$.MODULE$.FutureLiftOps(() -> this.$anonfun$14$$anonfun$1(_$234, key, range, evidence$1, x), this.evidence$2, this.evidence$1, this.evidence$3).futureLift());
        } else if (None$.MODULE$.equals(option)) {
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$235 -> FutureLift$.MODULE$.FutureLiftOps(() -> this.$anonfun$15$$anonfun$1(_$235, key, range, evidence$1), this.evidence$2, this.evidence$1, this.evidence$3).futureLift());
        } else {
            throw new MatchError(option);
        }
        Object res = object;
        return (F)package.all$.MODULE$.toFunctorOps(res, this.evidence$2).map((Function1 & Serializable)_$236 -> JavaConversions$.MODULE$.ListHasAsScala(_$236).asScala().toList().map((Function1 & Serializable)_$237 -> this.ScoredValuesOps((ScoredValue)_$237).asScoreWithValues()));
    }

    @Override
    public F zRangeWithScores(K key, long start, long stop) {
        return (F)package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$238 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.zRangeWithScores$$anonfun$1$$anonfun$1(_$238, key, start, stop), this.evidence$2, this.evidence$1, this.evidence$3).futureLift()), this.evidence$2).map((Function1 & Serializable)_$239 -> JavaConversions$.MODULE$.ListHasAsScala(_$239).asScala().toList().map((Function1 & Serializable)_$240 -> this.ScoredValuesOps((ScoredValue)_$240).asScoreWithValues()));
    }

    @Override
    public F zRank(K key, V value) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$241 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.zRank$$anonfun$1$$anonfun$1(_$241, key, value), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Option$.MODULE$.apply(x)));
    }

    @Override
    public F zRevRange(K key, long start, long stop) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$242 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.zRevRange$$anonfun$1$$anonfun$1(_$242, key, start, stop), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$243 -> JavaConversions$.MODULE$.ListHasAsScala(_$243).asScala().toList()));
    }

    @Override
    public F zRevRangeByLex(K key, effects.ZRange<V> range, Option<effects.RangeLimit> limit) {
        Object object;
        Option<effects.RangeLimit> option = limit;
        if (option instanceof Some) {
            effects.RangeLimit x = (effects.RangeLimit)((Some)option).value();
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$244 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.$anonfun$16$$anonfun$1(_$244, key, range, x), this.evidence$2, this.evidence$1, this.evidence$3).futureLift());
        } else if (None$.MODULE$.equals(option)) {
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$245 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.$anonfun$17$$anonfun$1(_$245, key, range), this.evidence$2, this.evidence$1, this.evidence$3).futureLift());
        } else {
            throw new MatchError(option);
        }
        Object res = object;
        return (F)package.all$.MODULE$.toFunctorOps(res, this.evidence$2).map((Function1 & Serializable)_$246 -> JavaConversions$.MODULE$.ListHasAsScala(_$246).asScala().toList());
    }

    @Override
    public <T> F zRevRangeByScore(K key, effects.ZRange<T> range, Option<effects.RangeLimit> limit, Numeric<T> evidence$1) {
        Object object;
        Option<effects.RangeLimit> option = limit;
        if (option instanceof Some) {
            effects.RangeLimit x = (effects.RangeLimit)((Some)option).value();
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$247 -> FutureLift$.MODULE$.FutureLiftOps(() -> this.$anonfun$18$$anonfun$1(_$247, key, range, evidence$1, x), this.evidence$2, this.evidence$1, this.evidence$3).futureLift());
        } else if (None$.MODULE$.equals(option)) {
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$248 -> FutureLift$.MODULE$.FutureLiftOps(() -> this.$anonfun$19$$anonfun$1(_$248, key, range, evidence$1), this.evidence$2, this.evidence$1, this.evidence$3).futureLift());
        } else {
            throw new MatchError(option);
        }
        Object res = object;
        return (F)package.all$.MODULE$.toFunctorOps(res, this.evidence$2).map((Function1 & Serializable)_$249 -> JavaConversions$.MODULE$.ListHasAsScala(_$249).asScala().toList());
    }

    @Override
    public <T> F zRevRangeByScoreWithScores(K key, effects.ZRange<T> range, Option<effects.RangeLimit> limit, Numeric<T> evidence$1) {
        Object object;
        Option<effects.RangeLimit> option = limit;
        if (option instanceof Some) {
            effects.RangeLimit x = (effects.RangeLimit)((Some)option).value();
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$250 -> FutureLift$.MODULE$.FutureLiftOps(() -> this.$anonfun$20$$anonfun$1(_$250, key, range, evidence$1, x), this.evidence$2, this.evidence$1, this.evidence$3).futureLift());
        } else if (None$.MODULE$.equals(option)) {
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$251 -> FutureLift$.MODULE$.FutureLiftOps(() -> this.$anonfun$21$$anonfun$1(_$251, key, range, evidence$1), this.evidence$2, this.evidence$1, this.evidence$3).futureLift());
        } else {
            throw new MatchError(option);
        }
        Object res = object;
        return (F)package.all$.MODULE$.toFunctorOps(res, this.evidence$2).map((Function1 & Serializable)_$252 -> JavaConversions$.MODULE$.ListHasAsScala(_$252).asScala().toList().map((Function1 & Serializable)_$253 -> this.ScoredValuesOps((ScoredValue)_$253).asScoreWithValues()));
    }

    @Override
    public F zRevRangeWithScores(K key, long start, long stop) {
        return (F)package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$254 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.zRevRangeWithScores$$anonfun$1$$anonfun$1(_$254, key, start, stop), this.evidence$2, this.evidence$1, this.evidence$3).futureLift()), this.evidence$2).map((Function1 & Serializable)_$255 -> JavaConversions$.MODULE$.ListHasAsScala(_$255).asScala().toList().map((Function1 & Serializable)_$256 -> this.ScoredValuesOps((ScoredValue)_$256).asScoreWithValues()));
    }

    @Override
    public F zRevRank(K key, V value) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$257 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.zRevRank$$anonfun$1$$anonfun$1(_$257, key, value), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Option$.MODULE$.apply(x)));
    }

    @Override
    public F zScore(K key, V value) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$258 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.zScore$$anonfun$1$$anonfun$1(_$258, key, value), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> Option$.MODULE$.apply(x)));
    }

    @Override
    public F zPopMin(K key, long count) {
        return (F)package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$259 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.zPopMin$$anonfun$1$$anonfun$1(_$259, key, count), this.evidence$2, this.evidence$1, this.evidence$3).futureLift()), this.evidence$2).map((Function1 & Serializable)_$260 -> JavaConversions$.MODULE$.ListHasAsScala(_$260).asScala().toList().map((Function1 & Serializable)_$261 -> this.ScoredValuesOps((ScoredValue)_$261).asScoreWithValues()));
    }

    @Override
    public F zPopMax(K key, long count) {
        return (F)package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$262 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.zPopMax$$anonfun$1$$anonfun$1(_$262, key, count), this.evidence$2, this.evidence$1, this.evidence$3).futureLift()), this.evidence$2).map((Function1 & Serializable)_$263 -> JavaConversions$.MODULE$.ListHasAsScala(_$263).asScala().toList().map((Function1 & Serializable)_$264 -> this.ScoredValuesOps((ScoredValue)_$264).asScoreWithValues()));
    }

    @Override
    public F bzPopMin(Duration timeout, NonEmptyList<K> keys) {
        return (F)package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$265 -> FutureLift$.MODULE$.FutureLiftOps(() -> this.bzPopMin$$anonfun$1$$anonfun$1(_$265, timeout, keys), this.evidence$2, this.evidence$1, this.evidence$3).futureLift()), this.evidence$2).map((Function1 & Serializable)_$266 -> Option$.MODULE$.apply(_$266).map((Function1 & Serializable)kv -> Tuple2$.MODULE$.apply(kv.getKey(), this.ScoredValuesOps((ScoredValue)kv.getValue()).asScoreWithValues())));
    }

    @Override
    public F bzPopMax(Duration timeout, NonEmptyList<K> keys) {
        return (F)package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$267 -> FutureLift$.MODULE$.FutureLiftOps(() -> this.bzPopMax$$anonfun$1$$anonfun$1(_$267, timeout, keys), this.evidence$2, this.evidence$1, this.evidence$3).futureLift()), this.evidence$2).map((Function1 & Serializable)_$268 -> Option$.MODULE$.apply(_$268).map((Function1 & Serializable)kv -> Tuple2$.MODULE$.apply(kv.getKey(), this.ScoredValuesOps((ScoredValue)kv.getValue()).asScoreWithValues())));
    }

    @Override
    public F zUnion(Option<ZAggregateArgs> args, Seq<K> keys) {
        Object object;
        Option<ZAggregateArgs> option = args;
        if (option instanceof Some) {
            ZAggregateArgs aggArgs = (ZAggregateArgs)((Some)option).value();
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$269 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.$anonfun$22$$anonfun$1(_$269, aggArgs, keys), this.evidence$2, this.evidence$1, this.evidence$3).futureLift());
        } else if (None$.MODULE$.equals(option)) {
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$270 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.$anonfun$23$$anonfun$1(_$270, keys), this.evidence$2, this.evidence$1, this.evidence$3).futureLift());
        } else {
            throw new MatchError(option);
        }
        Object res = object;
        return (F)package.all$.MODULE$.toFunctorOps(res, this.evidence$2).map((Function1 & Serializable)_$271 -> JavaConversions$.MODULE$.ListHasAsScala(_$271).asScala().toList());
    }

    @Override
    public F zUnionWithScores(Option<ZAggregateArgs> args, Seq<K> keys) {
        Object object;
        Option<ZAggregateArgs> option = args;
        if (option instanceof Some) {
            ZAggregateArgs aggArgs = (ZAggregateArgs)((Some)option).value();
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$272 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.$anonfun$24$$anonfun$1(_$272, aggArgs, keys), this.evidence$2, this.evidence$1, this.evidence$3).futureLift());
        } else if (None$.MODULE$.equals(option)) {
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$273 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.$anonfun$25$$anonfun$1(_$273, keys), this.evidence$2, this.evidence$1, this.evidence$3).futureLift());
        } else {
            throw new MatchError(option);
        }
        Object res = object;
        return (F)package.all$.MODULE$.toFunctorOps(res, this.evidence$2).map((Function1 & Serializable)_$274 -> JavaConversions$.MODULE$.ListHasAsScala(_$274).asScala().toList().map((Function1 & Serializable)_$275 -> this.ScoredValuesOps((ScoredValue)_$275).asScoreWithValues()));
    }

    @Override
    public F zInter(Option<ZAggregateArgs> args, Seq<K> keys) {
        Object object;
        Option<ZAggregateArgs> option = args;
        if (option instanceof Some) {
            ZAggregateArgs aggArgs = (ZAggregateArgs)((Some)option).value();
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$276 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.$anonfun$26$$anonfun$1(_$276, aggArgs, keys), this.evidence$2, this.evidence$1, this.evidence$3).futureLift());
        } else if (None$.MODULE$.equals(option)) {
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$277 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.$anonfun$27$$anonfun$1(_$277, keys), this.evidence$2, this.evidence$1, this.evidence$3).futureLift());
        } else {
            throw new MatchError(option);
        }
        Object res = object;
        return (F)package.all$.MODULE$.toFunctorOps(res, this.evidence$2).map((Function1 & Serializable)_$278 -> JavaConversions$.MODULE$.ListHasAsScala(_$278).asScala().toList());
    }

    @Override
    public F zInterWithScores(Option<ZAggregateArgs> args, Seq<K> keys) {
        Object object;
        Option<ZAggregateArgs> option = args;
        if (option instanceof Some) {
            ZAggregateArgs aggArgs = (ZAggregateArgs)((Some)option).value();
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$279 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.$anonfun$28$$anonfun$1(_$279, aggArgs, keys), this.evidence$2, this.evidence$1, this.evidence$3).futureLift());
        } else if (None$.MODULE$.equals(option)) {
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$280 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.$anonfun$29$$anonfun$1(_$280, keys), this.evidence$2, this.evidence$1, this.evidence$3).futureLift());
        } else {
            throw new MatchError(option);
        }
        Object res = object;
        return (F)package.all$.MODULE$.toFunctorOps(res, this.evidence$2).map((Function1 & Serializable)_$281 -> JavaConversions$.MODULE$.ListHasAsScala(_$281).asScala().toList().map((Function1 & Serializable)_$282 -> this.ScoredValuesOps((ScoredValue)_$282).asScoreWithValues()));
    }

    @Override
    public F zDiff(Seq<K> keys) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$283 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.zDiff$$anonfun$1$$anonfun$1(_$283, keys), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$284 -> JavaConversions$.MODULE$.ListHasAsScala(_$284).asScala().toList()));
    }

    @Override
    public F zDiffWithScores(Seq<K> keys) {
        return (F)package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$285 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.zDiffWithScores$$anonfun$1$$anonfun$1(_$285, keys), this.evidence$2, this.evidence$1, this.evidence$3).futureLift()), this.evidence$2).map((Function1 & Serializable)_$286 -> JavaConversions$.MODULE$.ListHasAsScala(_$286).asScala().toList().map((Function1 & Serializable)_$287 -> this.ScoredValuesOps((ScoredValue)_$287).asScoreWithValues()));
    }

    @Override
    public F ping() {
        return (F)this.ping;
    }

    @Override
    public F select(int index) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.conn().async(), this.evidence$2).flatMap((Function1 & Serializable)_$289 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.select$$anonfun$1$$anonfun$1(_$289, index), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).void());
    }

    @Override
    public F auth(CharSequence password) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$290 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.auth$$anonfun$1$$anonfun$1(_$290, password), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$291 -> {
            String string = _$291;
            String string2 = "OK";
            return !(string != null ? !string.equals(string2) : string2 != null);
        }));
    }

    @Override
    public F auth(String username, CharSequence password) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$292 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.auth$$anonfun$2$$anonfun$1(_$292, username, password), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$293 -> {
            String string = _$293;
            String string2 = "OK";
            return !(string != null ? !string.equals(string2) : string2 != null);
        }));
    }

    @Override
    public F setClientName(K name) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$294 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.setClientName$$anonfun$1$$anonfun$1(_$294, name), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$295 -> {
            String string = _$295;
            String string2 = "OK";
            return !(string != null ? !string.equals(string2) : string2 != null);
        }));
    }

    @Override
    public F getClientName() {
        return (F)package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$296 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.getClientName$$anonfun$1$$anonfun$1(_$296), this.evidence$2, this.evidence$1, this.evidence$3).futureLift()), this.evidence$2).map((Function1 & Serializable)x -> Option$.MODULE$.apply(x));
    }

    @Override
    public F getClientId() {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$297 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.getClientId$$anonfun$1$$anonfun$1(_$297), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> BoxesRunTime.unboxToLong((Object)x)));
    }

    @Override
    public F setLibName(String name) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$298 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.setLibName$$anonfun$1$$anonfun$1(_$298, name), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$299 -> {
            String string = _$299;
            String string2 = "OK";
            return !(string != null ? !string.equals(string2) : string2 != null);
        }));
    }

    @Override
    public F setLibVersion(String version) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$300 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.setLibVersion$$anonfun$1$$anonfun$1(_$300, version), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$301 -> {
            String string = _$301;
            String string2 = "OK";
            return !(string != null ? !string.equals(string2) : string2 != null);
        }));
    }

    @Override
    public F getClientInfo() {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$302 -> package.all$.MODULE$.toFlatMapOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.getClientInfo$$anonfun$1$$anonfun$1(_$302), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).flatMap((Function1 & Serializable)info -> this.parseClientInfo((String)info)));
    }

    private F parseClientInfo(String info) {
        return (F)FutureLift$.MODULE$.apply(this.evidence$1).delay(() -> BaseRedis.parseClientInfo$$anonfun$1(info));
    }

    @Override
    public F flushAll() {
        return (F)this.flushAll;
    }

    @Override
    public F flushAll(effects.FlushMode mode) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$305 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.flushAll$$anonfun$1$$anonfun$1(_$305, mode), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).void());
    }

    @Override
    public F flushDb() {
        return (F)this.flushDb;
    }

    @Override
    public F flushDb(effects.FlushMode mode) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$307 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.flushDb$$anonfun$1$$anonfun$1(_$307, mode), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).void());
    }

    @Override
    public F keys(K key) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$308 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.keys$$anonfun$1$$anonfun$1(_$308, key), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$309 -> JavaConversions$.MODULE$.ListHasAsScala(_$309).asScala().toList()));
    }

    private F parseInfo(String info) {
        return (F)FutureLift$.MODULE$.apply(this.evidence$1).delay(() -> BaseRedis.parseInfo$$anonfun$1(info));
    }

    @Override
    public F info() {
        return (F)package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$311 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.info$$anonfun$1$$anonfun$1(_$311), this.evidence$2, this.evidence$1, this.evidence$3).futureLift()), this.evidence$2).flatMap((Function1 & Serializable)info -> this.parseInfo((String)info));
    }

    @Override
    public F info(String section) {
        return (F)package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$312 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.info$$anonfun$3$$anonfun$1(_$312, section), this.evidence$2, this.evidence$1, this.evidence$3).futureLift()), this.evidence$2).flatMap((Function1 & Serializable)info -> this.parseInfo((String)info));
    }

    @Override
    public F dbsize() {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$313 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.dbsize$$anonfun$1$$anonfun$1(_$313), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> BoxesRunTime.unboxToLong((Object)x)));
    }

    @Override
    public F lastSave() {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$314 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.lastSave$$anonfun$1$$anonfun$1(_$314), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$315 -> _$315.toInstant()));
    }

    @Override
    public F slowLogLen() {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$316 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.slowLogLen$$anonfun$1$$anonfun$1(_$316), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)x -> BoxesRunTime.unboxToLong((Object)x)));
    }

    @Override
    public F eval(String script, effects.ScriptOutputType<V> output) {
        return (F)package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$317 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.eval$$anonfun$1$$anonfun$1(_$317, script, output), this.evidence$2, this.evidence$1, this.evidence$3).futureLift()), this.evidence$2).map((Function1 & Serializable)r -> output.convert(r));
    }

    @Override
    public F eval(String script, effects.ScriptOutputType<V> output, List<K> keys) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$318 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.eval$$anonfun$3$$anonfun$1(_$318, script, output, keys), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$319 -> output.convert(_$319)));
    }

    @Override
    public F eval(String script, effects.ScriptOutputType<V> output, List<K> keys, List<V> values) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$320 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.eval$$anonfun$4$$anonfun$1(_$320, script, output, keys, values), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$321 -> output.convert(_$321)));
    }

    @Override
    public F evalReadOnly(String script, effects.ScriptOutputType<V> output) {
        return (F)package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$322 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.evalReadOnly$$anonfun$1$$anonfun$1(_$322, script, output), this.evidence$2, this.evidence$1, this.evidence$3).futureLift()), this.evidence$2).map((Function1 & Serializable)r -> output.convert(r));
    }

    @Override
    public F evalReadOnly(String script, effects.ScriptOutputType<V> output, List<K> keys) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$323 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.evalReadOnly$$anonfun$3$$anonfun$1(_$323, script, output, keys), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$324 -> output.convert(_$324)));
    }

    @Override
    public F evalReadOnly(String script, effects.ScriptOutputType<V> output, List<K> keys, List<V> values) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$325 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.evalReadOnly$$anonfun$4$$anonfun$1(_$325, script, output, keys, values), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$326 -> output.convert(_$326)));
    }

    @Override
    public F evalSha(String digest, effects.ScriptOutputType<V> output) {
        return (F)package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$327 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.evalSha$$anonfun$1$$anonfun$1(_$327, digest, output), this.evidence$2, this.evidence$1, this.evidence$3).futureLift()), this.evidence$2).map((Function1 & Serializable)_$328 -> output.convert(_$328));
    }

    @Override
    public F evalSha(String digest, effects.ScriptOutputType<V> output, List<K> keys) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$329 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.evalSha$$anonfun$3$$anonfun$1(_$329, digest, output, keys), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$330 -> output.convert(_$330)));
    }

    @Override
    public F evalSha(String digest, effects.ScriptOutputType<V> output, List<K> keys, List<V> values) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$331 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.evalSha$$anonfun$4$$anonfun$1(_$331, digest, output, keys, values), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$332 -> output.convert(_$332)));
    }

    @Override
    public F evalShaReadOnly(String digest, effects.ScriptOutputType<V> output) {
        return (F)package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$333 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.evalShaReadOnly$$anonfun$1$$anonfun$1(_$333, digest, output), this.evidence$2, this.evidence$1, this.evidence$3).futureLift()), this.evidence$2).map((Function1 & Serializable)_$334 -> output.convert(_$334));
    }

    @Override
    public F evalShaReadOnly(String digest, effects.ScriptOutputType<V> output, List<K> keys) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$335 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.evalShaReadOnly$$anonfun$3$$anonfun$1(_$335, digest, output, keys), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$336 -> output.convert(_$336)));
    }

    @Override
    public F evalShaReadOnly(String digest, effects.ScriptOutputType<V> output, List<K> keys, List<V> values) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$337 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.evalShaReadOnly$$anonfun$4$$anonfun$1(_$337, digest, output, keys, values), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$338 -> output.convert(_$338)));
    }

    @Override
    public F scriptLoad(String script) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$339 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.scriptLoad$$anonfun$1$$anonfun$1(_$339, script), this.evidence$2, this.evidence$1, this.evidence$3).futureLift());
    }

    @Override
    public F scriptLoad(byte[] script) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$340 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.scriptLoad$$anonfun$2$$anonfun$1(_$340, script), this.evidence$2, this.evidence$1, this.evidence$3).futureLift());
    }

    @Override
    public F scriptExists(Seq<String> digests) {
        return (F)package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$341 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.scriptExists$$anonfun$1$$anonfun$1(_$341, digests), this.evidence$2, this.evidence$1, this.evidence$3).futureLift()), this.evidence$2).map((Function1 & Serializable)_$342 -> ((IterableOnceOps)JavaConversions$.MODULE$.ListHasAsScala(_$342).asScala().map((Function1 & Serializable)_$343 -> BoxesRunTime.unboxToBoolean((Object)_$343))).toList());
    }

    @Override
    public F scriptFlush() {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$344 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.scriptFlush$$anonfun$1$$anonfun$1(_$344), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).void());
    }

    @Override
    public F digest(String script) {
        return (F)package.all$.MODULE$.toFunctorOps(this.async(), this.evidence$2).map((Function1 & Serializable)_$345 -> _$345.digest(script));
    }

    @Override
    public F fcall(String function, effects.ScriptOutputType<V> output, List<K> keys) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$346 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.fcall$$anonfun$1$$anonfun$1(_$346, function, output, keys), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$347 -> output.convert(_$347)));
    }

    @Override
    public F fcall(String function, effects.ScriptOutputType<V> output, List<K> keys, List<V> values) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$348 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.fcall$$anonfun$2$$anonfun$1(_$348, function, output, keys, values), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$349 -> output.convert(_$349)));
    }

    @Override
    public F fcallReadOnly(String function, effects.ScriptOutputType<V> output, List<K> keys) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$350 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.fcallReadOnly$$anonfun$1$$anonfun$1(_$350, function, output, keys), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$351 -> output.convert(_$351)));
    }

    @Override
    public F fcallReadOnly(String function, effects.ScriptOutputType<V> output, List<K> keys, List<V> values) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$352 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.fcallReadOnly$$anonfun$2$$anonfun$1(_$352, function, output, keys, values), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$353 -> output.convert(_$353)));
    }

    @Override
    public F functionLoad(String functionCode) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$354 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.functionLoad$$anonfun$1$$anonfun$1(_$354, functionCode), this.evidence$2, this.evidence$1, this.evidence$3).futureLift());
    }

    @Override
    public F functionLoad(String functionCode, boolean replace) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$355 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.functionLoad$$anonfun$2$$anonfun$1(_$355, functionCode, replace), this.evidence$2, this.evidence$1, this.evidence$3).futureLift());
    }

    @Override
    public F functionDump() {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$356 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.functionDump$$anonfun$1$$anonfun$1(_$356), this.evidence$2, this.evidence$1, this.evidence$3).futureLift());
    }

    @Override
    public F functionRestore(byte[] dump) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$357 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.functionRestore$$anonfun$1$$anonfun$1(_$357, dump), this.evidence$2, this.evidence$1, this.evidence$3).futureLift());
    }

    @Override
    public F functionRestore(byte[] dump, effects.FunctionRestoreMode mode) {
        FunctionRestoreMode functionRestoreMode;
        effects.FunctionRestoreMode functionRestoreMode2 = mode;
        if (effects$FunctionRestoreMode$Flush$.MODULE$.equals(functionRestoreMode2)) {
            functionRestoreMode = FunctionRestoreMode.FLUSH;
        } else if (effects$FunctionRestoreMode$Append$.MODULE$.equals(functionRestoreMode2)) {
            functionRestoreMode = FunctionRestoreMode.APPEND;
        } else if (effects$FunctionRestoreMode$Replace$.MODULE$.equals(functionRestoreMode2)) {
            functionRestoreMode = FunctionRestoreMode.REPLACE;
        } else {
            throw new MatchError((Object)functionRestoreMode2);
        }
        FunctionRestoreMode jMode = functionRestoreMode;
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$358 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.functionRestore$$anonfun$2$$anonfun$1(_$358, dump, jMode), this.evidence$2, this.evidence$1, this.evidence$3).futureLift());
    }

    @Override
    public F functionFlush(effects.FlushMode flushMode) {
        FlushMode flushMode2;
        effects.FlushMode flushMode3 = flushMode;
        if (effects$FlushMode$Sync$.MODULE$.equals(flushMode3)) {
            flushMode2 = FlushMode.SYNC;
        } else if (effects$FlushMode$Async$.MODULE$.equals(flushMode3)) {
            flushMode2 = FlushMode.ASYNC;
        } else {
            throw new MatchError((Object)flushMode3);
        }
        FlushMode jFlushMode = flushMode2;
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$359 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.functionFlush$$anonfun$1$$anonfun$1(_$359, jFlushMode), this.evidence$2, this.evidence$1, this.evidence$3).futureLift());
    }

    @Override
    public F functionKill() {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$360 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.functionKill$$anonfun$1$$anonfun$1(_$360), this.evidence$2, this.evidence$1, this.evidence$3).futureLift());
    }

    @Override
    public F functionList() {
        return (F)package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$361 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.functionList$$anonfun$1$$anonfun$1(_$361), this.evidence$2, this.evidence$1, this.evidence$3).futureLift()), this.evidence$2).map((Function1 & Serializable)_$362 -> ((IterableOnceOps)JavaConversions$.MODULE$.ListHasAsScala(_$362).asScala().map((Function1 & Serializable)_$363 -> JavaConversions$.MODULE$.MapHasAsScala(_$363).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))).toList());
    }

    @Override
    public F functionList(String libraryName) {
        return (F)package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$364 -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.functionList$$anonfun$3$$anonfun$1(_$364, libraryName), this.evidence$2, this.evidence$1, this.evidence$3).futureLift()), this.evidence$2).map((Function1 & Serializable)_$365 -> ((IterableOnceOps)JavaConversions$.MODULE$.ListHasAsScala(_$365).asScala().map((Function1 & Serializable)_$366 -> JavaConversions$.MODULE$.MapHasAsScala(_$366).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))).toList());
    }

    @Override
    public F pfAdd(K key, Seq<V> values) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$367 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.pfAdd$$anonfun$1$$anonfun$1(_$367, key, values), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$368 -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(_$368)))));
    }

    @Override
    public F pfCount(K key) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$369 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.pfCount$$anonfun$1$$anonfun$1(_$369, key), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$370 -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(_$370)))));
    }

    @Override
    public F pfMerge(K outputKey, Seq<K> inputKeys) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$371 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.pfMerge$$anonfun$1$$anonfun$1(_$371, outputKey, inputKeys), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).void());
    }

    @Override
    public F xRead(Set<effects.XReadOffsets<K>> streams, Option<Duration> block, Option<Object> count) {
        Seq offsets = ((IterableOnceOps)streams.map((Function1 & Serializable)x$1 -> {
            effects.XReadOffsets xReadOffsets = x$1;
            if (xReadOffsets instanceof effects.XReadOffsets.All) {
                Object k;
                effects.XReadOffsets.All all = effects$XReadOffsets$All$.MODULE$.unapply((effects.XReadOffsets.All)xReadOffsets);
                Object key = k = all._1();
                return XReadArgs.StreamOffset.from(key, (String)"0");
            }
            if (xReadOffsets instanceof effects.XReadOffsets.Latest) {
                Object k;
                effects.XReadOffsets.Latest latest = effects$XReadOffsets$Latest$.MODULE$.unapply((effects.XReadOffsets.Latest)xReadOffsets);
                Object key = k = latest._1();
                return XReadArgs.StreamOffset.latest(key);
            }
            if (xReadOffsets instanceof effects.XReadOffsets.Custom) {
                effects.XReadOffsets.Custom custom = effects$XReadOffsets$Custom$.MODULE$.unapply((effects.XReadOffsets.Custom)xReadOffsets);
                Object k = custom._1();
                String string = custom._2();
                Object key = k;
                String offset = string;
                return XReadArgs.StreamOffset.from(key, (String)offset);
            }
            throw new MatchError((Object)xReadOffsets);
        })).toSeq();
        return (F)package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)redis -> FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.xRead$$anonfun$1$$anonfun$1(block, count, redis, offsets), this.evidence$2, this.evidence$1, this.evidence$3).futureLift()), this.evidence$2).map((Function1 & Serializable)_$372 -> this.StreamMessagesOps((java.util.List)_$372).toScala());
    }

    @Override
    public F xRange(K key, effects.XRangePoint start, effects.XRangePoint end, Option<Object> count) {
        return (F)package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$373 -> FutureLift$.MODULE$.FutureLiftOps(() -> this.xRange$$anonfun$1$$anonfun$1(_$373, key, start, end, count), this.evidence$2, this.evidence$1, this.evidence$3).futureLift()), this.evidence$2).map((Function1 & Serializable)_$374 -> this.StreamMessagesOps((java.util.List)_$374).toScala());
    }

    @Override
    public F xRevRange(K key, effects.XRangePoint start, effects.XRangePoint end, Option<Object> count) {
        return (F)package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$375 -> FutureLift$.MODULE$.FutureLiftOps(() -> this.xRevRange$$anonfun$1$$anonfun$1(_$375, key, start, end, count), this.evidence$2, this.evidence$1, this.evidence$3).futureLift()), this.evidence$2).map((Function1 & Serializable)_$376 -> this.StreamMessagesOps((java.util.List)_$376).toScala());
    }

    @Override
    public F xLen(K key) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$377 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.xLen$$anonfun$1$$anonfun$1(_$377, key), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$378 -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(_$378)))));
    }

    @Override
    public F xAdd(K key, scala.collection.immutable.Map<K, V> body, effects.XAddArgs args) {
        XAddArgs jArgs = XAddArgs.Builder.nomkstream();
        jArgs.nomkstream(args.nomkstream());
        args.id().foreach((Function1 & Serializable)x$0 -> jArgs.id(x$0));
        args.xTrimArgs().foreach((Function1 & Serializable)xTrimArgs -> {
            XAddArgs xAddArgs;
            effects.XTrimArgs.Strategy strategy = xTrimArgs.strategy();
            if (strategy instanceof effects.XTrimArgs.Strategy.MAXLEN) {
                long l;
                effects.XTrimArgs.Strategy.MAXLEN mAXLEN = effects$XTrimArgs$Strategy$MAXLEN$.MODULE$.unapply((effects.XTrimArgs.Strategy.MAXLEN)strategy);
                long threshold = l = mAXLEN._1();
                xAddArgs = jArgs.maxlen(threshold);
            } else if (strategy instanceof effects.XTrimArgs.Strategy.MINID) {
                String string;
                effects.XTrimArgs.Strategy.MINID mINID = effects$XTrimArgs$Strategy$MINID$.MODULE$.unapply((effects.XTrimArgs.Strategy.MINID)strategy);
                String id = string = mINID._1();
                xAddArgs = jArgs.minId(id);
            } else {
                throw new MatchError((Object)strategy);
            }
            effects.XTrimArgs.Precision precision = xTrimArgs.precision();
            if (effects$XTrimArgs$Precision$Exact$.MODULE$.equals(precision)) {
                return jArgs.exactTrimming();
            }
            if (precision instanceof effects.XTrimArgs.Precision.Approximate) {
                Option<Object> option;
                effects.XTrimArgs.Precision.Approximate approximate = effects$XTrimArgs$Precision$Approximate$.MODULE$.unapply((effects.XTrimArgs.Precision.Approximate)precision);
                Option<Object> limit = option = approximate._1();
                jArgs.approximateTrimming();
                limit.foreach((Function1 & Serializable)x$0 -> jArgs.limit(BoxesRunTime.unboxToLong((Object)x$0)));
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)precision);
        });
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$379 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.xAdd$$anonfun$3$$anonfun$1(_$379, key, jArgs, body), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)value -> new effects.MessageId(effects$MessageId$.MODULE$.apply(value))));
    }

    @Override
    public F xTrim(K key, effects.XTrimArgs args) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$380 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> this.xTrim$$anonfun$1$$anonfun$1(_$380, key, args), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$381 -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(_$381)))));
    }

    @Override
    public F xDel(K key, Seq<String> ids) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$2).flatMap((Function1 & Serializable)_$382 -> package.all$.MODULE$.toFunctorOps(FutureLift$.MODULE$.FutureLiftOps(() -> BaseRedis.xDel$$anonfun$1$$anonfun$1(_$382, key, ids), this.evidence$2, this.evidence$1, this.evidence$3).futureLift(), this.evidence$2).map((Function1 & Serializable)_$383 -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(_$383)))));
    }

    private static final RedisFuture $init$$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$288$1) {
        return _$288$1.ping();
    }

    private static final RedisFuture $init$$$anonfun$2$$anonfun$1(RedisClusterAsyncCommands _$304$1) {
        return _$304$1.flushall();
    }

    private static final RedisFuture $init$$$anonfun$3$$anonfun$1(RedisClusterAsyncCommands _$306$1) {
        return _$306$1.flushdb();
    }

    private static final RedisFuture copy$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$16$1, Object source$1, Object destination$1) {
        return _$16$1.copy(source$1, destination$1);
    }

    private final RedisFuture copy$$anonfun$2$$anonfun$1(RedisClusterAsyncCommands _$17$1, Object source$3, Object destination$3, effects.CopyArgs copyArgs$1) {
        return _$17$1.copy(source$3, destination$3, this.CopyArgOps(copyArgs$1).asJava());
    }

    private static final RedisFuture del$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$18$1, Seq keys$1, Object k$1) {
        return _$18$1.del((Object[])Arrays$.MODULE$.seqToArray((Seq)keys$1.$plus$colon(k$1), Object.class));
    }

    private static final RedisFuture dump$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$19$1, Object key$1) {
        return _$19$1.dump(key$1);
    }

    private static final RedisFuture exists$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$21$1, Seq all$1) {
        return _$21$1.exists((Object[])Arrays$.MODULE$.seqToArray(all$1, Object.class));
    }

    private static final RedisFuture expire$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands c$1, Object key$4, FiniteDuration expiresIn$2) {
        return c$1.pexpire(key$4, expiresIn$2.toMillis());
    }

    private static final RedisFuture expire$$anonfun$1$$anonfun$2(RedisClusterAsyncCommands c$2, Object key$5, FiniteDuration expiresIn$3) {
        return c$2.expire(key$5, expiresIn$3.toSeconds());
    }

    private final RedisFuture expire$$anonfun$3$$anonfun$1(RedisClusterAsyncCommands c$3, Object key$7, FiniteDuration expiresIn$5, effects.ExpireExistenceArg expireExistenceArg$2) {
        return c$3.pexpire(key$7, expiresIn$5.toMillis(), this.ExpireExistenceArgOps(expireExistenceArg$2).asJava());
    }

    private final RedisFuture expire$$anonfun$3$$anonfun$2(RedisClusterAsyncCommands c$4, Object key$8, FiniteDuration expiresIn$6, effects.ExpireExistenceArg expireExistenceArg$3) {
        return c$4.expire(key$8, expiresIn$6.toSeconds(), this.ExpireExistenceArgOps(expireExistenceArg$3).asJava());
    }

    private static final RedisFuture expireAt$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$23$1, Object key$9, Instant at$1) {
        return _$23$1.pexpireat(key$9, at$1.toEpochMilli());
    }

    private final RedisFuture expireAt$$anonfun$2$$anonfun$1(RedisClusterAsyncCommands _$24$1, Object key$11, Instant at$3, effects.ExpireExistenceArg expireExistenceArg$4) {
        return _$24$1.pexpireat(key$11, at$3.toEpochMilli(), this.ExpireExistenceArgOps(expireExistenceArg$4).asJava());
    }

    private static final RedisFuture objectIdletime$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$25$1, Object key$13) {
        return _$25$1.objectIdletime(key$13);
    }

    private static final RedisFuture persist$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$26$1, Object key$15) {
        return _$26$1.persist(key$15);
    }

    private static final RedisFuture pttl$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$27$1, Object key$17) {
        return _$27$1.pttl(key$17);
    }

    private static final RedisFuture randomKey$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$28$1) {
        return _$28$1.randomkey();
    }

    private static final RedisFuture restore$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$30$1, Object key$19, byte[] value$1) {
        return _$30$1.restore(key$19, 0L, value$1);
    }

    private final RedisFuture restore$$anonfun$2$$anonfun$1(RedisClusterAsyncCommands _$31$1, Object key$21, byte[] value$3, effects.RestoreArgs restoreArgs$1) {
        return _$31$1.restore(key$21, value$3, this.RestoreArgOps(restoreArgs$1).asJava());
    }

    private static final RedisFuture scan$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$32$1) {
        return _$32$1.scan();
    }

    private static final RedisFuture scan$$anonfun$2$$anonfun$1(RedisClusterAsyncCommands _$33$1, long cursor$1) {
        return _$33$1.scan(ScanCursor.of((String)BoxesRunTime.boxToLong((long)cursor$1).toString()));
    }

    private static final RedisFuture scan$$anonfun$3$$anonfun$1(RedisClusterAsyncCommands _$34$1, data.KeyScanCursor previous$1) {
        return _$34$1.scan((ScanCursor)previous$1.underlying());
    }

    private static final RedisFuture scan$$anonfun$4$$anonfun$1(RedisClusterAsyncCommands _$35$1, effects.ScanArgs scanArgs$1) {
        return _$35$1.scan(scanArgs$1.underlying());
    }

    private static final RedisFuture scan$$anonfun$5$$anonfun$1(RedisClusterAsyncCommands _$36$1, long cursor$3, effects.ScanArgs scanArgs$3) {
        return _$36$1.scan(ScanCursor.of((String)BoxesRunTime.boxToLong((long)cursor$3).toString()), scanArgs$3.underlying());
    }

    private static final RedisFuture scan$$anonfun$6$$anonfun$1(RedisClusterAsyncCommands _$37$1, data.KeyScanCursor previous$3, effects.ScanArgs scanArgs$5) {
        return _$37$1.scan((ScanCursor)previous$3.underlying(), scanArgs$5.underlying());
    }

    private static final RedisFuture scan$$anonfun$7$$anonfun$1(RedisClusterAsyncCommands _$38$1, effects.KeyScanArgs keyScanArgs$1) {
        return _$38$1.scan((ScanArgs)keyScanArgs$1.underlying());
    }

    private static final RedisFuture scan$$anonfun$8$$anonfun$1(RedisClusterAsyncCommands _$39$1, data.KeyScanCursor cursor$5, effects.KeyScanArgs keyScanArgs$3) {
        return _$39$1.scan((ScanCursor)cursor$5.underlying(), (ScanArgs)keyScanArgs$3.underlying());
    }

    private static final RedisFuture ttl$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$40$1, Object key$23) {
        return _$40$1.ttl(key$23);
    }

    private static final RedisFuture typeOf$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$41$1, Object key$25) {
        return _$41$1.type(key$25);
    }

    private static final RedisFuture unlink$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$42$1, Seq key$27) {
        return _$42$1.unlink((Object[])Arrays$.MODULE$.seqToArray(key$27, Object.class));
    }

    private static final void showThread$$anonfun$1(String op$1) {
        Predef$.MODULE$.println((Object)new StringBuilder(3).append(op$1).append(" - ").append(Thread.currentThread().getName()).toString());
    }

    private static final RedisFuture multi$$anonfun$1$$anonfun$1(RedisAsyncCommands c$5) {
        return c$5.multi();
    }

    private static final RedisFuture multi$$anonfun$1$$anonfun$2$$anonfun$1(RedisAsyncCommands _$43$1) {
        return _$43$1.multi();
    }

    private static final RedisFuture exec$$anonfun$1$$anonfun$1(RedisAsyncCommands c$6) {
        return c$6.exec();
    }

    private static final RedisFuture exec$$anonfun$1$$anonfun$2$$anonfun$1(RedisAsyncCommands _$44$1) {
        return _$44$1.exec();
    }

    private static final RedisFuture discard$$anonfun$1$$anonfun$1(RedisAsyncCommands c$7) {
        return c$7.discard();
    }

    private static final RedisFuture discard$$anonfun$1$$anonfun$2$$anonfun$1(RedisAsyncCommands _$45$1) {
        return _$45$1.discard();
    }

    private static final RedisFuture watch$$anonfun$1$$anonfun$1(RedisAsyncCommands c$8, Seq keys$3) {
        return c$8.watch((Object[])Arrays$.MODULE$.seqToArray(keys$3, Object.class));
    }

    private static final RedisFuture watch$$anonfun$1$$anonfun$2$$anonfun$1(RedisAsyncCommands _$46$1, Seq keys$5) {
        return _$46$1.watch((Object[])Arrays$.MODULE$.seqToArray(keys$5, Object.class));
    }

    private static final RedisFuture unwatch$$anonfun$1$$anonfun$1(RedisAsyncCommands c$9) {
        return c$9.unwatch();
    }

    private static final RedisFuture unwatch$$anonfun$1$$anonfun$2$$anonfun$1(RedisAsyncCommands _$47$1) {
        return _$47$1.unwatch();
    }

    private static final RedisFuture unsafe$$anonfun$1$$anonfun$1(Function1 f$2, RedisClusterAsyncCommands _$50$1) {
        return (RedisFuture)f$2.apply((Object)_$50$1);
    }

    private static final Object unsafeSync$$anonfun$1$$anonfun$1(Function1 f$4, RedisClusterAsyncCommands cmd$1) {
        return f$4.apply((Object)cmd$1);
    }

    private static final RedisFuture append$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$51$1, Object key$29, Object value$5) {
        return _$51$1.append(key$29, value$5);
    }

    private static final RedisFuture getSet$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$52$1, Object key$31, Object value$7) {
        return _$52$1.getset(key$31, value$7);
    }

    private static final RedisFuture set$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$53$1, Object key$33, Object value$9) {
        return _$53$1.set(key$33, value$9);
    }

    private static final RedisFuture set$$anonfun$4$$anonfun$1(RedisClusterAsyncCommands _$54$1, Object key$35, Object value$11, SetArgs jSetArgs$3) {
        return _$54$1.set(key$35, value$11, jSetArgs$3);
    }

    private static final RedisFuture setNx$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$56$1, Object key$37, Object value$13) {
        return _$56$1.setnx(key$37, value$13);
    }

    private static final RedisFuture setEx$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$57$1, Object key$39, FiniteDuration expiresIn$7, Object value$15) {
        return _$57$1.psetex(key$39, expiresIn$7.toMillis(), value$15);
    }

    private static final RedisFuture setEx$$anonfun$2$$anonfun$1(RedisClusterAsyncCommands _$58$1, Object key$41, FiniteDuration expiresIn$9, Object value$17) {
        return _$58$1.setex(key$41, expiresIn$9.toSeconds(), value$17);
    }

    private static final RedisFuture setRange$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$59$1, Object key$43, long offset$1, Object value$19) {
        return _$59$1.setrange(key$43, offset$1, value$19);
    }

    private static final RedisFuture decr$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$60$1, Object key$45) {
        return _$60$1.decr(key$45);
    }

    private static final RedisFuture decrBy$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$61$1, Object key$47, long amount$1) {
        return _$61$1.decrby(key$47, amount$1);
    }

    private static final RedisFuture incr$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$62$1, Object key$49) {
        return _$62$1.incr(key$49);
    }

    private static final RedisFuture incrBy$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$63$1, Object key$51, long amount$3) {
        return _$63$1.incrby(key$51, amount$3);
    }

    private static final RedisFuture incrByFloat$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$64$1, Object key$53, double amount$5) {
        return _$64$1.incrbyfloat(key$53, amount$5);
    }

    private static final RedisFuture get$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$65$1, Object key$55) {
        return _$65$1.get(key$55);
    }

    private static final RedisFuture getEx$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$66$1, Object key$57, GetExArgs jgetExArgs$1) {
        return _$66$1.getex(key$57, jgetExArgs$1);
    }

    private static final RedisFuture getRange$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$67$1, Object key$59, long start$1, long end$1) {
        return _$67$1.getrange(key$59, start$1, end$1);
    }

    private static final RedisFuture strLen$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$68$1, Object key$61) {
        return _$68$1.strlen(key$61);
    }

    private static final RedisFuture mGet$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$69$1, Set keys$7) {
        return _$69$1.mget((Object[])Arrays$.MODULE$.seqToArray(keys$7.toSeq(), Object.class));
    }

    private static final RedisFuture mSet$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$71$1, scala.collection.immutable.Map keyValues$1) {
        return _$71$1.mset(JavaConversions$.MODULE$.MapHasAsJava((Map)keyValues$1).asJava());
    }

    private static final RedisFuture mSetNx$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$72$1, scala.collection.immutable.Map keyValues$3) {
        return _$72$1.msetnx(JavaConversions$.MODULE$.MapHasAsJava((Map)keyValues$3).asJava());
    }

    private static final RedisFuture hDel$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$73$1, Object key$63, Seq fields$1, Object field$1) {
        return _$73$1.hdel(key$63, (Object[])Arrays$.MODULE$.seqToArray((Seq)fields$1.$plus$colon(field$1), Object.class));
    }

    private static final RedisFuture hGetDel$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$74$1, Object key$65, Seq fields$3, Object field$3) {
        return _$74$1.hgetdel(key$65, (Object[])Arrays$.MODULE$.seqToArray((Seq)fields$3.$plus$colon(field$3), Object.class));
    }

    private static final RedisFuture hExists$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$76$1, Object key$67, Object field$5) {
        return _$76$1.hexists(key$67, field$5);
    }

    private static final RedisFuture hGet$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$77$1, Object key$69, Object field$7) {
        return _$77$1.hget(key$69, field$7);
    }

    private static final RedisFuture hGetEx$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$78$1, Object key$71, HGetExArgs jgetExArgs$3, Seq fields$5, Object field$9) {
        return _$78$1.hgetex(key$71, jgetExArgs$3, (Object[])Arrays$.MODULE$.seqToArray((Seq)fields$5.$plus$colon(field$9), Object.class));
    }

    private static final RedisFuture hGetAll$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$80$1, Object key$73) {
        return _$80$1.hgetall(key$73);
    }

    private static final RedisFuture hmGet$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$82$1, Object key$75, Seq fields$7, Object field$11) {
        return _$82$1.hmget(key$75, (Object[])Arrays$.MODULE$.seqToArray((Seq)fields$7.$plus$colon(field$11), Object.class));
    }

    private static final RedisFuture hKeys$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$84$1, Object key$77) {
        return _$84$1.hkeys(key$77);
    }

    private static final RedisFuture hVals$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$86$1, Object key$79) {
        return _$86$1.hvals(key$79);
    }

    private static final RedisFuture hStrLen$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$88$1, Object key$81, Object field$13) {
        return _$88$1.hstrlen(key$81, field$13);
    }

    private static final RedisFuture hLen$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$89$1, Object key$83) {
        return _$89$1.hlen(key$83);
    }

    private static final RedisFuture hScan$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$90$1, Object key$85) {
        return _$90$1.hscan(key$85);
    }

    private static final RedisFuture hScan$$anonfun$2$$anonfun$1(RedisClusterAsyncCommands _$92$1, Object key$87, data.MapScanCursor cursor$7) {
        return _$92$1.hscan(key$87, (ScanCursor)cursor$7.underlying());
    }

    private static final RedisFuture hScan$$anonfun$3$$anonfun$1(RedisClusterAsyncCommands _$94$1, Object key$89, effects.ScanArgs scanArgs$7) {
        return _$94$1.hscan(key$89, scanArgs$7.underlying());
    }

    private static final RedisFuture hScan$$anonfun$4$$anonfun$1(RedisClusterAsyncCommands _$96$1, Object key$91, data.MapScanCursor cursor$9, effects.ScanArgs scanArgs$9) {
        return _$96$1.hscan(key$91, (ScanCursor)cursor$9.underlying(), scanArgs$9.underlying());
    }

    private static final RedisFuture hScanNoValues$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$98$1, Object key$93) {
        return _$98$1.hscanNovalues(key$93);
    }

    private static final RedisFuture hScanNoValues$$anonfun$2$$anonfun$1(RedisClusterAsyncCommands _$100$1, Object key$95, data.KeyScanCursor cursor$11) {
        return _$100$1.hscanNovalues(key$95, (ScanCursor)cursor$11.underlying());
    }

    private static final RedisFuture hScanNoValues$$anonfun$3$$anonfun$1(RedisClusterAsyncCommands _$102$1, Object key$97, effects.ScanArgs scanArgs$11) {
        return _$102$1.hscanNovalues(key$97, scanArgs$11.underlying());
    }

    private static final RedisFuture hScanNoValues$$anonfun$4$$anonfun$1(RedisClusterAsyncCommands _$104$1, Object key$99, data.KeyScanCursor cursor$13, effects.ScanArgs scanArgs$13) {
        return _$104$1.hscanNovalues(key$99, (ScanCursor)cursor$13.underlying(), scanArgs$13.underlying());
    }

    private static final RedisFuture hSet$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$106$1, Object key$101, Object field$15, Object value$21) {
        return _$106$1.hset(key$101, field$15, value$21);
    }

    private static final RedisFuture hSet$$anonfun$2$$anonfun$1(RedisClusterAsyncCommands _$107$1, Object key$103, scala.collection.immutable.Map fieldValues$1) {
        return _$107$1.hset(key$103, JavaConversions$.MODULE$.MapHasAsJava((Map)fieldValues$1).asJava());
    }

    private static final RedisFuture hExpire$$anonfun$1$$anonfun$1(FiniteDuration expiresIn$12, RedisClusterAsyncCommands c$10, Object key$106, Seq fields$10) {
        block8: {
            block3: {
                TimeUnit timeUnit;
                TimeUnit timeUnit2;
                block7: {
                    TimeUnit timeUnit3;
                    block6: {
                        TimeUnit timeUnit4;
                        TimeUnit timeUnit5;
                        block5: {
                            block4: {
                                TimeUnit timeUnit6;
                                TimeUnit timeUnit7;
                                block2: {
                                    timeUnit3 = expiresIn$12.unit();
                                    timeUnit7 = TimeUnit.MILLISECONDS;
                                    timeUnit6 = timeUnit3;
                                    if (timeUnit7 != null) break block2;
                                    if (timeUnit6 == null) break block3;
                                    break block4;
                                }
                                if (((Object)((Object)timeUnit7)).equals((Object)timeUnit6)) break block3;
                            }
                            timeUnit5 = TimeUnit.MICROSECONDS;
                            timeUnit4 = timeUnit3;
                            if (timeUnit5 != null) break block5;
                            if (timeUnit4 == null) break block3;
                            break block6;
                        }
                        if (((Object)((Object)timeUnit5)).equals((Object)timeUnit4)) break block3;
                    }
                    timeUnit2 = TimeUnit.NANOSECONDS;
                    timeUnit = timeUnit3;
                    if (timeUnit2 != null) break block7;
                    if (timeUnit == null) break block3;
                    break block8;
                }
                if (!((Object)((Object)timeUnit2)).equals((Object)timeUnit)) break block8;
            }
            return c$10.hpexpire(key$106, expiresIn$12.toMillis(), (Object[])Arrays$.MODULE$.seqToArray(fields$10, Object.class));
        }
        return c$10.hexpire(key$106, expiresIn$12.toSeconds(), (Object[])Arrays$.MODULE$.seqToArray(fields$10, Object.class));
    }

    private final RedisFuture hExpire$$anonfun$2$$anonfun$1(FiniteDuration expire$2, RedisClusterAsyncCommands c$11, Object key$108, effects.ExpireExistenceArg args$2, Seq fields$12) {
        block8: {
            block3: {
                TimeUnit timeUnit;
                TimeUnit timeUnit2;
                block7: {
                    TimeUnit timeUnit3;
                    block6: {
                        TimeUnit timeUnit4;
                        TimeUnit timeUnit5;
                        block5: {
                            block4: {
                                TimeUnit timeUnit6;
                                TimeUnit timeUnit7;
                                block2: {
                                    timeUnit3 = expire$2.unit();
                                    timeUnit7 = TimeUnit.MILLISECONDS;
                                    timeUnit6 = timeUnit3;
                                    if (timeUnit7 != null) break block2;
                                    if (timeUnit6 == null) break block3;
                                    break block4;
                                }
                                if (((Object)((Object)timeUnit7)).equals((Object)timeUnit6)) break block3;
                            }
                            timeUnit5 = TimeUnit.MICROSECONDS;
                            timeUnit4 = timeUnit3;
                            if (timeUnit5 != null) break block5;
                            if (timeUnit4 == null) break block3;
                            break block6;
                        }
                        if (((Object)((Object)timeUnit5)).equals((Object)timeUnit4)) break block3;
                    }
                    timeUnit2 = TimeUnit.NANOSECONDS;
                    timeUnit = timeUnit3;
                    if (timeUnit2 != null) break block7;
                    if (timeUnit == null) break block3;
                    break block8;
                }
                if (!((Object)((Object)timeUnit2)).equals((Object)timeUnit)) break block8;
            }
            return c$11.hpexpire(key$108, expire$2.toMillis(), this.ExpireExistenceArgOps(args$2).asJava(), (Object[])Arrays$.MODULE$.seqToArray(fields$12, Object.class));
        }
        return c$11.hexpire(key$108, expire$2.toSeconds(), this.ExpireExistenceArgOps(args$2).asJava(), (Object[])Arrays$.MODULE$.seqToArray(fields$12, Object.class));
    }

    private static final RedisFuture hExpireAt$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$110$1, Object key$109, Instant expireAt$1, Seq fields$13) {
        return _$110$1.hpexpireat(key$109, expireAt$1.toEpochMilli(), (Object[])Arrays$.MODULE$.seqToArray(fields$13, Object.class));
    }

    private final RedisFuture hExpireAt$$anonfun$2$$anonfun$1(RedisClusterAsyncCommands _$112$1, Object key$111, Instant expireAt$3, effects.ExpireExistenceArg args$3, Seq fields$15) {
        return _$112$1.hpexpireat(key$111, expireAt$3.toEpochMilli(), this.ExpireExistenceArgOps(args$3).asJava(), (Object[])Arrays$.MODULE$.seqToArray(fields$15, Object.class));
    }

    private static final RedisFuture hExpireTime$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$114$1, Object key$113, Seq fields$17) {
        return _$114$1.hpexpiretime(key$113, (Object[])Arrays$.MODULE$.seqToArray(fields$17, Object.class));
    }

    private static final RedisFuture hpExpireTime$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$116$1, Object key$115, Seq fields$19) {
        return _$116$1.hpexpiretime(key$115, (Object[])Arrays$.MODULE$.seqToArray(fields$19, Object.class));
    }

    private static final RedisFuture hPersist$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$118$1, Object key$117, Seq fields$21) {
        return _$118$1.hpersist(key$117, (Object[])Arrays$.MODULE$.seqToArray(fields$21, Object.class));
    }

    private static final RedisFuture hpttl$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$120$1, Object key$119, Seq fields$23) {
        return _$120$1.hpttl(key$119, (Object[])Arrays$.MODULE$.seqToArray(fields$23, Object.class));
    }

    private static final RedisFuture httl$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$122$1, Object key$121, Seq fields$25) {
        return _$122$1.httl(key$121, (Object[])Arrays$.MODULE$.seqToArray(fields$25, Object.class));
    }

    private static final RedisFuture hSetNx$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$124$1, Object key$123, Object field$17, Object value$23) {
        return _$124$1.hsetnx(key$123, field$17, value$23);
    }

    private static final RedisFuture hmSet$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$125$1, Object key$125, scala.collection.immutable.Map fieldValues$3) {
        return _$125$1.hmset(key$125, JavaConversions$.MODULE$.MapHasAsJava((Map)fieldValues$3).asJava());
    }

    private static final RedisFuture hIncrBy$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$126$1, Object key$127, Object field$19, long amount$7) {
        return _$126$1.hincrby(key$127, field$19, amount$7);
    }

    private static final RedisFuture hIncrByFloat$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$127$1, Object key$129, Object field$21, double amount$9) {
        return _$127$1.hincrbyfloat(key$129, field$21, amount$9);
    }

    private static final RedisFuture sIsMember$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$128$1, Object key$131, Object value$25) {
        return _$128$1.sismember(key$131, value$25);
    }

    private static final RedisFuture sMisMember$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$129$1, Object key$133, Seq values$1) {
        return _$129$1.smismember(key$133, (Object[])Arrays$.MODULE$.seqToArray(values$1, Object.class));
    }

    private static final RedisFuture sAdd$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$132$1, Object key$135, Seq values$3) {
        return _$132$1.sadd(key$135, (Object[])Arrays$.MODULE$.seqToArray(values$3, Object.class));
    }

    private static final RedisFuture sDiffStore$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$133$1, Object destination$5, Seq keys$9) {
        return _$133$1.sdiffstore(destination$5, (Object[])Arrays$.MODULE$.seqToArray(keys$9, Object.class));
    }

    private static final RedisFuture sInterStore$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$134$1, Object destination$7, Seq keys$11) {
        return _$134$1.sinterstore(destination$7, (Object[])Arrays$.MODULE$.seqToArray(keys$11, Object.class));
    }

    private static final RedisFuture sMove$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$135$1, Object source$5, Object destination$9, Object value$27) {
        return _$135$1.smove(source$5, destination$9, value$27);
    }

    private static final RedisFuture sPop$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$136$1, Object key$137) {
        return _$136$1.spop(key$137);
    }

    private static final RedisFuture sPop$$anonfun$2$$anonfun$1(RedisClusterAsyncCommands _$137$1, Object key$139, long count$1) {
        return _$137$1.spop(key$139, count$1);
    }

    private static final RedisFuture sRem$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$139$1, Object key$141, Seq values$5) {
        return _$139$1.srem(key$141, (Object[])Arrays$.MODULE$.seqToArray(values$5, Object.class));
    }

    private static final RedisFuture sCard$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$140$1, Object key$143) {
        return _$140$1.scard(key$143);
    }

    private static final RedisFuture sDiff$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$141$1, Seq keys$13) {
        return _$141$1.sdiff((Object[])Arrays$.MODULE$.seqToArray(keys$13, Object.class));
    }

    private static final RedisFuture sInter$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$143$1, Seq keys$15) {
        return _$143$1.sinter((Object[])Arrays$.MODULE$.seqToArray(keys$15, Object.class));
    }

    private static final RedisFuture sMembers$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$145$1, Object key$145) {
        return _$145$1.smembers(key$145);
    }

    private static final RedisFuture sRandMember$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$147$1, Object key$147) {
        return _$147$1.srandmember(key$147);
    }

    private static final RedisFuture sRandMember$$anonfun$2$$anonfun$1(RedisClusterAsyncCommands _$148$1, Object key$149, long count$3) {
        return _$148$1.srandmember(key$149, count$3);
    }

    private static final RedisFuture sUnion$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$150$1, Seq keys$17) {
        return _$150$1.sunion((Object[])Arrays$.MODULE$.seqToArray(keys$17, Object.class));
    }

    private static final RedisFuture sUnionStore$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$152$1, Object destination$11, Seq keys$19) {
        return _$152$1.sunionstore(destination$11, (Object[])Arrays$.MODULE$.seqToArray(keys$19, Object.class));
    }

    private static final RedisFuture lIndex$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$153$1, Object key$151, long index$1) {
        return _$153$1.lindex(key$151, index$1);
    }

    private static final RedisFuture lLen$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$154$1, Object key$153) {
        return _$154$1.llen(key$153);
    }

    private static final RedisFuture lRange$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$155$1, Object key$155, long start$3, long stop$1) {
        return _$155$1.lrange(key$155, start$3, stop$1);
    }

    private final RedisFuture blPop$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$157$1, Duration timeout$1, NonEmptyList keys$21) {
        return _$157$1.blpop(this.DurationOps(timeout$1).toSecondsOrZero(), (Object[])Arrays$.MODULE$.seqToArray((Seq)keys$21.toList(), Object.class));
    }

    private final RedisFuture brPop$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$159$1, Duration timeout$3, NonEmptyList keys$23) {
        return _$159$1.brpop(this.DurationOps(timeout$3).toSecondsOrZero(), (Object[])Arrays$.MODULE$.seqToArray((Seq)keys$23.toList(), Object.class));
    }

    private final RedisFuture brPopLPush$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$161$1, Duration timeout$5, Object source$7, Object destination$13) {
        return _$161$1.brpoplpush(this.DurationOps(timeout$5).toSecondsOrZero(), source$7, destination$13);
    }

    private static final RedisFuture lPop$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$162$1, Object key$157) {
        return _$162$1.lpop(key$157);
    }

    private static final RedisFuture lPush$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$163$1, Object key$159, Seq values$7) {
        return _$163$1.lpush(key$159, (Object[])Arrays$.MODULE$.seqToArray(values$7, Object.class));
    }

    private static final RedisFuture lPushX$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$164$1, Object key$161, Seq values$9) {
        return _$164$1.lpushx(key$161, (Object[])Arrays$.MODULE$.seqToArray(values$9, Object.class));
    }

    private static final RedisFuture rPop$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$165$1, Object key$163) {
        return _$165$1.rpop(key$163);
    }

    private static final RedisFuture rPopLPush$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$166$1, Object source$9, Object destination$15) {
        return _$166$1.rpoplpush(source$9, destination$15);
    }

    private static final RedisFuture rPush$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$167$1, Object key$165, Seq values$11) {
        return _$167$1.rpush(key$165, (Object[])Arrays$.MODULE$.seqToArray(values$11, Object.class));
    }

    private static final RedisFuture rPushX$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$168$1, Object key$167, Seq values$13) {
        return _$168$1.rpushx(key$167, (Object[])Arrays$.MODULE$.seqToArray(values$13, Object.class));
    }

    private static final RedisFuture lInsertAfter$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$169$1, Object key$169, Object pivot$1, Object value$29) {
        return _$169$1.linsert(key$169, false, pivot$1, value$29);
    }

    private static final RedisFuture lInsertBefore$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$170$1, Object key$171, Object pivot$3, Object value$31) {
        return _$170$1.linsert(key$171, true, pivot$3, value$31);
    }

    private static final RedisFuture lRem$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$171$1, Object key$173, long count$5, Object value$33) {
        return _$171$1.lrem(key$173, count$5, value$33);
    }

    private static final RedisFuture lSet$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$172$1, Object key$175, long index$3, Object value$35) {
        return _$172$1.lset(key$175, index$3, value$35);
    }

    private static final RedisFuture lTrim$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$173$1, Object key$177, long start$5, long stop$3) {
        return _$173$1.ltrim(key$177, start$5, stop$3);
    }

    private static final RedisFuture bitCount$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$174$1, Object key$179) {
        return _$174$1.bitcount(key$179);
    }

    private static final RedisFuture bitCount$$anonfun$2$$anonfun$1(RedisClusterAsyncCommands _$175$1, Object key$181, long start$7, long end$3) {
        return _$175$1.bitcount(key$181, start$7, end$3);
    }

    private static final RedisFuture bitField$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$176$1, Object key$183, Seq operations$1) {
        return _$176$1.bitfield(key$183, (BitFieldArgs)operations$1.foldLeft((Object)new BitFieldArgs(), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                BitFieldArgs bitFieldArgs = (BitFieldArgs)tuple2._1();
                BitCommandOperation bitCommandOperation = (BitCommandOperation)tuple2._2();
                BitFieldArgs b = bitFieldArgs;
                if (bitCommandOperation instanceof BitCommandOperation.Get) {
                    BitCommandOperation.Get get = BitCommandOperation$Get$.MODULE$.unapply((BitCommandOperation.Get)bitCommandOperation);
                    BitFieldArgs.BitFieldType bitFieldType = get._1();
                    int n = get._2();
                    BitFieldArgs.BitFieldType fieldType = bitFieldType;
                    int offset = n;
                    return b.get(fieldType, offset);
                }
                BitFieldArgs b2 = bitFieldArgs;
                if (bitCommandOperation instanceof BitCommandOperation.SetSigned) {
                    BitCommandOperation.SetSigned setSigned = BitCommandOperation$SetSigned$.MODULE$.unapply((BitCommandOperation.SetSigned)bitCommandOperation);
                    int n = setSigned._1();
                    long l = setSigned._2();
                    int n2 = setSigned._3();
                    int offset = n;
                    long value = l;
                    int bits = n2;
                    return b2.set(BitFieldArgs.signed((int)bits), offset, value);
                }
                BitFieldArgs b3 = bitFieldArgs;
                if (bitCommandOperation instanceof BitCommandOperation.SetUnsigned) {
                    BitCommandOperation.SetUnsigned setUnsigned = BitCommandOperation$SetUnsigned$.MODULE$.unapply((BitCommandOperation.SetUnsigned)bitCommandOperation);
                    int n = setUnsigned._1();
                    long l = setUnsigned._2();
                    int n3 = setUnsigned._3();
                    int offset = n;
                    long value = l;
                    int bits = n3;
                    return b3.set(BitFieldArgs.unsigned((int)bits), offset, value);
                }
                BitFieldArgs b4 = bitFieldArgs;
                if (bitCommandOperation instanceof BitCommandOperation.IncrSignedBy) {
                    BitCommandOperation.IncrSignedBy incrSignedBy = BitCommandOperation$IncrSignedBy$.MODULE$.unapply((BitCommandOperation.IncrSignedBy)bitCommandOperation);
                    int n = incrSignedBy._1();
                    long l = incrSignedBy._2();
                    int n4 = incrSignedBy._3();
                    int offset = n;
                    long value = l;
                    int bits = n4;
                    return b4.incrBy(BitFieldArgs.signed((int)bits), offset, value);
                }
                BitFieldArgs b5 = bitFieldArgs;
                if (bitCommandOperation instanceof BitCommandOperation.IncrUnsignedBy) {
                    BitCommandOperation.IncrUnsignedBy incrUnsignedBy = BitCommandOperation$IncrUnsignedBy$.MODULE$.unapply((BitCommandOperation.IncrUnsignedBy)bitCommandOperation);
                    int n = incrUnsignedBy._1();
                    long l = incrUnsignedBy._2();
                    int n5 = incrUnsignedBy._3();
                    int offset = n;
                    long value = l;
                    int bits = n5;
                    return b5.incrBy(BitFieldArgs.unsigned((int)bits), offset, value);
                }
                BitFieldArgs b6 = bitFieldArgs;
                if (bitCommandOperation instanceof BitCommandOperation.Overflow) {
                    BitCommandOperation.Overflow overflow = BitCommandOperation$Overflow$.MODULE$.unapply((BitCommandOperation.Overflow)bitCommandOperation);
                    Enumeration.Value value = overflow._1();
                    Enumeration.Value value2 = BitCommandOperation$Overflows$.MODULE$.SAT();
                    Enumeration.Value value3 = value;
                    if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                        return b6.overflow(BitFieldArgs.OverflowType.SAT);
                    }
                    BitFieldArgs b7 = bitFieldArgs;
                    Enumeration.Value value4 = BitCommandOperation$Overflows$.MODULE$.WRAP();
                    Enumeration.Value value5 = value;
                    if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                        return b7.overflow(BitFieldArgs.OverflowType.WRAP);
                    }
                    BitFieldArgs b8 = bitFieldArgs;
                    return b8.overflow(BitFieldArgs.OverflowType.FAIL);
                }
            }
            throw new MatchError((Object)tuple2);
        }));
    }

    private static final RedisFuture bitPos$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$179$1, Object key$185, boolean state$1) {
        return _$179$1.bitpos(key$185, state$1);
    }

    private static final RedisFuture bitPos$$anonfun$2$$anonfun$1(RedisClusterAsyncCommands _$180$1, Object key$187, boolean state$3, long start$9) {
        return _$180$1.bitpos(key$187, state$3, start$9);
    }

    private static final RedisFuture bitPos$$anonfun$3$$anonfun$1(RedisClusterAsyncCommands _$181$1, Object key$189, boolean state$5, long start$11, long end$5) {
        return _$181$1.bitpos(key$189, state$5, start$11, end$5);
    }

    private static final RedisFuture bitOpAnd$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$182$1, Object destination$17, Seq sources$1, Object source$11) {
        return _$182$1.bitopAnd(destination$17, (Object[])Arrays$.MODULE$.seqToArray((Seq)sources$1.$plus$colon(source$11), Object.class));
    }

    private static final RedisFuture bitOpNot$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$183$1, Object destination$19, Object source$13) {
        return _$183$1.bitopNot(destination$19, source$13);
    }

    private static final RedisFuture bitOpOr$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$184$1, Object destination$21, Seq sources$3, Object source$15) {
        return _$184$1.bitopOr(destination$21, (Object[])Arrays$.MODULE$.seqToArray((Seq)sources$3.$plus$colon(source$15), Object.class));
    }

    private static final RedisFuture bitOpXor$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$185$1, Object destination$23, Seq sources$5, Object source$17) {
        return _$185$1.bitopXor(destination$23, (Object[])Arrays$.MODULE$.seqToArray((Seq)sources$5.$plus$colon(source$17), Object.class));
    }

    private static final RedisFuture getBit$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$186$1, Object key$191, long offset$3) {
        return _$186$1.getbit(key$191, offset$3);
    }

    private static final RedisFuture setBit$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$187$1, Object key$193, long offset$5, int value$37) {
        return _$187$1.setbit(key$193, offset$5, value$37);
    }

    private static final RedisFuture geoDist$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$188$1, Object key$195, Object from$1, Object to$1, GeoArgs.Unit unit$1) {
        return _$188$1.geodist(key$195, from$1, to$1, unit$1);
    }

    private static final RedisFuture geoHash$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$189$1, Object key$197, Seq values$15, Object value$39) {
        return _$189$1.geohash(key$197, (Object[])Arrays$.MODULE$.seqToArray((Seq)values$15.$plus$colon(value$39), Object.class));
    }

    private static final RedisFuture geoPos$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$191$1, Object key$199, Seq values$17, Object value$41) {
        return _$191$1.geopos(key$199, (Object[])Arrays$.MODULE$.seqToArray((Seq)values$17.$plus$colon(value$41), Object.class));
    }

    private static final RedisFuture geoRadius$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$193$1, Object key$201, effects.GeoRadius geoRadius$1, GeoArgs.Unit unit$3) {
        return _$193$1.georadius(key$201, geoRadius$1.lon(), geoRadius$1.lat(), geoRadius$1.dist(), unit$3);
    }

    private static final RedisFuture geoRadius$$anonfun$3$$anonfun$1(RedisClusterAsyncCommands _$195$1, Object key$203, effects.GeoRadius geoRadius$3, GeoArgs.Unit unit$5, GeoArgs args$5) {
        return _$195$1.georadius(key$203, geoRadius$3.lon(), geoRadius$3.lat(), geoRadius$3.dist(), unit$5, args$5);
    }

    private static final RedisFuture geoRadiusByMember$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$198$1, Object key$205, Object value$43, double dist$1, GeoArgs.Unit unit$7) {
        return _$198$1.georadiusbymember(key$205, value$43, dist$1, unit$7);
    }

    private static final RedisFuture geoRadiusByMember$$anonfun$2$$anonfun$1(RedisClusterAsyncCommands _$200$1, Object key$207, Object value$45, double dist$3, GeoArgs.Unit unit$9, GeoArgs args$7) {
        return _$200$1.georadiusbymember(key$207, value$45, dist$3, unit$9, args$7);
    }

    private static final RedisFuture geoAdd$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$203$1, Object key$209, Seq triplets$1) {
        return _$203$1.geoadd(key$209, (Object[])Arrays$.MODULE$.seqToArray(triplets$1, Object.class));
    }

    private final RedisFuture geoRadius$$anonfun$5$$anonfun$1(RedisAsyncCommands _$204$1, Object key$211, effects.GeoRadius geoRadius$5, GeoArgs.Unit unit$11, effects.GeoRadiusKeyStorage storage$1) {
        return _$204$1.georadius(key$211, geoRadius$5.lon(), geoRadius$5.lat(), geoRadius$5.dist(), unit$11, this.GeoRadiusKeyStorageOps(storage$1).asGeoRadiusStoreArgs());
    }

    private final RedisFuture geoRadius$$anonfun$6$$anonfun$1(RedisAsyncCommands _$205$1, Object key$213, effects.GeoRadius geoRadius$7, GeoArgs.Unit unit$13, effects.GeoRadiusDistStorage storage$3) {
        return _$205$1.georadius(key$213, geoRadius$7.lon(), geoRadius$7.lat(), geoRadius$7.dist(), unit$13, this.GeoRadiusDistStorageOps(storage$3).asGeoRadiusStoreArgs());
    }

    private final RedisFuture geoRadiusByMember$$anonfun$4$$anonfun$1(RedisClusterAsyncCommands _$206$1, Object key$215, Object value$47, double dist$5, GeoArgs.Unit unit$15, effects.GeoRadiusKeyStorage storage$5) {
        return _$206$1.georadiusbymember(key$215, value$47, dist$5, unit$15, this.GeoRadiusKeyStorageOps(storage$5).asGeoRadiusStoreArgs());
    }

    private final RedisFuture geoRadiusByMember$$anonfun$5$$anonfun$1(RedisClusterAsyncCommands _$207$1, Object key$217, Object value$49, double dist$7, GeoArgs.Unit unit$17, effects.GeoRadiusDistStorage storage$7) {
        return _$207$1.georadiusbymember(key$217, value$49, dist$7, unit$17, this.GeoRadiusDistStorageOps(storage$7).asGeoRadiusStoreArgs());
    }

    private static final RedisFuture $anonfun$2$$anonfun$1(RedisClusterAsyncCommands _$208$1, Object key$219, ZAddArgs x$1, Seq values$19) {
        return _$208$1.zadd(key$219, x$1, (ScoredValue[])Arrays$.MODULE$.seqToArray((Seq)values$19.map((Function1 & Serializable)s -> ScoredValue.just((double)s.score(), s.value())), ScoredValue.class));
    }

    private static final RedisFuture $anonfun$3$$anonfun$1(RedisClusterAsyncCommands _$209$1, Object key$221, Seq values$21) {
        return _$209$1.zadd(key$221, (ScoredValue[])Arrays$.MODULE$.seqToArray((Seq)values$21.map((Function1 & Serializable)s -> ScoredValue.just((double)s.score(), s.value())), ScoredValue.class));
    }

    private static final RedisFuture $anonfun$4$$anonfun$1(RedisClusterAsyncCommands _$210$1, Object key$223, ZAddArgs x$3, effects.ScoreWithValue member$1) {
        return _$210$1.zaddincr(key$223, x$3, member$1.score(), member$1.value());
    }

    private static final RedisFuture $anonfun$5$$anonfun$1(RedisClusterAsyncCommands _$211$1, Object key$225, effects.ScoreWithValue member$3) {
        return _$211$1.zaddincr(key$225, member$3.score(), member$3.value());
    }

    private static final RedisFuture zIncrBy$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$212$1, Object key$227, double amount$11, Object member$5) {
        return _$212$1.zincrby(key$227, amount$11, member$5);
    }

    private static final RedisFuture $anonfun$6$$anonfun$1(RedisClusterAsyncCommands _$213$1, Object destination$25, ZStoreArgs x$5, Seq keys$25) {
        return _$213$1.zinterstore(destination$25, x$5, (Object[])Arrays$.MODULE$.seqToArray(keys$25, Object.class));
    }

    private static final RedisFuture $anonfun$7$$anonfun$1(RedisClusterAsyncCommands _$214$1, Object destination$27, Seq keys$27) {
        return _$214$1.zinterstore(destination$27, (Object[])Arrays$.MODULE$.seqToArray(keys$27, Object.class));
    }

    private static final RedisFuture zRem$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$215$1, Object key$229, Seq values$23, Object value$51) {
        return _$215$1.zrem(key$229, (Object[])Arrays$.MODULE$.seqToArray((Seq)values$23.$plus$colon(value$51), Object.class));
    }

    private static final RedisFuture zRemRangeByLex$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$216$1, Object key$231, effects.ZRange range$1) {
        return _$216$1.zremrangebylex(key$231, Range.create(range$1.start(), range$1.end()));
    }

    private static final RedisFuture zRemRangeByRank$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$217$1, Object key$233, long start$13, long stop$5) {
        return _$217$1.zremrangebyrank(key$233, start$13, stop$5);
    }

    private final RedisFuture zRemRangeByScore$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$218$1, Object key$235, effects.ZRange range$3, Numeric evidence$1$4) {
        return _$218$1.zremrangebyscore(key$235, this.ZRangeOps(range$3, evidence$1$4).asJavaRange());
    }

    private static final RedisFuture $anonfun$8$$anonfun$1(RedisClusterAsyncCommands _$219$1, Object destination$29, ZStoreArgs x$7, Seq keys$29) {
        return _$219$1.zunionstore(destination$29, x$7, (Object[])Arrays$.MODULE$.seqToArray(keys$29, Object.class));
    }

    private static final RedisFuture $anonfun$9$$anonfun$1(RedisClusterAsyncCommands _$220$1, Object destination$31, Seq keys$31) {
        return _$220$1.zunionstore(destination$31, (Object[])Arrays$.MODULE$.seqToArray(keys$31, Object.class));
    }

    private static final RedisFuture zCard$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$221$1, Object key$237) {
        return _$221$1.zcard(key$237);
    }

    private final RedisFuture zCount$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$222$1, Object key$239, effects.ZRange range$5, Numeric evidence$1$6) {
        return _$222$1.zcount(key$239, this.ZRangeOps(range$5, evidence$1$6).asJavaRange());
    }

    private static final RedisFuture zMScore$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$223$1, Object key$241, Seq values$25) {
        return _$223$1.zmscore(key$241, (Object[])Arrays$.MODULE$.seqToArray(values$25, Object.class));
    }

    private static final RedisFuture zLexCount$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$225$1, Object key$243, effects.ZRange range$7) {
        return _$225$1.zlexcount(key$243, Range.create(range$7.start(), range$7.end()));
    }

    private static final RedisFuture zRange$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$226$1, Object key$245, long start$15, long stop$7) {
        return _$226$1.zrange(key$245, start$15, stop$7);
    }

    private static final RedisFuture $anonfun$10$$anonfun$1(RedisClusterAsyncCommands _$228$1, Object key$247, effects.ZRange range$9, effects.RangeLimit x$9) {
        return _$228$1.zrangebylex(key$247, Range.create(range$9.start(), range$9.end()), Limit.create((long)x$9.offset(), (long)x$9.count()));
    }

    private static final RedisFuture $anonfun$11$$anonfun$1(RedisClusterAsyncCommands _$229$1, Object key$249, effects.ZRange range$11) {
        return _$229$1.zrangebylex(key$249, Range.create(range$11.start(), range$11.end()));
    }

    private final RedisFuture $anonfun$12$$anonfun$1(RedisClusterAsyncCommands _$231$1, Object key$251, effects.ZRange range$13, Numeric evidence$1$8, effects.RangeLimit x$11) {
        return _$231$1.zrangebyscore(key$251, this.ZRangeOps(range$13, evidence$1$8).asJavaRange(), Limit.create((long)x$11.offset(), (long)x$11.count()));
    }

    private final RedisFuture $anonfun$13$$anonfun$1(RedisClusterAsyncCommands _$232$1, Object key$253, effects.ZRange range$15, Numeric evidence$1$10) {
        return _$232$1.zrangebyscore(key$253, this.ZRangeOps(range$15, evidence$1$10).asJavaRange());
    }

    private final RedisFuture $anonfun$14$$anonfun$1(RedisClusterAsyncCommands _$234$1, Object key$255, effects.ZRange range$17, Numeric evidence$1$12, effects.RangeLimit x$13) {
        return _$234$1.zrangebyscoreWithScores(key$255, this.ZRangeOps(range$17, evidence$1$12).asJavaRange(), Limit.create((long)x$13.offset(), (long)x$13.count()));
    }

    private final RedisFuture $anonfun$15$$anonfun$1(RedisClusterAsyncCommands _$235$1, Object key$257, effects.ZRange range$19, Numeric evidence$1$14) {
        return _$235$1.zrangebyscoreWithScores(key$257, this.ZRangeOps(range$19, evidence$1$14).asJavaRange());
    }

    private static final RedisFuture zRangeWithScores$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$238$1, Object key$259, long start$17, long stop$9) {
        return _$238$1.zrangeWithScores(key$259, start$17, stop$9);
    }

    private static final RedisFuture zRank$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$241$1, Object key$261, Object value$53) {
        return _$241$1.zrank(key$261, value$53);
    }

    private static final RedisFuture zRevRange$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$242$1, Object key$263, long start$19, long stop$11) {
        return _$242$1.zrevrange(key$263, start$19, stop$11);
    }

    private static final RedisFuture $anonfun$16$$anonfun$1(RedisClusterAsyncCommands _$244$1, Object key$265, effects.ZRange range$21, effects.RangeLimit x$15) {
        return _$244$1.zrevrangebylex(key$265, Range.create(range$21.start(), range$21.end()), Limit.create((long)x$15.offset(), (long)x$15.count()));
    }

    private static final RedisFuture $anonfun$17$$anonfun$1(RedisClusterAsyncCommands _$245$1, Object key$267, effects.ZRange range$23) {
        return _$245$1.zrevrangebylex(key$267, Range.create(range$23.start(), range$23.end()));
    }

    private final RedisFuture $anonfun$18$$anonfun$1(RedisClusterAsyncCommands _$247$1, Object key$269, effects.ZRange range$25, Numeric evidence$1$16, effects.RangeLimit x$17) {
        return _$247$1.zrevrangebyscore(key$269, this.ZRangeOps(range$25, evidence$1$16).asJavaRange(), Limit.create((long)x$17.offset(), (long)x$17.count()));
    }

    private final RedisFuture $anonfun$19$$anonfun$1(RedisClusterAsyncCommands _$248$1, Object key$271, effects.ZRange range$27, Numeric evidence$1$18) {
        return _$248$1.zrevrangebyscore(key$271, this.ZRangeOps(range$27, evidence$1$18).asJavaRange());
    }

    private final RedisFuture $anonfun$20$$anonfun$1(RedisClusterAsyncCommands _$250$1, Object key$273, effects.ZRange range$29, Numeric evidence$1$20, effects.RangeLimit x$19) {
        return _$250$1.zrevrangebyscoreWithScores(key$273, this.ZRangeOps(range$29, evidence$1$20).asJavaRange(), Limit.create((long)x$19.offset(), (long)x$19.count()));
    }

    private final RedisFuture $anonfun$21$$anonfun$1(RedisClusterAsyncCommands _$251$1, Object key$275, effects.ZRange range$31, Numeric evidence$1$22) {
        return _$251$1.zrevrangebyscoreWithScores(key$275, this.ZRangeOps(range$31, evidence$1$22).asJavaRange());
    }

    private static final RedisFuture zRevRangeWithScores$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$254$1, Object key$277, long start$21, long stop$13) {
        return _$254$1.zrevrangeWithScores(key$277, start$21, stop$13);
    }

    private static final RedisFuture zRevRank$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$257$1, Object key$279, Object value$55) {
        return _$257$1.zrevrank(key$279, value$55);
    }

    private static final RedisFuture zScore$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$258$1, Object key$281, Object value$57) {
        return _$258$1.zscore(key$281, value$57);
    }

    private static final RedisFuture zPopMin$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$259$1, Object key$283, long count$7) {
        return _$259$1.zpopmin(key$283, count$7);
    }

    private static final RedisFuture zPopMax$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$262$1, Object key$285, long count$9) {
        return _$262$1.zpopmax(key$285, count$9);
    }

    private final RedisFuture bzPopMin$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$265$1, Duration timeout$7, NonEmptyList keys$33) {
        return _$265$1.bzpopmin(this.DurationOps(timeout$7).toSecondsOrZero(), (Object[])Arrays$.MODULE$.seqToArray((Seq)keys$33.toList(), Object.class));
    }

    private final RedisFuture bzPopMax$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$267$1, Duration timeout$9, NonEmptyList keys$35) {
        return _$267$1.bzpopmax(this.DurationOps(timeout$9).toSecondsOrZero(), (Object[])Arrays$.MODULE$.seqToArray((Seq)keys$35.toList(), Object.class));
    }

    private static final RedisFuture $anonfun$22$$anonfun$1(RedisClusterAsyncCommands _$269$1, ZAggregateArgs aggArgs$1, Seq keys$37) {
        return _$269$1.zunion(aggArgs$1, (Object[])Arrays$.MODULE$.seqToArray(keys$37, Object.class));
    }

    private static final RedisFuture $anonfun$23$$anonfun$1(RedisClusterAsyncCommands _$270$1, Seq keys$39) {
        return _$270$1.zunion((Object[])Arrays$.MODULE$.seqToArray(keys$39, Object.class));
    }

    private static final RedisFuture $anonfun$24$$anonfun$1(RedisClusterAsyncCommands _$272$1, ZAggregateArgs aggArgs$3, Seq keys$41) {
        return _$272$1.zunionWithScores(aggArgs$3, (Object[])Arrays$.MODULE$.seqToArray(keys$41, Object.class));
    }

    private static final RedisFuture $anonfun$25$$anonfun$1(RedisClusterAsyncCommands _$273$1, Seq keys$43) {
        return _$273$1.zunionWithScores((Object[])Arrays$.MODULE$.seqToArray(keys$43, Object.class));
    }

    private static final RedisFuture $anonfun$26$$anonfun$1(RedisClusterAsyncCommands _$276$1, ZAggregateArgs aggArgs$5, Seq keys$45) {
        return _$276$1.zinter(aggArgs$5, (Object[])Arrays$.MODULE$.seqToArray(keys$45, Object.class));
    }

    private static final RedisFuture $anonfun$27$$anonfun$1(RedisClusterAsyncCommands _$277$1, Seq keys$47) {
        return _$277$1.zinter((Object[])Arrays$.MODULE$.seqToArray(keys$47, Object.class));
    }

    private static final RedisFuture $anonfun$28$$anonfun$1(RedisClusterAsyncCommands _$279$1, ZAggregateArgs aggArgs$7, Seq keys$49) {
        return _$279$1.zinterWithScores(aggArgs$7, (Object[])Arrays$.MODULE$.seqToArray(keys$49, Object.class));
    }

    private static final RedisFuture $anonfun$29$$anonfun$1(RedisClusterAsyncCommands _$280$1, Seq keys$51) {
        return _$280$1.zinterWithScores((Object[])Arrays$.MODULE$.seqToArray(keys$51, Object.class));
    }

    private static final RedisFuture zDiff$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$283$1, Seq keys$53) {
        return _$283$1.zdiff((Object[])Arrays$.MODULE$.seqToArray(keys$53, Object.class));
    }

    private static final RedisFuture zDiffWithScores$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$285$1, Seq keys$55) {
        return _$285$1.zdiffWithScores((Object[])Arrays$.MODULE$.seqToArray(keys$55, Object.class));
    }

    private static final RedisFuture select$$anonfun$1$$anonfun$1(RedisAsyncCommands _$289$1, int index$5) {
        return _$289$1.select(index$5);
    }

    private static final RedisFuture auth$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$290$1, CharSequence password$1) {
        return _$290$1.auth(password$1);
    }

    private static final RedisFuture auth$$anonfun$2$$anonfun$1(RedisClusterAsyncCommands _$292$1, String username$1, CharSequence password$3) {
        return _$292$1.auth(username$1, password$3);
    }

    private static final RedisFuture setClientName$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$294$1, Object name$1) {
        return _$294$1.clientSetname(name$1);
    }

    private static final RedisFuture getClientName$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$296$1) {
        return _$296$1.clientGetname();
    }

    private static final RedisFuture getClientId$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$297$1) {
        return _$297$1.clientId();
    }

    private static final RedisFuture setLibName$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$298$1, String name$3) {
        return _$298$1.clientSetinfo("LIB-NAME", name$3);
    }

    private static final RedisFuture setLibVersion$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$300$1, String version$1) {
        return _$300$1.clientSetinfo("LIB-VER", version$1);
    }

    private static final RedisFuture getClientInfo$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$302$1) {
        return _$302$1.clientInfo();
    }

    private static final scala.collection.immutable.Map parseClientInfo$$anonfun$1(String info$1) {
        return Predef$.MODULE$.wrapRefArray((Object[])info$1.replace("\n", "").split(" ")).toList().map((Function1 & Serializable)_$303 -> Predef$.MODULE$.wrapRefArray((Object[])_$303.split("=", 2)).toList()).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(List x) {
                List list = x;
                if (list instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    List list2 = colon2.next$access$1();
                    String k = (String)colon2.head();
                    if (list2 instanceof .colon.colon) {
                        .colon.colon colon3 = (.colon.colon)list2;
                        List list3 = colon3.next$access$1();
                        String v = (String)colon3.head();
                        Nil$ nil$ = package$.MODULE$.Nil();
                        List list4 = list3;
                        if (!(nil$ != null ? !nil$.equals(list4) : list4 != null)) {
                            return true;
                        }
                    }
                }
                return false;
            }

            public final Object applyOrElse(List x, Function1 function1) {
                List list = x;
                if (list instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    List list2 = colon2.next$access$1();
                    String k = (String)colon2.head();
                    if (list2 instanceof .colon.colon) {
                        .colon.colon colon3 = (.colon.colon)list2;
                        List list3 = colon3.next$access$1();
                        String v = (String)colon3.head();
                        Nil$ nil$ = package$.MODULE$.Nil();
                        List list4 = list3;
                        if (!(nil$ != null ? !nil$.equals(list4) : list4 != null)) {
                            return Tuple2$.MODULE$.apply((Object)k, (Object)v);
                        }
                    }
                }
                return function1.apply((Object)x);
            }
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private static final RedisFuture flushAll$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$305$1, effects.FlushMode mode$1) {
        return _$305$1.flushall(mode$1.asJava());
    }

    private static final RedisFuture flushDb$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$307$1, effects.FlushMode mode$3) {
        return _$307$1.flushdb(mode$3.asJava());
    }

    private static final RedisFuture keys$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$308$1, Object key$287) {
        return _$308$1.keys(key$287);
    }

    private static final scala.collection.immutable.Map parseInfo$$anonfun$1(String info$2) {
        return Predef$.MODULE$.wrapRefArray((Object[])info$2.split("\\r?\\n")).toList().map((Function1 & Serializable)_$310 -> Predef$.MODULE$.wrapRefArray((Object[])_$310.split(":", 2)).toList()).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(List x) {
                List list = x;
                if (list instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    List list2 = colon2.next$access$1();
                    String k = (String)colon2.head();
                    if (list2 instanceof .colon.colon) {
                        .colon.colon colon3 = (.colon.colon)list2;
                        List list3 = colon3.next$access$1();
                        String v = (String)colon3.head();
                        Nil$ nil$ = package$.MODULE$.Nil();
                        List list4 = list3;
                        if (!(nil$ != null ? !nil$.equals(list4) : list4 != null)) {
                            return true;
                        }
                    }
                }
                return false;
            }

            public final Object applyOrElse(List x, Function1 function1) {
                List list = x;
                if (list instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    List list2 = colon2.next$access$1();
                    String k = (String)colon2.head();
                    if (list2 instanceof .colon.colon) {
                        .colon.colon colon3 = (.colon.colon)list2;
                        List list3 = colon3.next$access$1();
                        String v = (String)colon3.head();
                        Nil$ nil$ = package$.MODULE$.Nil();
                        List list4 = list3;
                        if (!(nil$ != null ? !nil$.equals(list4) : list4 != null)) {
                            return Tuple2$.MODULE$.apply((Object)k, (Object)v);
                        }
                    }
                }
                return function1.apply((Object)x);
            }
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private static final RedisFuture info$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$311$1) {
        return _$311$1.info();
    }

    private static final RedisFuture info$$anonfun$3$$anonfun$1(RedisClusterAsyncCommands _$312$1, String section$1) {
        return _$312$1.info(section$1);
    }

    private static final RedisFuture dbsize$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$313$1) {
        return _$313$1.dbsize();
    }

    private static final RedisFuture lastSave$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$314$1) {
        return _$314$1.lastsave();
    }

    private static final RedisFuture slowLogLen$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$316$1) {
        return _$316$1.slowlogLen();
    }

    private static final RedisFuture eval$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$317$1, String script$1, effects.ScriptOutputType output$1) {
        return _$317$1.eval(script$1, output$1.outputType(), new Object[0]);
    }

    private static final RedisFuture eval$$anonfun$3$$anonfun$1(RedisClusterAsyncCommands _$318$1, String script$3, effects.ScriptOutputType output$4, List keys$57) {
        return _$318$1.eval(script$3, output$4.outputType(), (Object[])keys$57.toArray(ClassTag$.MODULE$.Any()), new Object[0]);
    }

    private static final RedisFuture eval$$anonfun$4$$anonfun$1(RedisClusterAsyncCommands _$320$1, String script$5, effects.ScriptOutputType output$7, List keys$59, List values$27) {
        return _$320$1.eval(script$5, output$7.outputType(), (Object[])keys$59.toArray(ClassTag$.MODULE$.Any()), (Object[])Arrays$.MODULE$.seqToArray((Seq)values$27, Object.class));
    }

    private static final RedisFuture evalReadOnly$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$322$1, String script$7, effects.ScriptOutputType output$10) {
        return _$322$1.evalReadOnly(script$7, output$10.outputType(), Array$.MODULE$.emptyObjectArray(), new Object[0]);
    }

    private static final RedisFuture evalReadOnly$$anonfun$3$$anonfun$1(RedisClusterAsyncCommands _$323$1, String script$9, effects.ScriptOutputType output$13, List keys$61) {
        return _$323$1.evalReadOnly(script$9, output$13.outputType(), (Object[])keys$61.toArray(ClassTag$.MODULE$.Any()), new Object[0]);
    }

    private static final RedisFuture evalReadOnly$$anonfun$4$$anonfun$1(RedisClusterAsyncCommands _$325$1, String script$11, effects.ScriptOutputType output$16, List keys$63, List values$29) {
        return _$325$1.evalReadOnly(script$11, output$16.outputType(), (Object[])keys$63.toArray(ClassTag$.MODULE$.Any()), (Object[])Arrays$.MODULE$.seqToArray((Seq)values$29, Object.class));
    }

    private static final RedisFuture evalSha$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$327$1, String digest$1, effects.ScriptOutputType output$19) {
        return _$327$1.evalsha(digest$1, output$19.outputType(), new Object[0]);
    }

    private static final RedisFuture evalSha$$anonfun$3$$anonfun$1(RedisClusterAsyncCommands _$329$1, String digest$3, effects.ScriptOutputType output$22, List keys$65) {
        return _$329$1.evalsha(digest$3, output$22.outputType(), (Object[])keys$65.toArray(ClassTag$.MODULE$.Any()), new Object[0]);
    }

    private static final RedisFuture evalSha$$anonfun$4$$anonfun$1(RedisClusterAsyncCommands _$331$1, String digest$5, effects.ScriptOutputType output$25, List keys$67, List values$31) {
        return _$331$1.evalsha(digest$5, output$25.outputType(), (Object[])keys$67.toArray(ClassTag$.MODULE$.Any()), (Object[])Arrays$.MODULE$.seqToArray((Seq)values$31, Object.class));
    }

    private static final RedisFuture evalShaReadOnly$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$333$1, String digest$7, effects.ScriptOutputType output$28) {
        return _$333$1.evalshaReadOnly(digest$7, output$28.outputType(), Array$.MODULE$.emptyObjectArray(), new Object[0]);
    }

    private static final RedisFuture evalShaReadOnly$$anonfun$3$$anonfun$1(RedisClusterAsyncCommands _$335$1, String digest$9, effects.ScriptOutputType output$31, List keys$69) {
        return _$335$1.evalshaReadOnly(digest$9, output$31.outputType(), (Object[])keys$69.toArray(ClassTag$.MODULE$.Any()), new Object[0]);
    }

    private static final RedisFuture evalShaReadOnly$$anonfun$4$$anonfun$1(RedisClusterAsyncCommands _$337$1, String digest$11, effects.ScriptOutputType output$34, List keys$71, List values$33) {
        return _$337$1.evalshaReadOnly(digest$11, output$34.outputType(), (Object[])keys$71.toArray(ClassTag$.MODULE$.Any()), (Object[])Arrays$.MODULE$.seqToArray((Seq)values$33, Object.class));
    }

    private static final RedisFuture scriptLoad$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$339$1, String script$13) {
        return _$339$1.scriptLoad(script$13);
    }

    private static final RedisFuture scriptLoad$$anonfun$2$$anonfun$1(RedisClusterAsyncCommands _$340$1, byte[] script$15) {
        return _$340$1.scriptLoad(script$15);
    }

    private static final RedisFuture scriptExists$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$341$1, Seq digests$1) {
        return _$341$1.scriptExists((String[])Arrays$.MODULE$.seqToArray(digests$1, String.class));
    }

    private static final RedisFuture scriptFlush$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$344$1) {
        return _$344$1.scriptFlush();
    }

    private static final RedisFuture fcall$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$346$1, String function$1, effects.ScriptOutputType output$37, List keys$73) {
        return _$346$1.fcall(function$1, output$37.outputType(), (Object[])Arrays$.MODULE$.seqToArray((Seq)keys$73, Object.class));
    }

    private static final RedisFuture fcall$$anonfun$2$$anonfun$1(RedisClusterAsyncCommands _$348$1, String function$3, effects.ScriptOutputType output$40, List keys$75, List values$35) {
        return _$348$1.fcall(function$3, output$40.outputType(), (Object[])keys$75.toArray(ClassTag$.MODULE$.Any()), (Object[])Arrays$.MODULE$.seqToArray((Seq)values$35, Object.class));
    }

    private static final RedisFuture fcallReadOnly$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$350$1, String function$5, effects.ScriptOutputType output$43, List keys$77) {
        return _$350$1.fcallReadOnly(function$5, output$43.outputType(), (Object[])Arrays$.MODULE$.seqToArray((Seq)keys$77, Object.class));
    }

    private static final RedisFuture fcallReadOnly$$anonfun$2$$anonfun$1(RedisClusterAsyncCommands _$352$1, String function$7, effects.ScriptOutputType output$46, List keys$79, List values$37) {
        return _$352$1.fcallReadOnly(function$7, output$46.outputType(), (Object[])keys$79.toArray(ClassTag$.MODULE$.Any()), (Object[])Arrays$.MODULE$.seqToArray((Seq)values$37, Object.class));
    }

    private static final RedisFuture functionLoad$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$354$1, String functionCode$1) {
        return _$354$1.functionLoad(functionCode$1);
    }

    private static final RedisFuture functionLoad$$anonfun$2$$anonfun$1(RedisClusterAsyncCommands _$355$1, String functionCode$3, boolean replace$1) {
        return _$355$1.functionLoad(functionCode$3, replace$1);
    }

    private static final RedisFuture functionDump$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$356$1) {
        return _$356$1.functionDump();
    }

    private static final RedisFuture functionRestore$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$357$1, byte[] dump$1) {
        return _$357$1.functionRestore(dump$1);
    }

    private static final RedisFuture functionRestore$$anonfun$2$$anonfun$1(RedisClusterAsyncCommands _$358$1, byte[] dump$3, FunctionRestoreMode jMode$1) {
        return _$358$1.functionRestore(dump$3, jMode$1);
    }

    private static final RedisFuture functionFlush$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$359$1, FlushMode jFlushMode$1) {
        return _$359$1.functionFlush(jFlushMode$1);
    }

    private static final RedisFuture functionKill$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$360$1) {
        return _$360$1.functionKill();
    }

    private static final RedisFuture functionList$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$361$1) {
        return _$361$1.functionList();
    }

    private static final RedisFuture functionList$$anonfun$3$$anonfun$1(RedisClusterAsyncCommands _$364$1, String libraryName$1) {
        return _$364$1.functionList(libraryName$1);
    }

    private static final RedisFuture pfAdd$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$367$1, Object key$289, Seq values$39) {
        return _$367$1.pfadd(key$289, (Object[])Arrays$.MODULE$.seqToArray(values$39, Object.class));
    }

    private static final RedisFuture pfCount$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$369$1, Object key$291) {
        return _$369$1.pfcount(new Object[]{key$291});
    }

    private static final RedisFuture pfMerge$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$371$1, Object outputKey$1, Seq inputKeys$1) {
        return _$371$1.pfmerge(outputKey$1, (Object[])Arrays$.MODULE$.seqToArray(inputKeys$1, Object.class));
    }

    private static final RedisFuture xRead$$anonfun$1$$anonfun$1(Option block$2, Option count$12, RedisClusterAsyncCommands redis$1, Seq offsets$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)block$2, (Object)count$12);
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option)) {
                if (None$.MODULE$.equals(option2)) {
                    return redis$1.xread((XReadArgs.StreamOffset[])Arrays$.MODULE$.seqToArray(offsets$2, XReadArgs.StreamOffset.class));
                }
                if (option2 instanceof Some) {
                    long count = BoxesRunTime.unboxToLong((Object)((Some)option2).value());
                    return redis$1.xread(XReadArgs.Builder.count((long)count), (XReadArgs.StreamOffset[])Arrays$.MODULE$.seqToArray(offsets$2, XReadArgs.StreamOffset.class));
                }
            }
            if (option instanceof Some) {
                Duration duration;
                Duration block = duration = (Duration)((Some)option).value();
                if (None$.MODULE$.equals(option2)) {
                    return redis$1.xread(XReadArgs.Builder.block((long)block.toMillis()), (XReadArgs.StreamOffset[])Arrays$.MODULE$.seqToArray(offsets$2, XReadArgs.StreamOffset.class));
                }
                Duration block2 = duration;
                if (option2 instanceof Some) {
                    long count = BoxesRunTime.unboxToLong((Object)((Some)option2).value());
                    return redis$1.xread(XReadArgs.Builder.block((long)block2.toMillis()).count(count), (XReadArgs.StreamOffset[])Arrays$.MODULE$.seqToArray(offsets$2, XReadArgs.StreamOffset.class));
                }
            }
        }
        throw new MatchError((Object)tuple2);
    }

    private static final Limit xRange$$anonfun$1$$anonfun$1$$anonfun$1() {
        return Limit.unlimited();
    }

    private static final /* synthetic */ Limit xRange$$anonfun$1$$anonfun$1$$anonfun$2(long x$0) {
        return Limit.from((long)x$0);
    }

    private final RedisFuture xRange$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$373$1, Object key$293, effects.XRangePoint start$23, effects.XRangePoint end$7, Option count$13) {
        return _$373$1.xrange(key$293, this.XRangeOps(Tuple2$.MODULE$.apply((Object)start$23, (Object)end$7)).asJavaRange(), (Limit)count$13.fold(BaseRedis::xRange$$anonfun$1$$anonfun$1$$anonfun$1, (Function1 & Serializable)x$0 -> BaseRedis.xRange$$anonfun$1$$anonfun$1$$anonfun$2(BoxesRunTime.unboxToLong((Object)x$0))));
    }

    private static final Limit xRevRange$$anonfun$1$$anonfun$1$$anonfun$1() {
        return Limit.unlimited();
    }

    private static final /* synthetic */ Limit xRevRange$$anonfun$1$$anonfun$1$$anonfun$2(long x$0) {
        return Limit.from((long)x$0);
    }

    private final RedisFuture xRevRange$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$375$1, Object key$295, effects.XRangePoint start$25, effects.XRangePoint end$9, Option count$15) {
        return _$375$1.xrevrange(key$295, this.XRangeOps(Tuple2$.MODULE$.apply((Object)start$25, (Object)end$9)).asJavaRange(), (Limit)count$15.fold(BaseRedis::xRevRange$$anonfun$1$$anonfun$1$$anonfun$1, (Function1 & Serializable)x$0 -> BaseRedis.xRevRange$$anonfun$1$$anonfun$1$$anonfun$2(BoxesRunTime.unboxToLong((Object)x$0))));
    }

    private static final RedisFuture xLen$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$377$1, Object key$297) {
        return _$377$1.xlen(key$297);
    }

    private static final RedisFuture xAdd$$anonfun$3$$anonfun$1(RedisClusterAsyncCommands _$379$1, Object key$299, XAddArgs jArgs$4, scala.collection.immutable.Map body$1) {
        return _$379$1.xadd(key$299, jArgs$4, JavaConversions$.MODULE$.MapHasAsJava((Map)body$1).asJava());
    }

    private final RedisFuture xTrim$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$380$1, Object key$301, effects.XTrimArgs args$9) {
        return _$380$1.xtrim(key$301, this.XTrimArgsOps(args$9).asJava());
    }

    private static final RedisFuture xDel$$anonfun$1$$anonfun$1(RedisClusterAsyncCommands _$382$1, Object key$303, Seq ids$1) {
        return _$382$1.xdel(key$303, (String[])Arrays$.MODULE$.seqToArray(ids$1, String.class));
    }
}

