/*
 * Decompiled with CFR 0.152.
 */
package dev.resteasy.guice;

import com.google.inject.Provider;
import java.util.concurrent.CompletionStage;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.PropertyInjector;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class GuiceResourceFactory
implements ResourceFactory {
    private final Provider<?> provider;
    private final Class<?> scannableClass;
    private PropertyInjector propertyInjector;

    public GuiceResourceFactory(Provider<?> provider, Class<?> scannableClass) {
        this.provider = provider;
        this.scannableClass = scannableClass;
    }

    public Class<?> getScannableClass() {
        return this.scannableClass;
    }

    public void registered(ResteasyProviderFactory factory) {
        this.propertyInjector = factory.getInjectorFactory().createPropertyInjector(this.scannableClass, factory);
    }

    public Object createResource(HttpRequest request, HttpResponse response, ResteasyProviderFactory factory) {
        CompletionStage<Object> resource = this.provider.get();
        CompletionStage propertyStage = this.propertyInjector.inject(request, response, (Object)resource, true);
        return propertyStage == null ? resource : propertyStage.thenApply(v -> resource);
    }

    public void requestFinished(HttpRequest request, HttpResponse response, Object resource) {
    }

    public void unregistered() {
    }
}

