/*
 * Decompiled with CFR 0.152.
 */
package dev.resteasy.guice;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import dev.resteasy.guice.ModuleProcessor;
import dev.resteasy.guice._private.LogMessages;
import dev.resteasy.guice._private.Messages;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jboss.resteasy.plugins.server.servlet.ResteasyBootstrap;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class GuiceResteasyBootstrapServletContextListener
extends ResteasyBootstrap
implements ServletContextListener {
    private List<? extends Module> modules;
    @Inject
    private Injector parentInjector = null;

    public void contextInitialized(ServletContextEvent event) {
        super.contextInitialized(event);
        ServletContext context = event.getServletContext();
        ResteasyDeployment deployment = (ResteasyDeployment)context.getAttribute(ResteasyDeployment.class.getName());
        Registry registry = deployment.getRegistry();
        ResteasyProviderFactory providerFactory = deployment.getProviderFactory();
        ModuleProcessor processor = new ModuleProcessor(registry, providerFactory);
        List<? extends Module> modules = this.getModules(context);
        Stage stage = this.getStage(context);
        Injector injector = this.parentInjector != null ? this.parentInjector.createChildInjector(modules) : (stage == null ? Guice.createInjector(modules) : Guice.createInjector((Stage)stage, modules));
        this.withInjector(injector);
        processor.processInjector(injector);
        while (injector.getParent() != null) {
            injector = injector.getParent();
            processor.processInjector(injector);
        }
        this.modules = modules;
        this.triggerAnnotatedMethods(PostConstruct.class);
    }

    protected void withInjector(Injector injector) {
    }

    protected Stage getStage(ServletContext context) {
        String stageAsString = context.getInitParameter("resteasy.guice.stage");
        if (stageAsString == null) {
            return null;
        }
        try {
            return Stage.valueOf((String)stageAsString.trim());
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(Messages.MESSAGES.injectorStageNotProperlyDefined(stageAsString));
        }
    }

    protected List<? extends Module> getModules(ServletContext context) {
        ArrayList<Module> result = new ArrayList<Module>();
        String modulesString = context.getInitParameter("resteasy.guice.modules");
        if (modulesString != null) {
            String[] moduleStrings;
            for (String moduleString : moduleStrings = modulesString.trim().split(",")) {
                try {
                    LogMessages.LOGGER.info(Messages.MESSAGES.foundModule(moduleString));
                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(moduleString.trim());
                    Module module = (Module)clazz.newInstance();
                    result.add(module);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return result;
    }

    public void contextDestroyed(ServletContextEvent event) {
        this.triggerAnnotatedMethods(PreDestroy.class);
    }

    private void triggerAnnotatedMethods(Class<? extends Annotation> annotationClass) {
        for (Module module : this.modules) {
            Method[] methods;
            for (Method method : methods = module.getClass().getMethods()) {
                if (!method.isAnnotationPresent(annotationClass)) continue;
                if (method.getParameterTypes().length > 0) {
                    LogMessages.LOGGER.warn(Messages.MESSAGES.cannotExecute(module.getClass().getSimpleName(), annotationClass.getSimpleName(), method.getName()));
                    continue;
                }
                try {
                    method.invoke((Object)module, new Object[0]);
                }
                catch (InvocationTargetException ex) {
                    LogMessages.LOGGER.warn(Messages.MESSAGES.problemRunningAnnotationMethod(annotationClass.getSimpleName()), ex);
                }
                catch (IllegalAccessException ex) {
                    LogMessages.LOGGER.warn(Messages.MESSAGES.problemRunningAnnotationMethod(annotationClass.getSimpleName()), ex);
                }
            }
        }
    }
}

