/*
 * Decompiled with CFR 0.152.
 */
package dev.resteasy.guice.ext;

import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scope;
import dev.resteasy.guice.RequestScoped;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriInfo;
import org.jboss.resteasy.core.ResteasyContext;

public class RequestScopeModule
extends AbstractModule {
    protected void configure() {
        this.bindScope(RequestScoped.class, new Scope(){

            public <T> Provider<T> scope(final Key<T> key, final Provider<T> creator) {
                return new Provider<T>(){

                    public T get() {
                        Class instanceClass = (Class)key.getTypeLiteral().getType();
                        Object instance = ResteasyContext.getContextData((Class)instanceClass);
                        if (instance == null) {
                            instance = creator.get();
                            ResteasyContext.pushContext((Class)instanceClass, (Object)instance);
                        }
                        return instance;
                    }

                    public String toString() {
                        return String.format("%s[%s]", creator, super.toString());
                    }
                };
            }
        });
        this.bind(HttpServletRequest.class).toProvider(new ResteasyContextProvider<HttpServletRequest>(HttpServletRequest.class)).in(RequestScoped.class);
        this.bind(HttpServletResponse.class).toProvider(new ResteasyContextProvider<HttpServletResponse>(HttpServletResponse.class)).in(RequestScoped.class);
        this.bind(Request.class).toProvider(new ResteasyContextProvider<Request>(Request.class)).in(RequestScoped.class);
        this.bind(HttpHeaders.class).toProvider(new ResteasyContextProvider<HttpHeaders>(HttpHeaders.class)).in(RequestScoped.class);
        this.bind(UriInfo.class).toProvider(new ResteasyContextProvider<UriInfo>(UriInfo.class)).in(RequestScoped.class);
        this.bind(SecurityContext.class).toProvider(new ResteasyContextProvider<SecurityContext>(SecurityContext.class)).in(RequestScoped.class);
    }

    private static class ResteasyContextProvider<T>
    implements Provider<T> {
        private final Class<T> instanceClass;

        ResteasyContextProvider(Class<T> instanceClass) {
            this.instanceClass = instanceClass;
        }

        public T get() {
            return (T)ResteasyContext.getContextData(this.instanceClass);
        }
    }
}

