/*
 * Decompiled with CFR 0.152.
 */
package dev.romainguy.kotlin.math;

import dev.romainguy.kotlin.math.Float3;
import dev.romainguy.kotlin.math.MatrixKt;
import dev.romainguy.kotlin.math.Quaternion;
import dev.romainguy.kotlin.math.RotationsOrder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u001a\u0011\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0086\b\u001a\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u000e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0016\u0010\b\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u0019\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001H\u0086\b\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\f\u001a\u00020\r\u001a\u000e\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0011\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u0001H\u0086\b\u001a\u0011\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u0001H\u0086\b\u001a\u001e\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0004\u001a\u001e\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0004\u001a\u000e\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a(\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00042\b\b\u0002\u0010\u0016\u001a\u00020\u0004\u001a\u0015\u0010\u0017\u001a\u00020\u0001*\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u0001H\u0086\n\u001a\u0015\u0010\u0018\u001a\u00020\u0001*\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u0001H\u0086\n\u001a\u0015\u0010\u0019\u001a\u00020\u0001*\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u0001H\u0086\n\u001a\u0015\u0010\u001a\u001a\u00020\u0001*\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u0001H\u0086\n\u00a8\u0006\u001b"}, d2={"abs", "Ldev/romainguy/kotlin/math/Quaternion;", "q", "angle", "", "a", "b", "conjugate", "cross", "dot", "eulerAngles", "Ldev/romainguy/kotlin/math/Float3;", "order", "Ldev/romainguy/kotlin/math/RotationsOrder;", "inverse", "length", "length2", "lerp", "t", "nlerp", "normalize", "slerp", "dotThreshold", "div", "minus", "plus", "times", "kotlin-math"})
public final class QuaternionKt {
    @NotNull
    public static final Quaternion plus(float $this$plus, @NotNull Quaternion q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        boolean $i$f$plus = false;
        return new Quaternion($this$plus + q.getX(), $this$plus + q.getY(), $this$plus + q.getZ(), $this$plus + q.getW());
    }

    @NotNull
    public static final Quaternion minus(float $this$minus, @NotNull Quaternion q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        boolean $i$f$minus = false;
        return new Quaternion($this$minus - q.getX(), $this$minus - q.getY(), $this$minus - q.getZ(), $this$minus - q.getW());
    }

    @NotNull
    public static final Quaternion times(float $this$times, @NotNull Quaternion q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        boolean $i$f$times = false;
        return new Quaternion($this$times * q.getX(), $this$times * q.getY(), $this$times * q.getZ(), $this$times * q.getW());
    }

    @NotNull
    public static final Quaternion div(float $this$div, @NotNull Quaternion q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        boolean $i$f$div = false;
        return new Quaternion($this$div / q.getX(), $this$div / q.getY(), $this$div / q.getZ(), $this$div / q.getW());
    }

    @NotNull
    public static final Quaternion abs(@NotNull Quaternion q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        boolean $i$f$abs = false;
        return new Quaternion(Math.abs(q.getX()), Math.abs(q.getY()), Math.abs(q.getZ()), Math.abs(q.getW()));
    }

    public static final float length(@NotNull Quaternion q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        boolean $i$f$length = false;
        return (float)Math.sqrt(q.getX() * q.getX() + q.getY() * q.getY() + q.getZ() * q.getZ() + q.getW() * q.getW());
    }

    public static final float length2(@NotNull Quaternion q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        boolean $i$f$length2 = false;
        return q.getX() * q.getX() + q.getY() * q.getY() + q.getZ() * q.getZ() + q.getW() * q.getW();
    }

    public static final float dot(@NotNull Quaternion a, @NotNull Quaternion b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        boolean $i$f$dot = false;
        return a.getX() * b.getX() + a.getY() * b.getY() + a.getZ() * b.getZ() + a.getW() * b.getW();
    }

    @NotNull
    public static final Quaternion normalize(@NotNull Quaternion q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        boolean $i$f$length = false;
        float l = 1.0f / (float)Math.sqrt(q.getX() * q.getX() + q.getY() * q.getY() + q.getZ() * q.getZ() + q.getW() * q.getW());
        return new Quaternion(q.getX() * l, q.getY() * l, q.getZ() * l, q.getW() * l);
    }

    @NotNull
    public static final Quaternion conjugate(@NotNull Quaternion q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        return new Quaternion(-q.getX(), -q.getY(), -q.getZ(), q.getW());
    }

    @NotNull
    public static final Quaternion inverse(@NotNull Quaternion q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        boolean $i$f$dot = false;
        float d = 1.0f / (q.getX() * q.getX() + q.getY() * q.getY() + q.getZ() * q.getZ() + q.getW() * q.getW());
        return new Quaternion(-q.getX() * d, -q.getY() * d, -q.getZ() * d, q.getW() * d);
    }

    @NotNull
    public static final Quaternion cross(@NotNull Quaternion a, @NotNull Quaternion b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Quaternion this_$iv = a;
        boolean $i$f$times = false;
        Quaternion m = new Quaternion(this_$iv.getW() * b.getX() + this_$iv.getX() * b.getW() + this_$iv.getY() * b.getZ() - this_$iv.getZ() * b.getY(), this_$iv.getW() * b.getY() - this_$iv.getX() * b.getZ() + this_$iv.getY() * b.getW() + this_$iv.getZ() * b.getX(), this_$iv.getW() * b.getZ() + this_$iv.getX() * b.getY() - this_$iv.getY() * b.getX() + this_$iv.getZ() * b.getW(), this_$iv.getW() * b.getW() - this_$iv.getX() * b.getX() - this_$iv.getY() * b.getY() - this_$iv.getZ() * b.getZ());
        return new Quaternion(m.getX(), m.getY(), m.getZ(), 0.0f);
    }

    /*
     * WARNING - void declaration
     */
    public static final float angle(@NotNull Quaternion a, @NotNull Quaternion b) {
        void var2_3;
        float min$iv;
        void x$iv;
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        boolean $i$f$dot22 = false;
        float $i$f$dot22 = a.getX() * b.getX() + a.getY() * b.getY() + a.getZ() * b.getZ() + a.getW() * b.getW();
        float f = -1.0f;
        float max$iv = 1.0f;
        boolean $i$f$clamp = false;
        return 2.0f * (float)Math.acos(Math.abs(x$iv < min$iv ? min$iv : (x$iv > max$iv ? max$iv : var2_3)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Quaternion slerp(@NotNull Quaternion a, @NotNull Quaternion b, float t, float dotThreshold) {
        Quaternion quaternion;
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        boolean $i$f$dot = false;
        float dot = a.getX() * b.getX() + a.getY() * b.getY() + a.getZ() * b.getZ() + a.getW() * b.getW();
        Quaternion b1 = b;
        if (dot < 0.0f) {
            dot = -dot;
            b1 = b.unaryMinus();
        }
        if (dot < dotThreshold) {
            void q$iv;
            void v$iv;
            Quaternion this_$iv;
            void v$iv2;
            Quaternion this_$iv2;
            float angle = (float)Math.acos(dot);
            float s = (float)Math.sin(angle);
            Quaternion quaternion2 = a;
            float f = (float)Math.sin((1.0f - t) * angle);
            boolean $i$f$times22 = false;
            this_$iv2 = new Quaternion(this_$iv2.getX() * v$iv2, this_$iv2.getY() * v$iv2, this_$iv2.getZ() * v$iv2, this_$iv2.getW() * v$iv2);
            boolean $i$f$div22 = false;
            this_$iv2 = new Quaternion(this_$iv2.getX() / s, this_$iv2.getY() / s, this_$iv2.getZ() / s, this_$iv2.getW() / s);
            Quaternion $i$f$div22 = b1;
            float $i$f$times22 = (float)Math.sin(t * angle);
            boolean $i$f$times = false;
            this_$iv = new Quaternion(this_$iv.getX() * v$iv, this_$iv.getY() * v$iv, this_$iv.getZ() * v$iv, this_$iv.getW() * v$iv);
            boolean $i$f$div = false;
            this_$iv = new Quaternion(this_$iv.getX() / s, this_$iv.getY() / s, this_$iv.getZ() / s, this_$iv.getW() / s);
            boolean $i$f$plus = false;
            quaternion = new Quaternion(this_$iv2.getX() + q$iv.getX(), this_$iv2.getY() + q$iv.getY(), this_$iv2.getZ() + q$iv.getZ(), this_$iv2.getW() + q$iv.getW());
        } else {
            quaternion = QuaternionKt.nlerp(a, b1, t);
        }
        return quaternion;
    }

    public static /* synthetic */ Quaternion slerp$default(Quaternion quaternion, Quaternion quaternion2, float f, float f2, int n, Object object) {
        if ((n & 8) != 0) {
            f2 = 0.9995f;
        }
        return QuaternionKt.slerp(quaternion, quaternion2, f, f2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Quaternion lerp(@NotNull Quaternion a, @NotNull Quaternion b, float t) {
        void q$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        float $this$times$iv22 = 1.0f - t;
        boolean $i$f$times = false;
        Quaternion $this$times$iv22 = new Quaternion($this$times$iv22 * a.getX(), $this$times$iv22 * a.getY(), $this$times$iv22 * a.getZ(), $this$times$iv22 * a.getW());
        float $this$times$iv32 = t;
        boolean $i$f$times2 = false;
        Quaternion $this$times$iv32 = new Quaternion($this$times$iv32 * b.getX(), $this$times$iv32 * b.getY(), $this$times$iv32 * b.getZ(), $this$times$iv32 * b.getW());
        boolean $i$f$plus = false;
        return new Quaternion(this_$iv.getX() + q$iv.getX(), this_$iv.getY() + q$iv.getY(), this_$iv.getZ() + q$iv.getZ(), this_$iv.getW() + q$iv.getW());
    }

    @NotNull
    public static final Quaternion nlerp(@NotNull Quaternion a, @NotNull Quaternion b, float t) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return QuaternionKt.normalize(QuaternionKt.lerp(a, b, t));
    }

    @NotNull
    public static final Float3 eulerAngles(@NotNull Quaternion q, @NotNull RotationsOrder order) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        Intrinsics.checkNotNullParameter((Object)((Object)order), (String)"order");
        return MatrixKt.eulerAngles(MatrixKt.rotation(q), order);
    }

    public static /* synthetic */ Float3 eulerAngles$default(Quaternion quaternion, RotationsOrder rotationsOrder, int n, Object object) {
        if ((n & 2) != 0) {
            rotationsOrder = RotationsOrder.ZYX;
        }
        return QuaternionKt.eulerAngles(quaternion, rotationsOrder);
    }
}

