package dev.sargunv.maplibrecompose.core.camera

import androidx.compose.foundation.layout.PaddingValues
import androidx.compose.runtime.Immutable
import androidx.compose.ui.unit.dp
import io.github.dellisd.spatialk.geojson.Position

@Immutable
public data class CameraPosition(
  public val bearing: Double = 0.0,
  public val target: Position = Position(0.0, 0.0),
  public val tilt: Double = 0.0,
  public val zoom: Double = 1.0,
  public val padding: PaddingValues = PaddingValues(0.dp),
)
