/*
 * Decompiled with CFR 0.152.
 */
package dev.sargunv.maplibrecompose.core.util;

import android.graphics.PointF;
import androidx.compose.ui.Alignment;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.unit.IntOffset;
import androidx.compose.ui.unit.IntSizeKt;
import androidx.compose.ui.unit.LayoutDirection;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.sargunv.maplibrecompose.core.data.XY;
import dev.sargunv.maplibrecompose.core.expression.Insets;
import dev.sargunv.maplibrecompose.core.expression.Point;
import io.github.dellisd.spatialk.geojson.BoundingBox;
import io.github.dellisd.spatialk.geojson.Position;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maplibre.android.geometry.LatLng;
import org.maplibre.android.geometry.LatLngBounds;
import org.maplibre.android.style.expressions.Expression;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0000\u001a\f\u0010\u0006\u001a\u00020\u0005*\u00020\u0004H\u0000\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\tH\u0000\u001a\f\u0010\n\u001a\u00020\t*\u00020\bH\u0000\u001a\f\u0010\u000b\u001a\u00020\f*\u00020\rH\u0000\u001a\f\u0010\u000e\u001a\u00020\r*\u00020\fH\u0000\u001a\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u0006\u0012\u0002\b\u00030\u0011H\u0000\u001a\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002\u001a\u0014\u0010\u0016\u001a\u00020\u0017*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u00a8\u0006\u001b"}, d2={"correctedAndroidUri", "Ljava/net/URI;", "", "toPointF", "Landroid/graphics/PointF;", "Ldev/sargunv/maplibrecompose/core/data/XY;", "toXY", "toPosition", "Lio/github/dellisd/spatialk/geojson/Position;", "Lorg/maplibre/android/geometry/LatLng;", "toLatLng", "toBoundingBox", "Lio/github/dellisd/spatialk/geojson/BoundingBox;", "Lorg/maplibre/android/geometry/LatLngBounds;", "toLatLngBounds", "toMLNExpression", "Lorg/maplibre/android/style/expressions/Expression;", "Ldev/sargunv/maplibrecompose/core/expression/Expression;", "normalizeJsonLike", "Lcom/google/gson/JsonElement;", "value", "", "toGravity", "", "Landroidx/compose/ui/Alignment;", "layoutDir", "Landroidx/compose/ui/unit/LayoutDirection;", "maplibre-compose_release"})
@SourceDebugExtension(value={"SMAP\nutil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 util.kt\ndev/sargunv/maplibrecompose/core/util/UtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 IntOffset.kt\nandroidx/compose/ui/unit/IntOffset\n*L\n1#1,118:1\n1#2:119\n1863#3,2:120\n216#4,2:122\n58#5,4:124\n*S KotlinDebug\n*F\n+ 1 util.kt\ndev/sargunv/maplibrecompose/core/util/UtilKt\n*L\n66#1:120,2\n68#1:122,2\n101#1:124,4\n*E\n"})
public final class UtilKt {
    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final URI correctedAndroidUri(@NotNull String $this$correctedAndroidUri) {
        URI uRI;
        Intrinsics.checkNotNullParameter((Object)$this$correctedAndroidUri, (String)"<this>");
        URI uri = new URI($this$correctedAndroidUri);
        if (Intrinsics.areEqual((Object)uri.getScheme(), (Object)"file")) {
            String string = uri.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            if (StringsKt.startsWith$default((String)string, (String)"/android_asset/", (boolean)false, (int)2, null)) {
                String string2 = uri.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                uRI = new URI("asset://" + StringsKt.removePrefix((String)string2, (CharSequence)"/android_asset/"));
                return uRI;
            }
        }
        uRI = uri;
        return uRI;
    }

    @NotNull
    public static final PointF toPointF(@NotNull XY $this$toPointF) {
        Intrinsics.checkNotNullParameter((Object)$this$toPointF, (String)"<this>");
        return new PointF($this$toPointF.getX(), $this$toPointF.getY());
    }

    @NotNull
    public static final XY toXY(@NotNull PointF $this$toXY) {
        Intrinsics.checkNotNullParameter((Object)$this$toXY, (String)"<this>");
        return new XY($this$toXY.x, $this$toXY.y);
    }

    @NotNull
    public static final Position toPosition(@NotNull LatLng $this$toPosition) {
        Intrinsics.checkNotNullParameter((Object)$this$toPosition, (String)"<this>");
        return new Position($this$toPosition.getLongitude(), $this$toPosition.getLatitude());
    }

    @NotNull
    public static final LatLng toLatLng(@NotNull Position $this$toLatLng) {
        Intrinsics.checkNotNullParameter((Object)$this$toLatLng, (String)"<this>");
        return new LatLng($this$toLatLng.getLatitude(), $this$toLatLng.getLongitude());
    }

    @NotNull
    public static final BoundingBox toBoundingBox(@NotNull LatLngBounds $this$toBoundingBox) {
        Intrinsics.checkNotNullParameter((Object)$this$toBoundingBox, (String)"<this>");
        Position position = UtilKt.toPosition($this$toBoundingBox.getNorthEast());
        Position position2 = UtilKt.toPosition($this$toBoundingBox.getSouthWest());
        return new BoundingBox(position2, position);
    }

    @NotNull
    public static final LatLngBounds toLatLngBounds(@NotNull BoundingBox $this$toLatLngBounds) {
        Intrinsics.checkNotNullParameter((Object)$this$toLatLngBounds, (String)"<this>");
        return LatLngBounds.Companion.from($this$toLatLngBounds.getNortheast().getLatitude(), $this$toLatLngBounds.getNortheast().getLongitude(), $this$toLatLngBounds.getSouthwest().getLatitude(), $this$toLatLngBounds.getSouthwest().getLongitude());
    }

    @Nullable
    public static final Expression toMLNExpression(@NotNull dev.sargunv.maplibrecompose.core.expression.Expression<?> $this$toMLNExpression) {
        Intrinsics.checkNotNullParameter($this$toMLNExpression, (String)"<this>");
        return $this$toMLNExpression.getValue$maplibre_compose_release() != null ? Expression.Converter.convert((JsonElement)UtilKt.normalizeJsonLike($this$toMLNExpression.getValue$maplibre_compose_release())) : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final JsonElement normalizeJsonLike(Object value) {
        JsonElement jsonElement;
        Object object = value;
        if (object == null) {
            JsonNull jsonNull = JsonNull.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)jsonNull, (String)"INSTANCE");
            jsonElement = (JsonElement)jsonNull;
        } else if (object instanceof Boolean) {
            jsonElement = (JsonElement)new JsonPrimitive((Boolean)value);
        } else if (object instanceof Number) {
            jsonElement = (JsonElement)new JsonPrimitive((Number)value);
        } else if (object instanceof String) {
            jsonElement = (JsonElement)new JsonPrimitive((String)value);
        } else if (object instanceof List) {
            JsonArray jsonArray;
            JsonArray $this$normalizeJsonLike_u24lambda_u241 = jsonArray = new JsonArray();
            boolean bl = false;
            Iterable $this$forEach$iv = (Iterable)value;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl2 = false;
                $this$normalizeJsonLike_u24lambda_u241.add(UtilKt.normalizeJsonLike(it));
            }
            jsonElement = (JsonElement)jsonArray;
        } else if (object instanceof Map) {
            JsonObject jsonObject;
            JsonObject $this$normalizeJsonLike_u24lambda_u243 = jsonObject = new JsonObject();
            boolean bl = false;
            Map $this$forEach$iv = (Map)value;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry it = element$iv = iterator.next();
                boolean bl3 = false;
                Object k = it.getKey();
                Intrinsics.checkNotNull(k, (String)"null cannot be cast to non-null type kotlin.String");
                $this$normalizeJsonLike_u24lambda_u243.add((String)k, UtilKt.normalizeJsonLike(it.getValue()));
            }
            jsonElement = (JsonElement)jsonObject;
        } else if (object instanceof Point) {
            void $this$normalizeJsonLike_u24lambda_u245_u24lambda_u244;
            JsonArray jsonArray;
            JsonArray jsonArray2;
            JsonArray $this$normalizeJsonLike_u24lambda_u245 = jsonArray2 = new JsonArray();
            boolean bl = false;
            $this$normalizeJsonLike_u24lambda_u245.add("literal");
            JsonArray $i$f$forEach = jsonArray = new JsonArray();
            JsonArray jsonArray3 = $this$normalizeJsonLike_u24lambda_u245;
            boolean bl4 = false;
            $this$normalizeJsonLike_u24lambda_u245_u24lambda_u244.add(((Point)value).getX());
            $this$normalizeJsonLike_u24lambda_u245_u24lambda_u244.add(((Point)value).getY());
            jsonArray3.add((JsonElement)jsonArray);
            jsonElement = (JsonElement)jsonArray2;
        } else if (object instanceof Insets) {
            void $this$normalizeJsonLike_u24lambda_u247_u24lambda_u246;
            JsonArray jsonArray;
            JsonArray jsonArray4;
            JsonArray $this$normalizeJsonLike_u24lambda_u247 = jsonArray4 = new JsonArray();
            boolean bl = false;
            $this$normalizeJsonLike_u24lambda_u247.add("literal");
            JsonArray $this$normalizeJsonLike_u24lambda_u245_u24lambda_u244 = jsonArray = new JsonArray();
            JsonArray jsonArray5 = $this$normalizeJsonLike_u24lambda_u247;
            boolean bl5 = false;
            $this$normalizeJsonLike_u24lambda_u247_u24lambda_u246.add(((Insets)value).getTop());
            $this$normalizeJsonLike_u24lambda_u247_u24lambda_u246.add(((Insets)value).getRight());
            $this$normalizeJsonLike_u24lambda_u247_u24lambda_u246.add(((Insets)value).getBottom());
            $this$normalizeJsonLike_u24lambda_u247_u24lambda_u246.add(((Insets)value).getLeft());
            jsonArray5.add((JsonElement)jsonArray);
            jsonElement = (JsonElement)jsonArray4;
        } else if (object instanceof Color) {
            int it = ColorKt.toArgb-8_81llA((long)((Color)value).unbox-impl());
            boolean bl = false;
            String string = "rgba(" + (it >> 16 & 0xFF) + ", " + (it >> 8 & 0xFF) + ", " + (it & 0xFF) + ", " + Color.getAlpha-impl((long)((Color)value).unbox-impl()) + ")";
            jsonElement = (JsonElement)new JsonPrimitive(string);
        } else {
            throw new IllegalArgumentException("Unsupported type: " + Reflection.getOrCreateKotlinClass(value.getClass()));
        }
        return jsonElement;
    }

    public static final int toGravity(@NotNull Alignment $this$toGravity, @NotNull LayoutDirection layoutDir) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)$this$toGravity, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)layoutDir, (String)"layoutDir");
        long l = $this$toGravity.align-KFBX0sM(IntSizeKt.IntSize((int)1, (int)1), IntSizeKt.IntSize((int)3, (int)3), layoutDir);
        boolean bl = false;
        int x = IntOffset.getX-impl((long)l);
        boolean bl2 = false;
        int y = IntOffset.getY-impl((long)l);
        switch (x) {
            case 0: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 5;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid alignment".toString());
            }
        }
        int h = n2;
        switch (y) {
            case 0: {
                n = 48;
                break;
            }
            case 1: {
                n = 16;
                break;
            }
            case 2: {
                n = 80;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid alignment".toString());
            }
        }
        int v = n;
        return h | v;
    }
}

