/*
 * Decompiled with CFR 0.152.
 */
package dev.sargunv.maplibrecompose.core.source;

import androidx.compose.runtime.internal.StabilityInferred;
import dev.sargunv.maplibrecompose.core.source.ComputedSourceOptions;
import dev.sargunv.maplibrecompose.core.source.Source;
import dev.sargunv.maplibrecompose.core.util.UtilKt;
import io.github.dellisd.spatialk.geojson.BoundingBox;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.maplibre.android.geometry.LatLngBounds;
import org.maplibre.android.style.sources.CustomGeometrySource;
import org.maplibre.android.style.sources.CustomGeometrySourceOptions;
import org.maplibre.android.style.sources.GeometryTileProvider;
import org.maplibre.geojson.FeatureCollection;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0011\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005BS\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00126\u0010\n\u001a2\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\u000b\u00a2\u0006\u0004\b\u0004\u0010\u0013J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\fJ\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0010J&\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001e"}, d2={"Ldev/sargunv/maplibrecompose/core/source/ComputedSource;", "Ldev/sargunv/maplibrecompose/core/source/Source;", "impl", "Lorg/maplibre/android/style/sources/CustomGeometrySource;", "<init>", "(Lorg/maplibre/android/style/sources/CustomGeometrySource;)V", "id", "", "options", "Ldev/sargunv/maplibrecompose/core/source/ComputedSourceOptions;", "getFeatures", "Lkotlin/Function2;", "Lio/github/dellisd/spatialk/geojson/BoundingBox;", "Lkotlin/ParameterName;", "name", "bounds", "", "zoomLevel", "Lio/github/dellisd/spatialk/geojson/FeatureCollection;", "(Ljava/lang/String;Ldev/sargunv/maplibrecompose/core/source/ComputedSourceOptions;Lkotlin/jvm/functions/Function2;)V", "getImpl$maplibre_compose", "()Lorg/maplibre/android/style/sources/CustomGeometrySource;", "invalidateBounds", "", "invalidateTile", "x", "y", "setData", "data", "Companion", "maplibre-compose"})
@StabilityInferred(parameters=0)
public final class ComputedSource
extends Source {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final CustomGeometrySource impl;
    public static final int $stable = 8;

    @NotNull
    public CustomGeometrySource getImpl$maplibre_compose() {
        return this.impl;
    }

    public ComputedSource(@NotNull CustomGeometrySource impl) {
        Intrinsics.checkNotNullParameter((Object)impl, (String)"impl");
        super(null);
        this.impl = impl;
    }

    public ComputedSource(@NotNull String id, @NotNull ComputedSourceOptions options, final @NotNull Function2<? super BoundingBox, ? super Integer, io.github.dellisd.spatialk.geojson.FeatureCollection> getFeatures) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter(getFeatures, (String)"getFeatures");
        this(new CustomGeometrySource(id, ComputedSource.Companion.buildOptionMap(options), new GeometryTileProvider(){

            public FeatureCollection getFeaturesForBounds(LatLngBounds bounds, int zoomLevel) {
                Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
                FeatureCollection featureCollection = FeatureCollection.fromJson((String)((io.github.dellisd.spatialk.geojson.FeatureCollection)getFeatures.invoke((Object)UtilKt.toBoundingBox(bounds), (Object)zoomLevel)).json());
                Intrinsics.checkNotNullExpressionValue((Object)featureCollection, (String)"fromJson(...)");
                return featureCollection;
            }
        }));
    }

    public /* synthetic */ ComputedSource(String string2, ComputedSourceOptions computedSourceOptions, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            computedSourceOptions = new ComputedSourceOptions(0, 0, 0, 0.0f, false, false, 63, null);
        }
        this(string2, computedSourceOptions, (Function2<? super BoundingBox, ? super Integer, io.github.dellisd.spatialk.geojson.FeatureCollection>)function2);
    }

    public final void invalidateBounds(@NotNull BoundingBox bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        this.getImpl$maplibre_compose().invalidateRegion(UtilKt.toLatLngBounds(bounds));
    }

    public final void invalidateTile(int zoomLevel, int x, int y) {
        this.getImpl$maplibre_compose().invalidateTile(zoomLevel, x, y);
    }

    public final void setData(int zoomLevel, int x, int y, @NotNull io.github.dellisd.spatialk.geojson.FeatureCollection data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        CustomGeometrySource customGeometrySource = this.getImpl$maplibre_compose();
        FeatureCollection featureCollection = FeatureCollection.fromJson((String)data.json());
        Intrinsics.checkNotNullExpressionValue((Object)featureCollection, (String)"fromJson(...)");
        customGeometrySource.setTileData(zoomLevel, x, y, featureCollection);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Ldev/sargunv/maplibrecompose/core/source/ComputedSource$Companion;", "", "<init>", "()V", "buildOptionMap", "Lorg/maplibre/android/style/sources/CustomGeometrySourceOptions;", "options", "Ldev/sargunv/maplibrecompose/core/source/ComputedSourceOptions;", "maplibre-compose"})
    private static final class Companion {
        private Companion() {
        }

        private final CustomGeometrySourceOptions buildOptionMap(ComputedSourceOptions options) {
            CustomGeometrySourceOptions customGeometrySourceOptions;
            CustomGeometrySourceOptions $this$buildOptionMap_u24lambda_u240 = customGeometrySourceOptions = new CustomGeometrySourceOptions();
            boolean bl = false;
            $this$buildOptionMap_u24lambda_u240.withMinZoom(options.getMinZoom());
            $this$buildOptionMap_u24lambda_u240.withMaxZoom(options.getMaxZoom());
            $this$buildOptionMap_u24lambda_u240.withBuffer(options.getBuffer());
            $this$buildOptionMap_u24lambda_u240.withTolerance(options.getTolerance());
            $this$buildOptionMap_u24lambda_u240.withClip(options.getClip());
            $this$buildOptionMap_u24lambda_u240.withWrap(options.getWrap());
            return customGeometrySourceOptions;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

