/*
 * Decompiled with CFR 0.152.
 */
package dev.sargunv.maplibrecompose.compose.offline;

import dev.sargunv.maplibrecompose.compose.offline.DownloadProgress;
import dev.sargunv.maplibrecompose.compose.offline.DownloadStatus;
import dev.sargunv.maplibrecompose.compose.offline.OfflinePackDefinition;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.maplibre.android.geometry.LatLngBounds;
import org.maplibre.android.offline.OfflineGeometryRegionDefinition;
import org.maplibre.android.offline.OfflineRegionDefinition;
import org.maplibre.android.offline.OfflineRegionStatus;
import org.maplibre.android.offline.OfflineTilePyramidRegionDefinition;
import org.maplibre.geojson.Geometry;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u0014\u0010\u0003\u001a\u00020\u0002*\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\f\u0010\u0006\u001a\u00020\u0007*\u00020\bH\u0000\u00a8\u0006\t"}, d2={"toOfflinePackDefinition", "Ldev/sargunv/maplibrecompose/compose/offline/OfflinePackDefinition;", "Lorg/maplibre/android/offline/OfflineRegionDefinition;", "toMLNOfflineRegionDefinition", "pixelRatio", "", "toDownloadProgress", "Ldev/sargunv/maplibrecompose/compose/offline/DownloadProgress$Healthy;", "Lorg/maplibre/android/offline/OfflineRegionStatus;", "maplibre-compose"})
public final class UtilKt {
    @NotNull
    public static final OfflinePackDefinition toOfflinePackDefinition(@NotNull OfflineRegionDefinition $this$toOfflinePackDefinition) {
        OfflinePackDefinition offlinePackDefinition;
        Intrinsics.checkNotNullParameter((Object)$this$toOfflinePackDefinition, (String)"<this>");
        OfflineRegionDefinition offlineRegionDefinition = $this$toOfflinePackDefinition;
        if (offlineRegionDefinition instanceof OfflineTilePyramidRegionDefinition) {
            String string2 = ((OfflineTilePyramidRegionDefinition)$this$toOfflinePackDefinition).getStyleURL();
            Intrinsics.checkNotNull((Object)string2);
            LatLngBounds latLngBounds = ((OfflineTilePyramidRegionDefinition)$this$toOfflinePackDefinition).getBounds();
            Intrinsics.checkNotNull((Object)latLngBounds);
            offlinePackDefinition = new OfflinePackDefinition.TilePyramid(string2, dev.sargunv.maplibrecompose.core.util.UtilKt.toBoundingBox(latLngBounds), (int)((OfflineTilePyramidRegionDefinition)$this$toOfflinePackDefinition).getMinZoom(), Double.isInfinite(((OfflineTilePyramidRegionDefinition)$this$toOfflinePackDefinition).getMaxZoom()) ? null : Integer.valueOf((int)((OfflineTilePyramidRegionDefinition)$this$toOfflinePackDefinition).getMaxZoom()));
        } else if (offlineRegionDefinition instanceof OfflineGeometryRegionDefinition) {
            String string3 = ((OfflineGeometryRegionDefinition)$this$toOfflinePackDefinition).getStyleURL();
            Intrinsics.checkNotNull((Object)string3);
            Geometry geometry = ((OfflineGeometryRegionDefinition)$this$toOfflinePackDefinition).getGeometry();
            Intrinsics.checkNotNull((Object)geometry);
            String string4 = geometry.toJson();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toJson(...)");
            offlinePackDefinition = new OfflinePackDefinition.Shape(string3, io.github.dellisd.spatialk.geojson.Geometry.Companion.fromJson(string4), (int)((OfflineGeometryRegionDefinition)$this$toOfflinePackDefinition).getMinZoom(), Double.isInfinite(((OfflineGeometryRegionDefinition)$this$toOfflinePackDefinition).getMaxZoom()) ? null : Integer.valueOf((int)((OfflineGeometryRegionDefinition)$this$toOfflinePackDefinition).getMaxZoom()));
        } else {
            throw new IllegalArgumentException("Unknown OfflineRegionDefinition type: " + $this$toOfflinePackDefinition);
        }
        return offlinePackDefinition;
    }

    @NotNull
    public static final OfflineRegionDefinition toMLNOfflineRegionDefinition(@NotNull OfflinePackDefinition $this$toMLNOfflineRegionDefinition, float pixelRatio) {
        OfflineRegionDefinition offlineRegionDefinition;
        Intrinsics.checkNotNullParameter((Object)$this$toMLNOfflineRegionDefinition, (String)"<this>");
        OfflinePackDefinition offlinePackDefinition = $this$toMLNOfflineRegionDefinition;
        if (offlinePackDefinition instanceof OfflinePackDefinition.TilePyramid) {
            Integer n = ((OfflinePackDefinition.TilePyramid)$this$toMLNOfflineRegionDefinition).getMaxZoom();
            offlineRegionDefinition = (OfflineRegionDefinition)new OfflineTilePyramidRegionDefinition(((OfflinePackDefinition.TilePyramid)$this$toMLNOfflineRegionDefinition).getStyleUrl(), dev.sargunv.maplibrecompose.core.util.UtilKt.toLatLngBounds(((OfflinePackDefinition.TilePyramid)$this$toMLNOfflineRegionDefinition).getBounds()), (double)((OfflinePackDefinition.TilePyramid)$this$toMLNOfflineRegionDefinition).getMinZoom(), n != null ? (double)n.intValue() : Double.POSITIVE_INFINITY, pixelRatio);
        } else if (offlinePackDefinition instanceof OfflinePackDefinition.Shape) {
            Integer n = ((OfflinePackDefinition.Shape)$this$toMLNOfflineRegionDefinition).getMaxZoom();
            offlineRegionDefinition = (OfflineRegionDefinition)new OfflineGeometryRegionDefinition(((OfflinePackDefinition.Shape)$this$toMLNOfflineRegionDefinition).getStyleUrl(), dev.sargunv.maplibrecompose.core.util.UtilKt.toMlnGeometry(((OfflinePackDefinition.Shape)$this$toMLNOfflineRegionDefinition).getShape()), (double)((OfflinePackDefinition.Shape)$this$toMLNOfflineRegionDefinition).getMinZoom(), n != null ? (double)n.intValue() : Double.POSITIVE_INFINITY, pixelRatio);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return offlineRegionDefinition;
    }

    @NotNull
    public static final DownloadProgress.Healthy toDownloadProgress(@NotNull OfflineRegionStatus $this$toDownloadProgress) {
        DownloadStatus downloadStatus;
        Intrinsics.checkNotNullParameter((Object)$this$toDownloadProgress, (String)"<this>");
        long l = $this$toDownloadProgress.getCompletedResourceCount();
        long l2 = $this$toDownloadProgress.getCompletedResourceSize();
        long l3 = $this$toDownloadProgress.getCompletedTileCount();
        long l4 = $this$toDownloadProgress.getCompletedTileSize();
        if ($this$toDownloadProgress.isComplete()) {
            downloadStatus = DownloadStatus.Complete;
        } else {
            switch ($this$toDownloadProgress.getDownloadState()) {
                case 1: {
                    downloadStatus = DownloadStatus.Downloading;
                    break;
                }
                case 0: {
                    downloadStatus = DownloadStatus.Paused;
                    break;
                }
                default: {
                    throw new IllegalStateException(("Unknown OfflineRegion state: " + $this$toDownloadProgress.getDownloadState()).toString());
                }
            }
        }
        return new DownloadProgress.Healthy(l, l2, l3, l4, downloadStatus, $this$toDownloadProgress.isRequiredResourceCountPrecise(), $this$toDownloadProgress.getRequiredResourceCount());
    }
}

