/*
 * Decompiled with CFR 0.152.
 */
package dev.sargunv.maplibrecompose.core;

import android.graphics.PointF;
import android.graphics.RectF;
import androidx.compose.foundation.layout.PaddingValues;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.Dp;
import androidx.compose.ui.unit.DpRect;
import androidx.compose.ui.unit.LayoutDirection;
import co.touchlab.kermit.BaseLogger;
import co.touchlab.kermit.Logger;
import co.touchlab.kermit.Severity;
import dev.sargunv.maplibrecompose.core.AndroidMapKt;
import dev.sargunv.maplibrecompose.core.AndroidStyle;
import dev.sargunv.maplibrecompose.core.CameraMoveReason;
import dev.sargunv.maplibrecompose.core.CameraPosition;
import dev.sargunv.maplibrecompose.core.GestureSettings;
import dev.sargunv.maplibrecompose.core.KermitLoggerDefinition;
import dev.sargunv.maplibrecompose.core.MaplibreMap;
import dev.sargunv.maplibrecompose.core.OrnamentSettings;
import dev.sargunv.maplibrecompose.core.VisibleRegion;
import dev.sargunv.maplibrecompose.core.expression.Expression;
import dev.sargunv.maplibrecompose.core.util.UtilKt;
import io.github.dellisd.spatialk.geojson.BoundingBox;
import io.github.dellisd.spatialk.geojson.Feature;
import io.github.dellisd.spatialk.geojson.Position;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.SafeContinuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maplibre.android.camera.CameraPosition;
import org.maplibre.android.camera.CameraUpdateFactory;
import org.maplibre.android.geometry.LatLng;
import org.maplibre.android.gestures.MoveGestureDetector;
import org.maplibre.android.gestures.RotateGestureDetector;
import org.maplibre.android.gestures.ShoveGestureDetector;
import org.maplibre.android.gestures.StandardScaleGestureDetector;
import org.maplibre.android.log.LoggerDefinition;
import org.maplibre.android.maps.MapLibreMap;
import org.maplibre.android.maps.MapView;
import org.maplibre.android.maps.Style;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010<\u001a\u00020/2\u0006\u0010=\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020/2\u0006\u0010\u001e\u001a\u00020@H\u0016J\u0010\u0010A\u001a\u00020/2\u0006\u0010\u001e\u001a\u00020BH\u0016J\f\u0010C\u001a\u00020D*\u00020EH\u0002J\f\u0010F\u001a\u00020E*\u00020DH\u0002J \u0010L\u001a\u00020/2\u0006\u0010M\u001a\u00020D2\u0006\u0010N\u001a\u00020OH\u0096@\u00a2\u0006\u0004\bP\u0010QJ\u0017\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020UH\u0016\u00a2\u0006\u0004\bV\u0010WJ\u0017\u0010X\u001a\u00020U2\u0006\u0010Y\u001a\u00020SH\u0016\u00a2\u0006\u0004\bZ\u0010[J=\u0010\\\u001a\b\u0012\u0004\u0012\u00020^0]2\u0006\u0010T\u001a\u00020U2\u000e\u0010_\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010`2\u000e\u0010a\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010bH\u0016\u00a2\u0006\u0004\bc\u0010dJ6\u0010\\\u001a\b\u0012\u0004\u0012\u00020^0]2\u0006\u0010e\u001a\u00020f2\u000e\u0010_\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010`2\u000e\u0010a\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\b\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\n\u001a\u00020\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR(\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u001e\u001a\u0004\u0018\u00010\r@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000f@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R$\u0010(\u001a\u00020'2\u0006\u0010\u001e\u001a\u00020'8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R&\u0010,\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020/0-X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u0014\u00104\u001a\u0002058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0014\u00108\u001a\u0002098VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R$\u0010G\u001a\u00020D2\u0006\u0010\u001e\u001a\u00020D8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bH\u0010I\"\u0004\bJ\u0010K\u00a8\u0006g"}, d2={"Ldev/sargunv/maplibrecompose/core/AndroidMap;", "Ldev/sargunv/maplibrecompose/core/MaplibreMap;", "mapView", "Lorg/maplibre/android/maps/MapView;", "map", "Lorg/maplibre/android/maps/MapLibreMap;", "layoutDir", "Landroidx/compose/ui/unit/LayoutDirection;", "density", "Landroidx/compose/ui/unit/Density;", "callbacks", "Ldev/sargunv/maplibrecompose/core/MaplibreMap$Callbacks;", "logger", "Lco/touchlab/kermit/Logger;", "styleUrl", "", "<init>", "(Lorg/maplibre/android/maps/MapView;Lorg/maplibre/android/maps/MapLibreMap;Landroidx/compose/ui/unit/LayoutDirection;Landroidx/compose/ui/unit/Density;Ldev/sargunv/maplibrecompose/core/MaplibreMap$Callbacks;Lco/touchlab/kermit/Logger;Ljava/lang/String;)V", "getLayoutDir$maplibre_compose_release", "()Landroidx/compose/ui/unit/LayoutDirection;", "setLayoutDir$maplibre_compose_release", "(Landroidx/compose/ui/unit/LayoutDirection;)V", "getDensity$maplibre_compose_release", "()Landroidx/compose/ui/unit/Density;", "setDensity$maplibre_compose_release", "(Landroidx/compose/ui/unit/Density;)V", "getCallbacks$maplibre_compose_release", "()Ldev/sargunv/maplibrecompose/core/MaplibreMap$Callbacks;", "setCallbacks$maplibre_compose_release", "(Ldev/sargunv/maplibrecompose/core/MaplibreMap$Callbacks;)V", "value", "getLogger$maplibre_compose_release", "()Lco/touchlab/kermit/Logger;", "setLogger$maplibre_compose_release", "(Lco/touchlab/kermit/Logger;)V", "getStyleUrl", "()Ljava/lang/String;", "setStyleUrl", "(Ljava/lang/String;)V", "", "isDebugEnabled", "()Z", "setDebugEnabled", "(Z)V", "onFpsChanged", "Lkotlin/Function1;", "", "", "getOnFpsChanged", "()Lkotlin/jvm/functions/Function1;", "setOnFpsChanged", "(Lkotlin/jvm/functions/Function1;)V", "visibleBoundingBox", "Lio/github/dellisd/spatialk/geojson/BoundingBox;", "getVisibleBoundingBox", "()Lio/github/dellisd/spatialk/geojson/BoundingBox;", "visibleRegion", "Ldev/sargunv/maplibrecompose/core/VisibleRegion;", "getVisibleRegion", "()Ldev/sargunv/maplibrecompose/core/VisibleRegion;", "setMaximumFps", "maximumFps", "", "setGestureSettings", "Ldev/sargunv/maplibrecompose/core/GestureSettings;", "setOrnamentSettings", "Ldev/sargunv/maplibrecompose/core/OrnamentSettings;", "toCameraPosition", "Ldev/sargunv/maplibrecompose/core/CameraPosition;", "Lorg/maplibre/android/camera/CameraPosition;", "toMLNCameraPosition", "cameraPosition", "getCameraPosition", "()Ldev/sargunv/maplibrecompose/core/CameraPosition;", "setCameraPosition", "(Ldev/sargunv/maplibrecompose/core/CameraPosition;)V", "animateCameraPosition", "finalPosition", "duration", "Lkotlin/time/Duration;", "animateCameraPosition-8Mi8wO0", "(Ldev/sargunv/maplibrecompose/core/CameraPosition;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "positionFromScreenLocation", "Lio/github/dellisd/spatialk/geojson/Position;", "offset", "Landroidx/compose/ui/unit/DpOffset;", "positionFromScreenLocation-jo-Fl9I", "(J)Lio/github/dellisd/spatialk/geojson/Position;", "screenLocationFromPosition", "position", "screenLocationFromPosition-gVRvYmI", "(Lio/github/dellisd/spatialk/geojson/Position;)J", "queryRenderedFeatures", "", "Lio/github/dellisd/spatialk/geojson/Feature;", "layerIds", "", "predicate", "Ldev/sargunv/maplibrecompose/core/expression/Expression;", "queryRenderedFeatures-rOJDEFc", "(JLjava/util/Set;Ldev/sargunv/maplibrecompose/core/expression/Expression;)Ljava/util/List;", "rect", "Landroidx/compose/ui/unit/DpRect;", "maplibre-compose_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAndroidMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidMap.kt\ndev/sargunv/maplibrecompose/core/AndroidMap\n+ 2 Logger.kt\nco/touchlab/kermit/Logger\n+ 3 BaseLogger.kt\nco/touchlab/kermit/BaseLogger\n+ 4 Dp.kt\nandroidx/compose/ui/unit/DpKt\n+ 5 Dp.kt\nandroidx/compose/ui/unit/Dp\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,308:1\n41#2,3:309\n44#2:321\n41#2,3:354\n44#2:366\n46#2,3:367\n49#2:379\n38#3,9:312\n38#3,9:357\n38#3,9:370\n149#4:322\n206#4:323\n149#4:325\n206#4:326\n149#4:327\n149#4:329\n206#4:330\n149#4:331\n149#4:333\n206#4:334\n149#4:335\n159#4:337\n159#4:338\n159#4:339\n159#4:340\n149#4:341\n51#5:324\n51#5:328\n51#5:332\n51#5:336\n37#6,2:342\n37#6,2:348\n1557#7:344\n1628#7,3:345\n1557#7:350\n1628#7,3:351\n*S KotlinDebug\n*F\n+ 1 AndroidMap.kt\ndev/sargunv/maplibrecompose/core/AndroidMap\n*L\n69#1:309,3\n69#1:321\n73#1:354,3\n73#1:366\n93#1:367,3\n93#1:379\n69#1:312,9\n73#1:357,9\n93#1:370,9\n207#1:322\n207#1:323\n208#1:325\n208#1:326\n208#1:327\n210#1:329\n210#1:330\n210#1:331\n211#1:333\n211#1:334\n211#1:335\n227#1:337\n228#1:338\n229#1:339\n230#1:340\n232#1:341\n207#1:324\n208#1:328\n210#1:332\n211#1:336\n284#1:342,2\n296#1:348,2\n285#1:344\n285#1:345,3\n297#1:350\n297#1:351,3\n*E\n"})
public final class AndroidMap
implements MaplibreMap {
    @NotNull
    private final MapView mapView;
    @NotNull
    private final MapLibreMap map;
    @NotNull
    private LayoutDirection layoutDir;
    @NotNull
    private Density density;
    @NotNull
    private MaplibreMap.Callbacks callbacks;
    @Nullable
    private Logger logger;
    @NotNull
    private String styleUrl;
    @NotNull
    private Function1<? super Double, Unit> onFpsChanged;
    public static final int $stable = 8;

    public AndroidMap(@NotNull MapView mapView, @NotNull MapLibreMap map, @NotNull LayoutDirection layoutDir, @NotNull Density density, @NotNull MaplibreMap.Callbacks callbacks2, @Nullable Logger logger, @NotNull String styleUrl) {
        Intrinsics.checkNotNullParameter((Object)mapView, (String)"mapView");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        Intrinsics.checkNotNullParameter((Object)layoutDir, (String)"layoutDir");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)callbacks2, (String)"callbacks");
        Intrinsics.checkNotNullParameter((Object)styleUrl, (String)"styleUrl");
        this.mapView = mapView;
        this.map = map;
        this.layoutDir = layoutDir;
        this.density = density;
        this.callbacks = callbacks2;
        this.logger = logger;
        this.styleUrl = "";
        this.map.addOnCameraMoveStartedListener(arg_0 -> AndroidMap._init_$lambda$4(this, logger, arg_0));
        this.map.addOnCameraMoveListener(() -> AndroidMap._init_$lambda$5(this));
        this.map.addOnCameraIdleListener(() -> AndroidMap._init_$lambda$6(this));
        this.map.addOnMoveListener(new MapLibreMap.OnMoveListener(){

            public void onMoveBegin(MoveGestureDetector detector) {
                Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
                this.getCallbacks$maplibre_compose_release().onCameraMoveStarted(this, CameraMoveReason.GESTURE);
            }

            public void onMove(MoveGestureDetector detector) {
                Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
            }

            public void onMoveEnd(MoveGestureDetector detector) {
                Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
            }
        });
        this.map.addOnScaleListener(new MapLibreMap.OnScaleListener(){

            public void onScaleBegin(StandardScaleGestureDetector detector) {
                Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
                this.getCallbacks$maplibre_compose_release().onCameraMoveStarted(this, CameraMoveReason.GESTURE);
            }

            public void onScale(StandardScaleGestureDetector detector) {
                Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
            }

            public void onScaleEnd(StandardScaleGestureDetector detector) {
                Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
            }
        });
        this.map.addOnShoveListener(new MapLibreMap.OnShoveListener(){

            public void onShoveBegin(ShoveGestureDetector detector) {
                Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
                this.getCallbacks$maplibre_compose_release().onCameraMoveStarted(this, CameraMoveReason.GESTURE);
            }

            public void onShove(ShoveGestureDetector detector) {
                Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
            }

            public void onShoveEnd(ShoveGestureDetector detector) {
                Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
            }
        });
        this.map.addOnRotateListener(new MapLibreMap.OnRotateListener(){

            public void onRotateBegin(RotateGestureDetector detector) {
                Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
                this.getCallbacks$maplibre_compose_release().onCameraMoveStarted(this, CameraMoveReason.GESTURE);
            }

            public void onRotate(RotateGestureDetector detector) {
                Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
            }

            public void onRotateEnd(RotateGestureDetector detector) {
                Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
            }
        });
        this.map.addOnMapClickListener(arg_0 -> AndroidMap._init_$lambda$7(this, arg_0));
        this.map.addOnMapLongClickListener(arg_0 -> AndroidMap._init_$lambda$8(this, arg_0));
        this.map.setOnFpsChangedListener(arg_0 -> AndroidMap._init_$lambda$9(this, arg_0));
        this.setStyleUrl(styleUrl);
        this.onFpsChanged = AndroidMap::onFpsChanged$lambda$10;
    }

    @NotNull
    public final LayoutDirection getLayoutDir$maplibre_compose_release() {
        return this.layoutDir;
    }

    public final void setLayoutDir$maplibre_compose_release(@NotNull LayoutDirection layoutDirection) {
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"<set-?>");
        this.layoutDir = layoutDirection;
    }

    @NotNull
    public final Density getDensity$maplibre_compose_release() {
        return this.density;
    }

    public final void setDensity$maplibre_compose_release(@NotNull Density density) {
        Intrinsics.checkNotNullParameter((Object)density, (String)"<set-?>");
        this.density = density;
    }

    @NotNull
    public final MaplibreMap.Callbacks getCallbacks$maplibre_compose_release() {
        return this.callbacks;
    }

    public final void setCallbacks$maplibre_compose_release(@NotNull MaplibreMap.Callbacks callbacks2) {
        Intrinsics.checkNotNullParameter((Object)callbacks2, (String)"<set-?>");
        this.callbacks = callbacks2;
    }

    @Nullable
    public final Logger getLogger$maplibre_compose_release() {
        return this.logger;
    }

    public final void setLogger$maplibre_compose_release(@Nullable Logger value) {
        if (!Intrinsics.areEqual((Object)value, (Object)this.logger)) {
            org.maplibre.android.log.Logger.setLoggerDefinition((LoggerDefinition)new KermitLoggerDefinition(value));
            this.logger = value;
        }
    }

    @Override
    @NotNull
    public String getStyleUrl() {
        return this.styleUrl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setStyleUrl(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (Intrinsics.areEqual((Object)this.styleUrl, (Object)value)) {
            return;
        }
        Logger logger = this.logger;
        if (logger != null) {
            void this_$iv$iv;
            Throwable throwable$iv = null;
            String tag$iv = logger.getTag();
            boolean $i$f$i = false;
            BaseLogger baseLogger = (BaseLogger)logger;
            Severity severity$iv$iv = Severity.Info;
            boolean $i$f$logBlock = false;
            if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                Throwable throwable = throwable$iv;
                String string = tag$iv;
                Severity severity = severity$iv$iv;
                void var10_12 = this_$iv$iv;
                boolean bl = false;
                String string2 = "Setting style URL";
                var10_12.processLog(severity, string, throwable, string2);
            }
        }
        this.callbacks.onStyleChanged(this, null);
        Style.Builder builder = new Style.Builder().fromUri(UtilKt.correctedAndroidUri(value).toString());
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"fromUri(...)");
        Style.Builder builder2 = builder;
        this.map.setStyle(builder2, arg_0 -> AndroidMap._set_styleUrl_$lambda$2(this, arg_0));
        this.styleUrl = value;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.map.isDebugActive();
    }

    @Override
    public void setDebugEnabled(boolean value) {
        this.map.setDebugActive(value);
    }

    @Override
    @NotNull
    public Function1<Double, Unit> getOnFpsChanged() {
        return this.onFpsChanged;
    }

    @Override
    public void setOnFpsChanged(@NotNull Function1<? super Double, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.onFpsChanged = function1;
    }

    @Override
    @NotNull
    public BoundingBox getVisibleBoundingBox() {
        return UtilKt.toBoundingBox(this.map.getProjection().getVisibleRegion().latLngBounds);
    }

    @Override
    @NotNull
    public VisibleRegion getVisibleRegion() {
        org.maplibre.android.geometry.VisibleRegion visibleRegion = this.map.getProjection().getVisibleRegion();
        Intrinsics.checkNotNullExpressionValue((Object)visibleRegion, (String)"getVisibleRegion(...)");
        return AndroidMapKt.access$toVisibleRegion(visibleRegion);
    }

    @Override
    public void setMaximumFps(int maximumFps) {
        this.mapView.setMaximumFps(maximumFps);
    }

    @Override
    public void setGestureSettings(@NotNull GestureSettings value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.map.getUiSettings().setRotateGesturesEnabled(value.isRotateGesturesEnabled());
        this.map.getUiSettings().setScrollGesturesEnabled(value.isScrollGesturesEnabled());
        this.map.getUiSettings().setTiltGesturesEnabled(value.isTiltGesturesEnabled());
        this.map.getUiSettings().setZoomGesturesEnabled(value.isZoomGesturesEnabled());
        this.map.getUiSettings().setQuickZoomGesturesEnabled(value.isZoomGesturesEnabled());
        this.map.getUiSettings().setDoubleTapGesturesEnabled(value.isZoomGesturesEnabled());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setOrnamentSettings(@NotNull OrnamentSettings value) {
        void other$iv;
        void arg0$iv;
        void minimumValue$iv;
        float $this$coerceAtLeast_u2dYgX7TsA$iv;
        float other$iv2;
        void arg0$iv2;
        void minimumValue$iv2;
        float $this$coerceAtLeast_u2dYgX7TsA$iv2;
        float other$iv3;
        void arg0$iv3;
        void minimumValue$iv3;
        float $this$coerceAtLeast_u2dYgX7TsA$iv3;
        float other$iv4;
        void arg0$iv4;
        void minimumValue$iv4;
        float $this$coerceAtLeast_u2dYgX7TsA$iv4;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.map.getUiSettings().setLogoEnabled(value.isLogoEnabled());
        this.map.getUiSettings().setLogoGravity(UtilKt.toGravity(value.getLogoAlignment(), this.layoutDir));
        this.map.getUiSettings().setAttributionEnabled(value.isAttributionEnabled());
        this.map.getUiSettings().setAttributionGravity(UtilKt.toGravity(value.getAttributionAlignment(), this.layoutDir));
        this.map.getUiSettings().setCompassEnabled(value.isCompassEnabled());
        this.map.getUiSettings().setCompassGravity(UtilKt.toGravity(value.getCompassAlignment(), this.layoutDir));
        Density $this$setOrnamentSettings_u24lambda_u2411 = this.density;
        boolean bl = false;
        float f = value.getPadding().calculateLeftPadding-u2uoSUM(this.layoutDir);
        boolean $this$dp$iv22 = false;
        boolean $i$f$getDp = false;
        float $this$dp$iv22 = Dp.constructor-impl((float)((float)$this$dp$iv22));
        boolean bl2 = false;
        $this$coerceAtLeast_u2dYgX7TsA$iv4 = Dp.constructor-impl((float)RangesKt.coerceAtLeast((float)$this$coerceAtLeast_u2dYgX7TsA$iv4, (float)minimumValue$iv4));
        int $this$dp$iv32 = 8;
        $i$f$getDp = false;
        float $this$dp$iv32 = Dp.constructor-impl((float)$this$dp$iv32);
        boolean bl3 = false;
        int left = $this$setOrnamentSettings_u24lambda_u2411.roundToPx-0680j_4(Dp.constructor-impl((float)(arg0$iv4 + other$iv4)));
        other$iv4 = value.getPadding().calculateTopPadding-D9Ej5fM();
        boolean $this$dp$iv42 = false;
        boolean $i$f$getDp2 = false;
        float $this$dp$iv42 = Dp.constructor-impl((float)((float)$this$dp$iv42));
        $i$f$coerceAtLeast-YgX7TsA = false;
        $this$coerceAtLeast_u2dYgX7TsA$iv3 = Dp.constructor-impl((float)RangesKt.coerceAtLeast((float)$this$coerceAtLeast_u2dYgX7TsA$iv3, (float)minimumValue$iv3));
        int $this$dp$iv52 = 8;
        $i$f$getDp2 = false;
        float $this$dp$iv52 = Dp.constructor-impl((float)$this$dp$iv52);
        $i$f$plus-5rwHm24 = false;
        int top = $this$setOrnamentSettings_u24lambda_u2411.roundToPx-0680j_4(Dp.constructor-impl((float)(arg0$iv3 + other$iv3)));
        other$iv3 = value.getPadding().calculateRightPadding-u2uoSUM(this.layoutDir);
        boolean $this$dp$iv62 = false;
        boolean $i$f$getDp3 = false;
        float $this$dp$iv62 = Dp.constructor-impl((float)((float)$this$dp$iv62));
        $i$f$coerceAtLeast-YgX7TsA = false;
        $this$coerceAtLeast_u2dYgX7TsA$iv2 = Dp.constructor-impl((float)RangesKt.coerceAtLeast((float)$this$coerceAtLeast_u2dYgX7TsA$iv2, (float)minimumValue$iv2));
        int $this$dp$iv72 = 8;
        $i$f$getDp3 = false;
        float $this$dp$iv72 = Dp.constructor-impl((float)$this$dp$iv72);
        $i$f$plus-5rwHm24 = false;
        int right = $this$setOrnamentSettings_u24lambda_u2411.roundToPx-0680j_4(Dp.constructor-impl((float)(arg0$iv2 + other$iv2)));
        other$iv2 = value.getPadding().calculateBottomPadding-D9Ej5fM();
        boolean $this$dp$iv82 = false;
        boolean $i$f$getDp4 = false;
        float $this$dp$iv82 = Dp.constructor-impl((float)((float)$this$dp$iv82));
        $i$f$coerceAtLeast-YgX7TsA = false;
        $this$coerceAtLeast_u2dYgX7TsA$iv = Dp.constructor-impl((float)RangesKt.coerceAtLeast((float)$this$coerceAtLeast_u2dYgX7TsA$iv, (float)minimumValue$iv));
        int $this$dp$iv92 = 8;
        $i$f$getDp4 = false;
        float $this$dp$iv92 = Dp.constructor-impl((float)$this$dp$iv92);
        $i$f$plus-5rwHm24 = false;
        int bottom = $this$setOrnamentSettings_u24lambda_u2411.roundToPx-0680j_4(Dp.constructor-impl((float)(arg0$iv + other$iv)));
        this.map.getUiSettings().setAttributionMargins(left, top, right, bottom);
        this.map.getUiSettings().setLogoMargins(left, top, right, bottom);
        this.map.getUiSettings().setCompassMargins(left, top, right, bottom);
    }

    private final CameraPosition toCameraPosition(org.maplibre.android.camera.CameraPosition $this$toCameraPosition) {
        PaddingValues.Absolute absolute;
        LatLng latLng = $this$toCameraPosition.target;
        if (latLng == null || (latLng = UtilKt.toPosition(latLng)) == null) {
            latLng = new Position(0.0, 0.0);
        }
        LatLng latLng2 = latLng;
        double d = $this$toCameraPosition.zoom;
        double d2 = $this$toCameraPosition.bearing;
        double d3 = $this$toCameraPosition.tilt;
        if ($this$toCameraPosition.padding != null) {
            double[] it = $this$toCameraPosition.padding;
            boolean bl = false;
            double $this$dp$iv = it[0];
            boolean $i$f$getDp = false;
            float f = Dp.constructor-impl((float)((float)$this$dp$iv));
            $this$dp$iv = it[1];
            $i$f$getDp = false;
            float f2 = Dp.constructor-impl((float)((float)$this$dp$iv));
            $this$dp$iv = it[2];
            $i$f$getDp = false;
            float f3 = Dp.constructor-impl((float)((float)$this$dp$iv));
            $this$dp$iv = it[3];
            $i$f$getDp = false;
            PaddingValues.Absolute absolute2 = new PaddingValues.Absolute(f, f2, f3, Dp.constructor-impl((float)((float)$this$dp$iv)), null);
            absolute = absolute2;
        } else {
            boolean $this$dp$iv = false;
            boolean $i$f$getDp = false;
            PaddingValues.Absolute absolute3 = new PaddingValues.Absolute(Dp.constructor-impl((float)((float)$this$dp$iv)), 0.0f, 0.0f, 0.0f, 14, null);
            absolute = absolute3;
        }
        PaddingValues.Absolute absolute4 = absolute;
        return new CameraPosition(d2, (Position)latLng2, d3, d, (PaddingValues)absolute4);
    }

    private final org.maplibre.android.camera.CameraPosition toMLNCameraPosition(CameraPosition $this$toMLNCameraPosition) {
        Density $this$toMLNCameraPosition_u24lambda_u2413 = this.density;
        boolean bl = false;
        return new CameraPosition.Builder().target(UtilKt.toLatLng($this$toMLNCameraPosition.getTarget())).zoom($this$toMLNCameraPosition.getZoom()).tilt($this$toMLNCameraPosition.getTilt()).bearing($this$toMLNCameraPosition.getBearing()).padding((double)$this$toMLNCameraPosition_u24lambda_u2413.toPx-0680j_4($this$toMLNCameraPosition.getPadding().calculateLeftPadding-u2uoSUM(this.layoutDir)), (double)$this$toMLNCameraPosition_u24lambda_u2413.toPx-0680j_4($this$toMLNCameraPosition.getPadding().calculateTopPadding-D9Ej5fM()), (double)$this$toMLNCameraPosition_u24lambda_u2413.toPx-0680j_4($this$toMLNCameraPosition.getPadding().calculateRightPadding-u2uoSUM(this.layoutDir)), (double)$this$toMLNCameraPosition_u24lambda_u2413.toPx-0680j_4($this$toMLNCameraPosition.getPadding().calculateBottomPadding-D9Ej5fM())).build();
    }

    @Override
    @NotNull
    public CameraPosition getCameraPosition() {
        org.maplibre.android.camera.CameraPosition cameraPosition = this.map.getCameraPosition();
        Intrinsics.checkNotNullExpressionValue((Object)cameraPosition, (String)"getCameraPosition(...)");
        return this.toCameraPosition(cameraPosition);
    }

    @Override
    public void setCameraPosition(@NotNull CameraPosition value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.map.moveCamera(CameraUpdateFactory.newCameraPosition((org.maplibre.android.camera.CameraPosition)this.toMLNCameraPosition(value)));
    }

    @Override
    @Nullable
    public Object animateCameraPosition-8Mi8wO0(@NotNull CameraPosition finalPosition, long duration, @NotNull Continuation<? super Unit> $completion) {
        Continuation<? super Unit> continuation = $completion;
        SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
        Continuation cont = (Continuation)safeContinuation;
        boolean bl = false;
        this.map.animateCamera(CameraUpdateFactory.newCameraPosition((org.maplibre.android.camera.CameraPosition)this.toMLNCameraPosition(finalPosition)), Duration.toInt-impl((long)duration, (DurationUnit)DurationUnit.MILLISECONDS), new MapLibreMap.CancelableCallback((Continuation<? super Unit>)cont){
            final /* synthetic */ Continuation<Unit> $cont;
            {
                this.$cont = $cont;
            }

            public void onFinish() {
                this.$cont.resumeWith(Result.constructor-impl((Object)Unit.INSTANCE));
            }

            public void onCancel() {
                this.$cont.resumeWith(Result.constructor-impl((Object)Unit.INSTANCE));
            }
        });
        Object object = safeContinuation.getOrThrow();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @NotNull
    public Position positionFromScreenLocation-jo-Fl9I(long offset) {
        LatLng latLng = this.map.getProjection().fromScreenLocation(UtilKt.toPointF-gVKV90s(offset, this.density));
        Intrinsics.checkNotNullExpressionValue((Object)latLng, (String)"fromScreenLocation(...)");
        return UtilKt.toPosition(latLng);
    }

    @Override
    public long screenLocationFromPosition-gVRvYmI(@NotNull Position position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        PointF pointF = this.map.getProjection().toScreenLocation(UtilKt.toLatLng(position));
        Intrinsics.checkNotNullExpressionValue((Object)pointF, (String)"toScreenLocation(...)");
        return UtilKt.toOffset(pointF, this.density);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Feature> queryRenderedFeatures-rOJDEFc(long offset, @Nullable Set<String> layerIds, @Nullable Expression<Boolean> predicate) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String[] stringArray;
        Collection thisCollection$iv;
        Iterable $this$toTypedArray$iv;
        Function3 query2 = (Function3)new Function3<PointF, org.maplibre.android.style.expressions.Expression, String[], List<org.maplibre.geojson.Feature>>((Object)this.map){

            public final List<org.maplibre.geojson.Feature> invoke(PointF p0, org.maplibre.android.style.expressions.Expression p1, String[] p2) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((MapLibreMap)this.receiver).queryRenderedFeatures(p0, p1, p2);
            }
        };
        PointF pointF = UtilKt.toPointF-gVKV90s(offset, this.density);
        Expression<Boolean> expression = predicate;
        Object object = expression != null ? UtilKt.toMLNExpression(expression) : null;
        Set<String> set = layerIds;
        if (set != null) {
            $this$toTypedArray$iv = set;
            boolean $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            stringArray = thisCollection$iv.toArray(new String[0]);
        } else {
            stringArray = null;
        }
        $this$toTypedArray$iv = (Iterable)query2.invoke((Object)pointF, object, stringArray);
        boolean $i$f$map = false;
        thisCollection$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            org.maplibre.geojson.Feature feature = (org.maplibre.geojson.Feature)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.toJson();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            collection.add(Feature.Companion.fromJson(string));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Feature> queryRenderedFeatures(@NotNull DpRect rect, @Nullable Set<String> layerIds, @Nullable Expression<Boolean> predicate) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String[] stringArray;
        Collection thisCollection$iv;
        Iterable $this$toTypedArray$iv;
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Function3 query2 = (Function3)new Function3<RectF, org.maplibre.android.style.expressions.Expression, String[], List<org.maplibre.geojson.Feature>>((Object)this.map){

            public final List<org.maplibre.geojson.Feature> invoke(RectF p0, org.maplibre.android.style.expressions.Expression p1, String[] p2) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((MapLibreMap)this.receiver).queryRenderedFeatures(p0, p1, p2);
            }
        };
        RectF rectF = UtilKt.toRectF(rect, this.density);
        Expression<Boolean> expression = predicate;
        Object object = expression != null ? UtilKt.toMLNExpression(expression) : null;
        Set<String> set = layerIds;
        if (set != null) {
            $this$toTypedArray$iv = set;
            boolean $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            stringArray = thisCollection$iv.toArray(new String[0]);
        } else {
            stringArray = null;
        }
        $this$toTypedArray$iv = (Iterable)query2.invoke((Object)rectF, object, stringArray);
        boolean $i$f$map = false;
        thisCollection$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            org.maplibre.geojson.Feature feature = (org.maplibre.geojson.Feature)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.toJson();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            collection.add(Feature.Companion.fromJson(string));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final void _set_styleUrl_$lambda$2(AndroidMap this$0, Style it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Logger logger = this$0.logger;
        if (logger != null) {
            void this_$iv$iv;
            Throwable throwable$iv = null;
            String tag$iv = logger.getTag();
            boolean $i$f$i = false;
            BaseLogger baseLogger = (BaseLogger)logger;
            Severity severity$iv$iv = Severity.Info;
            boolean $i$f$logBlock = false;
            if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                Throwable throwable = throwable$iv;
                String string = tag$iv;
                Severity severity = severity$iv$iv;
                void var10_12 = this_$iv$iv;
                boolean bl = false;
                String string2 = "Style finished loading";
                var10_12.processLog(severity, string, throwable, string2);
            }
        }
        this$0.callbacks.onStyleChanged(this$0, new AndroidStyle(it));
    }

    /*
     * WARNING - void declaration
     */
    private static final void _init_$lambda$4(AndroidMap this$0, Logger $logger, int reason) {
        CameraMoveReason cameraMoveReason;
        MaplibreMap.Callbacks callbacks2 = this$0.callbacks;
        MaplibreMap maplibreMap = this$0;
        switch (reason) {
            case 1: {
                cameraMoveReason = CameraMoveReason.GESTURE;
                break;
            }
            case 3: {
                cameraMoveReason = CameraMoveReason.PROGRAMMATIC;
                break;
            }
            default: {
                if ($logger != null) {
                    void this_$iv$iv;
                    Throwable throwable$iv = null;
                    String tag$iv = $logger.getTag();
                    boolean $i$f$w = false;
                    BaseLogger baseLogger = (BaseLogger)$logger;
                    Severity severity$iv$iv = Severity.Warn;
                    boolean $i$f$logBlock = false;
                    if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                        Throwable throwable = throwable$iv;
                        String string = tag$iv;
                        Severity severity = severity$iv$iv;
                        void var12_12 = this_$iv$iv;
                        MaplibreMap maplibreMap2 = maplibreMap;
                        MaplibreMap.Callbacks callbacks3 = callbacks2;
                        boolean bl = false;
                        String string2 = "Unknown camera move reason: " + reason;
                        callbacks2 = callbacks3;
                        maplibreMap = maplibreMap2;
                        var12_12.processLog(severity, string, throwable, string2);
                    }
                }
                cameraMoveReason = CameraMoveReason.UNKNOWN;
            }
        }
        callbacks2.onCameraMoveStarted(maplibreMap, cameraMoveReason);
    }

    private static final void _init_$lambda$5(AndroidMap this$0) {
        this$0.callbacks.onCameraMoved(this$0);
    }

    private static final void _init_$lambda$6(AndroidMap this$0) {
        this$0.callbacks.onCameraMoveEnded(this$0);
    }

    private static final boolean _init_$lambda$7(AndroidMap this$0, LatLng coords) {
        Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
        Position pos = UtilKt.toPosition(coords);
        this$0.callbacks.onClick-GrvxvIE(this$0, pos, this$0.screenLocationFromPosition-gVRvYmI(pos));
        return true;
    }

    private static final boolean _init_$lambda$8(AndroidMap this$0, LatLng coords) {
        Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
        Position pos = UtilKt.toPosition(coords);
        this$0.callbacks.onClick-GrvxvIE(this$0, pos, this$0.screenLocationFromPosition-gVRvYmI(pos));
        return true;
    }

    private static final void _init_$lambda$9(AndroidMap this$0, double it) {
        this$0.getOnFpsChanged().invoke((Object)it);
    }

    private static final Unit onFpsChanged$lambda$10(double d) {
        return Unit.INSTANCE;
    }
}

