/*
 * Decompiled with CFR 0.152.
 */
package dev.sargunv.maplibrecompose.core.expression;

import androidx.compose.foundation.layout.PaddingValues;
import androidx.compose.runtime.Immutable;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.unit.Dp;
import androidx.compose.ui.unit.DpOffset;
import dev.sargunv.maplibrecompose.core.expression.ExpressionScope;
import dev.sargunv.maplibrecompose.core.expression.LayerPropertyEnum;
import dev.sargunv.maplibrecompose.core.expression.TCollator;
import dev.sargunv.maplibrecompose.core.expression.TFormatted;
import dev.sargunv.maplibrecompose.core.expression.TInterpolationType;
import dev.sargunv.maplibrecompose.core.expression.TResolvedImage;
import dev.sargunv.maplibrecompose.core.expression.UtilsKt;
import io.github.dellisd.spatialk.geojson.Geometry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0087\b\u0018\u0000 \u0012*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002:\u0001\u0012B\u0013\b\u0002\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u0004\u0018\u00010\u0002H\u00c0\u0003\u00a2\u0006\u0002\b\tJ\u001b\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u00c2\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0002X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Ldev/sargunv/maplibrecompose/core/expression/Expression;", "T", "", "value", "<init>", "(Ljava/lang/Object;)V", "getValue$maplibre_compose_release", "()Ljava/lang/Object;", "component1", "component1$maplibre_compose_release", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "maplibre-compose_release"})
@Immutable
public final class Expression<T> {
    @NotNull
    public static final Companion Companion;
    @Nullable
    private final Object value;
    public static final int $stable;
    @NotNull
    private static final Expression<Number>[] constSmallInts;
    @NotNull
    private static final Expression<Number>[] constSmallFloats;
    @NotNull
    private static final Expression<Color> constBlack;
    @NotNull
    private static final Expression<Color> constWhite;
    @NotNull
    private static final Expression<Color> constTransparent;
    @NotNull
    private static final Expression<Boolean> constFalse;
    @NotNull
    private static final Expression<Boolean> constTrue;
    @NotNull
    private static final Expression constNull;
    @NotNull
    private static final Expression<Offset> constZeroOffset;
    @NotNull
    private static final Expression<PaddingValues.Absolute> constZeroPadding;

    private Expression(Object value) {
        this.value = value;
    }

    @Nullable
    public final Object getValue$maplibre_compose_release() {
        return this.value;
    }

    @Nullable
    public final Object component1$maplibre_compose_release() {
        return this.value;
    }

    private final Expression<T> copy(Object value) {
        return new Expression<T>(value);
    }

    static /* synthetic */ Expression copy$default(Expression expression, Object object, int n, Object object2) {
        if ((n & 1) != 0) {
            object = expression.value;
        }
        return expression.copy(object);
    }

    @NotNull
    public String toString() {
        return "Expression(value=" + this.value + ")";
    }

    public int hashCode() {
        return this.value == null ? 0 : this.value.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Expression)) {
            return false;
        }
        Expression expression = (Expression)other;
        return Intrinsics.areEqual((Object)this.value, (Object)expression.value);
    }

    public /* synthetic */ Expression(Object value, DefaultConstructorMarker $constructor_marker) {
        this(value);
    }

    static {
        int n;
        Companion = new Companion(null);
        int n2 = 0;
        Expression[] expressionArray = new Expression[512];
        while (n2 < 512) {
            n = n2++;
            expressionArray[n] = new Expression(n);
        }
        constSmallInts = expressionArray;
        n2 = 0;
        expressionArray = new Expression[512];
        while (n2 < 512) {
            n = n2++;
            expressionArray[n] = new Expression(Float.valueOf((float)n / 20.0f));
        }
        constSmallFloats = expressionArray;
        constBlack = new Expression(Color.box-impl((long)Color.Companion.getBlack-0d7_KjU()));
        constWhite = new Expression(Color.box-impl((long)Color.Companion.getWhite-0d7_KjU()));
        constTransparent = new Expression(Color.box-impl((long)Color.Companion.getTransparent-0d7_KjU()));
        constFalse = new Expression(false);
        constTrue = new Expression(true);
        constNull = new Expression(null);
        constZeroOffset = new Expression(Offset.box-impl((long)Offset.Companion.getZero-F1C5BW0()));
        constZeroPadding = new Expression(UtilsKt.getZeroPadding());
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00062\u0006\u0010\u0019\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u001aJ\f\u0010\u001b\u001a\u00020\u000f*\u00020\u001cH\u0002J\u001b\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u001e\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001fJ\u001d\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00062\u0006\u0010\"\u001a\u00020!H\u0000\u00a2\u0006\u0004\b#\u0010$J\u001d\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\u0006\u0010&\u001a\u00020\u000bH\u0000\u00a2\u0006\u0004\b'\u0010(J\u001b\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00062\u0006\u0010*\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b+J\u0015\u0010,\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0006H\u0000\u00a2\u0006\u0002\b-J\u001d\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00140\u00062\u0006\u0010/\u001a\u00020\u0014H\u0000\u00a2\u0006\u0004\b0\u0010(J\u001d\u00101\u001a\b\u0012\u0004\u0012\u0002020\u00062\u0006\u00103\u001a\u000202H\u0000\u00a2\u0006\u0004\b4\u0010(J'\u00105\u001a\b\u0012\u0004\u0012\u0002H60\u0006\"\b\b\u0001\u00106*\u0002072\u0006\u00108\u001a\u0002H6H\u0000\u00a2\u0006\u0004\b9\u0010:J\u001b\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00160\u00062\u0006\u0010<\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b=J#\u0010>\u001a\u0006\u0012\u0002\b\u00030\u00062\u0010\u0010?\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060@H\u0000\u00a2\u0006\u0002\bAJ)\u0010B\u001a\u0006\u0012\u0002\b\u00030\u00062\u0016\u0010C\u001a\u0012\u0012\u0004\u0012\u00020\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060DH\u0000\u00a2\u0006\u0002\bER\u001c\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u001c\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Ldev/sargunv/maplibrecompose/core/expression/Expression$Companion;", "Ldev/sargunv/maplibrecompose/core/expression/ExpressionScope;", "<init>", "()V", "constSmallInts", "", "Ldev/sargunv/maplibrecompose/core/expression/Expression;", "", "[Ldev/sargunv/maplibrecompose/core/expression/Expression;", "constSmallFloats", "constBlack", "Landroidx/compose/ui/graphics/Color;", "constWhite", "constTransparent", "constFalse", "", "constTrue", "constNull", "", "constZeroOffset", "Landroidx/compose/ui/geometry/Offset;", "constZeroPadding", "Landroidx/compose/foundation/layout/PaddingValues$Absolute;", "ofString", "", "string", "ofString$maplibre_compose_release", "isSmallInt", "", "ofFloat", "float", "ofFloat$maplibre_compose_release", "ofDp", "Landroidx/compose/ui/unit/Dp;", "dp", "ofDp-0680j_4$maplibre_compose_release", "(F)Ldev/sargunv/maplibrecompose/core/expression/Expression;", "ofColor", "color", "ofColor-8_81llA$maplibre_compose_release", "(J)Ldev/sargunv/maplibrecompose/core/expression/Expression;", "ofBoolean", "bool", "ofBoolean$maplibre_compose_release", "ofNull", "ofNull$maplibre_compose_release", "ofOffset", "offset", "ofOffset-k-4lQ0M$maplibre_compose_release", "ofDpOffset", "Landroidx/compose/ui/unit/DpOffset;", "dpOffset", "ofDpOffset-jo-Fl9I$maplibre_compose_release", "ofLayerPropertyEnum", "T", "Ldev/sargunv/maplibrecompose/core/expression/LayerPropertyEnum;", "enum", "ofLayerPropertyEnum$maplibre_compose_release", "(Ldev/sargunv/maplibrecompose/core/expression/LayerPropertyEnum;)Ldev/sargunv/maplibrecompose/core/expression/Expression;", "ofPadding", "padding", "ofPadding$maplibre_compose_release", "ofList", "list", "", "ofList$maplibre_compose_release", "ofMap", "map", "", "ofMap$maplibre_compose_release", "maplibre-compose_release"})
    @SourceDebugExtension(value={"SMAP\nExpression.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Expression.kt\ndev/sargunv/maplibrecompose/core/expression/Expression$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1557#2:83\n1628#2,3:84\n1187#2,2:87\n1261#2,4:89\n*S KotlinDebug\n*F\n+ 1 Expression.kt\ndev/sargunv/maplibrecompose/core/expression/Expression$Companion\n*L\n75#1:83\n75#1:84,3\n79#1:87,2\n79#1:89,4\n*E\n"})
    public static final class Companion
    implements ExpressionScope {
        private Companion() {
        }

        @NotNull
        public final Expression<String> ofString$maplibre_compose_release(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            return new Expression<String>(string, null);
        }

        private final boolean isSmallInt(float $this$isSmallInt) {
            return $this$isSmallInt >= 0.0f && $this$isSmallInt < (float)constSmallInts.length && (float)((int)$this$isSmallInt) == $this$isSmallInt;
        }

        @NotNull
        public final Expression<Number> ofFloat$maplibre_compose_release(float f) {
            return this.isSmallInt(f) ? constSmallInts[(int)f] : (this.isSmallInt(f * 20.0f) ? constSmallFloats[(int)(f * 20.0f)] : new Expression(Float.valueOf(f), null));
        }

        @NotNull
        public final Expression<Dp> ofDp-0680j_4$maplibre_compose_release(float dp) {
            Expression<Number> expression = this.ofFloat$maplibre_compose_release(dp);
            Intrinsics.checkNotNull(expression, (String)"null cannot be cast to non-null type dev.sargunv.maplibrecompose.core.expression.Expression<androidx.compose.ui.unit.Dp>");
            return expression;
        }

        @NotNull
        public final Expression<Color> ofColor-8_81llA$maplibre_compose_release(long color) {
            long l = color;
            return Color.equals-impl0((long)l, (long)Color.Companion.getTransparent-0d7_KjU()) ? constTransparent : (Color.equals-impl0((long)l, (long)Color.Companion.getBlack-0d7_KjU()) ? constBlack : (Color.equals-impl0((long)l, (long)Color.Companion.getWhite-0d7_KjU()) ? constWhite : new Expression(Color.box-impl((long)color), null)));
        }

        @NotNull
        public final Expression<Boolean> ofBoolean$maplibre_compose_release(boolean bool) {
            return bool ? constTrue : constFalse;
        }

        @NotNull
        public final Expression ofNull$maplibre_compose_release() {
            return constNull;
        }

        @NotNull
        public final Expression<Offset> ofOffset-k-4lQ0M$maplibre_compose_release(long offset) {
            return Offset.equals-impl0((long)offset, (long)Offset.Companion.getZero-F1C5BW0()) ? constZeroOffset : new Expression(Offset.box-impl((long)offset), null);
        }

        @NotNull
        public final Expression<DpOffset> ofDpOffset-jo-Fl9I$maplibre_compose_release(long dpOffset) {
            Expression expression = DpOffset.equals-impl0((long)dpOffset, (long)DpOffset.Companion.getZero-RKDOV3M()) ? constZeroOffset : new Expression(Offset.box-impl((long)OffsetKt.Offset((float)DpOffset.getX-D9Ej5fM((long)dpOffset), (float)DpOffset.getY-D9Ej5fM((long)dpOffset))), null);
            Intrinsics.checkNotNull((Object)expression, (String)"null cannot be cast to non-null type dev.sargunv.maplibrecompose.core.expression.Expression<androidx.compose.ui.unit.DpOffset>");
            return expression;
        }

        @NotNull
        public final <T extends LayerPropertyEnum> Expression<T> ofLayerPropertyEnum$maplibre_compose_release(@NotNull T t) {
            Intrinsics.checkNotNullParameter(t, (String)"enum");
            Expression<String> expression = t.getExpr();
            Intrinsics.checkNotNull(expression, (String)"null cannot be cast to non-null type dev.sargunv.maplibrecompose.core.expression.Expression<T of dev.sargunv.maplibrecompose.core.expression.Expression.Companion.ofLayerPropertyEnum>");
            return expression;
        }

        @NotNull
        public final Expression<PaddingValues.Absolute> ofPadding$maplibre_compose_release(@NotNull PaddingValues.Absolute padding) {
            Intrinsics.checkNotNullParameter((Object)padding, (String)"padding");
            return Intrinsics.areEqual((Object)padding, (Object)UtilsKt.getZeroPadding()) ? constZeroPadding : new Expression(padding, null);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Expression<?> ofList$maplibre_compose_release(@NotNull List<? extends Expression<?>> list) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(list, (String)"list");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Expression expression = (Expression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getValue$maplibre_compose_release());
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            List list2 = (List)destination$iv$iv;
            return new Expression(list2, defaultConstructorMarker);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Expression<?> ofMap$maplibre_compose_release(@NotNull Map<String, ? extends Expression<?>> map) {
            void $this$associateTo$iv$iv;
            Intrinsics.checkNotNullParameter(map, (String)"map");
            Iterable $this$associate$iv = map.entrySet();
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv;
                boolean bl = false;
                String key = (String)entry.getKey();
                Expression value = (Expression)entry.getValue();
                entry = TuplesKt.to((Object)key, (Object)value.getValue$maplibre_compose_release());
                map2.put(entry.getFirst(), entry.getSecond());
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            Map map3 = destination$iv$iv;
            return new Expression(map3, defaultConstructorMarker);
        }

        @Override
        @NotNull
        public Expression<String> const(@NotNull String string) {
            return ExpressionScope.DefaultImpls.const((ExpressionScope)this, string);
        }

        @Override
        @NotNull
        public <T extends LayerPropertyEnum> Expression<T> const(@NotNull T value) {
            return ExpressionScope.DefaultImpls.const((ExpressionScope)this, value);
        }

        @Override
        @NotNull
        public Expression<Number> const(float f) {
            return ExpressionScope.DefaultImpls.const((ExpressionScope)this, f);
        }

        @Override
        @NotNull
        public Expression<Dp> const-0680j_4(float dp) {
            return ExpressionScope.DefaultImpls.const-0680j_4(this, dp);
        }

        @Override
        @NotNull
        public Expression<Boolean> const(boolean bool) {
            return ExpressionScope.DefaultImpls.const((ExpressionScope)this, bool);
        }

        @Override
        @NotNull
        public Expression<Color> const-8_81llA(long color) {
            return ExpressionScope.DefaultImpls.const-8_81llA(this, color);
        }

        @Override
        @NotNull
        public Expression<Offset> const-k-4lQ0M(long offset) {
            return ExpressionScope.DefaultImpls.const-k-4lQ0M(this, offset);
        }

        @Override
        @NotNull
        public Expression<DpOffset> const-jo-Fl9I(long dpOffset) {
            return ExpressionScope.DefaultImpls.const-jo-Fl9I(this, dpOffset);
        }

        @Override
        @NotNull
        public Expression<PaddingValues.Absolute> const(@NotNull PaddingValues.Absolute padding) {
            return ExpressionScope.DefaultImpls.const((ExpressionScope)this, padding);
        }

        @Override
        @NotNull
        public <T> Expression<T> nil() {
            return ExpressionScope.DefaultImpls.nil(this);
        }

        @Override
        @NotNull
        public Expression<Dp> getDp(@NotNull Expression<? extends Number> $this$dp) {
            return ExpressionScope.DefaultImpls.getDp(this, $this$dp);
        }

        @Override
        @NotNull
        public Expression<Number> getValue(@NotNull Expression<Dp> $this$value) {
            return ExpressionScope.DefaultImpls.getValue(this, $this$value);
        }

        @Override
        @NotNull
        public <T> Expression<T> let(@NotNull String name, @NotNull Expression<?> value, @NotNull Expression<? extends T> expression) {
            return ExpressionScope.DefaultImpls.let(this, name, value, expression);
        }

        @Override
        @NotNull
        public <T> Expression<T> var(@NotNull String name) {
            return ExpressionScope.DefaultImpls.var(this, name);
        }

        @Override
        @NotNull
        public <T> Expression<List<T>> literal(@NotNull List<? extends Expression<? extends T>> values) {
            return ExpressionScope.DefaultImpls.literal((ExpressionScope)this, values);
        }

        @Override
        @NotNull
        public <T> Expression<Map<String, T>> literal(@NotNull Map<String, ? extends Expression<? extends T>> values) {
            return ExpressionScope.DefaultImpls.literal((ExpressionScope)this, values);
        }

        @Override
        @NotNull
        public <T> Expression<List<T>> array(@NotNull Expression<?> value, @Nullable Expression<String> type, @Nullable Expression<? extends Number> length) {
            return ExpressionScope.DefaultImpls.array(this, value, type, length);
        }

        @Override
        @NotNull
        public Expression<String> typeof(@NotNull Expression<?> expression) {
            return ExpressionScope.DefaultImpls.typeof(this, expression);
        }

        @Override
        @NotNull
        public Expression<String> string(@NotNull Expression<?> value, Expression<?> ... fallbacks) {
            return ExpressionScope.DefaultImpls.string(this, value, fallbacks);
        }

        @Override
        @NotNull
        public Expression<Number> number(@NotNull Expression<?> value, Expression<?> ... fallbacks) {
            return ExpressionScope.DefaultImpls.number(this, value, fallbacks);
        }

        @Override
        @NotNull
        public Expression<Boolean> boolean(@NotNull Expression<?> value, Expression<?> ... fallbacks) {
            return ExpressionScope.DefaultImpls.boolean(this, value, fallbacks);
        }

        @Override
        @NotNull
        public <T> Expression<Map<String, T>> object(@NotNull Expression<?> value, Expression<?> ... fallbacks) {
            return ExpressionScope.DefaultImpls.object(this, value, fallbacks);
        }

        @Override
        @NotNull
        public Expression<TCollator> collator(@Nullable Expression<Boolean> caseSensitive, @Nullable Expression<Boolean> diacriticSensitive, @Nullable Expression<String> locale) {
            return ExpressionScope.DefaultImpls.collator(this, caseSensitive, diacriticSensitive, locale);
        }

        @Override
        @NotNull
        public Expression<TFormatted> format(Pair<? extends Expression<?>, ExpressionScope.FormatStyle> ... sections) {
            return ExpressionScope.DefaultImpls.format((ExpressionScope)this, sections);
        }

        @Override
        @NotNull
        public Expression<TFormatted> format(@NotNull Expression<String> value) {
            return ExpressionScope.DefaultImpls.format((ExpressionScope)this, value);
        }

        @Override
        @NotNull
        public Expression<TResolvedImage> image(@NotNull Expression<String> value) {
            return ExpressionScope.DefaultImpls.image(this, value);
        }

        @Override
        @NotNull
        public Expression<String> numberFormat(@NotNull Expression<? extends Number> number, @Nullable Expression<String> locale, @Nullable Expression<String> currency, @Nullable Expression<? extends Number> minFractionDigits, @Nullable Expression<? extends Number> maxFractionDigits) {
            return ExpressionScope.DefaultImpls.numberFormat(this, number, locale, currency, minFractionDigits, maxFractionDigits);
        }

        @Override
        @NotNull
        public Expression<String> toString(@NotNull Expression<?> value) {
            return ExpressionScope.DefaultImpls.toString(this, value);
        }

        @Override
        @NotNull
        public Expression<Number> toNumber(@NotNull Expression<?> value, Expression<?> ... fallbacks) {
            return ExpressionScope.DefaultImpls.toNumber(this, value, fallbacks);
        }

        @Override
        @NotNull
        public Expression<Boolean> toBoolean(@NotNull Expression<?> value) {
            return ExpressionScope.DefaultImpls.toBoolean(this, value);
        }

        @Override
        @NotNull
        public Expression<Color> toColor(@NotNull Expression<?> value, Expression<?> ... fallbacks) {
            return ExpressionScope.DefaultImpls.toColor(this, value, fallbacks);
        }

        @Override
        @NotNull
        public <T> Expression<T> at(@NotNull Expression<? extends Number> index, @NotNull Expression<? extends List<? extends T>> array) {
            return ExpressionScope.DefaultImpls.at(this, index, array);
        }

        @Override
        @JvmName(name="getAtIndex")
        @NotNull
        public <T> Expression<T> getAtIndex(@NotNull Expression<? extends List<? extends T>> $this$get, @NotNull Expression<? extends Number> index) {
            return ExpressionScope.DefaultImpls.getAtIndex(this, $this$get, index);
        }

        @Override
        @NotNull
        public <T> Expression<T> get(@NotNull Expression<String> key, @Nullable Expression<? extends Map<String, ?>> obj) {
            return ExpressionScope.DefaultImpls.get(this, key, obj);
        }

        @Override
        @JvmName(name="inList")
        @NotNull
        public Expression<Boolean> inList(@NotNull Expression<?> needle, @NotNull Expression<? extends List<?>> haystack) {
            return ExpressionScope.DefaultImpls.inList(this, needle, haystack);
        }

        @Override
        @JvmName(name="inString")
        @NotNull
        public Expression<Boolean> inString(@NotNull Expression<String> needle, @NotNull Expression<String> haystack) {
            return ExpressionScope.DefaultImpls.inString(this, needle, haystack);
        }

        @Override
        @JvmName(name="inListInfix")
        @NotNull
        public Expression<Boolean> inListInfix(@NotNull Expression<?> $this$in, @NotNull Expression<? extends List<?>> other) {
            return ExpressionScope.DefaultImpls.inListInfix(this, $this$in, other);
        }

        @Override
        @JvmName(name="inStringInfix")
        @NotNull
        public Expression<Boolean> inStringInfix(@NotNull Expression<String> $this$in, @NotNull Expression<String> other) {
            return ExpressionScope.DefaultImpls.inStringInfix(this, $this$in, other);
        }

        @Override
        @NotNull
        public Expression<Number> indexOf(@NotNull Expression<?> value, @NotNull Expression<? extends List<?>> array, @Nullable Expression<? extends Number> start) {
            return ExpressionScope.DefaultImpls.indexOf(this, value, array, start);
        }

        @Override
        @JvmName(name="sliceString")
        @NotNull
        public Expression<String> sliceString(@NotNull Expression<String> value, @NotNull Expression<? extends Number> start, @Nullable Expression<? extends Number> length) {
            return ExpressionScope.DefaultImpls.sliceString(this, value, start, length);
        }

        @Override
        @JvmName(name="sliceList")
        @NotNull
        public <T> Expression<T> sliceList(@NotNull Expression<? extends List<? extends T>> value, @NotNull Expression<? extends Number> start, @Nullable Expression<? extends Number> length) {
            return ExpressionScope.DefaultImpls.sliceList(this, value, start, length);
        }

        @Override
        @NotNull
        public Expression<Boolean> has(@NotNull Expression<String> key, @Nullable Expression<? extends Map<String, ?>> obj) {
            return ExpressionScope.DefaultImpls.has(this, key, obj);
        }

        @Override
        @JvmName(name="lengthOfString")
        @NotNull
        public Expression<Number> lengthOfString(@NotNull Expression<String> value) {
            return ExpressionScope.DefaultImpls.lengthOfString(this, value);
        }

        @Override
        @JvmName(name="lengthOfList")
        @NotNull
        public Expression<Number> lengthOfList(@NotNull Expression<? extends List<?>> value) {
            return ExpressionScope.DefaultImpls.lengthOfList(this, value);
        }

        @Override
        @NotNull
        public <T> Expression<T> case(@NotNull ExpressionScope.CaseBranch<T>[] branches, @NotNull Expression<? extends T> fallback) {
            return ExpressionScope.DefaultImpls.case(this, branches, fallback);
        }

        @Override
        @NotNull
        public <Output> ExpressionScope.CaseBranch<Output> then(@NotNull Expression<Boolean> $this$then, @NotNull Expression<? extends Output> output) {
            return ExpressionScope.DefaultImpls.then((ExpressionScope)this, $this$then, output);
        }

        @Override
        @NotNull
        public <Output> ExpressionScope.MatchBranch<String, Output> then(@NotNull String $this$then, @NotNull Expression<? extends Output> output) {
            return ExpressionScope.DefaultImpls.then((ExpressionScope)this, $this$then, output);
        }

        @Override
        @NotNull
        public <Output> ExpressionScope.MatchBranch<Number, Output> then(@NotNull Number $this$then, @NotNull Expression<? extends Output> output) {
            return ExpressionScope.DefaultImpls.then((ExpressionScope)this, $this$then, output);
        }

        @Override
        @JvmName(name="stringsThen")
        @NotNull
        public <Output> ExpressionScope.MatchBranch<String, Output> stringsThen(@NotNull List<String> $this$then, @NotNull Expression<? extends Output> output) {
            return ExpressionScope.DefaultImpls.stringsThen(this, $this$then, output);
        }

        @Override
        @JvmName(name="numbersThen")
        @NotNull
        public <Output> ExpressionScope.MatchBranch<Number, Output> numbersThen(@NotNull List<? extends Number> $this$then, @NotNull Expression<? extends Output> output) {
            return ExpressionScope.DefaultImpls.numbersThen(this, $this$then, output);
        }

        @Override
        @JvmName(name="matchStrings")
        @NotNull
        public <T> Expression<T> matchStrings(@NotNull Expression<String> input, @NotNull Expression<? extends T> fallback, ExpressionScope.MatchBranch<String, T> ... branches) {
            return ExpressionScope.DefaultImpls.matchStrings(this, input, fallback, branches);
        }

        @Override
        @JvmName(name="matchNumbers")
        @NotNull
        public <T> Expression<T> matchNumbers(@NotNull Expression<? extends Number> input, @NotNull Expression<? extends T> fallback, ExpressionScope.MatchBranch<Number, T> ... branches) {
            return ExpressionScope.DefaultImpls.matchNumbers(this, input, fallback, branches);
        }

        @Override
        @NotNull
        public <T> Expression<T> coalesce(Expression<? extends T> ... values) {
            return ExpressionScope.DefaultImpls.coalesce(this, values);
        }

        @Override
        @NotNull
        public Expression<Boolean> eq(@NotNull Expression<?> $this$eq, @NotNull Expression<?> other) {
            return ExpressionScope.DefaultImpls.eq(this, $this$eq, other);
        }

        @Override
        @NotNull
        public Expression<Boolean> eq(@NotNull Expression<String> left, @NotNull Expression<String> right, @Nullable Expression<? extends TCollator> collator) {
            return ExpressionScope.DefaultImpls.eq(this, left, right, collator);
        }

        @Override
        @NotNull
        public Expression<Boolean> neq(@NotNull Expression<?> $this$neq, @NotNull Expression<?> other) {
            return ExpressionScope.DefaultImpls.neq(this, $this$neq, other);
        }

        @Override
        @NotNull
        public Expression<Boolean> neq(@NotNull Expression<String> left, @NotNull Expression<String> right, @Nullable Expression<? extends TCollator> collator) {
            return ExpressionScope.DefaultImpls.neq(this, left, right, collator);
        }

        @Override
        @JvmName(name="gtNumber")
        @NotNull
        public Expression<Boolean> gtNumber(@NotNull Expression<? extends Number> $this$gt, @NotNull Expression<? extends Number> other) {
            return ExpressionScope.DefaultImpls.gtNumber(this, $this$gt, other);
        }

        @Override
        @JvmName(name="gtDp")
        @NotNull
        public Expression<Boolean> gtDp(@NotNull Expression<Dp> $this$gt, @NotNull Expression<Dp> other) {
            return ExpressionScope.DefaultImpls.gtDp(this, $this$gt, other);
        }

        @Override
        @JvmName(name="gtString")
        @NotNull
        public Expression<Boolean> gtString(@NotNull Expression<String> $this$gt, @NotNull Expression<String> other) {
            return ExpressionScope.DefaultImpls.gtString(this, $this$gt, other);
        }

        @Override
        @NotNull
        public Expression<Boolean> gt(@NotNull Expression<String> left, @NotNull Expression<String> right, @Nullable Expression<? extends TCollator> collator) {
            return ExpressionScope.DefaultImpls.gt(this, left, right, collator);
        }

        @Override
        @JvmName(name="ltNumber")
        @NotNull
        public Expression<Boolean> ltNumber(@NotNull Expression<? extends Number> $this$lt, @NotNull Expression<? extends Number> other) {
            return ExpressionScope.DefaultImpls.ltNumber(this, $this$lt, other);
        }

        @Override
        @JvmName(name="ltDp")
        @NotNull
        public Expression<Boolean> ltDp(@NotNull Expression<Dp> $this$lt, @NotNull Expression<Dp> other) {
            return ExpressionScope.DefaultImpls.ltDp(this, $this$lt, other);
        }

        @Override
        @JvmName(name="ltString")
        @NotNull
        public Expression<Boolean> ltString(@NotNull Expression<String> $this$lt, @NotNull Expression<String> other) {
            return ExpressionScope.DefaultImpls.ltString(this, $this$lt, other);
        }

        @Override
        @NotNull
        public Expression<Boolean> lt(@NotNull Expression<String> left, @NotNull Expression<String> right, @Nullable Expression<? extends TCollator> collator) {
            return ExpressionScope.DefaultImpls.lt(this, left, right, collator);
        }

        @Override
        @JvmName(name="gteNumber")
        @NotNull
        public Expression<Boolean> gteNumber(@NotNull Expression<? extends Number> $this$gte, @NotNull Expression<? extends Number> other) {
            return ExpressionScope.DefaultImpls.gteNumber(this, $this$gte, other);
        }

        @Override
        @JvmName(name="gteDp")
        @NotNull
        public Expression<Boolean> gteDp(@NotNull Expression<Dp> $this$gte, @NotNull Expression<Dp> other) {
            return ExpressionScope.DefaultImpls.gteDp(this, $this$gte, other);
        }

        @Override
        @JvmName(name="gteString")
        @NotNull
        public Expression<Boolean> gteString(@NotNull Expression<String> $this$gte, @NotNull Expression<String> other) {
            return ExpressionScope.DefaultImpls.gteString(this, $this$gte, other);
        }

        @Override
        @NotNull
        public Expression<Boolean> gte(@NotNull Expression<String> left, @NotNull Expression<String> right, @Nullable Expression<? extends TCollator> collator) {
            return ExpressionScope.DefaultImpls.gte(this, left, right, collator);
        }

        @Override
        @JvmName(name="lteNumber")
        @NotNull
        public Expression<Boolean> lteNumber(@NotNull Expression<? extends Number> $this$lte, @NotNull Expression<? extends Number> other) {
            return ExpressionScope.DefaultImpls.lteNumber(this, $this$lte, other);
        }

        @Override
        @JvmName(name="lteDp")
        @NotNull
        public Expression<Boolean> lteDp(@NotNull Expression<Dp> $this$lte, @NotNull Expression<Dp> other) {
            return ExpressionScope.DefaultImpls.lteDp(this, $this$lte, other);
        }

        @Override
        @JvmName(name="lteString")
        @NotNull
        public Expression<Boolean> lteString(@NotNull Expression<String> $this$lte, @NotNull Expression<String> other) {
            return ExpressionScope.DefaultImpls.lteString(this, $this$lte, other);
        }

        @Override
        @NotNull
        public Expression<Boolean> lte(@NotNull Expression<String> left, @NotNull Expression<String> right, @Nullable Expression<? extends TCollator> collator) {
            return ExpressionScope.DefaultImpls.lte(this, left, right, collator);
        }

        @Override
        @NotNull
        public Expression<Boolean> all(Expression<Boolean> ... expressions) {
            return ExpressionScope.DefaultImpls.all(this, expressions);
        }

        @Override
        @NotNull
        public Expression<Boolean> any(Expression<Boolean> ... expressions) {
            return ExpressionScope.DefaultImpls.any(this, expressions);
        }

        @Override
        @NotNull
        public Expression<Boolean> not(@NotNull Expression<Boolean> expression) {
            return ExpressionScope.DefaultImpls.not(this, expression);
        }

        @Override
        @JvmName(name="notOperator")
        @NotNull
        public Expression<Boolean> notOperator(@NotNull Expression<Boolean> $this$not) {
            return ExpressionScope.DefaultImpls.notOperator(this, $this$not);
        }

        @Override
        @NotNull
        public Expression<Boolean> within(@NotNull Expression<? extends Geometry> geometry) {
            return ExpressionScope.DefaultImpls.within(this, geometry);
        }

        @Override
        @NotNull
        public <Output> Expression<Output> step(@NotNull Expression<? extends Number> input, @NotNull Expression<? extends Output> fallback, Pair<? extends Number, ? extends Expression<? extends Output>> ... stops) {
            return ExpressionScope.DefaultImpls.step(this, input, fallback, stops);
        }

        @Override
        @NotNull
        public <Output> Expression<Output> interpolate(@NotNull Expression<? extends TInterpolationType> type, @NotNull Expression<? extends Number> input, Pair<? extends Number, ? extends Expression<? extends Output>> ... stops) {
            return ExpressionScope.DefaultImpls.interpolate(this, type, input, stops);
        }

        @Override
        @NotNull
        public Expression<Color> interpolateHcl(@NotNull Expression<? extends TInterpolationType> type, @NotNull Expression<? extends Number> input, Pair<? extends Number, Expression<Color>> ... stops) {
            return ExpressionScope.DefaultImpls.interpolateHcl(this, type, input, stops);
        }

        @Override
        @NotNull
        public Expression<Color> interpolateLab(@NotNull Expression<? extends TInterpolationType> type, @NotNull Expression<? extends Number> input, Pair<? extends Number, Expression<Color>> ... stops) {
            return ExpressionScope.DefaultImpls.interpolateLab(this, type, input, stops);
        }

        @Override
        @NotNull
        public Expression<TInterpolationType> exponential(@NotNull Expression<? extends Number> base) {
            return ExpressionScope.DefaultImpls.exponential(this, base);
        }

        @Override
        @NotNull
        public Expression<TInterpolationType> linear() {
            return ExpressionScope.DefaultImpls.linear(this);
        }

        @Override
        @NotNull
        public Expression<TInterpolationType> cubicBezier(@NotNull Expression<? extends Number> x1, @NotNull Expression<? extends Number> y1, @NotNull Expression<? extends Number> x2, @NotNull Expression<? extends Number> y2) {
            return ExpressionScope.DefaultImpls.cubicBezier(this, x1, y1, x2, y2);
        }

        @Override
        @NotNull
        public Expression<Number> ln2() {
            return ExpressionScope.DefaultImpls.ln2(this);
        }

        @Override
        @NotNull
        public Expression<Number> pi() {
            return ExpressionScope.DefaultImpls.pi(this);
        }

        @Override
        @NotNull
        public Expression<Number> e() {
            return ExpressionScope.DefaultImpls.e(this);
        }

        @Override
        @NotNull
        public Expression<Number> sum(Expression<? extends Number> ... numbers) {
            return ExpressionScope.DefaultImpls.sum(this, numbers);
        }

        @Override
        @JvmName(name="sumDp")
        @NotNull
        public Expression<Dp> sumDp(Expression<Dp> ... numbers) {
            return ExpressionScope.DefaultImpls.sumDp(this, numbers);
        }

        @Override
        @NotNull
        public Expression<Number> product(Expression<? extends Number> ... numbers) {
            return ExpressionScope.DefaultImpls.product(this, numbers);
        }

        @Override
        @JvmName(name="productDp")
        @NotNull
        public Expression<Dp> productDp(Expression<Dp> ... numbers) {
            return ExpressionScope.DefaultImpls.productDp(this, numbers);
        }

        @Override
        @NotNull
        public Expression<Number> plus(@NotNull Expression<? extends Number> $this$plus, @NotNull Expression<? extends Number> other) {
            return ExpressionScope.DefaultImpls.plus(this, $this$plus, other);
        }

        @Override
        @JvmName(name="plusDp")
        @NotNull
        public Expression<Dp> plusDp(@NotNull Expression<Dp> $this$plus, @NotNull Expression<Dp> other) {
            return ExpressionScope.DefaultImpls.plusDp(this, $this$plus, other);
        }

        @Override
        @NotNull
        public Expression<Number> times(@NotNull Expression<? extends Number> $this$times, @NotNull Expression<? extends Number> other) {
            return ExpressionScope.DefaultImpls.times(this, $this$times, other);
        }

        @Override
        @JvmName(name="timesDp")
        @NotNull
        public Expression<Dp> timesDp(@NotNull Expression<Dp> $this$times, @NotNull Expression<Dp> other) {
            return ExpressionScope.DefaultImpls.timesDp(this, $this$times, other);
        }

        @Override
        @NotNull
        public Expression<Number> minus(@NotNull Expression<? extends Number> $this$minus, @NotNull Expression<? extends Number> other) {
            return ExpressionScope.DefaultImpls.minus(this, $this$minus, other);
        }

        @Override
        @JvmName(name="minusDp")
        @NotNull
        public Expression<Dp> minusDp(@NotNull Expression<Dp> $this$minus, @NotNull Expression<Dp> other) {
            return ExpressionScope.DefaultImpls.minusDp(this, $this$minus, other);
        }

        @Override
        @NotNull
        public Expression<Number> unaryMinus(@NotNull Expression<? extends Number> $this$unaryMinus) {
            return ExpressionScope.DefaultImpls.unaryMinus(this, $this$unaryMinus);
        }

        @Override
        @JvmName(name="unaryMinusDp")
        @NotNull
        public Expression<Dp> unaryMinusDp(@NotNull Expression<Dp> $this$unaryMinus) {
            return ExpressionScope.DefaultImpls.unaryMinusDp(this, $this$unaryMinus);
        }

        @Override
        @NotNull
        public Expression<Number> div(@NotNull Expression<? extends Number> $this$div, @NotNull Expression<? extends Number> b) {
            return ExpressionScope.DefaultImpls.div(this, $this$div, b);
        }

        @Override
        @JvmName(name="divDp")
        @NotNull
        public Expression<Dp> divDp(@NotNull Expression<Dp> $this$div, @NotNull Expression<Dp> b) {
            return ExpressionScope.DefaultImpls.divDp(this, $this$div, b);
        }

        @Override
        @NotNull
        public Expression<Number> rem(@NotNull Expression<? extends Number> $this$rem, @NotNull Expression<? extends Number> b) {
            return ExpressionScope.DefaultImpls.rem(this, $this$rem, b);
        }

        @Override
        @JvmName(name="remDp")
        @NotNull
        public Expression<Dp> remDp(@NotNull Expression<Dp> $this$rem, @NotNull Expression<Dp> b) {
            return ExpressionScope.DefaultImpls.remDp(this, $this$rem, b);
        }

        @Override
        @NotNull
        public Expression<Number> pow(@NotNull Expression<? extends Number> $this$pow, @NotNull Expression<? extends Number> exponent) {
            return ExpressionScope.DefaultImpls.pow(this, $this$pow, exponent);
        }

        @Override
        @NotNull
        public Expression<Number> sqrt(@NotNull Expression<? extends Number> value) {
            return ExpressionScope.DefaultImpls.sqrt(this, value);
        }

        @Override
        @NotNull
        public Expression<Number> log10(@NotNull Expression<? extends Number> value) {
            return ExpressionScope.DefaultImpls.log10(this, value);
        }

        @Override
        @NotNull
        public Expression<Number> ln(@NotNull Expression<? extends Number> value) {
            return ExpressionScope.DefaultImpls.ln(this, value);
        }

        @Override
        @NotNull
        public Expression<Number> log2(@NotNull Expression<? extends Number> value) {
            return ExpressionScope.DefaultImpls.log2(this, value);
        }

        @Override
        @NotNull
        public Expression<Number> sin(@NotNull Expression<? extends Number> value) {
            return ExpressionScope.DefaultImpls.sin(this, value);
        }

        @Override
        @NotNull
        public Expression<Number> cos(@NotNull Expression<? extends Number> value) {
            return ExpressionScope.DefaultImpls.cos(this, value);
        }

        @Override
        @NotNull
        public Expression<Number> tan(@NotNull Expression<? extends Number> value) {
            return ExpressionScope.DefaultImpls.tan(this, value);
        }

        @Override
        @NotNull
        public Expression<Number> asin(@NotNull Expression<? extends Number> value) {
            return ExpressionScope.DefaultImpls.asin(this, value);
        }

        @Override
        @NotNull
        public Expression<Number> acos(@NotNull Expression<? extends Number> value) {
            return ExpressionScope.DefaultImpls.acos(this, value);
        }

        @Override
        @NotNull
        public Expression<Number> atan(@NotNull Expression<? extends Number> value) {
            return ExpressionScope.DefaultImpls.atan(this, value);
        }

        @Override
        @NotNull
        public Expression<Number> min(Expression<? extends Number> ... numbers) {
            return ExpressionScope.DefaultImpls.min(this, numbers);
        }

        @Override
        @JvmName(name="minDp")
        @NotNull
        public Expression<Dp> minDp(Expression<Dp> ... numbers) {
            return ExpressionScope.DefaultImpls.minDp(this, numbers);
        }

        @Override
        @NotNull
        public Expression<Number> max(Expression<? extends Number> ... numbers) {
            return ExpressionScope.DefaultImpls.max(this, numbers);
        }

        @Override
        @JvmName(name="maxDp")
        @NotNull
        public Expression<Dp> maxDp(Expression<Dp> ... numbers) {
            return ExpressionScope.DefaultImpls.maxDp(this, numbers);
        }

        @Override
        @NotNull
        public Expression<Number> round(@NotNull Expression<? extends Number> value) {
            return ExpressionScope.DefaultImpls.round(this, value);
        }

        @Override
        @JvmName(name="roundDp")
        @NotNull
        public Expression<Dp> roundDp(@NotNull Expression<Dp> value) {
            return ExpressionScope.DefaultImpls.roundDp(this, value);
        }

        @Override
        @NotNull
        public Expression<Number> abs(@NotNull Expression<? extends Number> value) {
            return ExpressionScope.DefaultImpls.abs(this, value);
        }

        @Override
        @JvmName(name="absDp")
        @NotNull
        public Expression<Dp> absDp(@NotNull Expression<Dp> value) {
            return ExpressionScope.DefaultImpls.absDp(this, value);
        }

        @Override
        @NotNull
        public Expression<Number> ceil(@NotNull Expression<? extends Number> value) {
            return ExpressionScope.DefaultImpls.ceil(this, value);
        }

        @Override
        @JvmName(name="ceilDp")
        @NotNull
        public Expression<Dp> ceilDp(@NotNull Expression<Dp> value) {
            return ExpressionScope.DefaultImpls.ceilDp(this, value);
        }

        @Override
        @NotNull
        public Expression<Number> floor(@NotNull Expression<? extends Number> value) {
            return ExpressionScope.DefaultImpls.floor(this, value);
        }

        @Override
        @JvmName(name="floorDp")
        @NotNull
        public Expression<Dp> floorDp(@NotNull Expression<Dp> value) {
            return ExpressionScope.DefaultImpls.floorDp(this, value);
        }

        @Override
        @NotNull
        public Expression<Number> distance(@NotNull Expression<? extends Geometry> value) {
            return ExpressionScope.DefaultImpls.distance(this, value);
        }

        @Override
        @NotNull
        public Expression<List<Number>> toRgba(@NotNull Expression<Color> color) {
            return ExpressionScope.DefaultImpls.toRgba(this, color);
        }

        @Override
        @NotNull
        public Expression<Color> rgba(@NotNull Expression<? extends Number> red, @NotNull Expression<? extends Number> green, @NotNull Expression<? extends Number> blue, @NotNull Expression<? extends Number> alpha) {
            return ExpressionScope.DefaultImpls.rgba(this, red, green, blue, alpha);
        }

        @Override
        @NotNull
        public Expression<Color> rgb(@NotNull Expression<? extends Number> red, @NotNull Expression<? extends Number> green, @NotNull Expression<? extends Number> blue) {
            return ExpressionScope.DefaultImpls.rgb(this, red, green, blue);
        }

        @Override
        @NotNull
        public <T> Expression<Map<String, T>> properties() {
            return ExpressionScope.DefaultImpls.properties(this);
        }

        @Override
        @NotNull
        public <T> Expression<T> featureState(@NotNull Expression<String> key) {
            return ExpressionScope.DefaultImpls.featureState(this, key);
        }

        @Override
        @NotNull
        public Expression<String> geometryType() {
            return ExpressionScope.DefaultImpls.geometryType(this);
        }

        @Override
        @NotNull
        public <T> Expression<T> id() {
            return ExpressionScope.DefaultImpls.id(this);
        }

        @Override
        @NotNull
        public Expression<Number> lineProgress(@NotNull Expression<? extends Number> value) {
            return ExpressionScope.DefaultImpls.lineProgress(this, value);
        }

        @Override
        @NotNull
        public <T> Expression<T> accumulated(@NotNull Expression<String> key) {
            return ExpressionScope.DefaultImpls.accumulated(this, key);
        }

        @Override
        @NotNull
        public Expression<Number> zoom() {
            return ExpressionScope.DefaultImpls.zoom(this);
        }

        @Override
        @NotNull
        public Expression<Number> heatmapDensity() {
            return ExpressionScope.DefaultImpls.heatmapDensity(this);
        }

        @Override
        @NotNull
        public Expression<Boolean> isSupportedScript(@NotNull Expression<String> script) {
            return ExpressionScope.DefaultImpls.isSupportedScript(this, script);
        }

        @Override
        @NotNull
        public Expression<String> upcase(@NotNull Expression<String> string) {
            return ExpressionScope.DefaultImpls.upcase(this, string);
        }

        @Override
        @NotNull
        public Expression<String> downcase(@NotNull Expression<String> string) {
            return ExpressionScope.DefaultImpls.downcase(this, string);
        }

        @Override
        @NotNull
        public Expression<String> concat(Expression<String> ... strings) {
            return ExpressionScope.DefaultImpls.concat(this, strings);
        }

        @Override
        @NotNull
        public Expression<String> resolvedLocale(@NotNull Expression<? extends TCollator> collator) {
            return ExpressionScope.DefaultImpls.resolvedLocale(this, collator);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

