// Generated by the protocol buffer compiler.  DO NOT EDIT!
// NO CHECKED-IN PROTOBUF GENCODE
// source: sigstore_trustroot.proto
// Protobuf Java Version: 4.28.3

package dev.sigstore.proto.trustroot.v1;

/**
 * <pre>
 * TrustedRoot describes the client's complete set of trusted entities.
 * How the TrustedRoot is populated is not specified, but can be a
 * combination of many sources such as TUF repositories, files on disk etc.
 *
 * The TrustedRoot is not meant to be used for any artifact verification, only
 * to capture the complete/global set of trusted verification materials.
 * When verifying an artifact, based on the artifact and policies, a selection
 * of keys/authorities are expected to be extracted and provided to the
 * verification function. This way the set of keys/authorities can be kept to
 * a minimal set by the policy to gain better control over what signatures
 * that are allowed.
 *
 * The embedded transparency logs, CT logs, CAs and TSAs MUST include any
 * previously used instance -- otherwise signatures made in the past cannot
 * be verified.
 *
 * All the listed instances SHOULD be sorted by the 'valid_for' in ascending
 * order, that is, the oldest instance first. Only the last instance is
 * allowed to have their 'end' timestamp unset. All previous instances MUST
 * have a closed interval of validity. The last instance MAY have a closed
 * interval. Clients MUST accept instances that overlaps in time, if not
 * clients may experience problems during rotations of verification
 * materials.
 *
 * To be able to manage planned rotations of either transparency logs or
 * certificate authorities, clienst MUST accept lists of instances where
 * the last instance have a 'valid_for' that belongs to the future.
 * This should not be a problem as clients SHOULD first seek the trust root
 * for a suitable instance before creating a per artifact trust root (that
 * is, a sub-set of the complete trust root) that is used for verification.
 * </pre>
 *
 * Protobuf type {@code dev.sigstore.trustroot.v1.TrustedRoot}
 */
@javax.annotation.Generated(value="protoc", comments="annotations:TrustedRoot.java.pb.meta")
public final class TrustedRoot extends
    com.google.protobuf.GeneratedMessage implements
    // @@protoc_insertion_point(message_implements:dev.sigstore.trustroot.v1.TrustedRoot)
    TrustedRootOrBuilder {
private static final long serialVersionUID = 0L;
  static {
    com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
      com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
      /* major= */ 4,
      /* minor= */ 28,
      /* patch= */ 3,
      /* suffix= */ "",
      TrustedRoot.class.getName());
  }
  // Use TrustedRoot.newBuilder() to construct.
  private TrustedRoot(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
    super(builder);
  }
  private TrustedRoot() {
    mediaType_ = "";
    tlogs_ = java.util.Collections.emptyList();
    certificateAuthorities_ = java.util.Collections.emptyList();
    ctlogs_ = java.util.Collections.emptyList();
    timestampAuthorities_ = java.util.Collections.emptyList();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return dev.sigstore.proto.trustroot.v1.TrustRootProto.internal_static_dev_sigstore_trustroot_v1_TrustedRoot_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return dev.sigstore.proto.trustroot.v1.TrustRootProto.internal_static_dev_sigstore_trustroot_v1_TrustedRoot_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            dev.sigstore.proto.trustroot.v1.TrustedRoot.class, dev.sigstore.proto.trustroot.v1.TrustedRoot.Builder.class);
  }

  public static final int MEDIA_TYPE_FIELD_NUMBER = 1;
  @SuppressWarnings("serial")
  private volatile java.lang.Object mediaType_ = "";
  /**
   * <pre>
   * MUST be application/vnd.dev.sigstore.trustedroot.v0.1+json
   * when encoded as JSON.
   * Clients MUST be able to process and parse content with the media
   * type defined in the old format:
   * application/vnd.dev.sigstore.trustedroot+json;version=0.1
   * </pre>
   *
   * <code>string media_type = 1;</code>
   * @return The mediaType.
   */
  @java.lang.Override
  public java.lang.String getMediaType() {
    java.lang.Object ref = mediaType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      mediaType_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * MUST be application/vnd.dev.sigstore.trustedroot.v0.1+json
   * when encoded as JSON.
   * Clients MUST be able to process and parse content with the media
   * type defined in the old format:
   * application/vnd.dev.sigstore.trustedroot+json;version=0.1
   * </pre>
   *
   * <code>string media_type = 1;</code>
   * @return The bytes for mediaType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getMediaTypeBytes() {
    java.lang.Object ref = mediaType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      mediaType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TLOGS_FIELD_NUMBER = 2;
  @SuppressWarnings("serial")
  private java.util.List<dev.sigstore.proto.trustroot.v1.TransparencyLogInstance> tlogs_;
  /**
   * <pre>
   * A set of trusted Rekor servers.
   * </pre>
   *
   * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance tlogs = 2;</code>
   */
  @java.lang.Override
  public java.util.List<dev.sigstore.proto.trustroot.v1.TransparencyLogInstance> getTlogsList() {
    return tlogs_;
  }
  /**
   * <pre>
   * A set of trusted Rekor servers.
   * </pre>
   *
   * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance tlogs = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends dev.sigstore.proto.trustroot.v1.TransparencyLogInstanceOrBuilder> 
      getTlogsOrBuilderList() {
    return tlogs_;
  }
  /**
   * <pre>
   * A set of trusted Rekor servers.
   * </pre>
   *
   * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance tlogs = 2;</code>
   */
  @java.lang.Override
  public int getTlogsCount() {
    return tlogs_.size();
  }
  /**
   * <pre>
   * A set of trusted Rekor servers.
   * </pre>
   *
   * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance tlogs = 2;</code>
   */
  @java.lang.Override
  public dev.sigstore.proto.trustroot.v1.TransparencyLogInstance getTlogs(int index) {
    return tlogs_.get(index);
  }
  /**
   * <pre>
   * A set of trusted Rekor servers.
   * </pre>
   *
   * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance tlogs = 2;</code>
   */
  @java.lang.Override
  public dev.sigstore.proto.trustroot.v1.TransparencyLogInstanceOrBuilder getTlogsOrBuilder(
      int index) {
    return tlogs_.get(index);
  }

  public static final int CERTIFICATE_AUTHORITIES_FIELD_NUMBER = 3;
  @SuppressWarnings("serial")
  private java.util.List<dev.sigstore.proto.trustroot.v1.CertificateAuthority> certificateAuthorities_;
  /**
   * <pre>
   * A set of trusted certificate authorities (e.g Fulcio), and any
   * intermediate certificates they provide.
   * If a CA is issuing multiple intermediate certificate, each
   * combination shall be represented as separate chain. I.e, a single
   * root cert may appear in multiple chains but with different
   * intermediate and/or leaf certificates.
   * The certificates are intended to be used for verifying artifact
   * signatures.
   * </pre>
   *
   * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority certificate_authorities = 3;</code>
   */
  @java.lang.Override
  public java.util.List<dev.sigstore.proto.trustroot.v1.CertificateAuthority> getCertificateAuthoritiesList() {
    return certificateAuthorities_;
  }
  /**
   * <pre>
   * A set of trusted certificate authorities (e.g Fulcio), and any
   * intermediate certificates they provide.
   * If a CA is issuing multiple intermediate certificate, each
   * combination shall be represented as separate chain. I.e, a single
   * root cert may appear in multiple chains but with different
   * intermediate and/or leaf certificates.
   * The certificates are intended to be used for verifying artifact
   * signatures.
   * </pre>
   *
   * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority certificate_authorities = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends dev.sigstore.proto.trustroot.v1.CertificateAuthorityOrBuilder> 
      getCertificateAuthoritiesOrBuilderList() {
    return certificateAuthorities_;
  }
  /**
   * <pre>
   * A set of trusted certificate authorities (e.g Fulcio), and any
   * intermediate certificates they provide.
   * If a CA is issuing multiple intermediate certificate, each
   * combination shall be represented as separate chain. I.e, a single
   * root cert may appear in multiple chains but with different
   * intermediate and/or leaf certificates.
   * The certificates are intended to be used for verifying artifact
   * signatures.
   * </pre>
   *
   * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority certificate_authorities = 3;</code>
   */
  @java.lang.Override
  public int getCertificateAuthoritiesCount() {
    return certificateAuthorities_.size();
  }
  /**
   * <pre>
   * A set of trusted certificate authorities (e.g Fulcio), and any
   * intermediate certificates they provide.
   * If a CA is issuing multiple intermediate certificate, each
   * combination shall be represented as separate chain. I.e, a single
   * root cert may appear in multiple chains but with different
   * intermediate and/or leaf certificates.
   * The certificates are intended to be used for verifying artifact
   * signatures.
   * </pre>
   *
   * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority certificate_authorities = 3;</code>
   */
  @java.lang.Override
  public dev.sigstore.proto.trustroot.v1.CertificateAuthority getCertificateAuthorities(int index) {
    return certificateAuthorities_.get(index);
  }
  /**
   * <pre>
   * A set of trusted certificate authorities (e.g Fulcio), and any
   * intermediate certificates they provide.
   * If a CA is issuing multiple intermediate certificate, each
   * combination shall be represented as separate chain. I.e, a single
   * root cert may appear in multiple chains but with different
   * intermediate and/or leaf certificates.
   * The certificates are intended to be used for verifying artifact
   * signatures.
   * </pre>
   *
   * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority certificate_authorities = 3;</code>
   */
  @java.lang.Override
  public dev.sigstore.proto.trustroot.v1.CertificateAuthorityOrBuilder getCertificateAuthoritiesOrBuilder(
      int index) {
    return certificateAuthorities_.get(index);
  }

  public static final int CTLOGS_FIELD_NUMBER = 4;
  @SuppressWarnings("serial")
  private java.util.List<dev.sigstore.proto.trustroot.v1.TransparencyLogInstance> ctlogs_;
  /**
   * <pre>
   * A set of trusted certificate transparency logs.
   * </pre>
   *
   * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance ctlogs = 4;</code>
   */
  @java.lang.Override
  public java.util.List<dev.sigstore.proto.trustroot.v1.TransparencyLogInstance> getCtlogsList() {
    return ctlogs_;
  }
  /**
   * <pre>
   * A set of trusted certificate transparency logs.
   * </pre>
   *
   * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance ctlogs = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends dev.sigstore.proto.trustroot.v1.TransparencyLogInstanceOrBuilder> 
      getCtlogsOrBuilderList() {
    return ctlogs_;
  }
  /**
   * <pre>
   * A set of trusted certificate transparency logs.
   * </pre>
   *
   * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance ctlogs = 4;</code>
   */
  @java.lang.Override
  public int getCtlogsCount() {
    return ctlogs_.size();
  }
  /**
   * <pre>
   * A set of trusted certificate transparency logs.
   * </pre>
   *
   * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance ctlogs = 4;</code>
   */
  @java.lang.Override
  public dev.sigstore.proto.trustroot.v1.TransparencyLogInstance getCtlogs(int index) {
    return ctlogs_.get(index);
  }
  /**
   * <pre>
   * A set of trusted certificate transparency logs.
   * </pre>
   *
   * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance ctlogs = 4;</code>
   */
  @java.lang.Override
  public dev.sigstore.proto.trustroot.v1.TransparencyLogInstanceOrBuilder getCtlogsOrBuilder(
      int index) {
    return ctlogs_.get(index);
  }

  public static final int TIMESTAMP_AUTHORITIES_FIELD_NUMBER = 5;
  @SuppressWarnings("serial")
  private java.util.List<dev.sigstore.proto.trustroot.v1.CertificateAuthority> timestampAuthorities_;
  /**
   * <pre>
   * A set of trusted timestamping authorities.
   * </pre>
   *
   * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority timestamp_authorities = 5;</code>
   */
  @java.lang.Override
  public java.util.List<dev.sigstore.proto.trustroot.v1.CertificateAuthority> getTimestampAuthoritiesList() {
    return timestampAuthorities_;
  }
  /**
   * <pre>
   * A set of trusted timestamping authorities.
   * </pre>
   *
   * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority timestamp_authorities = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends dev.sigstore.proto.trustroot.v1.CertificateAuthorityOrBuilder> 
      getTimestampAuthoritiesOrBuilderList() {
    return timestampAuthorities_;
  }
  /**
   * <pre>
   * A set of trusted timestamping authorities.
   * </pre>
   *
   * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority timestamp_authorities = 5;</code>
   */
  @java.lang.Override
  public int getTimestampAuthoritiesCount() {
    return timestampAuthorities_.size();
  }
  /**
   * <pre>
   * A set of trusted timestamping authorities.
   * </pre>
   *
   * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority timestamp_authorities = 5;</code>
   */
  @java.lang.Override
  public dev.sigstore.proto.trustroot.v1.CertificateAuthority getTimestampAuthorities(int index) {
    return timestampAuthorities_.get(index);
  }
  /**
   * <pre>
   * A set of trusted timestamping authorities.
   * </pre>
   *
   * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority timestamp_authorities = 5;</code>
   */
  @java.lang.Override
  public dev.sigstore.proto.trustroot.v1.CertificateAuthorityOrBuilder getTimestampAuthoritiesOrBuilder(
      int index) {
    return timestampAuthorities_.get(index);
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(mediaType_)) {
      com.google.protobuf.GeneratedMessage.writeString(output, 1, mediaType_);
    }
    for (int i = 0; i < tlogs_.size(); i++) {
      output.writeMessage(2, tlogs_.get(i));
    }
    for (int i = 0; i < certificateAuthorities_.size(); i++) {
      output.writeMessage(3, certificateAuthorities_.get(i));
    }
    for (int i = 0; i < ctlogs_.size(); i++) {
      output.writeMessage(4, ctlogs_.get(i));
    }
    for (int i = 0; i < timestampAuthorities_.size(); i++) {
      output.writeMessage(5, timestampAuthorities_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(mediaType_)) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(1, mediaType_);
    }
    for (int i = 0; i < tlogs_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(2, tlogs_.get(i));
    }
    for (int i = 0; i < certificateAuthorities_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(3, certificateAuthorities_.get(i));
    }
    for (int i = 0; i < ctlogs_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(4, ctlogs_.get(i));
    }
    for (int i = 0; i < timestampAuthorities_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(5, timestampAuthorities_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof dev.sigstore.proto.trustroot.v1.TrustedRoot)) {
      return super.equals(obj);
    }
    dev.sigstore.proto.trustroot.v1.TrustedRoot other = (dev.sigstore.proto.trustroot.v1.TrustedRoot) obj;

    if (!getMediaType()
        .equals(other.getMediaType())) return false;
    if (!getTlogsList()
        .equals(other.getTlogsList())) return false;
    if (!getCertificateAuthoritiesList()
        .equals(other.getCertificateAuthoritiesList())) return false;
    if (!getCtlogsList()
        .equals(other.getCtlogsList())) return false;
    if (!getTimestampAuthoritiesList()
        .equals(other.getTimestampAuthoritiesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + MEDIA_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getMediaType().hashCode();
    if (getTlogsCount() > 0) {
      hash = (37 * hash) + TLOGS_FIELD_NUMBER;
      hash = (53 * hash) + getTlogsList().hashCode();
    }
    if (getCertificateAuthoritiesCount() > 0) {
      hash = (37 * hash) + CERTIFICATE_AUTHORITIES_FIELD_NUMBER;
      hash = (53 * hash) + getCertificateAuthoritiesList().hashCode();
    }
    if (getCtlogsCount() > 0) {
      hash = (37 * hash) + CTLOGS_FIELD_NUMBER;
      hash = (53 * hash) + getCtlogsList().hashCode();
    }
    if (getTimestampAuthoritiesCount() > 0) {
      hash = (37 * hash) + TIMESTAMP_AUTHORITIES_FIELD_NUMBER;
      hash = (53 * hash) + getTimestampAuthoritiesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static dev.sigstore.proto.trustroot.v1.TrustedRoot parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static dev.sigstore.proto.trustroot.v1.TrustedRoot parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static dev.sigstore.proto.trustroot.v1.TrustedRoot parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static dev.sigstore.proto.trustroot.v1.TrustedRoot parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static dev.sigstore.proto.trustroot.v1.TrustedRoot parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static dev.sigstore.proto.trustroot.v1.TrustedRoot parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static dev.sigstore.proto.trustroot.v1.TrustedRoot parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input);
  }
  public static dev.sigstore.proto.trustroot.v1.TrustedRoot parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static dev.sigstore.proto.trustroot.v1.TrustedRoot parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static dev.sigstore.proto.trustroot.v1.TrustedRoot parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static dev.sigstore.proto.trustroot.v1.TrustedRoot parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input);
  }
  public static dev.sigstore.proto.trustroot.v1.TrustedRoot parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(dev.sigstore.proto.trustroot.v1.TrustedRoot prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessage.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * TrustedRoot describes the client's complete set of trusted entities.
   * How the TrustedRoot is populated is not specified, but can be a
   * combination of many sources such as TUF repositories, files on disk etc.
   *
   * The TrustedRoot is not meant to be used for any artifact verification, only
   * to capture the complete/global set of trusted verification materials.
   * When verifying an artifact, based on the artifact and policies, a selection
   * of keys/authorities are expected to be extracted and provided to the
   * verification function. This way the set of keys/authorities can be kept to
   * a minimal set by the policy to gain better control over what signatures
   * that are allowed.
   *
   * The embedded transparency logs, CT logs, CAs and TSAs MUST include any
   * previously used instance -- otherwise signatures made in the past cannot
   * be verified.
   *
   * All the listed instances SHOULD be sorted by the 'valid_for' in ascending
   * order, that is, the oldest instance first. Only the last instance is
   * allowed to have their 'end' timestamp unset. All previous instances MUST
   * have a closed interval of validity. The last instance MAY have a closed
   * interval. Clients MUST accept instances that overlaps in time, if not
   * clients may experience problems during rotations of verification
   * materials.
   *
   * To be able to manage planned rotations of either transparency logs or
   * certificate authorities, clienst MUST accept lists of instances where
   * the last instance have a 'valid_for' that belongs to the future.
   * This should not be a problem as clients SHOULD first seek the trust root
   * for a suitable instance before creating a per artifact trust root (that
   * is, a sub-set of the complete trust root) that is used for verification.
   * </pre>
   *
   * Protobuf type {@code dev.sigstore.trustroot.v1.TrustedRoot}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessage.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:dev.sigstore.trustroot.v1.TrustedRoot)
      dev.sigstore.proto.trustroot.v1.TrustedRootOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return dev.sigstore.proto.trustroot.v1.TrustRootProto.internal_static_dev_sigstore_trustroot_v1_TrustedRoot_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return dev.sigstore.proto.trustroot.v1.TrustRootProto.internal_static_dev_sigstore_trustroot_v1_TrustedRoot_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              dev.sigstore.proto.trustroot.v1.TrustedRoot.class, dev.sigstore.proto.trustroot.v1.TrustedRoot.Builder.class);
    }

    // Construct using dev.sigstore.proto.trustroot.v1.TrustedRoot.newBuilder()
    private Builder() {

    }

    private Builder(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      super(parent);

    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      mediaType_ = "";
      if (tlogsBuilder_ == null) {
        tlogs_ = java.util.Collections.emptyList();
      } else {
        tlogs_ = null;
        tlogsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (certificateAuthoritiesBuilder_ == null) {
        certificateAuthorities_ = java.util.Collections.emptyList();
      } else {
        certificateAuthorities_ = null;
        certificateAuthoritiesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      if (ctlogsBuilder_ == null) {
        ctlogs_ = java.util.Collections.emptyList();
      } else {
        ctlogs_ = null;
        ctlogsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      if (timestampAuthoritiesBuilder_ == null) {
        timestampAuthorities_ = java.util.Collections.emptyList();
      } else {
        timestampAuthorities_ = null;
        timestampAuthoritiesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return dev.sigstore.proto.trustroot.v1.TrustRootProto.internal_static_dev_sigstore_trustroot_v1_TrustedRoot_descriptor;
    }

    @java.lang.Override
    public dev.sigstore.proto.trustroot.v1.TrustedRoot getDefaultInstanceForType() {
      return dev.sigstore.proto.trustroot.v1.TrustedRoot.getDefaultInstance();
    }

    @java.lang.Override
    public dev.sigstore.proto.trustroot.v1.TrustedRoot build() {
      dev.sigstore.proto.trustroot.v1.TrustedRoot result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public dev.sigstore.proto.trustroot.v1.TrustedRoot buildPartial() {
      dev.sigstore.proto.trustroot.v1.TrustedRoot result = new dev.sigstore.proto.trustroot.v1.TrustedRoot(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) { buildPartial0(result); }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(dev.sigstore.proto.trustroot.v1.TrustedRoot result) {
      if (tlogsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          tlogs_ = java.util.Collections.unmodifiableList(tlogs_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.tlogs_ = tlogs_;
      } else {
        result.tlogs_ = tlogsBuilder_.build();
      }
      if (certificateAuthoritiesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          certificateAuthorities_ = java.util.Collections.unmodifiableList(certificateAuthorities_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.certificateAuthorities_ = certificateAuthorities_;
      } else {
        result.certificateAuthorities_ = certificateAuthoritiesBuilder_.build();
      }
      if (ctlogsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          ctlogs_ = java.util.Collections.unmodifiableList(ctlogs_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.ctlogs_ = ctlogs_;
      } else {
        result.ctlogs_ = ctlogsBuilder_.build();
      }
      if (timestampAuthoritiesBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          timestampAuthorities_ = java.util.Collections.unmodifiableList(timestampAuthorities_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.timestampAuthorities_ = timestampAuthorities_;
      } else {
        result.timestampAuthorities_ = timestampAuthoritiesBuilder_.build();
      }
    }

    private void buildPartial0(dev.sigstore.proto.trustroot.v1.TrustedRoot result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.mediaType_ = mediaType_;
      }
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof dev.sigstore.proto.trustroot.v1.TrustedRoot) {
        return mergeFrom((dev.sigstore.proto.trustroot.v1.TrustedRoot)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(dev.sigstore.proto.trustroot.v1.TrustedRoot other) {
      if (other == dev.sigstore.proto.trustroot.v1.TrustedRoot.getDefaultInstance()) return this;
      if (!other.getMediaType().isEmpty()) {
        mediaType_ = other.mediaType_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (tlogsBuilder_ == null) {
        if (!other.tlogs_.isEmpty()) {
          if (tlogs_.isEmpty()) {
            tlogs_ = other.tlogs_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureTlogsIsMutable();
            tlogs_.addAll(other.tlogs_);
          }
          onChanged();
        }
      } else {
        if (!other.tlogs_.isEmpty()) {
          if (tlogsBuilder_.isEmpty()) {
            tlogsBuilder_.dispose();
            tlogsBuilder_ = null;
            tlogs_ = other.tlogs_;
            bitField0_ = (bitField0_ & ~0x00000002);
            tlogsBuilder_ = 
              com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                 getTlogsFieldBuilder() : null;
          } else {
            tlogsBuilder_.addAllMessages(other.tlogs_);
          }
        }
      }
      if (certificateAuthoritiesBuilder_ == null) {
        if (!other.certificateAuthorities_.isEmpty()) {
          if (certificateAuthorities_.isEmpty()) {
            certificateAuthorities_ = other.certificateAuthorities_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureCertificateAuthoritiesIsMutable();
            certificateAuthorities_.addAll(other.certificateAuthorities_);
          }
          onChanged();
        }
      } else {
        if (!other.certificateAuthorities_.isEmpty()) {
          if (certificateAuthoritiesBuilder_.isEmpty()) {
            certificateAuthoritiesBuilder_.dispose();
            certificateAuthoritiesBuilder_ = null;
            certificateAuthorities_ = other.certificateAuthorities_;
            bitField0_ = (bitField0_ & ~0x00000004);
            certificateAuthoritiesBuilder_ = 
              com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                 getCertificateAuthoritiesFieldBuilder() : null;
          } else {
            certificateAuthoritiesBuilder_.addAllMessages(other.certificateAuthorities_);
          }
        }
      }
      if (ctlogsBuilder_ == null) {
        if (!other.ctlogs_.isEmpty()) {
          if (ctlogs_.isEmpty()) {
            ctlogs_ = other.ctlogs_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureCtlogsIsMutable();
            ctlogs_.addAll(other.ctlogs_);
          }
          onChanged();
        }
      } else {
        if (!other.ctlogs_.isEmpty()) {
          if (ctlogsBuilder_.isEmpty()) {
            ctlogsBuilder_.dispose();
            ctlogsBuilder_ = null;
            ctlogs_ = other.ctlogs_;
            bitField0_ = (bitField0_ & ~0x00000008);
            ctlogsBuilder_ = 
              com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                 getCtlogsFieldBuilder() : null;
          } else {
            ctlogsBuilder_.addAllMessages(other.ctlogs_);
          }
        }
      }
      if (timestampAuthoritiesBuilder_ == null) {
        if (!other.timestampAuthorities_.isEmpty()) {
          if (timestampAuthorities_.isEmpty()) {
            timestampAuthorities_ = other.timestampAuthorities_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureTimestampAuthoritiesIsMutable();
            timestampAuthorities_.addAll(other.timestampAuthorities_);
          }
          onChanged();
        }
      } else {
        if (!other.timestampAuthorities_.isEmpty()) {
          if (timestampAuthoritiesBuilder_.isEmpty()) {
            timestampAuthoritiesBuilder_.dispose();
            timestampAuthoritiesBuilder_ = null;
            timestampAuthorities_ = other.timestampAuthorities_;
            bitField0_ = (bitField0_ & ~0x00000010);
            timestampAuthoritiesBuilder_ = 
              com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                 getTimestampAuthoritiesFieldBuilder() : null;
          } else {
            timestampAuthoritiesBuilder_.addAllMessages(other.timestampAuthorities_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              mediaType_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000001;
              break;
            } // case 10
            case 18: {
              dev.sigstore.proto.trustroot.v1.TransparencyLogInstance m =
                  input.readMessage(
                      dev.sigstore.proto.trustroot.v1.TransparencyLogInstance.parser(),
                      extensionRegistry);
              if (tlogsBuilder_ == null) {
                ensureTlogsIsMutable();
                tlogs_.add(m);
              } else {
                tlogsBuilder_.addMessage(m);
              }
              break;
            } // case 18
            case 26: {
              dev.sigstore.proto.trustroot.v1.CertificateAuthority m =
                  input.readMessage(
                      dev.sigstore.proto.trustroot.v1.CertificateAuthority.parser(),
                      extensionRegistry);
              if (certificateAuthoritiesBuilder_ == null) {
                ensureCertificateAuthoritiesIsMutable();
                certificateAuthorities_.add(m);
              } else {
                certificateAuthoritiesBuilder_.addMessage(m);
              }
              break;
            } // case 26
            case 34: {
              dev.sigstore.proto.trustroot.v1.TransparencyLogInstance m =
                  input.readMessage(
                      dev.sigstore.proto.trustroot.v1.TransparencyLogInstance.parser(),
                      extensionRegistry);
              if (ctlogsBuilder_ == null) {
                ensureCtlogsIsMutable();
                ctlogs_.add(m);
              } else {
                ctlogsBuilder_.addMessage(m);
              }
              break;
            } // case 34
            case 42: {
              dev.sigstore.proto.trustroot.v1.CertificateAuthority m =
                  input.readMessage(
                      dev.sigstore.proto.trustroot.v1.CertificateAuthority.parser(),
                      extensionRegistry);
              if (timestampAuthoritiesBuilder_ == null) {
                ensureTimestampAuthoritiesIsMutable();
                timestampAuthorities_.add(m);
              } else {
                timestampAuthoritiesBuilder_.addMessage(m);
              }
              break;
            } // case 42
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int bitField0_;

    private java.lang.Object mediaType_ = "";
    /**
     * <pre>
     * MUST be application/vnd.dev.sigstore.trustedroot.v0.1+json
     * when encoded as JSON.
     * Clients MUST be able to process and parse content with the media
     * type defined in the old format:
     * application/vnd.dev.sigstore.trustedroot+json;version=0.1
     * </pre>
     *
     * <code>string media_type = 1;</code>
     * @return The mediaType.
     */
    public java.lang.String getMediaType() {
      java.lang.Object ref = mediaType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        mediaType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * MUST be application/vnd.dev.sigstore.trustedroot.v0.1+json
     * when encoded as JSON.
     * Clients MUST be able to process and parse content with the media
     * type defined in the old format:
     * application/vnd.dev.sigstore.trustedroot+json;version=0.1
     * </pre>
     *
     * <code>string media_type = 1;</code>
     * @return The bytes for mediaType.
     */
    public com.google.protobuf.ByteString
        getMediaTypeBytes() {
      java.lang.Object ref = mediaType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        mediaType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * MUST be application/vnd.dev.sigstore.trustedroot.v0.1+json
     * when encoded as JSON.
     * Clients MUST be able to process and parse content with the media
     * type defined in the old format:
     * application/vnd.dev.sigstore.trustedroot+json;version=0.1
     * </pre>
     *
     * <code>string media_type = 1;</code>
     * @param value The mediaType to set.
     * @return This builder for chaining.
     */
    public Builder setMediaType(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      mediaType_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * MUST be application/vnd.dev.sigstore.trustedroot.v0.1+json
     * when encoded as JSON.
     * Clients MUST be able to process and parse content with the media
     * type defined in the old format:
     * application/vnd.dev.sigstore.trustedroot+json;version=0.1
     * </pre>
     *
     * <code>string media_type = 1;</code>
     * @return This builder for chaining.
     */
    public Builder clearMediaType() {
      mediaType_ = getDefaultInstance().getMediaType();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * MUST be application/vnd.dev.sigstore.trustedroot.v0.1+json
     * when encoded as JSON.
     * Clients MUST be able to process and parse content with the media
     * type defined in the old format:
     * application/vnd.dev.sigstore.trustedroot+json;version=0.1
     * </pre>
     *
     * <code>string media_type = 1;</code>
     * @param value The bytes for mediaType to set.
     * @return This builder for chaining.
     */
    public Builder setMediaTypeBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      mediaType_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<dev.sigstore.proto.trustroot.v1.TransparencyLogInstance> tlogs_ =
      java.util.Collections.emptyList();
    private void ensureTlogsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        tlogs_ = new java.util.ArrayList<dev.sigstore.proto.trustroot.v1.TransparencyLogInstance>(tlogs_);
        bitField0_ |= 0x00000002;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilder<
        dev.sigstore.proto.trustroot.v1.TransparencyLogInstance, dev.sigstore.proto.trustroot.v1.TransparencyLogInstance.Builder, dev.sigstore.proto.trustroot.v1.TransparencyLogInstanceOrBuilder> tlogsBuilder_;

    /**
     * <pre>
     * A set of trusted Rekor servers.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance tlogs = 2;</code>
     */
    public java.util.List<dev.sigstore.proto.trustroot.v1.TransparencyLogInstance> getTlogsList() {
      if (tlogsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(tlogs_);
      } else {
        return tlogsBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * A set of trusted Rekor servers.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance tlogs = 2;</code>
     */
    public int getTlogsCount() {
      if (tlogsBuilder_ == null) {
        return tlogs_.size();
      } else {
        return tlogsBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * A set of trusted Rekor servers.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance tlogs = 2;</code>
     */
    public dev.sigstore.proto.trustroot.v1.TransparencyLogInstance getTlogs(int index) {
      if (tlogsBuilder_ == null) {
        return tlogs_.get(index);
      } else {
        return tlogsBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * A set of trusted Rekor servers.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance tlogs = 2;</code>
     */
    public Builder setTlogs(
        int index, dev.sigstore.proto.trustroot.v1.TransparencyLogInstance value) {
      if (tlogsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTlogsIsMutable();
        tlogs_.set(index, value);
        onChanged();
      } else {
        tlogsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * A set of trusted Rekor servers.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance tlogs = 2;</code>
     */
    public Builder setTlogs(
        int index, dev.sigstore.proto.trustroot.v1.TransparencyLogInstance.Builder builderForValue) {
      if (tlogsBuilder_ == null) {
        ensureTlogsIsMutable();
        tlogs_.set(index, builderForValue.build());
        onChanged();
      } else {
        tlogsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * A set of trusted Rekor servers.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance tlogs = 2;</code>
     */
    public Builder addTlogs(dev.sigstore.proto.trustroot.v1.TransparencyLogInstance value) {
      if (tlogsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTlogsIsMutable();
        tlogs_.add(value);
        onChanged();
      } else {
        tlogsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * A set of trusted Rekor servers.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance tlogs = 2;</code>
     */
    public Builder addTlogs(
        int index, dev.sigstore.proto.trustroot.v1.TransparencyLogInstance value) {
      if (tlogsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTlogsIsMutable();
        tlogs_.add(index, value);
        onChanged();
      } else {
        tlogsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * A set of trusted Rekor servers.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance tlogs = 2;</code>
     */
    public Builder addTlogs(
        dev.sigstore.proto.trustroot.v1.TransparencyLogInstance.Builder builderForValue) {
      if (tlogsBuilder_ == null) {
        ensureTlogsIsMutable();
        tlogs_.add(builderForValue.build());
        onChanged();
      } else {
        tlogsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * A set of trusted Rekor servers.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance tlogs = 2;</code>
     */
    public Builder addTlogs(
        int index, dev.sigstore.proto.trustroot.v1.TransparencyLogInstance.Builder builderForValue) {
      if (tlogsBuilder_ == null) {
        ensureTlogsIsMutable();
        tlogs_.add(index, builderForValue.build());
        onChanged();
      } else {
        tlogsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * A set of trusted Rekor servers.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance tlogs = 2;</code>
     */
    public Builder addAllTlogs(
        java.lang.Iterable<? extends dev.sigstore.proto.trustroot.v1.TransparencyLogInstance> values) {
      if (tlogsBuilder_ == null) {
        ensureTlogsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, tlogs_);
        onChanged();
      } else {
        tlogsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * A set of trusted Rekor servers.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance tlogs = 2;</code>
     */
    public Builder clearTlogs() {
      if (tlogsBuilder_ == null) {
        tlogs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        tlogsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * A set of trusted Rekor servers.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance tlogs = 2;</code>
     */
    public Builder removeTlogs(int index) {
      if (tlogsBuilder_ == null) {
        ensureTlogsIsMutable();
        tlogs_.remove(index);
        onChanged();
      } else {
        tlogsBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * A set of trusted Rekor servers.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance tlogs = 2;</code>
     */
    public dev.sigstore.proto.trustroot.v1.TransparencyLogInstance.Builder getTlogsBuilder(
        int index) {
      return getTlogsFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * A set of trusted Rekor servers.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance tlogs = 2;</code>
     */
    public dev.sigstore.proto.trustroot.v1.TransparencyLogInstanceOrBuilder getTlogsOrBuilder(
        int index) {
      if (tlogsBuilder_ == null) {
        return tlogs_.get(index);  } else {
        return tlogsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * A set of trusted Rekor servers.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance tlogs = 2;</code>
     */
    public java.util.List<? extends dev.sigstore.proto.trustroot.v1.TransparencyLogInstanceOrBuilder> 
         getTlogsOrBuilderList() {
      if (tlogsBuilder_ != null) {
        return tlogsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(tlogs_);
      }
    }
    /**
     * <pre>
     * A set of trusted Rekor servers.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance tlogs = 2;</code>
     */
    public dev.sigstore.proto.trustroot.v1.TransparencyLogInstance.Builder addTlogsBuilder() {
      return getTlogsFieldBuilder().addBuilder(
          dev.sigstore.proto.trustroot.v1.TransparencyLogInstance.getDefaultInstance());
    }
    /**
     * <pre>
     * A set of trusted Rekor servers.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance tlogs = 2;</code>
     */
    public dev.sigstore.proto.trustroot.v1.TransparencyLogInstance.Builder addTlogsBuilder(
        int index) {
      return getTlogsFieldBuilder().addBuilder(
          index, dev.sigstore.proto.trustroot.v1.TransparencyLogInstance.getDefaultInstance());
    }
    /**
     * <pre>
     * A set of trusted Rekor servers.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance tlogs = 2;</code>
     */
    public java.util.List<dev.sigstore.proto.trustroot.v1.TransparencyLogInstance.Builder> 
         getTlogsBuilderList() {
      return getTlogsFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilder<
        dev.sigstore.proto.trustroot.v1.TransparencyLogInstance, dev.sigstore.proto.trustroot.v1.TransparencyLogInstance.Builder, dev.sigstore.proto.trustroot.v1.TransparencyLogInstanceOrBuilder> 
        getTlogsFieldBuilder() {
      if (tlogsBuilder_ == null) {
        tlogsBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
            dev.sigstore.proto.trustroot.v1.TransparencyLogInstance, dev.sigstore.proto.trustroot.v1.TransparencyLogInstance.Builder, dev.sigstore.proto.trustroot.v1.TransparencyLogInstanceOrBuilder>(
                tlogs_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        tlogs_ = null;
      }
      return tlogsBuilder_;
    }

    private java.util.List<dev.sigstore.proto.trustroot.v1.CertificateAuthority> certificateAuthorities_ =
      java.util.Collections.emptyList();
    private void ensureCertificateAuthoritiesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        certificateAuthorities_ = new java.util.ArrayList<dev.sigstore.proto.trustroot.v1.CertificateAuthority>(certificateAuthorities_);
        bitField0_ |= 0x00000004;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilder<
        dev.sigstore.proto.trustroot.v1.CertificateAuthority, dev.sigstore.proto.trustroot.v1.CertificateAuthority.Builder, dev.sigstore.proto.trustroot.v1.CertificateAuthorityOrBuilder> certificateAuthoritiesBuilder_;

    /**
     * <pre>
     * A set of trusted certificate authorities (e.g Fulcio), and any
     * intermediate certificates they provide.
     * If a CA is issuing multiple intermediate certificate, each
     * combination shall be represented as separate chain. I.e, a single
     * root cert may appear in multiple chains but with different
     * intermediate and/or leaf certificates.
     * The certificates are intended to be used for verifying artifact
     * signatures.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority certificate_authorities = 3;</code>
     */
    public java.util.List<dev.sigstore.proto.trustroot.v1.CertificateAuthority> getCertificateAuthoritiesList() {
      if (certificateAuthoritiesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(certificateAuthorities_);
      } else {
        return certificateAuthoritiesBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * A set of trusted certificate authorities (e.g Fulcio), and any
     * intermediate certificates they provide.
     * If a CA is issuing multiple intermediate certificate, each
     * combination shall be represented as separate chain. I.e, a single
     * root cert may appear in multiple chains but with different
     * intermediate and/or leaf certificates.
     * The certificates are intended to be used for verifying artifact
     * signatures.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority certificate_authorities = 3;</code>
     */
    public int getCertificateAuthoritiesCount() {
      if (certificateAuthoritiesBuilder_ == null) {
        return certificateAuthorities_.size();
      } else {
        return certificateAuthoritiesBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * A set of trusted certificate authorities (e.g Fulcio), and any
     * intermediate certificates they provide.
     * If a CA is issuing multiple intermediate certificate, each
     * combination shall be represented as separate chain. I.e, a single
     * root cert may appear in multiple chains but with different
     * intermediate and/or leaf certificates.
     * The certificates are intended to be used for verifying artifact
     * signatures.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority certificate_authorities = 3;</code>
     */
    public dev.sigstore.proto.trustroot.v1.CertificateAuthority getCertificateAuthorities(int index) {
      if (certificateAuthoritiesBuilder_ == null) {
        return certificateAuthorities_.get(index);
      } else {
        return certificateAuthoritiesBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * A set of trusted certificate authorities (e.g Fulcio), and any
     * intermediate certificates they provide.
     * If a CA is issuing multiple intermediate certificate, each
     * combination shall be represented as separate chain. I.e, a single
     * root cert may appear in multiple chains but with different
     * intermediate and/or leaf certificates.
     * The certificates are intended to be used for verifying artifact
     * signatures.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority certificate_authorities = 3;</code>
     */
    public Builder setCertificateAuthorities(
        int index, dev.sigstore.proto.trustroot.v1.CertificateAuthority value) {
      if (certificateAuthoritiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCertificateAuthoritiesIsMutable();
        certificateAuthorities_.set(index, value);
        onChanged();
      } else {
        certificateAuthoritiesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * A set of trusted certificate authorities (e.g Fulcio), and any
     * intermediate certificates they provide.
     * If a CA is issuing multiple intermediate certificate, each
     * combination shall be represented as separate chain. I.e, a single
     * root cert may appear in multiple chains but with different
     * intermediate and/or leaf certificates.
     * The certificates are intended to be used for verifying artifact
     * signatures.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority certificate_authorities = 3;</code>
     */
    public Builder setCertificateAuthorities(
        int index, dev.sigstore.proto.trustroot.v1.CertificateAuthority.Builder builderForValue) {
      if (certificateAuthoritiesBuilder_ == null) {
        ensureCertificateAuthoritiesIsMutable();
        certificateAuthorities_.set(index, builderForValue.build());
        onChanged();
      } else {
        certificateAuthoritiesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * A set of trusted certificate authorities (e.g Fulcio), and any
     * intermediate certificates they provide.
     * If a CA is issuing multiple intermediate certificate, each
     * combination shall be represented as separate chain. I.e, a single
     * root cert may appear in multiple chains but with different
     * intermediate and/or leaf certificates.
     * The certificates are intended to be used for verifying artifact
     * signatures.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority certificate_authorities = 3;</code>
     */
    public Builder addCertificateAuthorities(dev.sigstore.proto.trustroot.v1.CertificateAuthority value) {
      if (certificateAuthoritiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCertificateAuthoritiesIsMutable();
        certificateAuthorities_.add(value);
        onChanged();
      } else {
        certificateAuthoritiesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * A set of trusted certificate authorities (e.g Fulcio), and any
     * intermediate certificates they provide.
     * If a CA is issuing multiple intermediate certificate, each
     * combination shall be represented as separate chain. I.e, a single
     * root cert may appear in multiple chains but with different
     * intermediate and/or leaf certificates.
     * The certificates are intended to be used for verifying artifact
     * signatures.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority certificate_authorities = 3;</code>
     */
    public Builder addCertificateAuthorities(
        int index, dev.sigstore.proto.trustroot.v1.CertificateAuthority value) {
      if (certificateAuthoritiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCertificateAuthoritiesIsMutable();
        certificateAuthorities_.add(index, value);
        onChanged();
      } else {
        certificateAuthoritiesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * A set of trusted certificate authorities (e.g Fulcio), and any
     * intermediate certificates they provide.
     * If a CA is issuing multiple intermediate certificate, each
     * combination shall be represented as separate chain. I.e, a single
     * root cert may appear in multiple chains but with different
     * intermediate and/or leaf certificates.
     * The certificates are intended to be used for verifying artifact
     * signatures.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority certificate_authorities = 3;</code>
     */
    public Builder addCertificateAuthorities(
        dev.sigstore.proto.trustroot.v1.CertificateAuthority.Builder builderForValue) {
      if (certificateAuthoritiesBuilder_ == null) {
        ensureCertificateAuthoritiesIsMutable();
        certificateAuthorities_.add(builderForValue.build());
        onChanged();
      } else {
        certificateAuthoritiesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * A set of trusted certificate authorities (e.g Fulcio), and any
     * intermediate certificates they provide.
     * If a CA is issuing multiple intermediate certificate, each
     * combination shall be represented as separate chain. I.e, a single
     * root cert may appear in multiple chains but with different
     * intermediate and/or leaf certificates.
     * The certificates are intended to be used for verifying artifact
     * signatures.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority certificate_authorities = 3;</code>
     */
    public Builder addCertificateAuthorities(
        int index, dev.sigstore.proto.trustroot.v1.CertificateAuthority.Builder builderForValue) {
      if (certificateAuthoritiesBuilder_ == null) {
        ensureCertificateAuthoritiesIsMutable();
        certificateAuthorities_.add(index, builderForValue.build());
        onChanged();
      } else {
        certificateAuthoritiesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * A set of trusted certificate authorities (e.g Fulcio), and any
     * intermediate certificates they provide.
     * If a CA is issuing multiple intermediate certificate, each
     * combination shall be represented as separate chain. I.e, a single
     * root cert may appear in multiple chains but with different
     * intermediate and/or leaf certificates.
     * The certificates are intended to be used for verifying artifact
     * signatures.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority certificate_authorities = 3;</code>
     */
    public Builder addAllCertificateAuthorities(
        java.lang.Iterable<? extends dev.sigstore.proto.trustroot.v1.CertificateAuthority> values) {
      if (certificateAuthoritiesBuilder_ == null) {
        ensureCertificateAuthoritiesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, certificateAuthorities_);
        onChanged();
      } else {
        certificateAuthoritiesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * A set of trusted certificate authorities (e.g Fulcio), and any
     * intermediate certificates they provide.
     * If a CA is issuing multiple intermediate certificate, each
     * combination shall be represented as separate chain. I.e, a single
     * root cert may appear in multiple chains but with different
     * intermediate and/or leaf certificates.
     * The certificates are intended to be used for verifying artifact
     * signatures.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority certificate_authorities = 3;</code>
     */
    public Builder clearCertificateAuthorities() {
      if (certificateAuthoritiesBuilder_ == null) {
        certificateAuthorities_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        certificateAuthoritiesBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * A set of trusted certificate authorities (e.g Fulcio), and any
     * intermediate certificates they provide.
     * If a CA is issuing multiple intermediate certificate, each
     * combination shall be represented as separate chain. I.e, a single
     * root cert may appear in multiple chains but with different
     * intermediate and/or leaf certificates.
     * The certificates are intended to be used for verifying artifact
     * signatures.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority certificate_authorities = 3;</code>
     */
    public Builder removeCertificateAuthorities(int index) {
      if (certificateAuthoritiesBuilder_ == null) {
        ensureCertificateAuthoritiesIsMutable();
        certificateAuthorities_.remove(index);
        onChanged();
      } else {
        certificateAuthoritiesBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * A set of trusted certificate authorities (e.g Fulcio), and any
     * intermediate certificates they provide.
     * If a CA is issuing multiple intermediate certificate, each
     * combination shall be represented as separate chain. I.e, a single
     * root cert may appear in multiple chains but with different
     * intermediate and/or leaf certificates.
     * The certificates are intended to be used for verifying artifact
     * signatures.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority certificate_authorities = 3;</code>
     */
    public dev.sigstore.proto.trustroot.v1.CertificateAuthority.Builder getCertificateAuthoritiesBuilder(
        int index) {
      return getCertificateAuthoritiesFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * A set of trusted certificate authorities (e.g Fulcio), and any
     * intermediate certificates they provide.
     * If a CA is issuing multiple intermediate certificate, each
     * combination shall be represented as separate chain. I.e, a single
     * root cert may appear in multiple chains but with different
     * intermediate and/or leaf certificates.
     * The certificates are intended to be used for verifying artifact
     * signatures.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority certificate_authorities = 3;</code>
     */
    public dev.sigstore.proto.trustroot.v1.CertificateAuthorityOrBuilder getCertificateAuthoritiesOrBuilder(
        int index) {
      if (certificateAuthoritiesBuilder_ == null) {
        return certificateAuthorities_.get(index);  } else {
        return certificateAuthoritiesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * A set of trusted certificate authorities (e.g Fulcio), and any
     * intermediate certificates they provide.
     * If a CA is issuing multiple intermediate certificate, each
     * combination shall be represented as separate chain. I.e, a single
     * root cert may appear in multiple chains but with different
     * intermediate and/or leaf certificates.
     * The certificates are intended to be used for verifying artifact
     * signatures.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority certificate_authorities = 3;</code>
     */
    public java.util.List<? extends dev.sigstore.proto.trustroot.v1.CertificateAuthorityOrBuilder> 
         getCertificateAuthoritiesOrBuilderList() {
      if (certificateAuthoritiesBuilder_ != null) {
        return certificateAuthoritiesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(certificateAuthorities_);
      }
    }
    /**
     * <pre>
     * A set of trusted certificate authorities (e.g Fulcio), and any
     * intermediate certificates they provide.
     * If a CA is issuing multiple intermediate certificate, each
     * combination shall be represented as separate chain. I.e, a single
     * root cert may appear in multiple chains but with different
     * intermediate and/or leaf certificates.
     * The certificates are intended to be used for verifying artifact
     * signatures.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority certificate_authorities = 3;</code>
     */
    public dev.sigstore.proto.trustroot.v1.CertificateAuthority.Builder addCertificateAuthoritiesBuilder() {
      return getCertificateAuthoritiesFieldBuilder().addBuilder(
          dev.sigstore.proto.trustroot.v1.CertificateAuthority.getDefaultInstance());
    }
    /**
     * <pre>
     * A set of trusted certificate authorities (e.g Fulcio), and any
     * intermediate certificates they provide.
     * If a CA is issuing multiple intermediate certificate, each
     * combination shall be represented as separate chain. I.e, a single
     * root cert may appear in multiple chains but with different
     * intermediate and/or leaf certificates.
     * The certificates are intended to be used for verifying artifact
     * signatures.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority certificate_authorities = 3;</code>
     */
    public dev.sigstore.proto.trustroot.v1.CertificateAuthority.Builder addCertificateAuthoritiesBuilder(
        int index) {
      return getCertificateAuthoritiesFieldBuilder().addBuilder(
          index, dev.sigstore.proto.trustroot.v1.CertificateAuthority.getDefaultInstance());
    }
    /**
     * <pre>
     * A set of trusted certificate authorities (e.g Fulcio), and any
     * intermediate certificates they provide.
     * If a CA is issuing multiple intermediate certificate, each
     * combination shall be represented as separate chain. I.e, a single
     * root cert may appear in multiple chains but with different
     * intermediate and/or leaf certificates.
     * The certificates are intended to be used for verifying artifact
     * signatures.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority certificate_authorities = 3;</code>
     */
    public java.util.List<dev.sigstore.proto.trustroot.v1.CertificateAuthority.Builder> 
         getCertificateAuthoritiesBuilderList() {
      return getCertificateAuthoritiesFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilder<
        dev.sigstore.proto.trustroot.v1.CertificateAuthority, dev.sigstore.proto.trustroot.v1.CertificateAuthority.Builder, dev.sigstore.proto.trustroot.v1.CertificateAuthorityOrBuilder> 
        getCertificateAuthoritiesFieldBuilder() {
      if (certificateAuthoritiesBuilder_ == null) {
        certificateAuthoritiesBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
            dev.sigstore.proto.trustroot.v1.CertificateAuthority, dev.sigstore.proto.trustroot.v1.CertificateAuthority.Builder, dev.sigstore.proto.trustroot.v1.CertificateAuthorityOrBuilder>(
                certificateAuthorities_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        certificateAuthorities_ = null;
      }
      return certificateAuthoritiesBuilder_;
    }

    private java.util.List<dev.sigstore.proto.trustroot.v1.TransparencyLogInstance> ctlogs_ =
      java.util.Collections.emptyList();
    private void ensureCtlogsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        ctlogs_ = new java.util.ArrayList<dev.sigstore.proto.trustroot.v1.TransparencyLogInstance>(ctlogs_);
        bitField0_ |= 0x00000008;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilder<
        dev.sigstore.proto.trustroot.v1.TransparencyLogInstance, dev.sigstore.proto.trustroot.v1.TransparencyLogInstance.Builder, dev.sigstore.proto.trustroot.v1.TransparencyLogInstanceOrBuilder> ctlogsBuilder_;

    /**
     * <pre>
     * A set of trusted certificate transparency logs.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance ctlogs = 4;</code>
     */
    public java.util.List<dev.sigstore.proto.trustroot.v1.TransparencyLogInstance> getCtlogsList() {
      if (ctlogsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(ctlogs_);
      } else {
        return ctlogsBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * A set of trusted certificate transparency logs.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance ctlogs = 4;</code>
     */
    public int getCtlogsCount() {
      if (ctlogsBuilder_ == null) {
        return ctlogs_.size();
      } else {
        return ctlogsBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * A set of trusted certificate transparency logs.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance ctlogs = 4;</code>
     */
    public dev.sigstore.proto.trustroot.v1.TransparencyLogInstance getCtlogs(int index) {
      if (ctlogsBuilder_ == null) {
        return ctlogs_.get(index);
      } else {
        return ctlogsBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * A set of trusted certificate transparency logs.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance ctlogs = 4;</code>
     */
    public Builder setCtlogs(
        int index, dev.sigstore.proto.trustroot.v1.TransparencyLogInstance value) {
      if (ctlogsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCtlogsIsMutable();
        ctlogs_.set(index, value);
        onChanged();
      } else {
        ctlogsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * A set of trusted certificate transparency logs.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance ctlogs = 4;</code>
     */
    public Builder setCtlogs(
        int index, dev.sigstore.proto.trustroot.v1.TransparencyLogInstance.Builder builderForValue) {
      if (ctlogsBuilder_ == null) {
        ensureCtlogsIsMutable();
        ctlogs_.set(index, builderForValue.build());
        onChanged();
      } else {
        ctlogsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * A set of trusted certificate transparency logs.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance ctlogs = 4;</code>
     */
    public Builder addCtlogs(dev.sigstore.proto.trustroot.v1.TransparencyLogInstance value) {
      if (ctlogsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCtlogsIsMutable();
        ctlogs_.add(value);
        onChanged();
      } else {
        ctlogsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * A set of trusted certificate transparency logs.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance ctlogs = 4;</code>
     */
    public Builder addCtlogs(
        int index, dev.sigstore.proto.trustroot.v1.TransparencyLogInstance value) {
      if (ctlogsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCtlogsIsMutable();
        ctlogs_.add(index, value);
        onChanged();
      } else {
        ctlogsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * A set of trusted certificate transparency logs.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance ctlogs = 4;</code>
     */
    public Builder addCtlogs(
        dev.sigstore.proto.trustroot.v1.TransparencyLogInstance.Builder builderForValue) {
      if (ctlogsBuilder_ == null) {
        ensureCtlogsIsMutable();
        ctlogs_.add(builderForValue.build());
        onChanged();
      } else {
        ctlogsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * A set of trusted certificate transparency logs.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance ctlogs = 4;</code>
     */
    public Builder addCtlogs(
        int index, dev.sigstore.proto.trustroot.v1.TransparencyLogInstance.Builder builderForValue) {
      if (ctlogsBuilder_ == null) {
        ensureCtlogsIsMutable();
        ctlogs_.add(index, builderForValue.build());
        onChanged();
      } else {
        ctlogsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * A set of trusted certificate transparency logs.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance ctlogs = 4;</code>
     */
    public Builder addAllCtlogs(
        java.lang.Iterable<? extends dev.sigstore.proto.trustroot.v1.TransparencyLogInstance> values) {
      if (ctlogsBuilder_ == null) {
        ensureCtlogsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, ctlogs_);
        onChanged();
      } else {
        ctlogsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * A set of trusted certificate transparency logs.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance ctlogs = 4;</code>
     */
    public Builder clearCtlogs() {
      if (ctlogsBuilder_ == null) {
        ctlogs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        ctlogsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * A set of trusted certificate transparency logs.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance ctlogs = 4;</code>
     */
    public Builder removeCtlogs(int index) {
      if (ctlogsBuilder_ == null) {
        ensureCtlogsIsMutable();
        ctlogs_.remove(index);
        onChanged();
      } else {
        ctlogsBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * A set of trusted certificate transparency logs.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance ctlogs = 4;</code>
     */
    public dev.sigstore.proto.trustroot.v1.TransparencyLogInstance.Builder getCtlogsBuilder(
        int index) {
      return getCtlogsFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * A set of trusted certificate transparency logs.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance ctlogs = 4;</code>
     */
    public dev.sigstore.proto.trustroot.v1.TransparencyLogInstanceOrBuilder getCtlogsOrBuilder(
        int index) {
      if (ctlogsBuilder_ == null) {
        return ctlogs_.get(index);  } else {
        return ctlogsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * A set of trusted certificate transparency logs.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance ctlogs = 4;</code>
     */
    public java.util.List<? extends dev.sigstore.proto.trustroot.v1.TransparencyLogInstanceOrBuilder> 
         getCtlogsOrBuilderList() {
      if (ctlogsBuilder_ != null) {
        return ctlogsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(ctlogs_);
      }
    }
    /**
     * <pre>
     * A set of trusted certificate transparency logs.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance ctlogs = 4;</code>
     */
    public dev.sigstore.proto.trustroot.v1.TransparencyLogInstance.Builder addCtlogsBuilder() {
      return getCtlogsFieldBuilder().addBuilder(
          dev.sigstore.proto.trustroot.v1.TransparencyLogInstance.getDefaultInstance());
    }
    /**
     * <pre>
     * A set of trusted certificate transparency logs.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance ctlogs = 4;</code>
     */
    public dev.sigstore.proto.trustroot.v1.TransparencyLogInstance.Builder addCtlogsBuilder(
        int index) {
      return getCtlogsFieldBuilder().addBuilder(
          index, dev.sigstore.proto.trustroot.v1.TransparencyLogInstance.getDefaultInstance());
    }
    /**
     * <pre>
     * A set of trusted certificate transparency logs.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.TransparencyLogInstance ctlogs = 4;</code>
     */
    public java.util.List<dev.sigstore.proto.trustroot.v1.TransparencyLogInstance.Builder> 
         getCtlogsBuilderList() {
      return getCtlogsFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilder<
        dev.sigstore.proto.trustroot.v1.TransparencyLogInstance, dev.sigstore.proto.trustroot.v1.TransparencyLogInstance.Builder, dev.sigstore.proto.trustroot.v1.TransparencyLogInstanceOrBuilder> 
        getCtlogsFieldBuilder() {
      if (ctlogsBuilder_ == null) {
        ctlogsBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
            dev.sigstore.proto.trustroot.v1.TransparencyLogInstance, dev.sigstore.proto.trustroot.v1.TransparencyLogInstance.Builder, dev.sigstore.proto.trustroot.v1.TransparencyLogInstanceOrBuilder>(
                ctlogs_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        ctlogs_ = null;
      }
      return ctlogsBuilder_;
    }

    private java.util.List<dev.sigstore.proto.trustroot.v1.CertificateAuthority> timestampAuthorities_ =
      java.util.Collections.emptyList();
    private void ensureTimestampAuthoritiesIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        timestampAuthorities_ = new java.util.ArrayList<dev.sigstore.proto.trustroot.v1.CertificateAuthority>(timestampAuthorities_);
        bitField0_ |= 0x00000010;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilder<
        dev.sigstore.proto.trustroot.v1.CertificateAuthority, dev.sigstore.proto.trustroot.v1.CertificateAuthority.Builder, dev.sigstore.proto.trustroot.v1.CertificateAuthorityOrBuilder> timestampAuthoritiesBuilder_;

    /**
     * <pre>
     * A set of trusted timestamping authorities.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority timestamp_authorities = 5;</code>
     */
    public java.util.List<dev.sigstore.proto.trustroot.v1.CertificateAuthority> getTimestampAuthoritiesList() {
      if (timestampAuthoritiesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(timestampAuthorities_);
      } else {
        return timestampAuthoritiesBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * A set of trusted timestamping authorities.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority timestamp_authorities = 5;</code>
     */
    public int getTimestampAuthoritiesCount() {
      if (timestampAuthoritiesBuilder_ == null) {
        return timestampAuthorities_.size();
      } else {
        return timestampAuthoritiesBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * A set of trusted timestamping authorities.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority timestamp_authorities = 5;</code>
     */
    public dev.sigstore.proto.trustroot.v1.CertificateAuthority getTimestampAuthorities(int index) {
      if (timestampAuthoritiesBuilder_ == null) {
        return timestampAuthorities_.get(index);
      } else {
        return timestampAuthoritiesBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * A set of trusted timestamping authorities.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority timestamp_authorities = 5;</code>
     */
    public Builder setTimestampAuthorities(
        int index, dev.sigstore.proto.trustroot.v1.CertificateAuthority value) {
      if (timestampAuthoritiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTimestampAuthoritiesIsMutable();
        timestampAuthorities_.set(index, value);
        onChanged();
      } else {
        timestampAuthoritiesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * A set of trusted timestamping authorities.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority timestamp_authorities = 5;</code>
     */
    public Builder setTimestampAuthorities(
        int index, dev.sigstore.proto.trustroot.v1.CertificateAuthority.Builder builderForValue) {
      if (timestampAuthoritiesBuilder_ == null) {
        ensureTimestampAuthoritiesIsMutable();
        timestampAuthorities_.set(index, builderForValue.build());
        onChanged();
      } else {
        timestampAuthoritiesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * A set of trusted timestamping authorities.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority timestamp_authorities = 5;</code>
     */
    public Builder addTimestampAuthorities(dev.sigstore.proto.trustroot.v1.CertificateAuthority value) {
      if (timestampAuthoritiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTimestampAuthoritiesIsMutable();
        timestampAuthorities_.add(value);
        onChanged();
      } else {
        timestampAuthoritiesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * A set of trusted timestamping authorities.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority timestamp_authorities = 5;</code>
     */
    public Builder addTimestampAuthorities(
        int index, dev.sigstore.proto.trustroot.v1.CertificateAuthority value) {
      if (timestampAuthoritiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTimestampAuthoritiesIsMutable();
        timestampAuthorities_.add(index, value);
        onChanged();
      } else {
        timestampAuthoritiesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * A set of trusted timestamping authorities.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority timestamp_authorities = 5;</code>
     */
    public Builder addTimestampAuthorities(
        dev.sigstore.proto.trustroot.v1.CertificateAuthority.Builder builderForValue) {
      if (timestampAuthoritiesBuilder_ == null) {
        ensureTimestampAuthoritiesIsMutable();
        timestampAuthorities_.add(builderForValue.build());
        onChanged();
      } else {
        timestampAuthoritiesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * A set of trusted timestamping authorities.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority timestamp_authorities = 5;</code>
     */
    public Builder addTimestampAuthorities(
        int index, dev.sigstore.proto.trustroot.v1.CertificateAuthority.Builder builderForValue) {
      if (timestampAuthoritiesBuilder_ == null) {
        ensureTimestampAuthoritiesIsMutable();
        timestampAuthorities_.add(index, builderForValue.build());
        onChanged();
      } else {
        timestampAuthoritiesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * A set of trusted timestamping authorities.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority timestamp_authorities = 5;</code>
     */
    public Builder addAllTimestampAuthorities(
        java.lang.Iterable<? extends dev.sigstore.proto.trustroot.v1.CertificateAuthority> values) {
      if (timestampAuthoritiesBuilder_ == null) {
        ensureTimestampAuthoritiesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, timestampAuthorities_);
        onChanged();
      } else {
        timestampAuthoritiesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * A set of trusted timestamping authorities.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority timestamp_authorities = 5;</code>
     */
    public Builder clearTimestampAuthorities() {
      if (timestampAuthoritiesBuilder_ == null) {
        timestampAuthorities_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        timestampAuthoritiesBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * A set of trusted timestamping authorities.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority timestamp_authorities = 5;</code>
     */
    public Builder removeTimestampAuthorities(int index) {
      if (timestampAuthoritiesBuilder_ == null) {
        ensureTimestampAuthoritiesIsMutable();
        timestampAuthorities_.remove(index);
        onChanged();
      } else {
        timestampAuthoritiesBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * A set of trusted timestamping authorities.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority timestamp_authorities = 5;</code>
     */
    public dev.sigstore.proto.trustroot.v1.CertificateAuthority.Builder getTimestampAuthoritiesBuilder(
        int index) {
      return getTimestampAuthoritiesFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * A set of trusted timestamping authorities.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority timestamp_authorities = 5;</code>
     */
    public dev.sigstore.proto.trustroot.v1.CertificateAuthorityOrBuilder getTimestampAuthoritiesOrBuilder(
        int index) {
      if (timestampAuthoritiesBuilder_ == null) {
        return timestampAuthorities_.get(index);  } else {
        return timestampAuthoritiesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * A set of trusted timestamping authorities.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority timestamp_authorities = 5;</code>
     */
    public java.util.List<? extends dev.sigstore.proto.trustroot.v1.CertificateAuthorityOrBuilder> 
         getTimestampAuthoritiesOrBuilderList() {
      if (timestampAuthoritiesBuilder_ != null) {
        return timestampAuthoritiesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(timestampAuthorities_);
      }
    }
    /**
     * <pre>
     * A set of trusted timestamping authorities.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority timestamp_authorities = 5;</code>
     */
    public dev.sigstore.proto.trustroot.v1.CertificateAuthority.Builder addTimestampAuthoritiesBuilder() {
      return getTimestampAuthoritiesFieldBuilder().addBuilder(
          dev.sigstore.proto.trustroot.v1.CertificateAuthority.getDefaultInstance());
    }
    /**
     * <pre>
     * A set of trusted timestamping authorities.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority timestamp_authorities = 5;</code>
     */
    public dev.sigstore.proto.trustroot.v1.CertificateAuthority.Builder addTimestampAuthoritiesBuilder(
        int index) {
      return getTimestampAuthoritiesFieldBuilder().addBuilder(
          index, dev.sigstore.proto.trustroot.v1.CertificateAuthority.getDefaultInstance());
    }
    /**
     * <pre>
     * A set of trusted timestamping authorities.
     * </pre>
     *
     * <code>repeated .dev.sigstore.trustroot.v1.CertificateAuthority timestamp_authorities = 5;</code>
     */
    public java.util.List<dev.sigstore.proto.trustroot.v1.CertificateAuthority.Builder> 
         getTimestampAuthoritiesBuilderList() {
      return getTimestampAuthoritiesFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilder<
        dev.sigstore.proto.trustroot.v1.CertificateAuthority, dev.sigstore.proto.trustroot.v1.CertificateAuthority.Builder, dev.sigstore.proto.trustroot.v1.CertificateAuthorityOrBuilder> 
        getTimestampAuthoritiesFieldBuilder() {
      if (timestampAuthoritiesBuilder_ == null) {
        timestampAuthoritiesBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
            dev.sigstore.proto.trustroot.v1.CertificateAuthority, dev.sigstore.proto.trustroot.v1.CertificateAuthority.Builder, dev.sigstore.proto.trustroot.v1.CertificateAuthorityOrBuilder>(
                timestampAuthorities_,
                ((bitField0_ & 0x00000010) != 0),
                getParentForChildren(),
                isClean());
        timestampAuthorities_ = null;
      }
      return timestampAuthoritiesBuilder_;
    }

    // @@protoc_insertion_point(builder_scope:dev.sigstore.trustroot.v1.TrustedRoot)
  }

  // @@protoc_insertion_point(class_scope:dev.sigstore.trustroot.v1.TrustedRoot)
  private static final dev.sigstore.proto.trustroot.v1.TrustedRoot DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new dev.sigstore.proto.trustroot.v1.TrustedRoot();
  }

  public static dev.sigstore.proto.trustroot.v1.TrustedRoot getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TrustedRoot>
      PARSER = new com.google.protobuf.AbstractParser<TrustedRoot>() {
    @java.lang.Override
    public TrustedRoot parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<TrustedRoot> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TrustedRoot> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public dev.sigstore.proto.trustroot.v1.TrustedRoot getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

