
package dev.sigstore.rekor;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.processing.Generated;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;


/**
 * Specifies the hash algorithm and value for the content
 * 
 */
@Generated("jsonschema2pojo")
public class Hash {

    /**
     * The hashing function used to compute the hash value
     * (Required)
     * 
     */
    @SerializedName("algorithm")
    @Expose
    private Hash.Algorithm algorithm;
    /**
     * The hash value for the content
     * (Required)
     * 
     */
    @SerializedName("value")
    @Expose
    private String value;

    /**
     * The hashing function used to compute the hash value
     * (Required)
     * 
     */
    public Hash.Algorithm getAlgorithm() {
        return algorithm;
    }

    /**
     * The hashing function used to compute the hash value
     * (Required)
     * 
     */
    public void setAlgorithm(Hash.Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    public Hash withAlgorithm(Hash.Algorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    /**
     * The hash value for the content
     * (Required)
     * 
     */
    public String getValue() {
        return value;
    }

    /**
     * The hash value for the content
     * (Required)
     * 
     */
    public void setValue(String value) {
        this.value = value;
    }

    public Hash withValue(String value) {
        this.value = value;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Hash.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("algorithm");
        sb.append('=');
        sb.append(((this.algorithm == null)?"<null>":this.algorithm));
        sb.append(',');
        sb.append("value");
        sb.append('=');
        sb.append(((this.value == null)?"<null>":this.value));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.value == null)? 0 :this.value.hashCode()));
        result = ((result* 31)+((this.algorithm == null)? 0 :this.algorithm.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Hash) == false) {
            return false;
        }
        Hash rhs = ((Hash) other);
        return (((this.value == rhs.value)||((this.value!= null)&&this.value.equals(rhs.value)))&&((this.algorithm == rhs.algorithm)||((this.algorithm!= null)&&this.algorithm.equals(rhs.algorithm))));
    }


    /**
     * The hashing function used to compute the hash value
     * 
     */
    @Generated("jsonschema2pojo")
    public enum Algorithm {

        @SerializedName("sha256")
        SHA_256("sha256");
        private final String value;
        private final static Map<String, Hash.Algorithm> CONSTANTS = new HashMap<String, Hash.Algorithm>();

        static {
            for (Hash.Algorithm c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Algorithm(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static Hash.Algorithm fromValue(String value) {
            Hash.Algorithm constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
