/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore;

import com.google.api.client.util.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteSource;
import com.google.common.io.Files;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import dev.sigstore.KeylessSignerException;
import dev.sigstore.TrustedRootProvider;
import dev.sigstore.bundle.Bundle;
import dev.sigstore.bundle.ImmutableBundle;
import dev.sigstore.encryption.certificates.Certificates;
import dev.sigstore.encryption.signers.Signer;
import dev.sigstore.encryption.signers.Signers;
import dev.sigstore.fulcio.client.CertificateRequest;
import dev.sigstore.fulcio.client.FulcioClient;
import dev.sigstore.fulcio.client.FulcioClientGrpc;
import dev.sigstore.fulcio.client.FulcioVerificationException;
import dev.sigstore.fulcio.client.FulcioVerifier;
import dev.sigstore.fulcio.client.UnsupportedAlgorithmException;
import dev.sigstore.oidc.client.OidcClients;
import dev.sigstore.oidc.client.OidcException;
import dev.sigstore.oidc.client.OidcToken;
import dev.sigstore.oidc.client.OidcTokenMatcher;
import dev.sigstore.rekor.client.HashedRekordRequest;
import dev.sigstore.rekor.client.RekorClient;
import dev.sigstore.rekor.client.RekorClientHttp;
import dev.sigstore.rekor.client.RekorParseException;
import dev.sigstore.rekor.client.RekorResponse;
import dev.sigstore.rekor.client.RekorVerificationException;
import dev.sigstore.rekor.client.RekorVerifier;
import dev.sigstore.trustroot.SigstoreTrustedRoot;
import dev.sigstore.tuf.SigstoreTufClient;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import org.bouncycastle.util.encoders.Base64;

public class KeylessSigner
implements AutoCloseable {
    public static final Duration DEFAULT_MIN_SIGNING_CERTIFICATE_LIFETIME = Duration.ofMinutes(5L);
    private final FulcioClient fulcioClient;
    private final FulcioVerifier fulcioVerifier;
    private final RekorClient rekorClient;
    private final RekorVerifier rekorVerifier;
    private final OidcClients oidcClients;
    private final List<OidcTokenMatcher> oidcIdentities;
    private final Signer signer;
    private final Duration minSigningCertificateLifetime;
    @Nullable
    @GuardedBy(value="lock")
    private CertPath signingCert;
    @Nullable
    @GuardedBy(value="lock")
    private byte[] signingCertPemBytes;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    private KeylessSigner(FulcioClient fulcioClient, FulcioVerifier fulcioVerifier, RekorClient rekorClient, RekorVerifier rekorVerifier, OidcClients oidcClients, List<OidcTokenMatcher> oidcIdentities, Signer signer, Duration minSigningCertificateLifetime) {
        this.fulcioClient = fulcioClient;
        this.fulcioVerifier = fulcioVerifier;
        this.rekorClient = rekorClient;
        this.rekorVerifier = rekorVerifier;
        this.oidcClients = oidcClients;
        this.oidcIdentities = oidcIdentities;
        this.signer = signer;
        this.minSigningCertificateLifetime = minSigningCertificateLifetime;
    }

    @Override
    public void close() {
        this.lock.writeLock().lock();
        try {
            this.signingCert = null;
            this.signingCertPemBytes = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @CheckReturnValue
    public static Builder builder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckReturnValue
    public List<Bundle> sign(List<byte[]> artifactDigests) throws KeylessSignerException {
        if (artifactDigests.size() == 0) {
            throw new IllegalArgumentException("Require one or more digests");
        }
        ImmutableList.Builder result = ImmutableList.builder();
        for (byte[] artifactDigest : artifactDigests) {
            RekorResponse rekorResponse;
            byte[] signingCertPemBytes;
            CertPath signingCert;
            byte[] signature;
            try {
                signature = this.signer.signDigest(artifactDigest);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException ex) {
                throw new KeylessSignerException("Failed to sign artifact", ex);
            }
            try {
                this.renewSigningCertificate();
            }
            catch (FulcioVerificationException | UnsupportedAlgorithmException | OidcException | IOException | InterruptedException | InvalidKeyException | NoSuchAlgorithmException | SignatureException | CertificateException ex) {
                throw new KeylessSignerException("Failed to obtain signing certificate", ex);
            }
            this.lock.readLock().lock();
            try {
                signingCert = this.signingCert;
                signingCertPemBytes = this.signingCertPemBytes;
                if (signingCert == null) {
                    throw new IllegalStateException("Signing certificate is null");
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
            HashedRekordRequest rekorRequest = HashedRekordRequest.newHashedRekordRequest(artifactDigest, signingCertPemBytes, signature);
            try {
                rekorResponse = this.rekorClient.putEntry(rekorRequest);
            }
            catch (RekorParseException | IOException ex) {
                throw new KeylessSignerException("Failed to put entry in rekor", ex);
            }
            String calculatedHashedRekord = Base64.toBase64String((byte[])rekorRequest.toJsonPayload().getBytes(StandardCharsets.UTF_8));
            if (!Objects.equals(calculatedHashedRekord, rekorResponse.getEntry().getBody())) {
                throw new KeylessSignerException("Returned log entry was inconsistent with request");
            }
            try {
                this.rekorVerifier.verifyEntry(rekorResponse.getEntry());
            }
            catch (RekorVerificationException ex) {
                throw new KeylessSignerException("Failed to validate rekor response after signing", ex);
            }
            result.add((Object)ImmutableBundle.builder().certPath(signingCert).addEntries(rekorResponse.getEntry()).messageSignature(Bundle.MessageSignature.of(Bundle.HashAlgorithm.SHA2_256, artifactDigest, signature)).build());
        }
        return result.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renewSigningCertificate() throws InterruptedException, CertificateException, IOException, UnsupportedAlgorithmException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, FulcioVerificationException, OidcException, KeylessSignerException {
        this.lock.readLock().lock();
        try {
            long lifetimeLeft;
            if (this.signingCert != null && (lifetimeLeft = Certificates.getLeaf(this.signingCert).getNotAfter().getTime() - System.currentTimeMillis()) > this.minSigningCertificateLifetime.toMillis()) {
                return;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            this.signingCert = null;
            this.signingCertPemBytes = null;
            OidcToken tokenInfo = this.oidcClients.getIDToken();
            if (!this.oidcIdentities.isEmpty() && this.oidcIdentities.stream().noneMatch(id -> id.test(tokenInfo))) {
                throw new KeylessSignerException("Obtained Oidc Token " + tokenInfo + " does not match any identities in allow list");
            }
            CertPath renewedSigningCert = this.fulcioClient.signingCertificate(CertificateRequest.newCertificateRequest(this.signer.getPublicKey(), tokenInfo.getIdToken(), this.signer.sign(tokenInfo.getSubjectAlternativeName().getBytes(StandardCharsets.UTF_8))));
            CertPath trimmed = this.fulcioVerifier.trimTrustedParent(renewedSigningCert);
            this.fulcioVerifier.verifySigningCertificate(trimmed);
            this.signingCert = trimmed;
            this.signingCertPemBytes = Certificates.toPemBytes(this.signingCert);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @CheckReturnValue
    public Bundle sign(byte[] artifactDigest) throws KeylessSignerException {
        return this.sign(List.of(artifactDigest)).get(0);
    }

    @CheckReturnValue
    public Map<Path, Bundle> signFiles(List<Path> artifacts) throws KeylessSignerException {
        if (artifacts.size() == 0) {
            throw new IllegalArgumentException("Require one or more paths");
        }
        ArrayList<byte[]> digests = new ArrayList<byte[]>(artifacts.size());
        for (Path artifact : artifacts) {
            ByteSource artifactByteSource = Files.asByteSource((File)artifact.toFile());
            try {
                digests.add(artifactByteSource.hash(Hashing.sha256()).asBytes());
            }
            catch (IOException ex) {
                throw new KeylessSignerException("Failed to hash artifact " + artifact);
            }
        }
        List<Bundle> signingResult = this.sign(digests);
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (int i = 0; i < artifacts.size(); ++i) {
            result.put((Object)artifacts.get(i), (Object)signingResult.get(i));
        }
        return result.build();
    }

    @CheckReturnValue
    public Bundle signFile(Path artifact) throws KeylessSignerException {
        return this.signFiles(List.of(artifact)).get(artifact);
    }

    @Deprecated
    public Bundle signFile2(Path artifact) throws KeylessSignerException {
        return this.signFiles(List.of(artifact)).get(artifact);
    }

    public static class Builder {
        private TrustedRootProvider trustedRootProvider;
        private OidcClients oidcClients;
        private List<OidcTokenMatcher> oidcIdentities = Collections.emptyList();
        private Signer signer;
        private Duration minSigningCertificateLifetime = DEFAULT_MIN_SIGNING_CERTIFICATE_LIFETIME;
        private URI fulcioUri;
        private URI rekorUri;

        @CanIgnoreReturnValue
        public Builder fulcioUrl(URI uri) {
            this.fulcioUri = uri;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder rekorUrl(URI uri) {
            this.rekorUri = uri;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder trustedRootProvider(TrustedRootProvider trustedRootProvider) {
            this.trustedRootProvider = trustedRootProvider;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder oidcClients(OidcClients oidcClients) {
            this.oidcClients = oidcClients;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder allowedOidcIdentities(List<OidcTokenMatcher> oidcIdentities) {
            this.oidcIdentities = ImmutableList.copyOf(oidcIdentities);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder signer(Signer signer) {
            this.signer = signer;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder minSigningCertificateLifetime(Duration minSigningCertificateLifetime) {
            this.minSigningCertificateLifetime = minSigningCertificateLifetime;
            return this;
        }

        @CheckReturnValue
        public KeylessSigner build() throws CertificateException, IOException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, InvalidAlgorithmParameterException {
            Preconditions.checkNotNull((Object)this.trustedRootProvider);
            SigstoreTrustedRoot trustedRoot = this.trustedRootProvider.get();
            Preconditions.checkNotNull((Object)this.fulcioUri);
            Preconditions.checkNotNull((Object)this.rekorUri);
            Preconditions.checkNotNull((Object)this.oidcClients);
            Preconditions.checkNotNull(this.oidcIdentities);
            Preconditions.checkNotNull((Object)this.signer);
            Preconditions.checkNotNull((Object)this.minSigningCertificateLifetime);
            FulcioClientGrpc fulcioClient = FulcioClientGrpc.builder().setUri(this.fulcioUri).build();
            FulcioVerifier fulcioVerifier = FulcioVerifier.newFulcioVerifier(trustedRoot);
            RekorClientHttp rekorClient = RekorClientHttp.builder().setUri(this.rekorUri).build();
            RekorVerifier rekorVerifier = RekorVerifier.newRekorVerifier(trustedRoot);
            return new KeylessSigner(fulcioClient, fulcioVerifier, rekorClient, rekorVerifier, this.oidcClients, this.oidcIdentities, this.signer, this.minSigningCertificateLifetime);
        }

        @CanIgnoreReturnValue
        public Builder sigstorePublicDefaults() {
            SigstoreTufClient.Builder sigstoreTufClientBuilder = SigstoreTufClient.builder().usePublicGoodInstance();
            this.trustedRootProvider = TrustedRootProvider.from(sigstoreTufClientBuilder);
            this.fulcioUri = FulcioClient.PUBLIC_GOOD_URI;
            this.rekorUri = RekorClient.PUBLIC_GOOD_URI;
            this.oidcClients(OidcClients.PUBLIC_GOOD);
            this.signer(Signers.newEcdsaSigner());
            this.minSigningCertificateLifetime(DEFAULT_MIN_SIGNING_CERTIFICATE_LIFETIME);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder sigstoreStagingDefaults() {
            SigstoreTufClient.Builder sigstoreTufClientBuilder = SigstoreTufClient.builder().useStagingInstance();
            this.trustedRootProvider = TrustedRootProvider.from(sigstoreTufClientBuilder);
            this.fulcioUri = FulcioClient.STAGING_URI;
            this.rekorUri = RekorClient.STAGING_URI;
            this.oidcClients(OidcClients.STAGING);
            this.signer(Signers.newEcdsaSigner());
            this.minSigningCertificateLifetime(DEFAULT_MIN_SIGNING_CERTIFICATE_LIFETIME);
            return this;
        }
    }
}

