/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore;

import com.google.common.base.Preconditions;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import dev.sigstore.proto.trustroot.v1.TrustedRoot;
import dev.sigstore.trustroot.SigstoreTrustedRoot;
import dev.sigstore.tuf.SigstoreTufClient;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;

@FunctionalInterface
public interface TrustedRootProvider {
    public SigstoreTrustedRoot get() throws InvalidAlgorithmParameterException, CertificateException, InvalidKeySpecException, NoSuchAlgorithmException, IOException, InvalidKeyException;

    public static TrustedRootProvider from(SigstoreTufClient.Builder tufClientBuilder) {
        Preconditions.checkNotNull((Object)tufClientBuilder);
        return () -> {
            SigstoreTufClient tufClient = tufClientBuilder.build();
            tufClient.update();
            return tufClient.getSigstoreTrustedRoot();
        };
    }

    public static TrustedRootProvider from(Path trustedRoot) {
        Preconditions.checkNotNull((Object)trustedRoot);
        return () -> {
            TrustedRoot.Builder trustedRootBuilder = TrustedRoot.newBuilder();
            JsonFormat.parser().merge(Files.readString(trustedRoot, StandardCharsets.UTF_8), (Message.Builder)trustedRootBuilder);
            return SigstoreTrustedRoot.from(trustedRootBuilder.build());
        };
    }
}

