/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.bundle;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import dev.sigstore.bundle.Bundle;
import dev.sigstore.bundle.BundleParseException;
import dev.sigstore.bundle.ImmutableBundle;
import dev.sigstore.bundle.ImmutableDSSESignature;
import dev.sigstore.bundle.ImmutableMessageDigest;
import dev.sigstore.bundle.ImmutableMessageSignature;
import dev.sigstore.bundle.ImmutableTimestamp;
import dev.sigstore.proto.ProtoMutators;
import dev.sigstore.proto.bundle.v1.Bundle;
import dev.sigstore.proto.common.v1.HashAlgorithm;
import dev.sigstore.proto.common.v1.RFC3161SignedTimestamp;
import dev.sigstore.proto.rekor.v1.InclusionProof;
import dev.sigstore.proto.rekor.v1.TransparencyLogEntry;
import dev.sigstore.rekor.client.ImmutableInclusionProof;
import dev.sigstore.rekor.client.ImmutableRekorEntry;
import dev.sigstore.rekor.client.ImmutableVerification;
import dev.sigstore.rekor.client.RekorEntry;
import io.intoto.EnvelopeOuterClass;
import java.io.IOException;
import java.io.Reader;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import org.bouncycastle.util.encoders.Hex;

class BundleReader {
    BundleReader() {
    }

    static Bundle readBundle(Reader jsonReader) throws BundleParseException {
        CertPath certPath;
        ImmutableBundle.Builder bundleBuilder;
        dev.sigstore.proto.bundle.v1.Bundle protoBundle;
        block21: {
            Bundle.Builder protoBundleBuilder = dev.sigstore.proto.bundle.v1.Bundle.newBuilder();
            try {
                JsonFormat.parser().merge(jsonReader, (Message.Builder)protoBundleBuilder);
            }
            catch (IOException ioe) {
                throw new BundleParseException("Could not process bundle json", ioe);
            }
            protoBundle = protoBundleBuilder.build();
            bundleBuilder = ImmutableBundle.builder();
            if (!Bundle.SUPPORTED_MEDIA_TYPES.contains(protoBundle.getMediaType())) {
                throw new BundleParseException("Unsupported bundle media type: " + protoBundle.getMediaType());
            }
            bundleBuilder.mediaType(protoBundle.getMediaType());
            if (protoBundle.getVerificationMaterial().getTlogEntriesCount() == 0) {
                throw new BundleParseException("Could not find any tlog entries in bundle json");
            }
            for (TransparencyLogEntry bundleEntry : protoBundle.getVerificationMaterial().getTlogEntriesList()) {
                if (!bundleEntry.hasInclusionProof()) {
                    throw new BundleParseException("Could not find an inclusion proof");
                }
                InclusionProof bundleInclusionProof = bundleEntry.getInclusionProof();
                ImmutableInclusionProof inclusionProof = ImmutableInclusionProof.builder().logIndex(bundleInclusionProof.getLogIndex()).rootHash(Hex.toHexString((byte[])bundleInclusionProof.getRootHash().toByteArray())).treeSize(bundleInclusionProof.getTreeSize()).checkpoint(bundleInclusionProof.getCheckpoint().getEnvelope()).addAllHashes(bundleInclusionProof.getHashesList().stream().map(ByteString::toByteArray).map(Hex::toHexString).collect(Collectors.toList())).build();
                ImmutableVerification verification = ImmutableVerification.builder().signedEntryTimestamp(Base64.getEncoder().encodeToString(bundleEntry.getInclusionPromise().getSignedEntryTimestamp().toByteArray())).inclusionProof(inclusionProof).build();
                ImmutableRekorEntry rekorEntry = ImmutableRekorEntry.builder().integratedTime(bundleEntry.getIntegratedTime()).logID(Hex.toHexString((byte[])bundleEntry.getLogId().getKeyId().toByteArray())).logIndex(bundleEntry.getLogIndex()).body(Base64.getEncoder().encodeToString(bundleEntry.getCanonicalizedBody().toByteArray())).verification(verification).build();
                bundleBuilder.addEntries((RekorEntry)rekorEntry);
            }
            if (protoBundle.hasDsseEnvelope()) {
                EnvelopeOuterClass.Envelope dsseEnvelope = protoBundle.getDsseEnvelope();
                if (dsseEnvelope.getSignaturesCount() != 1) {
                    throw new BundleParseException("DSEE envelopes must contain exactly one signature");
                }
                ImmutableDSSESignature dsseSignature = ImmutableDSSESignature.builder().payload(dsseEnvelope.getPayload().toStringUtf8()).payloadType(dsseEnvelope.getPayloadType()).signature(dsseEnvelope.getSignatures(0).toByteArray()).build();
                bundleBuilder.dSSESignature(dsseSignature);
            } else if (protoBundle.hasMessageSignature()) {
                byte[] signature = protoBundle.getMessageSignature().getSignature().toByteArray();
                if (protoBundle.getMessageSignature().hasMessageDigest()) {
                    HashAlgorithm hashAlgorithm = protoBundle.getMessageSignature().getMessageDigest().getAlgorithm();
                    if (hashAlgorithm != HashAlgorithm.SHA2_256) {
                        throw new BundleParseException("Cannot read message digests of type " + hashAlgorithm + ", only " + HashAlgorithm.SHA2_256 + " is supported");
                    }
                    ImmutableMessageSignature messageSignature = ImmutableMessageSignature.builder().messageDigest(ImmutableMessageDigest.builder().hashAlgorithm(Bundle.HashAlgorithm.SHA2_256).digest(protoBundle.getMessageSignature().getMessageDigest().getDigest().toByteArray()).build()).signature(signature).build();
                    bundleBuilder.messageSignature(messageSignature);
                } else {
                    bundleBuilder.messageSignature(ImmutableMessageSignature.builder().signature(signature).build());
                }
            } else {
                throw new BundleParseException("A MessageSignature or DSSEEnvelope must be provided");
            }
            try {
                if (protoBundle.getVerificationMaterial().hasCertificate()) {
                    certPath = ProtoMutators.toCertPath(List.of(protoBundle.getVerificationMaterial().getCertificate()));
                    break block21;
                }
                if (protoBundle.getVerificationMaterial().hasX509CertificateChain()) {
                    certPath = ProtoMutators.toCertPath(protoBundle.getVerificationMaterial().getX509CertificateChain().getCertificatesList());
                    break block21;
                }
                if (protoBundle.getVerificationMaterial().hasPublicKey()) {
                    throw new BundleParseException("Plain public keys are not supported by this client");
                }
                throw new BundleParseException("Could not find a certificate or certificate chain");
            }
            catch (CertificateException ce) {
                throw new BundleParseException("Could not parse bundle certificate chain", ce);
            }
        }
        bundleBuilder.certPath(certPath);
        if (protoBundle.getVerificationMaterial().hasTimestampVerificationData()) {
            for (RFC3161SignedTimestamp timestamp : protoBundle.getVerificationMaterial().getTimestampVerificationData().getRfc3161TimestampsList()) {
                bundleBuilder.addTimestamps((Bundle.Timestamp)ImmutableTimestamp.builder().rfc3161Timestamp(timestamp.toByteArray()).build());
            }
        }
        return bundleBuilder.build();
    }
}

