/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.fulcio.client;

import com.google.common.collect.ImmutableMap;
import dev.sigstore.fulcio.client.ImmutableCertificateRequest;
import dev.sigstore.fulcio.client.UnsupportedAlgorithmException;
import dev.sigstore.fulcio.v2.PublicKeyAlgorithm;
import java.security.PublicKey;
import java.util.Map;
import org.immutables.value.Value;

@Value.Immutable
public interface CertificateRequest {
    public static final Map<String, PublicKeyAlgorithm> SUPPORTED_ALGORITHMS = ImmutableMap.of((Object)"EC", (Object)((Object)PublicKeyAlgorithm.ECDSA), (Object)"RSA", (Object)((Object)PublicKeyAlgorithm.RSA_PSS));

    public PublicKey getPublicKey();

    public PublicKeyAlgorithm getPublicKeyAlgorithm();

    public byte[] getProofOfPossession();

    public String getIdToken();

    public static CertificateRequest newCertificateRequest(PublicKey publicKey, String idToken, byte[] proofOfPossession) throws UnsupportedAlgorithmException {
        if (!SUPPORTED_ALGORITHMS.containsKey(publicKey.getAlgorithm())) {
            throw new UnsupportedAlgorithmException(SUPPORTED_ALGORITHMS.keySet(), publicKey.getAlgorithm());
        }
        return ImmutableCertificateRequest.builder().publicKey(publicKey).publicKeyAlgorithm(SUPPORTED_ALGORITHMS.get(publicKey.getAlgorithm())).idToken(idToken).proofOfPossession(proofOfPossession).build();
    }
}

