/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.fulcio.client;

import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.fulcio.client.FulcioCertificateMatcher;
import dev.sigstore.strings.StringMatcher;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FulcioCertificateMatcher", generator="Immutables")
@Immutable
public final class ImmutableFulcioCertificateMatcher
extends FulcioCertificateMatcher {
    private final StringMatcher issuer;
    private final StringMatcher subjectAlternativeName;
    private final ImmutableMap<String, StringMatcher> oidRawStrings;
    private final ImmutableMap<String, StringMatcher> oidDerAsn1Strings;
    private final ImmutableMap<String, byte[]> oidBytes;

    private ImmutableFulcioCertificateMatcher(StringMatcher issuer, StringMatcher subjectAlternativeName, ImmutableMap<String, StringMatcher> oidRawStrings, ImmutableMap<String, StringMatcher> oidDerAsn1Strings, ImmutableMap<String, byte[]> oidBytes) {
        this.issuer = issuer;
        this.subjectAlternativeName = subjectAlternativeName;
        this.oidRawStrings = oidRawStrings;
        this.oidDerAsn1Strings = oidDerAsn1Strings;
        this.oidBytes = oidBytes;
    }

    @Override
    public StringMatcher getIssuer() {
        return this.issuer;
    }

    @Override
    public StringMatcher getSubjectAlternativeName() {
        return this.subjectAlternativeName;
    }

    public ImmutableMap<String, StringMatcher> getOidRawStrings() {
        return this.oidRawStrings;
    }

    public ImmutableMap<String, StringMatcher> getOidDerAsn1Strings() {
        return this.oidDerAsn1Strings;
    }

    public ImmutableMap<String, byte[]> getOidBytes() {
        return this.oidBytes;
    }

    public final ImmutableFulcioCertificateMatcher withIssuer(StringMatcher value) {
        if (this.issuer == value) {
            return this;
        }
        StringMatcher newValue = Objects.requireNonNull(value, "issuer");
        return new ImmutableFulcioCertificateMatcher(newValue, this.subjectAlternativeName, this.oidRawStrings, this.oidDerAsn1Strings, this.oidBytes);
    }

    public final ImmutableFulcioCertificateMatcher withSubjectAlternativeName(StringMatcher value) {
        if (this.subjectAlternativeName == value) {
            return this;
        }
        StringMatcher newValue = Objects.requireNonNull(value, "subjectAlternativeName");
        return new ImmutableFulcioCertificateMatcher(this.issuer, newValue, this.oidRawStrings, this.oidDerAsn1Strings, this.oidBytes);
    }

    public final ImmutableFulcioCertificateMatcher withOidRawStrings(Map<String, ? extends StringMatcher> entries) {
        if (this.oidRawStrings == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableFulcioCertificateMatcher(this.issuer, this.subjectAlternativeName, (ImmutableMap<String, StringMatcher>)newValue, this.oidDerAsn1Strings, this.oidBytes);
    }

    public final ImmutableFulcioCertificateMatcher withOidDerAsn1Strings(Map<String, ? extends StringMatcher> entries) {
        if (this.oidDerAsn1Strings == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableFulcioCertificateMatcher(this.issuer, this.subjectAlternativeName, this.oidRawStrings, (ImmutableMap<String, StringMatcher>)newValue, this.oidBytes);
    }

    public final ImmutableFulcioCertificateMatcher withOidBytes(Map<String, ? extends byte[]> entries) {
        if (this.oidBytes == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableFulcioCertificateMatcher(this.issuer, this.subjectAlternativeName, this.oidRawStrings, this.oidDerAsn1Strings, (ImmutableMap<String, byte[]>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFulcioCertificateMatcher && this.equalTo(0, (ImmutableFulcioCertificateMatcher)another);
    }

    private boolean equalTo(int synthetic, ImmutableFulcioCertificateMatcher another) {
        return this.issuer.equals(another.issuer) && this.subjectAlternativeName.equals(another.subjectAlternativeName) && this.oidRawStrings.equals(another.oidRawStrings) && this.oidDerAsn1Strings.equals(another.oidDerAsn1Strings) && this.oidBytes.equals(another.oidBytes);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.issuer.hashCode();
        h += (h << 5) + this.subjectAlternativeName.hashCode();
        h += (h << 5) + this.oidRawStrings.hashCode();
        h += (h << 5) + this.oidDerAsn1Strings.hashCode();
        h += (h << 5) + this.oidBytes.hashCode();
        return h;
    }

    public static ImmutableFulcioCertificateMatcher copyOf(FulcioCertificateMatcher instance) {
        if (instance instanceof ImmutableFulcioCertificateMatcher) {
            return (ImmutableFulcioCertificateMatcher)instance;
        }
        return ImmutableFulcioCertificateMatcher.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FulcioCertificateMatcher", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ISSUER = 1L;
        private static final long INIT_BIT_SUBJECT_ALTERNATIVE_NAME = 2L;
        private long initBits = 3L;
        @Nullable
        private StringMatcher issuer;
        @Nullable
        private StringMatcher subjectAlternativeName;
        private ImmutableMap.Builder<String, StringMatcher> oidRawStrings = ImmutableMap.builder();
        private ImmutableMap.Builder<String, StringMatcher> oidDerAsn1Strings = ImmutableMap.builder();
        private ImmutableMap.Builder<String, byte[]> oidBytes = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(FulcioCertificateMatcher instance) {
            Objects.requireNonNull(instance, "instance");
            this.issuer(instance.getIssuer());
            this.subjectAlternativeName(instance.getSubjectAlternativeName());
            this.putAllOidRawStrings(instance.getOidRawStrings());
            this.putAllOidDerAsn1Strings(instance.getOidDerAsn1Strings());
            this.putAllOidBytes(instance.getOidBytes());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder issuer(StringMatcher issuer) {
            this.issuer = Objects.requireNonNull(issuer, "issuer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder subjectAlternativeName(StringMatcher subjectAlternativeName) {
            this.subjectAlternativeName = Objects.requireNonNull(subjectAlternativeName, "subjectAlternativeName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putOidRawStrings(String key, StringMatcher value) {
            this.oidRawStrings.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putOidRawStrings(Map.Entry<String, ? extends StringMatcher> entry) {
            this.oidRawStrings.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder oidRawStrings(Map<String, ? extends StringMatcher> entries) {
            this.oidRawStrings = ImmutableMap.builder();
            return this.putAllOidRawStrings(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllOidRawStrings(Map<String, ? extends StringMatcher> entries) {
            this.oidRawStrings.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putOidDerAsn1Strings(String key, StringMatcher value) {
            this.oidDerAsn1Strings.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putOidDerAsn1Strings(Map.Entry<String, ? extends StringMatcher> entry) {
            this.oidDerAsn1Strings.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder oidDerAsn1Strings(Map<String, ? extends StringMatcher> entries) {
            this.oidDerAsn1Strings = ImmutableMap.builder();
            return this.putAllOidDerAsn1Strings(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllOidDerAsn1Strings(Map<String, ? extends StringMatcher> entries) {
            this.oidDerAsn1Strings.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putOidBytes(String key, byte[] value) {
            this.oidBytes.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putOidBytes(Map.Entry<String, ? extends byte[]> entry) {
            this.oidBytes.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder oidBytes(Map<String, ? extends byte[]> entries) {
            this.oidBytes = ImmutableMap.builder();
            return this.putAllOidBytes(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllOidBytes(Map<String, ? extends byte[]> entries) {
            this.oidBytes.putAll(entries);
            return this;
        }

        public ImmutableFulcioCertificateMatcher build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFulcioCertificateMatcher(this.issuer, this.subjectAlternativeName, (ImmutableMap<String, StringMatcher>)this.oidRawStrings.build(), (ImmutableMap<String, StringMatcher>)this.oidDerAsn1Strings.build(), (ImmutableMap<String, byte[]>)this.oidBytes.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("issuer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("subjectAlternativeName");
            }
            return "Cannot build FulcioCertificateMatcher, some of required attributes are not set " + attributes;
        }
    }
}

