/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.rekor.client;

import com.google.common.base.Splitter;
import dev.sigstore.rekor.client.ImmutableCheckpoint;
import dev.sigstore.rekor.client.ImmutableCheckpointSignature;
import dev.sigstore.rekor.client.RekorEntry;
import dev.sigstore.rekor.client.RekorParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

class Checkpoints {
    private static final Pattern SIGNATURE_BLOCK = Pattern.compile("\\u2014 (\\S+) (\\S+)");

    Checkpoints() {
    }

    static RekorEntry.Checkpoint from(String encoded) throws RekorParseException {
        long size;
        List split = Splitter.on((String)"\n\n").splitToList((CharSequence)encoded);
        if (split.size() != 2) {
            throw new RekorParseException("Checkpoint must contain one blank line, delineating the header from the signature block");
        }
        String header = (String)split.get(0);
        String data = (String)split.get(1);
        List headers = Splitter.on((String)"\n").splitToList((CharSequence)header);
        if (headers.size() < 3) {
            throw new RekorParseException("Checkpoint header must contain at least 3 lines");
        }
        String origin = (String)headers.get(0);
        try {
            size = Long.parseLong((String)headers.get(1));
        }
        catch (NumberFormatException nfe) {
            throw new RekorParseException("Checkpoint header attribute size must be a number, but was: " + (String)headers.get(1));
        }
        String base64Hash = (String)headers.get(2);
        if (data.length() == 0) {
            throw new RekorParseException("Checkpoint body must contain at least one signature");
        }
        if (!data.endsWith("\n")) {
            throw new RekorParseException("Checkpoint signature section must end with newline");
        }
        ArrayList<RekorEntry.CheckpointSignature> signatures = new ArrayList<RekorEntry.CheckpointSignature>();
        for (String sig : data.lines().collect(Collectors.toList())) {
            signatures.add(Checkpoints.sigFrom(sig));
        }
        return ImmutableCheckpoint.builder().signedData(header + "\n").origin(origin).size(size).base64Hash(base64Hash).addAllSignatures(signatures).build();
    }

    static RekorEntry.CheckpointSignature sigFrom(String signatureLine) throws RekorParseException {
        Matcher m = SIGNATURE_BLOCK.matcher(signatureLine);
        if (!m.find()) {
            throw new RekorParseException("Checkpoint signature '" + signatureLine + "' was not in the format '\u2014 <id> <base64 keyhint+signature>'");
        }
        String identity = m.group(1);
        byte[] keySig = Base64.getDecoder().decode(m.group(2));
        if (keySig.length < 5) {
            throw new RekorParseException("Checkpoint signature <keyhint + signature> was " + keySig.length + " bytes long, but must be at least 5 bytes long");
        }
        byte[] keyHint = Arrays.copyOfRange(keySig, 0, 4);
        byte[] signature = Arrays.copyOfRange(keySig, 4, keySig.length);
        return ImmutableCheckpointSignature.builder().identity(identity).keyHint(keyHint).signature(signature).build();
    }
}

