/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.rekor.client;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.rekor.client.RekorEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RekorEntry.CheckpointSignature", generator="Immutables")
@Immutable
public final class ImmutableCheckpointSignature
implements RekorEntry.CheckpointSignature {
    private final String identity;
    private final byte[] keyHint;
    private final byte[] signature;

    private ImmutableCheckpointSignature(String identity, byte[] keyHint, byte[] signature) {
        this.identity = identity;
        this.keyHint = keyHint;
        this.signature = signature;
    }

    @Override
    public String getIdentity() {
        return this.identity;
    }

    @Override
    public byte[] getKeyHint() {
        return (byte[])this.keyHint.clone();
    }

    @Override
    public byte[] getSignature() {
        return (byte[])this.signature.clone();
    }

    public final ImmutableCheckpointSignature withIdentity(String value) {
        String newValue = Objects.requireNonNull(value, "identity");
        if (this.identity.equals(newValue)) {
            return this;
        }
        return new ImmutableCheckpointSignature(newValue, this.keyHint, this.signature);
    }

    public final ImmutableCheckpointSignature withKeyHint(byte ... elements) {
        byte[] newValue = (byte[])elements.clone();
        return new ImmutableCheckpointSignature(this.identity, newValue, this.signature);
    }

    public final ImmutableCheckpointSignature withSignature(byte ... elements) {
        byte[] newValue = (byte[])elements.clone();
        return new ImmutableCheckpointSignature(this.identity, this.keyHint, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCheckpointSignature && this.equalTo(0, (ImmutableCheckpointSignature)another);
    }

    private boolean equalTo(int synthetic, ImmutableCheckpointSignature another) {
        return this.identity.equals(another.identity) && Arrays.equals(this.keyHint, another.keyHint) && Arrays.equals(this.signature, another.signature);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identity.hashCode();
        h += (h << 5) + Arrays.hashCode(this.keyHint);
        h += (h << 5) + Arrays.hashCode(this.signature);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CheckpointSignature").omitNullValues().add("identity", (Object)this.identity).add("keyHint", (Object)Arrays.toString(this.keyHint)).add("signature", (Object)Arrays.toString(this.signature)).toString();
    }

    public static ImmutableCheckpointSignature copyOf(RekorEntry.CheckpointSignature instance) {
        if (instance instanceof ImmutableCheckpointSignature) {
            return (ImmutableCheckpointSignature)instance;
        }
        return ImmutableCheckpointSignature.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RekorEntry.CheckpointSignature", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_IDENTITY = 1L;
        private static final long INIT_BIT_KEY_HINT = 2L;
        private static final long INIT_BIT_SIGNATURE = 4L;
        private long initBits = 7L;
        @Nullable
        private String identity;
        @Nullable
        private byte[] keyHint;
        @Nullable
        private byte[] signature;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RekorEntry.CheckpointSignature instance) {
            Objects.requireNonNull(instance, "instance");
            this.identity(instance.getIdentity());
            this.keyHint(instance.getKeyHint());
            this.signature(instance.getSignature());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder identity(String identity) {
            this.identity = Objects.requireNonNull(identity, "identity");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder keyHint(byte ... keyHint) {
            this.keyHint = (byte[])keyHint.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder signature(byte ... signature) {
            this.signature = (byte[])signature.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableCheckpointSignature build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCheckpointSignature(this.identity, this.keyHint, this.signature);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("identity");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("keyHint");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("signature");
            }
            return "Cannot build CheckpointSignature, some of required attributes are not set " + attributes;
        }
    }
}

