/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.rekor.client;

import dev.sigstore.json.GsonSupplier;
import dev.sigstore.rekor.client.Checkpoints;
import dev.sigstore.rekor.client.RekorEntryBody;
import dev.sigstore.rekor.client.RekorParseException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.erdtman.jcs.JsonCanonicalizer;
import org.immutables.gson.Gson;
import org.immutables.value.Value;

@Gson.TypeAdapters
@Value.Immutable
public interface RekorEntry {
    public String getBody();

    @Value.Derived
    default public RekorEntryBody getBodyDecoded() {
        return (RekorEntryBody)GsonSupplier.GSON.get().fromJson(new String(Base64.getDecoder().decode(this.getBody()), StandardCharsets.UTF_8), RekorEntryBody.class);
    }

    default public byte[] getSignableContent() {
        HashMap<String, Object> signableContent = new HashMap<String, Object>();
        signableContent.put("body", this.getBody());
        signableContent.put("integratedTime", this.getIntegratedTime());
        signableContent.put("logID", this.getLogID());
        signableContent.put("logIndex", this.getLogIndex());
        try {
            return new JsonCanonicalizer(GsonSupplier.GSON.get().toJson(signableContent)).getEncodedUTF8();
        }
        catch (IOException e) {
            throw new RuntimeException("GSON generated invalid json when serializing RekorEntry");
        }
    }

    public long getIntegratedTime();

    @Value.Derived
    @Gson.Ignore
    default public Instant getIntegratedTimeInstant() {
        return Instant.ofEpochSecond(this.getIntegratedTime());
    }

    public String getLogID();

    public long getLogIndex();

    public Verification getVerification();

    @Value.Immutable
    public static interface CheckpointSignature {
        public String getIdentity();

        public byte[] getKeyHint();

        public byte[] getSignature();
    }

    @Value.Immutable
    public static interface Checkpoint {
        public String getSignedData();

        public String getOrigin();

        public Long getSize();

        public String getBase64Hash();

        public List<CheckpointSignature> getSignatures();
    }

    @Value.Immutable
    public static interface InclusionProof {
        public List<String> getHashes();

        public Long getLogIndex();

        public String getRootHash();

        public Long getTreeSize();

        public String getCheckpoint();

        @Value.Lazy
        default public Checkpoint parsedCheckpoint() throws RekorParseException {
            return Checkpoints.from(this.getCheckpoint());
        }
    }

    @Value.Immutable
    public static interface Verification {
        @Nullable
        public String getSignedEntryTimestamp();

        public InclusionProof getInclusionProof();
    }
}

