/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.rekor.client;

import com.google.common.hash.Hashing;
import dev.sigstore.encryption.signers.Verifier;
import dev.sigstore.encryption.signers.Verifiers;
import dev.sigstore.rekor.client.RekorEntry;
import dev.sigstore.rekor.client.RekorParseException;
import dev.sigstore.rekor.client.RekorVerificationException;
import dev.sigstore.trustroot.SigstoreTrustedRoot;
import dev.sigstore.trustroot.TransparencyLog;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import org.bouncycastle.util.encoders.Hex;

public class RekorVerifier {
    private final List<TransparencyLog> tlogs;

    public static RekorVerifier newRekorVerifier(SigstoreTrustedRoot trustRoot) {
        return RekorVerifier.newRekorVerifier(trustRoot.getTLogs());
    }

    public static RekorVerifier newRekorVerifier(List<TransparencyLog> tlogs) {
        return new RekorVerifier(tlogs);
    }

    private RekorVerifier(List<TransparencyLog> tlogs) {
        this.tlogs = tlogs;
    }

    public void verifyEntry(RekorEntry entry) throws RekorVerificationException {
        if (entry.getVerification() == null) {
            throw new RekorVerificationException("No verification information in entry.");
        }
        if (entry.getVerification().getSignedEntryTimestamp() == null) {
            throw new RekorVerificationException("No signed entry timestamp found in entry.");
        }
        TransparencyLog tlog = TransparencyLog.find(this.tlogs, Hex.decode((String)entry.getLogID()), entry.getIntegratedTimeInstant()).orElseThrow(() -> new RekorVerificationException("Log entry (logid, timestamp) does not match any provided transparency logs."));
        try {
            Verifier verifier = Verifiers.newVerifier(tlog.getPublicKey().toJavaPublicKey());
            if (!verifier.verify(entry.getSignableContent(), Base64.getDecoder().decode(entry.getVerification().getSignedEntryTimestamp()))) {
                throw new RekorVerificationException("Entry SET was not valid");
            }
        }
        catch (InvalidKeySpecException ike) {
            throw new RekorVerificationException("Public Key could be parsed", ike);
        }
        catch (InvalidKeyException ike) {
            throw new RekorVerificationException("Public Key was invalid", ike);
        }
        catch (SignatureException se) {
            throw new RekorVerificationException("Signature was invalid", se);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new AssertionError((Object)"Required verification algorithm 'SHA256withECDSA' not found.");
        }
        this.verifyInclusionProof(entry);
        this.verifyCheckpoint(entry, tlog);
    }

    private void verifyInclusionProof(RekorEntry entry) throws RekorVerificationException {
        RekorEntry.InclusionProof inclusionProof = entry.getVerification().getInclusionProof();
        byte[] leafHash = Hashing.sha256().hashBytes(RekorVerifier.combineBytes(new byte[]{0}, Base64.getDecoder().decode(entry.getBody()))).asBytes();
        Long nodeIndex = inclusionProof.getLogIndex();
        long totalNodes = inclusionProof.getTreeSize() - 1L;
        byte[] currentHash = leafHash;
        List<String> hashes = inclusionProof.getHashes();
        for (String hash : hashes) {
            byte[] p = Hex.decode((String)hash);
            if (totalNodes == 0L) {
                throw new RekorVerificationException("Inclusion proof failed, ended prematurely");
            }
            if (nodeIndex == totalNodes || nodeIndex % 2L == 1L) {
                currentHash = RekorVerifier.hashChildren(p, currentHash);
                while (nodeIndex % 2L == 0L) {
                    nodeIndex = nodeIndex >> 1;
                    totalNodes >>= 1;
                }
            } else {
                currentHash = RekorVerifier.hashChildren(currentHash, p);
            }
            nodeIndex = nodeIndex >> 1;
            totalNodes >>= 1;
        }
        String calcuatedRootHash = Hex.toHexString((byte[])currentHash);
        if (!calcuatedRootHash.equals(inclusionProof.getRootHash())) {
            throw new RekorVerificationException("Calculated inclusion proof root hash does not match provided root hash\n" + calcuatedRootHash + "\n" + inclusionProof.getRootHash());
        }
    }

    private void verifyCheckpoint(RekorEntry entry, TransparencyLog tlog) throws RekorVerificationException {
        RekorEntry.Checkpoint checkpoint;
        try {
            checkpoint = entry.getVerification().getInclusionProof().parsedCheckpoint();
        }
        catch (RekorParseException ex) {
            throw new RekorVerificationException("Could not parse checkpoint", ex);
        }
        byte[] inclusionRootHash = Hex.decode((String)entry.getVerification().getInclusionProof().getRootHash());
        byte[] checkpointRootHash = Base64.getDecoder().decode(checkpoint.getBase64Hash());
        if (!Arrays.equals(inclusionRootHash, checkpointRootHash)) {
            throw new RekorVerificationException("Checkpoint root hash does not match root hash provided in inclusion proof");
        }
        byte[] keyHash = Hashing.sha256().hashBytes(tlog.getPublicKey().getRawBytes()).asBytes();
        RekorEntry.CheckpointSignature sig = checkpoint.getSignatures().get(0);
        for (int i = 0; i < 4; ++i) {
            if (sig.getKeyHint()[i] == keyHash[i]) continue;
            throw new RekorVerificationException("Checkpoint key hint did not match provided log public key");
        }
        String signedData = checkpoint.getSignedData();
        try {
            if (!Verifiers.newVerifier(tlog.getPublicKey().toJavaPublicKey()).verify(signedData.getBytes(StandardCharsets.UTF_8), sig.getSignature())) {
                throw new RekorVerificationException("Checkpoint signature was invalid");
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException | InvalidKeySpecException ex) {
            throw new RekorVerificationException("Could not verify checkpoint signature", ex);
        }
    }

    private static byte[] combineBytes(byte[] first, byte[] second) {
        byte[] result = new byte[first.length + second.length];
        System.arraycopy(first, 0, result, 0, first.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    private static byte[] hashChildren(byte[] left, byte[] right) {
        return Hashing.sha256().hashBytes(RekorVerifier.combineBytes(new byte[]{1}, RekorVerifier.combineBytes(left, right))).asBytes();
    }
}

