/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.strings;

import dev.sigstore.strings.RegexSyntaxException;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public interface StringMatcher
extends Predicate<String> {
    public static StringMatcher string(final String string) {
        Objects.requireNonNull(string, "string matcher cannot be initialized with null string");
        return new StringMatcher(){

            @Override
            public boolean test(String target) {
                return string.equals(target);
            }

            public String toString() {
                return "'String: " + string + "'";
            }
        };
    }

    public static StringMatcher regex(String string) throws RegexSyntaxException {
        Pattern pattern;
        Objects.requireNonNull(string, "string matcher cannot be initialized with null regex");
        try {
            pattern = Pattern.compile(string);
        }
        catch (PatternSyntaxException ex) {
            throw new RegexSyntaxException("Could not parse regex: '" + string + "'", ex);
        }
        return new StringMatcher(){

            @Override
            public boolean test(String target) {
                if (target == null) {
                    return false;
                }
                return pattern.matcher(target).matches();
            }

            public String toString() {
                return "'RegEx: " + pattern + "'";
            }
        };
    }
}

