/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.trustroot;

import dev.sigstore.proto.ProtoMutators;
import dev.sigstore.trustroot.ImmutableCertificateAuthority;
import dev.sigstore.trustroot.Subject;
import dev.sigstore.trustroot.ValidFor;
import java.net.URI;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@Value.Immutable
public abstract class CertificateAuthority {
    public abstract CertPath getCertPath();

    public abstract URI getUri();

    public abstract ValidFor getValidFor();

    public abstract Subject getSubject();

    public boolean isCurrent() {
        return this.getValidFor().contains(Instant.now());
    }

    @Value.Lazy
    public TrustAnchor asTrustAnchor() throws CertificateException, InvalidAlgorithmParameterException {
        List<? extends Certificate> certs = this.getCertPath().getCertificates();
        X509Certificate fulcioRootObj = (X509Certificate)certs.get(certs.size() - 1);
        TrustAnchor fulcioRootTrustAnchor = new TrustAnchor(fulcioRootObj, null);
        new PKIXParameters(Collections.singleton(fulcioRootTrustAnchor));
        return fulcioRootTrustAnchor;
    }

    public static CertificateAuthority from(dev.sigstore.proto.trustroot.v1.CertificateAuthority proto) throws CertificateException {
        return ImmutableCertificateAuthority.builder().certPath(ProtoMutators.toCertPath(proto.getCertChain().getCertificatesList())).validFor(ValidFor.from(proto.getValidFor())).uri(URI.create(proto.getUri())).subject(Subject.from(proto.getSubject())).build();
    }

    public static List<CertificateAuthority> find(List<CertificateAuthority> all, Instant time) {
        return all.stream().filter(ca -> ca.getValidFor().contains(time)).collect(Collectors.toList());
    }
}

