/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.trustroot;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.trustroot.CertificateAuthority;
import dev.sigstore.trustroot.SigstoreTrustedRoot;
import dev.sigstore.trustroot.TransparencyLog;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SigstoreTrustedRoot", generator="Immutables")
@Immutable
public final class ImmutableSigstoreTrustedRoot
implements SigstoreTrustedRoot {
    private final ImmutableList<CertificateAuthority> cAs;
    private final ImmutableList<TransparencyLog> tLogs;
    private final ImmutableList<TransparencyLog> cTLogs;

    private ImmutableSigstoreTrustedRoot(ImmutableList<CertificateAuthority> cAs, ImmutableList<TransparencyLog> tLogs, ImmutableList<TransparencyLog> cTLogs) {
        this.cAs = cAs;
        this.tLogs = tLogs;
        this.cTLogs = cTLogs;
    }

    public ImmutableList<CertificateAuthority> getCAs() {
        return this.cAs;
    }

    public ImmutableList<TransparencyLog> getTLogs() {
        return this.tLogs;
    }

    public ImmutableList<TransparencyLog> getCTLogs() {
        return this.cTLogs;
    }

    public final ImmutableSigstoreTrustedRoot withCAs(CertificateAuthority ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableSigstoreTrustedRoot((ImmutableList<CertificateAuthority>)newValue, this.tLogs, this.cTLogs);
    }

    public final ImmutableSigstoreTrustedRoot withCAs(Iterable<? extends CertificateAuthority> elements) {
        if (this.cAs == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableSigstoreTrustedRoot((ImmutableList<CertificateAuthority>)newValue, this.tLogs, this.cTLogs);
    }

    public final ImmutableSigstoreTrustedRoot withTLogs(TransparencyLog ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableSigstoreTrustedRoot(this.cAs, (ImmutableList<TransparencyLog>)newValue, this.cTLogs);
    }

    public final ImmutableSigstoreTrustedRoot withTLogs(Iterable<? extends TransparencyLog> elements) {
        if (this.tLogs == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableSigstoreTrustedRoot(this.cAs, (ImmutableList<TransparencyLog>)newValue, this.cTLogs);
    }

    public final ImmutableSigstoreTrustedRoot withCTLogs(TransparencyLog ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableSigstoreTrustedRoot(this.cAs, this.tLogs, (ImmutableList<TransparencyLog>)newValue);
    }

    public final ImmutableSigstoreTrustedRoot withCTLogs(Iterable<? extends TransparencyLog> elements) {
        if (this.cTLogs == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableSigstoreTrustedRoot(this.cAs, this.tLogs, (ImmutableList<TransparencyLog>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSigstoreTrustedRoot && this.equalTo(0, (ImmutableSigstoreTrustedRoot)another);
    }

    private boolean equalTo(int synthetic, ImmutableSigstoreTrustedRoot another) {
        return this.cAs.equals(another.cAs) && this.tLogs.equals(another.tLogs) && this.cTLogs.equals(another.cTLogs);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.cAs.hashCode();
        h += (h << 5) + this.tLogs.hashCode();
        h += (h << 5) + this.cTLogs.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SigstoreTrustedRoot").omitNullValues().add("cAs", this.cAs).add("tLogs", this.tLogs).add("cTLogs", this.cTLogs).toString();
    }

    public static ImmutableSigstoreTrustedRoot copyOf(SigstoreTrustedRoot instance) {
        if (instance instanceof ImmutableSigstoreTrustedRoot) {
            return (ImmutableSigstoreTrustedRoot)instance;
        }
        return ImmutableSigstoreTrustedRoot.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SigstoreTrustedRoot", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<CertificateAuthority> cAs = ImmutableList.builder();
        private ImmutableList.Builder<TransparencyLog> tLogs = ImmutableList.builder();
        private ImmutableList.Builder<TransparencyLog> cTLogs = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SigstoreTrustedRoot instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllCAs(instance.getCAs());
            this.addAllTLogs(instance.getTLogs());
            this.addAllCTLogs(instance.getCTLogs());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCAs(CertificateAuthority element) {
            this.cAs.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCAs(CertificateAuthority ... elements) {
            this.cAs.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cAs(Iterable<? extends CertificateAuthority> elements) {
            this.cAs = ImmutableList.builder();
            return this.addAllCAs(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllCAs(Iterable<? extends CertificateAuthority> elements) {
            this.cAs.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTLogs(TransparencyLog element) {
            this.tLogs.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTLogs(TransparencyLog ... elements) {
            this.tLogs.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tLogs(Iterable<? extends TransparencyLog> elements) {
            this.tLogs = ImmutableList.builder();
            return this.addAllTLogs(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTLogs(Iterable<? extends TransparencyLog> elements) {
            this.tLogs.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCTLogs(TransparencyLog element) {
            this.cTLogs.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCTLogs(TransparencyLog ... elements) {
            this.cTLogs.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cTLogs(Iterable<? extends TransparencyLog> elements) {
            this.cTLogs = ImmutableList.builder();
            return this.addAllCTLogs(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllCTLogs(Iterable<? extends TransparencyLog> elements) {
            this.cTLogs.addAll(elements);
            return this;
        }

        public ImmutableSigstoreTrustedRoot build() {
            return new ImmutableSigstoreTrustedRoot((ImmutableList<CertificateAuthority>)this.cAs.build(), (ImmutableList<TransparencyLog>)this.tLogs.build(), (ImmutableList<TransparencyLog>)this.cTLogs.build());
        }
    }
}

