/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.trustroot;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.trustroot.LogId;
import dev.sigstore.trustroot.PublicKey;
import dev.sigstore.trustroot.TransparencyLog;
import java.net.URI;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TransparencyLog", generator="Immutables")
@Immutable
public final class ImmutableTransparencyLog
implements TransparencyLog {
    private final URI baseUrl;
    private final String hashAlgorithm;
    private final LogId logId;
    private final PublicKey publicKey;

    private ImmutableTransparencyLog(URI baseUrl, String hashAlgorithm, LogId logId, PublicKey publicKey) {
        this.baseUrl = baseUrl;
        this.hashAlgorithm = hashAlgorithm;
        this.logId = logId;
        this.publicKey = publicKey;
    }

    @Override
    public URI getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    @Override
    public LogId getLogId() {
        return this.logId;
    }

    @Override
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public final ImmutableTransparencyLog withBaseUrl(URI value) {
        if (this.baseUrl == value) {
            return this;
        }
        URI newValue = Objects.requireNonNull(value, "baseUrl");
        return new ImmutableTransparencyLog(newValue, this.hashAlgorithm, this.logId, this.publicKey);
    }

    public final ImmutableTransparencyLog withHashAlgorithm(String value) {
        String newValue = Objects.requireNonNull(value, "hashAlgorithm");
        if (this.hashAlgorithm.equals(newValue)) {
            return this;
        }
        return new ImmutableTransparencyLog(this.baseUrl, newValue, this.logId, this.publicKey);
    }

    public final ImmutableTransparencyLog withLogId(LogId value) {
        if (this.logId == value) {
            return this;
        }
        LogId newValue = Objects.requireNonNull(value, "logId");
        return new ImmutableTransparencyLog(this.baseUrl, this.hashAlgorithm, newValue, this.publicKey);
    }

    public final ImmutableTransparencyLog withPublicKey(PublicKey value) {
        if (this.publicKey == value) {
            return this;
        }
        PublicKey newValue = Objects.requireNonNull(value, "publicKey");
        return new ImmutableTransparencyLog(this.baseUrl, this.hashAlgorithm, this.logId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTransparencyLog && this.equalTo(0, (ImmutableTransparencyLog)another);
    }

    private boolean equalTo(int synthetic, ImmutableTransparencyLog another) {
        return this.baseUrl.equals(another.baseUrl) && this.hashAlgorithm.equals(another.hashAlgorithm) && this.logId.equals(another.logId) && this.publicKey.equals(another.publicKey);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.baseUrl.hashCode();
        h += (h << 5) + this.hashAlgorithm.hashCode();
        h += (h << 5) + this.logId.hashCode();
        h += (h << 5) + this.publicKey.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TransparencyLog").omitNullValues().add("baseUrl", (Object)this.baseUrl).add("hashAlgorithm", (Object)this.hashAlgorithm).add("logId", (Object)this.logId).add("publicKey", (Object)this.publicKey).toString();
    }

    public static ImmutableTransparencyLog copyOf(TransparencyLog instance) {
        if (instance instanceof ImmutableTransparencyLog) {
            return (ImmutableTransparencyLog)instance;
        }
        return ImmutableTransparencyLog.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TransparencyLog", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_BASE_URL = 1L;
        private static final long INIT_BIT_HASH_ALGORITHM = 2L;
        private static final long INIT_BIT_LOG_ID = 4L;
        private static final long INIT_BIT_PUBLIC_KEY = 8L;
        private long initBits = 15L;
        @Nullable
        private URI baseUrl;
        @Nullable
        private String hashAlgorithm;
        @Nullable
        private LogId logId;
        @Nullable
        private PublicKey publicKey;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TransparencyLog instance) {
            Objects.requireNonNull(instance, "instance");
            this.baseUrl(instance.getBaseUrl());
            this.hashAlgorithm(instance.getHashAlgorithm());
            this.logId(instance.getLogId());
            this.publicKey(instance.getPublicKey());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder baseUrl(URI baseUrl) {
            this.baseUrl = Objects.requireNonNull(baseUrl, "baseUrl");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hashAlgorithm(String hashAlgorithm) {
            this.hashAlgorithm = Objects.requireNonNull(hashAlgorithm, "hashAlgorithm");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder logId(LogId logId) {
            this.logId = Objects.requireNonNull(logId, "logId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder publicKey(PublicKey publicKey) {
            this.publicKey = Objects.requireNonNull(publicKey, "publicKey");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableTransparencyLog build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTransparencyLog(this.baseUrl, this.hashAlgorithm, this.logId, this.publicKey);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("baseUrl");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("hashAlgorithm");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("logId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("publicKey");
            }
            return "Cannot build TransparencyLog, some of required attributes are not set " + attributes;
        }
    }
}

