/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.tuf;

import dev.sigstore.tuf.TufException;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;

public class InvalidHashesException
extends TufException {
    InvalidHashesException(String resourceName, String algorithm, String expectedHash, String computedHash) {
        this(resourceName, new InvalidHash(algorithm, expectedHash, computedHash));
    }

    InvalidHashesException(String resourceName, InvalidHash ... invalidHashes) {
        super(String.format(Locale.ROOT, "The hashes for %s did not match expectations:\n%s", resourceName, InvalidHashesException.invalidHashesToString(invalidHashes)));
    }

    private static String invalidHashesToString(InvalidHash ... invalidHashes) {
        return Arrays.stream(invalidHashes).map(InvalidHash::toString).collect(Collectors.joining("\n"));
    }

    static class InvalidHash {
        final String algorithm;
        final String expectedHash;
        final String computedHash;

        InvalidHash(String algorithm, String expectedHash, String computedHash) {
            this.algorithm = algorithm;
            this.expectedHash = expectedHash;
            this.computedHash = computedHash;
        }

        public String toString() {
            return String.format(Locale.ROOT, "algorithm: %s, expected hash: %s, computed hash: %s", this.algorithm, this.expectedHash, this.computedHash);
        }
    }
}

