/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.tuf;

import com.google.common.base.Preconditions;
import dev.sigstore.json.GsonSupplier;
import dev.sigstore.tuf.Fetcher;
import dev.sigstore.tuf.FileExceedsMaxLengthException;
import dev.sigstore.tuf.MetaFetchResult;
import dev.sigstore.tuf.model.Root;
import dev.sigstore.tuf.model.SignedTufMeta;
import dev.sigstore.tuf.model.TufMeta;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;

public class MetaFetcher {
    private static final int MAX_META_BYTES = 101376;
    private final Fetcher fetcher;

    private MetaFetcher(Fetcher fetcher) {
        this.fetcher = fetcher;
    }

    public static MetaFetcher newFetcher(Fetcher fetcher) {
        return new MetaFetcher(fetcher);
    }

    public String getSource() {
        return this.fetcher.getSource();
    }

    public Optional<MetaFetchResult<Root>> getRootAtVersion(int version) throws IOException, FileExceedsMaxLengthException {
        String versionFileName = version + ".root.json";
        return this.getMeta(versionFileName, Root.class, null);
    }

    public <T extends SignedTufMeta<? extends TufMeta>> Optional<MetaFetchResult<T>> getMeta(String role, Class<T> t) throws IOException, FileExceedsMaxLengthException {
        return this.getMeta(MetaFetcher.getFileName(role, null), t, null);
    }

    public <T extends SignedTufMeta<? extends TufMeta>> Optional<MetaFetchResult<T>> getMeta(String role, int version, Class<T> t, Integer maxSize) throws IOException, FileExceedsMaxLengthException {
        Preconditions.checkArgument((version > 0 ? 1 : 0) != 0, (String)"version should be positive, got: %s", (int)version);
        return this.getMeta(MetaFetcher.getFileName(role, version), t, maxSize);
    }

    private static String getFileName(String role, @Nullable Integer version) {
        return version == null ? role + ".json" : String.format(Locale.ROOT, "%d.%s.json", version, role);
    }

    <T extends SignedTufMeta<? extends TufMeta>> Optional<MetaFetchResult<T>> getMeta(String filename, Class<T> t, Integer maxSize) throws IOException, FileExceedsMaxLengthException {
        byte[] roleBytes = this.fetcher.fetchResource(filename, maxSize == null ? 101376 : maxSize);
        if (roleBytes == null) {
            return Optional.empty();
        }
        MetaFetchResult<SignedTufMeta> result = new MetaFetchResult<SignedTufMeta>(roleBytes, (SignedTufMeta)GsonSupplier.GSON.get().fromJson(new String(roleBytes, StandardCharsets.UTF_8), t));
        return Optional.of(result);
    }
}

