/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.tuf.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.tuf.model.DelegationRole;
import dev.sigstore.tuf.model.Role;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DelegationRole", generator="Immutables")
@Immutable
public final class ImmutableDelegationRole
implements DelegationRole {
    private final ImmutableList<String> keyids;
    private final int threshold;
    private final String name;
    private final ImmutableList<String> paths;
    private final boolean isTerminating;

    private ImmutableDelegationRole(ImmutableList<String> keyids, int threshold, String name, ImmutableList<String> paths, boolean isTerminating) {
        this.keyids = keyids;
        this.threshold = threshold;
        this.name = name;
        this.paths = paths;
        this.isTerminating = isTerminating;
    }

    public ImmutableList<String> getKeyids() {
        return this.keyids;
    }

    @Override
    public int getThreshold() {
        return this.threshold;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ImmutableList<String> getPaths() {
        return this.paths;
    }

    @Override
    public boolean isTerminating() {
        return this.isTerminating;
    }

    public final ImmutableDelegationRole withKeyids(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableDelegationRole((ImmutableList<String>)newValue, this.threshold, this.name, this.paths, this.isTerminating);
    }

    public final ImmutableDelegationRole withKeyids(Iterable<String> elements) {
        if (this.keyids == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableDelegationRole((ImmutableList<String>)newValue, this.threshold, this.name, this.paths, this.isTerminating);
    }

    public final ImmutableDelegationRole withThreshold(int value) {
        if (this.threshold == value) {
            return this;
        }
        return new ImmutableDelegationRole(this.keyids, value, this.name, this.paths, this.isTerminating);
    }

    public final ImmutableDelegationRole withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableDelegationRole(this.keyids, this.threshold, newValue, this.paths, this.isTerminating);
    }

    public final ImmutableDelegationRole withPaths(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableDelegationRole(this.keyids, this.threshold, this.name, (ImmutableList<String>)newValue, this.isTerminating);
    }

    public final ImmutableDelegationRole withPaths(Iterable<String> elements) {
        if (this.paths == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableDelegationRole(this.keyids, this.threshold, this.name, (ImmutableList<String>)newValue, this.isTerminating);
    }

    public final ImmutableDelegationRole withIsTerminating(boolean value) {
        if (this.isTerminating == value) {
            return this;
        }
        return new ImmutableDelegationRole(this.keyids, this.threshold, this.name, this.paths, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDelegationRole && this.equalTo(0, (ImmutableDelegationRole)another);
    }

    private boolean equalTo(int synthetic, ImmutableDelegationRole another) {
        return this.keyids.equals(another.keyids) && this.threshold == another.threshold && this.name.equals(another.name) && this.paths.equals(another.paths) && this.isTerminating == another.isTerminating;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.keyids.hashCode();
        h += (h << 5) + this.threshold;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.paths.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.isTerminating);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DelegationRole").omitNullValues().add("keyids", this.keyids).add("threshold", this.threshold).add("name", (Object)this.name).add("paths", this.paths).add("isTerminating", this.isTerminating).toString();
    }

    public static ImmutableDelegationRole copyOf(DelegationRole instance) {
        if (instance instanceof ImmutableDelegationRole) {
            return (ImmutableDelegationRole)instance;
        }
        return ImmutableDelegationRole.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DelegationRole", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_THRESHOLD = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_IS_TERMINATING = 4L;
        private long initBits = 7L;
        private ImmutableList.Builder<String> keyids = ImmutableList.builder();
        private int threshold;
        @Nullable
        private String name;
        private ImmutableList.Builder<String> paths = ImmutableList.builder();
        private boolean isTerminating;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DelegationRole instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Role instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Role instance;
            long bits = 0L;
            if (object instanceof DelegationRole) {
                instance = (DelegationRole)object;
                this.name(instance.getName());
                if ((bits & 2L) == 0L) {
                    this.threshold(instance.getThreshold());
                    bits |= 2L;
                }
                this.isTerminating(instance.isTerminating());
                this.addAllPaths(instance.getPaths());
                if ((bits & 1L) == 0L) {
                    this.addAllKeyids(instance.getKeyids());
                    bits |= 1L;
                }
            }
            if (object instanceof Role) {
                instance = (Role)object;
                if ((bits & 2L) == 0L) {
                    this.threshold(instance.getThreshold());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.addAllKeyids(instance.getKeyids());
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder addKeyids(String element) {
            this.keyids.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addKeyids(String ... elements) {
            this.keyids.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder keyids(Iterable<String> elements) {
            this.keyids = ImmutableList.builder();
            return this.addAllKeyids(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllKeyids(Iterable<String> elements) {
            this.keyids.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder threshold(int threshold) {
            this.threshold = threshold;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPaths(String element) {
            this.paths.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPaths(String ... elements) {
            this.paths.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder paths(Iterable<String> elements) {
            this.paths = ImmutableList.builder();
            return this.addAllPaths(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPaths(Iterable<String> elements) {
            this.paths.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isTerminating(boolean isTerminating) {
            this.isTerminating = isTerminating;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableDelegationRole build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDelegationRole((ImmutableList<String>)this.keyids.build(), this.threshold, this.name, (ImmutableList<String>)this.paths.build(), this.isTerminating);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("threshold");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("isTerminating");
            }
            return "Cannot build DelegationRole, some of required attributes are not set " + attributes;
        }
    }
}

