/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.tuf.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.tuf.model.Key;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Key", generator="Immutables")
@Immutable
public final class ImmutableKey
implements Key {
    private final ImmutableList<String> keyIdHashAlgorithms;
    private final String keyType;
    private final ImmutableMap<String, String> keyVal;
    private final String scheme;

    private ImmutableKey(ImmutableList<String> keyIdHashAlgorithms, String keyType, ImmutableMap<String, String> keyVal, String scheme) {
        this.keyIdHashAlgorithms = keyIdHashAlgorithms;
        this.keyType = keyType;
        this.keyVal = keyVal;
        this.scheme = scheme;
    }

    public ImmutableList<String> getKeyIdHashAlgorithms() {
        return this.keyIdHashAlgorithms;
    }

    @Override
    public String getKeyType() {
        return this.keyType;
    }

    public ImmutableMap<String, String> getKeyVal() {
        return this.keyVal;
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    public final ImmutableKey withKeyIdHashAlgorithms(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableKey((ImmutableList<String>)newValue, this.keyType, this.keyVal, this.scheme);
    }

    public final ImmutableKey withKeyIdHashAlgorithms(Iterable<String> elements) {
        if (this.keyIdHashAlgorithms == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableKey((ImmutableList<String>)newValue, this.keyType, this.keyVal, this.scheme);
    }

    public final ImmutableKey withKeyType(String value) {
        String newValue = Objects.requireNonNull(value, "keyType");
        if (this.keyType.equals(newValue)) {
            return this;
        }
        return new ImmutableKey(this.keyIdHashAlgorithms, newValue, this.keyVal, this.scheme);
    }

    public final ImmutableKey withKeyVal(Map<String, ? extends String> entries) {
        if (this.keyVal == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableKey(this.keyIdHashAlgorithms, this.keyType, (ImmutableMap<String, String>)newValue, this.scheme);
    }

    public final ImmutableKey withScheme(String value) {
        String newValue = Objects.requireNonNull(value, "scheme");
        if (this.scheme.equals(newValue)) {
            return this;
        }
        return new ImmutableKey(this.keyIdHashAlgorithms, this.keyType, this.keyVal, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableKey && this.equalTo(0, (ImmutableKey)another);
    }

    private boolean equalTo(int synthetic, ImmutableKey another) {
        return this.keyIdHashAlgorithms.equals(another.keyIdHashAlgorithms) && this.keyType.equals(another.keyType) && this.keyVal.equals(another.keyVal) && this.scheme.equals(another.scheme);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.keyIdHashAlgorithms.hashCode();
        h += (h << 5) + this.keyType.hashCode();
        h += (h << 5) + this.keyVal.hashCode();
        h += (h << 5) + this.scheme.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Key").omitNullValues().add("keyIdHashAlgorithms", this.keyIdHashAlgorithms).add("keyType", (Object)this.keyType).add("keyVal", this.keyVal).add("scheme", (Object)this.scheme).toString();
    }

    public static ImmutableKey copyOf(Key instance) {
        if (instance instanceof ImmutableKey) {
            return (ImmutableKey)instance;
        }
        return ImmutableKey.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Key", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY_TYPE = 1L;
        private static final long INIT_BIT_SCHEME = 2L;
        private long initBits = 3L;
        private ImmutableList.Builder<String> keyIdHashAlgorithms = ImmutableList.builder();
        @Nullable
        private String keyType;
        private ImmutableMap.Builder<String, String> keyVal = ImmutableMap.builder();
        @Nullable
        private String scheme;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Key instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllKeyIdHashAlgorithms(instance.getKeyIdHashAlgorithms());
            this.keyType(instance.getKeyType());
            this.putAllKeyVal(instance.getKeyVal());
            this.scheme(instance.getScheme());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addKeyIdHashAlgorithms(String element) {
            this.keyIdHashAlgorithms.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addKeyIdHashAlgorithms(String ... elements) {
            this.keyIdHashAlgorithms.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder keyIdHashAlgorithms(Iterable<String> elements) {
            this.keyIdHashAlgorithms = ImmutableList.builder();
            return this.addAllKeyIdHashAlgorithms(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllKeyIdHashAlgorithms(Iterable<String> elements) {
            this.keyIdHashAlgorithms.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder keyType(String keyType) {
            this.keyType = Objects.requireNonNull(keyType, "keyType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putKeyVal(String key, String value) {
            this.keyVal.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putKeyVal(Map.Entry<String, ? extends String> entry) {
            this.keyVal.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder keyVal(Map<String, ? extends String> entries) {
            this.keyVal = ImmutableMap.builder();
            return this.putAllKeyVal(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllKeyVal(Map<String, ? extends String> entries) {
            this.keyVal.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder scheme(String scheme) {
            this.scheme = Objects.requireNonNull(scheme, "scheme");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableKey build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableKey((ImmutableList<String>)this.keyIdHashAlgorithms.build(), this.keyType, (ImmutableMap<String, String>)this.keyVal.build(), this.scheme);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("keyType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("scheme");
            }
            return "Cannot build Key, some of required attributes are not set " + attributes;
        }
    }
}

