/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.tuf.model;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.tuf.model.Hashes;
import dev.sigstore.tuf.model.TargetMeta;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TargetMeta.TargetData", generator="Immutables")
@Immutable
public final class ImmutableTargetData
implements TargetMeta.TargetData {
    @Nullable
    private final TargetMeta.Custom custom;
    private final Hashes hashes;
    private final int length;

    private ImmutableTargetData(@Nullable TargetMeta.Custom custom, Hashes hashes, int length) {
        this.custom = custom;
        this.hashes = hashes;
        this.length = length;
    }

    @Override
    public Optional<TargetMeta.Custom> getCustom() {
        return Optional.ofNullable(this.custom);
    }

    @Override
    public Hashes getHashes() {
        return this.hashes;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    public final ImmutableTargetData withCustom(TargetMeta.Custom value) {
        TargetMeta.Custom newValue = Objects.requireNonNull(value, "custom");
        if (this.custom == newValue) {
            return this;
        }
        return ImmutableTargetData.validate(new ImmutableTargetData(newValue, this.hashes, this.length));
    }

    public final ImmutableTargetData withCustom(Optional<? extends TargetMeta.Custom> optional) {
        TargetMeta.Custom value = optional.orElse(null);
        if (this.custom == value) {
            return this;
        }
        return ImmutableTargetData.validate(new ImmutableTargetData(value, this.hashes, this.length));
    }

    public final ImmutableTargetData withHashes(Hashes value) {
        if (this.hashes == value) {
            return this;
        }
        Hashes newValue = Objects.requireNonNull(value, "hashes");
        return ImmutableTargetData.validate(new ImmutableTargetData(this.custom, newValue, this.length));
    }

    public final ImmutableTargetData withLength(int value) {
        if (this.length == value) {
            return this;
        }
        return ImmutableTargetData.validate(new ImmutableTargetData(this.custom, this.hashes, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTargetData && this.equalTo(0, (ImmutableTargetData)another);
    }

    private boolean equalTo(int synthetic, ImmutableTargetData another) {
        return Objects.equals(this.custom, another.custom) && this.hashes.equals(another.hashes) && this.length == another.length;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.custom);
        h += (h << 5) + this.hashes.hashCode();
        h += (h << 5) + this.length;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TargetData").omitNullValues().add("custom", (Object)this.custom).add("hashes", (Object)this.hashes).add("length", this.length).toString();
    }

    private static ImmutableTargetData validate(ImmutableTargetData instance) {
        instance.check();
        return instance;
    }

    public static ImmutableTargetData copyOf(TargetMeta.TargetData instance) {
        if (instance instanceof ImmutableTargetData) {
            return (ImmutableTargetData)instance;
        }
        return ImmutableTargetData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TargetMeta.TargetData", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_HASHES = 1L;
        private static final long INIT_BIT_LENGTH = 2L;
        private long initBits = 3L;
        @Nullable
        private TargetMeta.Custom custom;
        @Nullable
        private Hashes hashes;
        private int length;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TargetMeta.TargetData instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<TargetMeta.Custom> customOptional = instance.getCustom();
            if (customOptional.isPresent()) {
                this.custom(customOptional);
            }
            this.hashes(instance.getHashes());
            this.length(instance.getLength());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder custom(TargetMeta.Custom custom) {
            this.custom = Objects.requireNonNull(custom, "custom");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder custom(Optional<? extends TargetMeta.Custom> custom) {
            this.custom = custom.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hashes(Hashes hashes) {
            this.hashes = Objects.requireNonNull(hashes, "hashes");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder length(int length) {
            this.length = length;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableTargetData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableTargetData.validate(new ImmutableTargetData(this.custom, this.hashes, this.length));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("hashes");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("length");
            }
            return "Cannot build TargetData, some of required attributes are not set " + attributes;
        }
    }
}

