/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.tuf.model;

import dev.sigstore.tuf.model.Hashes;
import dev.sigstore.tuf.model.TufMeta;
import java.util.Map;
import java.util.Optional;
import org.immutables.gson.Gson;
import org.immutables.value.Value;

@Gson.TypeAdapters
@Value.Immutable
public interface SnapshotMeta
extends TufMeta {
    public static final Integer DEFAULT_MAX_LENGTH = 2000000;

    public Map<String, SnapshotTarget> getMeta();

    default public SnapshotTarget getTargetMeta(String targetName) {
        return this.getMeta().get(targetName);
    }

    @Value.Immutable
    public static interface SnapshotTarget {
        public Optional<Hashes> getHashes();

        public Optional<Integer> getLength();

        @Value.Derived
        @Gson.Ignore
        default public Integer getLengthOrDefault() {
            return this.getLength().orElse(DEFAULT_MAX_LENGTH);
        }

        public int getVersion();
    }
}

