/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.bundle;

import com.google.api.FieldBehavior;
import com.google.api.FieldBehaviorProto;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import dev.sigstore.proto.bundle.v1.Bundle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BundleVerifier {
    static final JsonFormat.Parser JSON_PARSER = JsonFormat.parser();

    public static List<String> allMissingFields(String bundleJson) {
        Bundle.Builder bundle = Bundle.newBuilder();
        try {
            JSON_PARSER.merge(bundleJson, (Message.Builder)bundle);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Unable to parse Sigstore Bundle " + bundleJson, e);
        }
        return BundleVerifier.findMissingFields(bundle);
    }

    static List<String> findMissingFields(MessageOrBuilder message) {
        ArrayList<String> missing = new ArrayList<String>();
        BundleVerifier.findMissingFields(message, "", missing);
        return missing;
    }

    private static void findMissingFields(MessageOrBuilder message, String prefix, List<String> missing) {
        for (Descriptors.FieldDescriptor fieldDescriptor : message.getDescriptorForType().getFields()) {
            if (!BundleVerifier.isRequired(fieldDescriptor) || fieldDescriptor.getContainingOneof() != null || (fieldDescriptor.isRepeated() ? message.getRepeatedFieldCount(fieldDescriptor) != 0 : message.hasField(fieldDescriptor))) continue;
            missing.add(prefix + fieldDescriptor.getName());
        }
        for (Descriptors.OneofDescriptor oneofDescriptor : message.getDescriptorForType().getRealOneofs()) {
            if (message.hasOneof(oneofDescriptor) || !oneofDescriptor.getFields().stream().anyMatch(BundleVerifier::isRequired)) continue;
            missing.add(prefix + oneofDescriptor.getName());
        }
        for (Map.Entry entry : message.getAllFields().entrySet()) {
            Descriptors.FieldDescriptor field = (Descriptors.FieldDescriptor)entry.getKey();
            Object value = entry.getValue();
            if (field.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) continue;
            if (!field.isRepeated()) {
                BundleVerifier.findMissingFields((MessageOrBuilder)value, BundleVerifier.subMessagePrefix(prefix, field, -1), missing);
                continue;
            }
            int i = 0;
            for (MessageOrBuilder element : (List)value) {
                BundleVerifier.findMissingFields(element, BundleVerifier.subMessagePrefix(prefix, field, i++), missing);
            }
        }
    }

    private static String subMessagePrefix(String prefix, Descriptors.FieldDescriptor field, int index) {
        StringBuilder result = new StringBuilder(prefix);
        if (field.isExtension()) {
            result.append('(').append(field.getFullName()).append(')');
        } else {
            result.append(field.getName());
        }
        if (index != -1) {
            result.append('[').append(index).append(']');
        }
        result.append('.');
        return result.toString();
    }

    static boolean isRequired(Descriptors.FieldDescriptor field) {
        return field.isRequired() || ((List)field.toProto().getOptions().getExtension(FieldBehaviorProto.fieldBehavior)).contains((Object)FieldBehavior.REQUIRED);
    }
}

